/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class RulerMain
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final String programName = "Ruler";
    private final String programVersion = "03.00";
    private RulerMain mainWindow;
    private Ruler aRuler;
    private SpinnerModel spinnerModelRulerWidth = new SpinnerNumberModel(500, 5, 5000, 1);
    private SpinnerModel spinnerModelRulerHeight = new SpinnerNumberModel(200, 5, 5000, 1);
    private SpinnerModel spinnerModelRulerMajorStep = new SpinnerNumberModel(20, 0, 5000, 1);
    private SpinnerModel spinnerModelRulerMinorStep = new SpinnerNumberModel(10, 0, 5000, 1);
    private SpinnerModel spinnerModelRulerMajorTick = new SpinnerNumberModel(4, 0, 5000, 1);
    private SpinnerModel spinnerModelRulerMinorTick = new SpinnerNumberModel(2, 0, 5000, 1);
    private JLabel rulerWidthLabel = new JLabel("Ruler Width");
    private JLabel rulerHeightLabel = new JLabel("Ruler Height");
    private JLabel rulerMajorLabel = new JLabel("Major Ticks");
    private JLabel rulerMinorLabel = new JLabel("Minor Ticks");
    private JLabel rulerMajorTickLabel = new JLabel("Major Tick Length");
    private JLabel rulerMinorTickLabel = new JLabel("Minor Tick Length");
    private JSpinner rulerWidth = new JSpinner(this.spinnerModelRulerWidth);
    private JSpinner rulerHeight = new JSpinner(this.spinnerModelRulerHeight);
    private JSpinner rulerMajor = new JSpinner(this.spinnerModelRulerMajorStep);
    private JSpinner rulerMinor = new JSpinner(this.spinnerModelRulerMinorStep);
    private JSpinner rulerMajorTick = new JSpinner(this.spinnerModelRulerMajorTick);
    private JSpinner rulerMinorTick = new JSpinner(this.spinnerModelRulerMinorTick);
    private JButton helpButton = new JButton("?");
    private JLabel linesHLabel = new JLabel("Horizontal");
    private JLabel linesVLabel = new JLabel("Vertical");
    private JCheckBox topBox = new JCheckBox("Top");
    private JCheckBox middleBox = new JCheckBox("Middle");
    private JCheckBox bottomBox = new JCheckBox("Bottom");
    private JCheckBox leftBox = new JCheckBox("Left");
    private JCheckBox centreBox = new JCheckBox("Centre");
    private JCheckBox rightBox = new JCheckBox("Right");
    private JLabel calibrateHLabel = new JLabel("Calibrate");
    private JLabel calibrateVLabel = new JLabel("Calibrate");
    private JCheckBox topCalibrateBox = new JCheckBox("");
    private JCheckBox middleCalibrateBox = new JCheckBox("");
    private JCheckBox bottomCalibrateBox = new JCheckBox("");
    private JCheckBox leftCalibrateBox = new JCheckBox("");
    private JCheckBox centreCalibrateBox = new JCheckBox("");
    private JCheckBox rightCalibrateBox = new JCheckBox("");
    private JButton showButton = new JButton("Show");
    private JButton hideButton = new JButton("Hide");
    private JLabel screens = new JLabel();
    private FlowLayout flowLayout = new FlowLayout(0);
    private String helpText = "<html> <b>Screen Ruler</b><br>All dimensions are in pixels.<br>Ruler will stay in foreground. To close it, type ESC when it is in focus.<br>If ruler has been closed, re-open by changing any value or typing any character with no field active.<br>Resize the ruler by entering Ruler Width and Height or by dragging the handles.<br>Screen dimensions of all monitors are shown. The one the configuration window (not the ruler itself) is on is \"(this)\".<br>The resolution in dots per inch is only available for the default monitor.<br>&copy;2023-2025 Alan Shepherd https://ashepherd.eu.</html>";
    private ChangeListener spinnerListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent c) {
            RulerMain.this.applyActions();
        }
    };
    private ActionListener checkboxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            RulerMain.this.applyActions();
        }
    };
    private FocusListener lostFocusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent f) {
        }

        @Override
        public void focusLost(FocusEvent f) {
            if (f.isTemporary()) {
                return;
            }
            RulerMain.this.applyActions();
        }
    };
    private KeyListener enterKeyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent k) {
            RulerMain.this.applyActions();
        }

        @Override
        public void keyPressed(KeyEvent p) {
        }

        @Override
        public void keyReleased(KeyEvent r) {
        }
    };

    public RulerMain() {
        this.mainWindow = this;
        this.setTitle("Ruler 03.00");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            @Override
            public void windowActivated(WindowEvent wa) {
                RulerMain.this.screens.setText(RulerMain.this.getScreenData());
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent m) {
                RulerMain.this.screens.setText(RulerMain.this.getScreenData());
            }
        });
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.rulerWidthLabel.setToolTipText("Set ruler width in pixels");
        this.rulerWidth.setToolTipText(this.rulerWidthLabel.getToolTipText());
        this.rulerHeightLabel.setToolTipText("Set ruler height in pixels");
        this.rulerHeight.setToolTipText(this.rulerHeightLabel.getToolTipText());
        this.rulerMajorLabel.setToolTipText("Spae between major ticks in pixels. 0 for no major ticks.");
        this.rulerMajor.setToolTipText(this.rulerMajorLabel.getToolTipText());
        this.rulerMinorLabel.setToolTipText("Space between minor ticks in pixels. 0 for no minor ticks.");
        this.rulerMinor.setToolTipText(this.rulerMinorLabel.getToolTipText());
        this.rulerMajorTickLabel.setToolTipText("Set major tick mark size in pixels");
        this.rulerMajorTick.setToolTipText(this.rulerMajorTickLabel.getToolTipText());
        this.rulerMinorTickLabel.setToolTipText("Set minor tick mark size in pixels");
        this.rulerMinorTick.setToolTipText(this.rulerMinorTickLabel.getToolTipText());
        this.helpButton.setToolTipText("Click for information");
        this.topBox.setToolTipText("Horizontal line at top");
        this.middleBox.setToolTipText("Horizontal line in middle");
        this.bottomBox.setToolTipText("Horizontal line at bottom");
        this.leftBox.setToolTipText("Vertical line on left");
        this.centreBox.setToolTipText("Vertical line in center");
        this.rightBox.setToolTipText("Vertical line at right");
        this.topCalibrateBox.setToolTipText("Calibrate the major ticks on top line");
        this.middleCalibrateBox.setToolTipText("Calibrate the major ticks on middle line");
        this.bottomCalibrateBox.setToolTipText("Calibrate the major ticks on bottom line");
        this.leftCalibrateBox.setToolTipText("Calibrate the major ticks on left line");
        this.centreCalibrateBox.setToolTipText("Calibrate the major ticks on centre line");
        this.rightCalibrateBox.setToolTipText("Calibrate the major ticks on right line");
        this.showButton.setToolTipText("Click this button to show the ruler if it has been hidden.");
        this.hideButton.setToolTipText("Click this button to hide the ruler (or type escape when the ruler is in focus).");
        ((JSpinner.DefaultEditor)this.rulerWidth.getEditor()).getTextField().addFocusListener(this.lostFocusListener);
        ((JSpinner.DefaultEditor)this.rulerHeight.getEditor()).getTextField().addFocusListener(this.lostFocusListener);
        ((JSpinner.DefaultEditor)this.rulerMajor.getEditor()).getTextField().addFocusListener(this.lostFocusListener);
        ((JSpinner.DefaultEditor)this.rulerMinor.getEditor()).getTextField().addFocusListener(this.lostFocusListener);
        ((JSpinner.DefaultEditor)this.rulerMajorTick.getEditor()).getTextField().addFocusListener(this.lostFocusListener);
        ((JSpinner.DefaultEditor)this.rulerMinorTick.getEditor()).getTextField().addFocusListener(this.lostFocusListener);
        this.rulerWidth.getEditor().setPreferredSize(new Dimension(50, 10));
        this.rulerHeight.getEditor().setPreferredSize(new Dimension(50, 10));
        this.rulerMajor.getEditor().setPreferredSize(new Dimension(50, 10));
        this.rulerMinor.getEditor().setPreferredSize(new Dimension(50, 10));
        this.rulerMajorTick.getEditor().setPreferredSize(new Dimension(50, 10));
        this.rulerMinorTick.getEditor().setPreferredSize(new Dimension(50, 10));
        this.rulerWidth.addChangeListener(this.spinnerListener);
        this.rulerHeight.addChangeListener(this.spinnerListener);
        this.rulerMajor.addChangeListener(this.spinnerListener);
        this.rulerMinor.addChangeListener(this.spinnerListener);
        this.rulerMajorTick.addChangeListener(this.spinnerListener);
        this.rulerMinorTick.addChangeListener(this.spinnerListener);
        this.middleBox.setSelected(true);
        this.middleCalibrateBox.setSelected(true);
        this.centreBox.setSelected(true);
        this.centreCalibrateBox.setSelected(true);
        this.topBox.addActionListener(this.checkboxListener);
        this.middleBox.addActionListener(this.checkboxListener);
        this.bottomBox.addActionListener(this.checkboxListener);
        this.leftBox.addActionListener(this.checkboxListener);
        this.centreBox.addActionListener(this.checkboxListener);
        this.rightBox.addActionListener(this.checkboxListener);
        this.topCalibrateBox.addActionListener(this.checkboxListener);
        this.middleCalibrateBox.addActionListener(this.checkboxListener);
        this.bottomCalibrateBox.addActionListener(this.checkboxListener);
        this.leftCalibrateBox.addActionListener(this.checkboxListener);
        this.centreCalibrateBox.addActionListener(this.checkboxListener);
        this.rightCalibrateBox.addActionListener(this.checkboxListener);
        this.helpButton.setPreferredSize(new Dimension(20, 20));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                JOptionPane.showMessageDialog(RulerMain.this.mainWindow, RulerMain.this.helpText);
            }
        });
        this.showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RulerMain.this.applyActions();
            }
        });
        this.hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RulerMain.this.aRuler != null) {
                    RulerMain.this.aRuler.dispose();
                }
            }
        });
        Box rulerPanel = Box.createVerticalBox();
        JPanel rulerSizePanel = new JPanel(this.flowLayout);
        rulerSizePanel.add(this.rulerWidthLabel);
        rulerSizePanel.add(this.rulerWidth);
        rulerSizePanel.add(this.rulerHeightLabel);
        rulerSizePanel.add(this.rulerHeight);
        rulerSizePanel.add(this.showButton);
        JPanel rulerStepPanel = new JPanel(this.flowLayout);
        rulerStepPanel.add(this.rulerMajorLabel);
        rulerStepPanel.add(this.rulerMajor);
        rulerStepPanel.add(this.rulerMinorLabel);
        rulerStepPanel.add(this.rulerMinor);
        rulerStepPanel.add(this.hideButton);
        JPanel rulerTickPanel = new JPanel(this.flowLayout);
        rulerTickPanel.add(this.rulerMajorTickLabel);
        rulerTickPanel.add(this.rulerMajorTick);
        rulerTickPanel.add(this.rulerMinorTickLabel);
        rulerTickPanel.add(this.rulerMinorTick);
        rulerPanel.add(rulerSizePanel);
        rulerPanel.add(rulerStepPanel);
        rulerPanel.add(rulerTickPanel);
        JPanel linesPanel = new JPanel();
        linesPanel.setLayout(new GridLayout(4, 4));
        linesPanel.add(this.linesHLabel);
        linesPanel.add(this.calibrateHLabel);
        linesPanel.add(this.linesVLabel);
        linesPanel.add(this.calibrateVLabel);
        linesPanel.add(this.topBox);
        linesPanel.add(this.topCalibrateBox);
        linesPanel.add(this.leftBox);
        linesPanel.add(this.leftCalibrateBox);
        linesPanel.add(this.middleBox);
        linesPanel.add(this.middleCalibrateBox);
        linesPanel.add(this.centreBox);
        linesPanel.add(this.centreCalibrateBox);
        linesPanel.add(this.bottomBox);
        linesPanel.add(this.bottomCalibrateBox);
        linesPanel.add(this.rightBox);
        linesPanel.add(this.rightCalibrateBox);
        JPanel screensPanel = new JPanel(this.flowLayout);
        this.screens.setText(this.getScreenData());
        screensPanel.add(this.screens);
        screensPanel.add(this.helpButton);
        this.add(rulerPanel);
        this.add(linesPanel);
        this.add(screensPanel);
        this.addKeyListener(this.enterKeyListener);
        this.applyActions();
        this.pack();
    }

    private void applyActions() {
        this.calibrateLogic();
        Runnable showRulerThread = () -> {
            if (this.aRuler == null) {
                this.aRuler = new Ruler(this.mainWindow);
                this.aRuler.setLocation(new Point(5, 5));
            } else {
                Point oldPos = this.aRuler.getPos();
                this.aRuler.dispose();
                this.aRuler = new Ruler(this.mainWindow);
                this.aRuler.setLocation(oldPos);
            }
            this.aRuler.setVisible(true);
        };
        Thread rulerThread = new Thread(showRulerThread);
        rulerThread.start();
    }

    private String getScreenData() {
        Object data = "<html><b>Screen Dimensions</b><br>";
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        GraphicsConfiguration graphicsConfig = this.mainWindow.getGraphicsConfiguration();
        GraphicsDevice ourScreen = graphicsConfig.getDevice();
        String us = "";
        int i = 0;
        while (i < gs.length) {
            GraphicsDevice gd = gs[i];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc[0]);
            Object dpi = "";
            DisplayMode dm = gd.getDisplayMode();
            if (gd == ourScreen) {
                us = " (this) ";
                dpi = " Resolution " + Toolkit.getDefaultToolkit().getScreenResolution() + " dpi";
            } else {
                us = "";
                dpi = "";
            }
            data = (String)data + "Monitor " + (i + 1) + us + " Width " + dm.getWidth() + " Height " + dm.getHeight() + (String)dpi + "<br>";
            data = (String)data + "&nbsp;&nbsp;Insets Top " + insets.top + " Bottom " + insets.bottom + " Left " + insets.left + " Right " + insets.right + "<br>";
            ++i;
        }
        data = (String)data + "</html>";
        return data;
    }

    private void calibrateLogic() {
        if (this.topBox.isSelected()) {
            this.topCalibrateBox.setEnabled(true);
        } else {
            this.topCalibrateBox.setEnabled(false);
        }
        if (this.middleBox.isSelected()) {
            this.middleCalibrateBox.setEnabled(true);
        } else {
            this.middleCalibrateBox.setEnabled(false);
        }
        if (this.bottomBox.isSelected()) {
            this.bottomCalibrateBox.setEnabled(true);
        } else {
            this.bottomCalibrateBox.setEnabled(false);
        }
        if (this.topBox.isSelected()) {
            this.topCalibrateBox.setEnabled(true);
        } else {
            this.topCalibrateBox.setEnabled(false);
        }
        if (this.leftBox.isSelected()) {
            this.leftCalibrateBox.setEnabled(true);
        } else {
            this.leftCalibrateBox.setEnabled(false);
        }
        if (this.centreBox.isSelected()) {
            this.centreCalibrateBox.setEnabled(true);
        } else {
            this.centreCalibrateBox.setEnabled(false);
        }
        if (this.rightBox.isSelected()) {
            this.rightCalibrateBox.setEnabled(true);
        } else {
            this.rightCalibrateBox.setEnabled(false);
        }
    }

    public int getRulerWidth() {
        return (Integer)this.rulerWidth.getValue();
    }

    public int getRulerHeight() {
        return (Integer)this.rulerHeight.getValue();
    }

    public int getRulerMajorStep() {
        return (Integer)this.rulerMajor.getValue();
    }

    public int getRulerMinorStep() {
        return (Integer)this.rulerMinor.getValue();
    }

    public int getRulerMajorTick() {
        return (Integer)this.rulerMajorTick.getValue();
    }

    public int getRulerMinorTick() {
        return (Integer)this.rulerMinorTick.getValue();
    }

    public boolean getTop() {
        return this.topBox.isSelected();
    }

    public boolean getMiddle() {
        return this.middleBox.isSelected();
    }

    public boolean getBottom() {
        return this.bottomBox.isSelected();
    }

    public boolean getLeft() {
        return this.leftBox.isSelected();
    }

    public boolean getCentre() {
        return this.centreBox.isSelected();
    }

    public boolean getRight() {
        return this.rightBox.isSelected();
    }

    public boolean getTopCalibrate() {
        return this.topBox.isSelected() & this.topCalibrateBox.isSelected();
    }

    public boolean getMiddleCalibrate() {
        return this.middleBox.isSelected() & this.middleCalibrateBox.isSelected();
    }

    public boolean getBottomCalibrate() {
        return this.bottomBox.isSelected() & this.bottomCalibrateBox.isSelected();
    }

    public boolean getLeftCalibrate() {
        return this.leftBox.isSelected() & this.leftCalibrateBox.isSelected();
    }

    public boolean getCentreCalibrate() {
        return this.centreBox.isSelected() & this.centreCalibrateBox.isSelected();
    }

    public boolean getRightCalibrate() {
        return this.rightBox.isSelected() & this.rightCalibrateBox.isSelected();
    }

    public void setWidth(int w) {
        this.rulerWidth.setValue(w);
    }

    public void setHeight(int h) {
        this.rulerHeight.setValue(h);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RulerMain mainWindow = new RulerMain();
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice defaultScreen = ge.getDefaultScreenDevice();
                Rectangle rect = defaultScreen.getDefaultConfiguration().getBounds();
                int x = (int)rect.getMaxX() - mainWindow.getWidth();
                int y = 0;
                mainWindow.setLocation(x, y);
                mainWindow.setVisible(true);
                mainWindow.setMaximumSize(new Dimension(Toolkit.getDefaultToolkit().getScreenSize()));
            }
        });
    }
}

