/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JDialog;
import javax.swing.JPanel;

class Ruler
extends JDialog {
    private static final long serialVersionUID = 1L;
    private RulerMain mainGUI;
    private JDialog ourFrame;
    private int ruleWidth;
    private int ruleHeight;
    private int majorStep;
    private int minorStep;
    private int majorTick;
    private int minorTick;
    private int startX;
    private int startY;
    private int leftMargin;
    private int rightMargin;
    private int topMargin;
    private int bottomMargin;
    private int windowWidth;
    private int windowHeight;
    private Rectangle2D topLeftDrag;
    private Rectangle2D topRightDrag;
    private Rectangle2D middleLeftDrag;
    private Rectangle2D middleRightDrag;
    private Rectangle2D bottomLeftDrag;
    private Rectangle2D bottomRightDrag;
    private Rectangle2D topCentreDrag;
    private Rectangle2D bottomCentreDrag;
    private boolean topLeftDragging = false;
    private boolean topRightDragging = false;
    private boolean middleLeftDragging = false;
    private boolean middleRightDragging = false;
    private boolean bottomLeftDragging = false;
    private boolean bottomRightDragging = false;
    private boolean topCentreDragging = false;
    private boolean bottomCentreDragging = false;
    private boolean windowDragging = false;
    private int dragStartX;
    private int dragStartY;
    private Point dragStartPoint;
    private int boundTolerance = 8;
    private int newX;
    private int newY;
    private int deltaX;
    private int deltaY;
    private int newRuleWidth = this.ruleWidth;
    private int newRuleHeight = this.ruleHeight;
    private static Font axisFont = new Font("Serif", 0, 10);
    private static Color axisColor = new Color(255, 0, 0, 128);
    private static Color handleColor = new Color(100, 100, 100, 200);

    public Ruler(final RulerMain mainGUI) {
        this.ourFrame = this;
        this.mainGUI = mainGUI;
        this.ruleWidth = mainGUI.getRulerWidth();
        this.ruleHeight = mainGUI.getRulerHeight();
        this.majorStep = mainGUI.getRulerMajorStep();
        this.minorStep = mainGUI.getRulerMinorStep();
        this.majorTick = mainGUI.getRulerMajorTick();
        this.minorTick = mainGUI.getRulerMinorTick();
        RulerPanel ruler = new RulerPanel();
        this.setContentPane(ruler);
        this.setUndecorated(true);
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setBackground(new Color(0.5f, 0.0f, 0.0f, 0.05f));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Ruler.this.topLeftDragging = false;
                Ruler.this.topRightDragging = false;
                Ruler.this.middleLeftDragging = false;
                Ruler.this.middleRightDragging = false;
                Ruler.this.bottomLeftDragging = false;
                Ruler.this.bottomRightDragging = false;
                Ruler.this.topCentreDragging = false;
                Ruler.this.bottomCentreDragging = false;
                Ruler.this.windowDragging = false;
                Ruler.this.dragStartX = e.getX();
                Ruler.this.dragStartY = e.getY();
                Ruler.this.newRuleWidth = Ruler.this.ruleWidth;
                Ruler.this.newRuleHeight = Ruler.this.ruleHeight;
                Ruler.this.dragStartPoint = Ruler.this.ourFrame.getLocationOnScreen();
                if (Ruler.this.topLeftDrag != null && Ruler.this.topLeftDrag.contains(e.getX(), e.getY())) {
                    Ruler.this.topLeftDragging = true;
                }
                if (Ruler.this.topCentreDrag != null && Ruler.this.topCentreDrag.contains(e.getX(), e.getY())) {
                    Ruler.this.topCentreDragging = true;
                }
                if (Ruler.this.topRightDrag != null && Ruler.this.topRightDrag.contains(e.getX(), e.getY())) {
                    Ruler.this.topRightDragging = true;
                }
                if (Ruler.this.middleLeftDrag != null && Ruler.this.middleLeftDrag.contains(e.getX(), e.getY())) {
                    Ruler.this.middleLeftDragging = true;
                }
                if (Ruler.this.middleRightDrag != null && Ruler.this.middleRightDrag.contains(e.getX(), e.getY())) {
                    Ruler.this.middleRightDragging = true;
                }
                if (Ruler.this.bottomLeftDrag != null && Ruler.this.bottomLeftDrag.contains(e.getX(), e.getY())) {
                    Ruler.this.bottomLeftDragging = true;
                }
                if (Ruler.this.bottomCentreDrag != null && Ruler.this.bottomCentreDrag.contains(e.getX(), e.getY())) {
                    Ruler.this.bottomCentreDragging = true;
                }
                if (Ruler.this.bottomRightDrag != null && Ruler.this.bottomRightDrag.contains(e.getX(), e.getY())) {
                    Ruler.this.bottomRightDragging = true;
                }
                if (!(Ruler.this.topLeftDragging || Ruler.this.topCentreDragging || Ruler.this.topRightDragging || Ruler.this.middleLeftDragging || Ruler.this.middleRightDragging || Ruler.this.bottomLeftDragging || Ruler.this.bottomCentreDragging || Ruler.this.bottomRightDragging)) {
                    Ruler.this.windowDragging = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent r) {
                Ruler.this.mouseMoveActions(r);
                mainGUI.setWidth(Ruler.this.newRuleWidth);
                mainGUI.setHeight(Ruler.this.newRuleHeight);
                Ruler.this.topLeftDragging = false;
                Ruler.this.topRightDragging = false;
                Ruler.this.middleLeftDragging = false;
                Ruler.this.middleRightDragging = false;
                Ruler.this.bottomLeftDragging = false;
                Ruler.this.bottomRightDragging = false;
                Ruler.this.topCentreDragging = false;
                Ruler.this.bottomCentreDragging = false;
                Ruler.this.windowDragging = false;
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent c) {
                Ruler.this.mouseMoveActions(c);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 27) {
                    Ruler.this.ourFrame.dispose();
                }
            }
        });
        this.pack();
    }

    private void mouseMoveActions(MouseEvent e) {
        Point newPoint = this.dragStartPoint;
        this.newX = e.getX();
        this.newY = e.getY();
        this.deltaX = this.newX - this.dragStartX;
        this.deltaY = this.newY - this.dragStartY;
        if (this.windowDragging) {
            newPoint.translate(this.deltaX, this.deltaY);
            this.setLocation(newPoint);
            return;
        }
        if (this.topLeftDragging) {
            if (this.newX > this.dragStartX) {
                newPoint.translate(this.deltaX, 0);
                this.newRuleWidth = this.ruleWidth - this.deltaX;
            } else {
                newPoint.translate(this.deltaX, 0);
                this.newRuleWidth = this.ruleWidth - this.deltaX;
            }
            if (this.newY > this.dragStartY) {
                newPoint.translate(0, this.deltaY);
                this.newRuleHeight = this.ruleHeight - this.deltaY;
            } else {
                newPoint.translate(0, this.deltaY);
                this.newRuleHeight = this.ruleHeight - this.deltaY;
            }
        }
        if (this.topCentreDragging) {
            if (this.newY > this.dragStartY) {
                newPoint.translate(0, this.deltaY);
                this.newRuleHeight = this.ruleHeight - this.deltaY;
            } else {
                newPoint.translate(0, this.deltaY);
                this.newRuleHeight = this.ruleHeight - this.deltaY;
            }
        }
        if (this.topRightDragging) {
            this.newRuleWidth = this.newX > this.dragStartX ? this.ruleWidth + this.deltaX : this.ruleWidth + this.deltaX;
            if (this.newY > this.dragStartY) {
                newPoint.translate(0, this.deltaY);
                this.newRuleHeight = this.ruleHeight - this.deltaY;
            } else {
                newPoint.translate(0, this.deltaY);
                this.newRuleHeight = this.ruleHeight - this.deltaY;
            }
        }
        if (this.middleLeftDragging) {
            if (this.newX > this.dragStartX) {
                newPoint.translate(this.deltaX, 0);
                this.newRuleWidth = this.ruleWidth - this.deltaX;
            } else {
                newPoint.translate(this.deltaX, 0);
                this.newRuleWidth = this.ruleWidth - this.deltaX;
            }
        }
        if (this.middleRightDragging) {
            this.newRuleWidth = this.newX > this.dragStartX ? this.ruleWidth + this.deltaX : this.ruleWidth + this.deltaX;
        }
        if (this.bottomLeftDragging) {
            if (this.newX > this.dragStartX) {
                newPoint.translate(this.deltaX, 0);
                this.newRuleWidth = this.ruleWidth - this.deltaX;
            } else {
                newPoint.translate(this.deltaX, 0);
                this.newRuleWidth = this.ruleWidth - this.deltaX;
            }
            this.newRuleHeight = this.newY > this.dragStartY ? this.ruleHeight + this.deltaY : this.ruleHeight + this.deltaY;
        }
        if (this.bottomCentreDragging) {
            this.newRuleHeight = this.newY > this.dragStartY ? this.ruleHeight + this.deltaY : this.ruleHeight + this.deltaY;
        }
        if (this.bottomRightDragging) {
            this.newRuleWidth = this.newX > this.dragStartX ? this.ruleWidth + this.deltaX : this.ruleWidth + this.deltaX;
            this.newRuleHeight = this.newY > this.dragStartY ? this.ruleHeight + this.deltaY : this.ruleHeight + this.deltaY;
        }
        this.setLocation(newPoint);
        this.ruleWidth = this.newRuleWidth;
        this.ruleHeight = this.newRuleHeight;
        this.dragStartX = this.newX;
        this.dragStartY = this.newY;
        this.dragStartPoint = newPoint;
        this.windowWidth = this.ruleWidth + this.leftMargin + this.rightMargin;
        this.windowHeight = this.ruleHeight + this.topMargin + this.bottomMargin;
        this.setSize(new Dimension(this.windowWidth, this.windowHeight));
        this.startX = this.leftMargin;
        this.startY = this.topMargin;
        this.ourFrame.repaint();
    }

    private void drawH(Graphics2D g, int x, int y, int w, int major, int minor, int majorStep, int minorStep, boolean cal) {
        int xBase = x;
        if (majorStep != 0) {
            g.drawLine(xBase, y, xBase + w, y);
            g.setFont(axisFont);
            FontMetrics metrics = g.getFontMetrics(axisFont);
            Rectangle2D tickBounds = metrics.getStringBounds("0", g);
            int nTicks = w / majorStep;
            int tickStringX = x - metrics.stringWidth("0") / 2;
            int tickStringY = y + metrics.getAscent() + major / 2;
            Rectangle2D prevBounds = new Rectangle2D.Double(tickStringX, tickStringY, tickBounds.getWidth(), tickBounds.getHeight());
            int nextX = xBase;
            int i = 0;
            while (i <= nTicks) {
                String number = String.valueOf(i * majorStep);
                int numberWidth = metrics.stringWidth(number);
                tickBounds = metrics.getStringBounds(number, g);
                tickStringX = nextX - numberWidth / 2;
                tickStringY = y + metrics.getAscent() + major;
                tickBounds.setRect(tickStringX, tickStringY, tickBounds.getWidth(), tickBounds.getHeight());
                g.drawLine(nextX, y + major, nextX, y - major);
                if (cal && (!tickBounds.intersects(prevBounds) || i == 0)) {
                    g.drawString(number, nextX - numberWidth / 2, y + metrics.getAscent() + major);
                    prevBounds = tickBounds;
                }
                nextX += majorStep;
                ++i;
            }
        }
        if (minorStep != 0) {
            int nHorizontalTicks = w / minorStep;
            int atX = xBase;
            int i = 0;
            while (i <= nHorizontalTicks) {
                g.drawLine(atX, y - minor, atX, y + minor);
                atX += minorStep;
                ++i;
            }
        }
    }

    private void drawV(Graphics2D g, int x, int y, int h, int major, int minor, int majorStep, int minorStep, boolean cal) {
        int yBase = y;
        int nextY = y;
        if (majorStep != 0) {
            g.drawLine(x, yBase, x, yBase + h);
            g.setFont(axisFont);
            FontMetrics metrics = g.getFontMetrics(axisFont);
            Rectangle2D tickBounds = metrics.getStringBounds("0", g);
            int nTicks = h / majorStep;
            int tickStringX = x - metrics.stringWidth("0") / 2;
            int tickStringY = nextY + metrics.getAscent() + major / 2;
            Rectangle2D prevBounds = new Rectangle2D.Double(tickStringX, tickStringY, tickBounds.getWidth(), tickBounds.getHeight());
            nextY = yBase;
            int i = 0;
            while (i <= nTicks) {
                String number = String.valueOf(i * majorStep);
                int numberWidth = metrics.stringWidth(number);
                tickBounds = metrics.getStringBounds(number, g);
                tickStringX = x - numberWidth / 2;
                tickStringY = nextY + metrics.getAscent() + major;
                tickBounds.setRect(tickStringX, tickStringY, tickBounds.getWidth(), tickBounds.getHeight());
                g.drawLine(x + major, nextY, x - major, nextY);
                if (cal && (!tickBounds.intersects(prevBounds) || i == 0)) {
                    g.drawString(number, x - metrics.stringWidth(number) - major, nextY + metrics.getDescent());
                    prevBounds = tickBounds;
                }
                nextY += majorStep;
                ++i;
            }
        }
        if (minorStep != 0) {
            int nVerticalTicks = h / minorStep;
            int atY = yBase;
            int i = 0;
            while (i < nVerticalTicks) {
                g.drawLine(x - minor, atY, x + minor, atY);
                atY += minorStep;
                ++i;
            }
        }
    }

    public Point getPos() {
        return new Point(this.ourFrame.getX(), this.ourFrame.getY());
    }

    private class RulerPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private RulerPanel() {
            FontMetrics metrics = this.getFontMetrics(axisFont);
            int fontWidth = metrics.stringWidth(String.valueOf(Ruler.this.ruleWidth));
            int zeroWidth = metrics.stringWidth("0");
            int fontHeight = metrics.getHeight();
            Ruler.this.topMargin = Ruler.this.boundTolerance;
            if (Ruler.this.mainGUI.getTop()) {
                Ruler.this.topMargin += Ruler.this.majorTick;
            }
            Ruler.this.bottomMargin = Ruler.this.boundTolerance;
            if (Ruler.this.mainGUI.getBottom()) {
                Ruler.this.bottomMargin += Ruler.this.majorTick;
                if (Ruler.this.mainGUI.getBottomCalibrate()) {
                    Ruler.this.bottomMargin += fontHeight;
                }
            }
            Ruler.this.leftMargin = Ruler.this.boundTolerance;
            if (Ruler.this.mainGUI.getLeft()) {
                Ruler.this.leftMargin += Ruler.this.majorTick;
                if (Ruler.this.mainGUI.getLeftCalibrate()) {
                    Ruler.this.leftMargin += fontWidth;
                }
            }
            Ruler.this.rightMargin = Ruler.this.boundTolerance;
            if (Ruler.this.mainGUI.getRight()) {
                Ruler.this.rightMargin += Ruler.this.majorTick;
            }
            if (Ruler.this.mainGUI.getTopCalibrate() || Ruler.this.mainGUI.getMiddleCalibrate() || Ruler.this.mainGUI.getBottomCalibrate()) {
                Ruler.this.leftMargin += zeroWidth / 2;
                Ruler.this.rightMargin += fontWidth / 2;
            }
            if (Ruler.this.mainGUI.getLeftCalibrate() || Ruler.this.mainGUI.getCentreCalibrate() || Ruler.this.mainGUI.getRightCalibrate()) {
                Ruler.this.topMargin += fontHeight / 2;
            }
            Ruler.this.windowWidth = Ruler.this.ruleWidth + Ruler.this.leftMargin + Ruler.this.rightMargin;
            Ruler.this.windowHeight = Ruler.this.ruleHeight + Ruler.this.topMargin + Ruler.this.bottomMargin;
            this.setPreferredSize(new Dimension(Ruler.this.windowWidth, Ruler.this.windowHeight));
            Ruler.this.startX = Ruler.this.leftMargin;
            Ruler.this.startY = Ruler.this.topMargin;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(axisColor);
            g2d.setStroke(new BasicStroke(1.0f));
            if (Ruler.this.mainGUI.getTop()) {
                Ruler.this.drawH(g2d, Ruler.this.startX, Ruler.this.startY, Ruler.this.ruleWidth, Ruler.this.majorTick, Ruler.this.minorTick, Ruler.this.majorStep, Ruler.this.minorStep, Ruler.this.mainGUI.getTopCalibrate());
            }
            if (Ruler.this.mainGUI.getMiddle()) {
                Ruler.this.drawH(g2d, Ruler.this.startX, Ruler.this.startY + Ruler.this.ruleHeight / 2, Ruler.this.ruleWidth, Ruler.this.majorTick, Ruler.this.minorTick, Ruler.this.majorStep, Ruler.this.minorStep, Ruler.this.mainGUI.getMiddleCalibrate());
            }
            if (Ruler.this.mainGUI.getBottom()) {
                Ruler.this.drawH(g2d, Ruler.this.startX, Ruler.this.startY + Ruler.this.ruleHeight, Ruler.this.ruleWidth, Ruler.this.majorTick, Ruler.this.minorTick, Ruler.this.majorStep, Ruler.this.minorStep, Ruler.this.mainGUI.getBottomCalibrate());
            }
            if (Ruler.this.mainGUI.getLeft()) {
                Ruler.this.drawV(g2d, Ruler.this.startX, Ruler.this.startY, Ruler.this.ruleHeight, Ruler.this.majorTick, Ruler.this.minorTick, Ruler.this.majorStep, Ruler.this.minorStep, Ruler.this.mainGUI.getLeftCalibrate());
            }
            if (Ruler.this.mainGUI.getCentre()) {
                Ruler.this.drawV(g2d, Ruler.this.startX + Ruler.this.ruleWidth / 2, Ruler.this.startY, Ruler.this.ruleHeight, Ruler.this.majorTick, Ruler.this.minorTick, Ruler.this.majorStep, Ruler.this.minorStep, Ruler.this.mainGUI.getCentreCalibrate());
            }
            if (Ruler.this.mainGUI.getRight()) {
                Ruler.this.drawV(g2d, Ruler.this.startX + Ruler.this.ruleWidth, Ruler.this.startY, Ruler.this.ruleHeight, Ruler.this.majorTick, Ruler.this.minorTick, Ruler.this.majorStep, Ruler.this.minorStep, Ruler.this.mainGUI.getRightCalibrate());
            }
            g2d.setColor(handleColor);
            Ruler.this.topLeftDrag = new Rectangle2D.Double(0.0, 0.0, Ruler.this.boundTolerance, Ruler.this.boundTolerance);
            g2d.draw(Ruler.this.topLeftDrag);
            Ruler.this.topCentreDrag = new Rectangle2D.Double(Ruler.this.startX + Ruler.this.ruleWidth / 2 - Ruler.this.boundTolerance / 2, 0.0, Ruler.this.boundTolerance, Ruler.this.boundTolerance);
            g2d.draw(Ruler.this.topCentreDrag);
            Ruler.this.topRightDrag = new Rectangle2D.Double(Ruler.this.windowWidth - Ruler.this.boundTolerance, 0.0, Ruler.this.boundTolerance, Ruler.this.boundTolerance);
            g2d.draw(Ruler.this.topRightDrag);
            Ruler.this.middleLeftDrag = new Rectangle2D.Double(0.0, (Ruler.this.windowHeight + Ruler.this.topMargin - Ruler.this.bottomMargin) / 2 - Ruler.this.boundTolerance / 2, Ruler.this.boundTolerance, Ruler.this.boundTolerance);
            g2d.draw(Ruler.this.middleLeftDrag);
            Ruler.this.middleRightDrag = new Rectangle2D.Double(Ruler.this.windowWidth - Ruler.this.boundTolerance, (Ruler.this.windowHeight + Ruler.this.topMargin - Ruler.this.bottomMargin) / 2 - Ruler.this.boundTolerance / 2, Ruler.this.boundTolerance, Ruler.this.boundTolerance);
            g2d.draw(Ruler.this.middleRightDrag);
            Ruler.this.bottomLeftDrag = new Rectangle2D.Double(0.0, Ruler.this.windowHeight - Ruler.this.boundTolerance, Ruler.this.boundTolerance, Ruler.this.boundTolerance);
            g2d.draw(Ruler.this.bottomLeftDrag);
            Ruler.this.bottomCentreDrag = new Rectangle2D.Double(Ruler.this.startX + Ruler.this.ruleWidth / 2 - Ruler.this.boundTolerance / 2, Ruler.this.windowHeight - Ruler.this.boundTolerance, Ruler.this.boundTolerance, Ruler.this.boundTolerance);
            g2d.draw(Ruler.this.bottomCentreDrag);
            Ruler.this.bottomRightDrag = new Rectangle2D.Double(Ruler.this.windowWidth - Ruler.this.boundTolerance, Ruler.this.windowHeight - Ruler.this.boundTolerance, Ruler.this.boundTolerance, Ruler.this.boundTolerance);
            g2d.draw(Ruler.this.bottomRightDrag);
        }
    }
}

