/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ZoomPanPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollBar scroll = new JScrollBar(0, 0, 10, 0, 100);
    private String scrollTip = "Use the scrollbar to traverse the input wave.";
    private int sliderMax = 200;
    private static final int sliderBend = 10;
    private JSlider slider = new JSlider(0, this.sliderMax, 0);
    private String sliderTip = "Use the slider to change the horizontal time magnification (zoom).";
    private List<ZoomPanListener> listeners = new ArrayList<ZoomPanListener>();

    ZoomPanPanel(boolean invertSlider) {
        this.scroll.setToolTipText(this.scrollTip);
        this.scroll.setBackground(Color.WHITE);
        this.scroll.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent a) {
                ZoomPanPanel.this.moved();
            }
        });
        this.slider.setToolTipText(this.sliderTip);
        this.slider.setPaintTicks(false);
        this.slider.setPaintLabels(false);
        this.slider.setEnabled(true);
        this.slider.setValue(0);
        this.slider.setInverted(invertSlider);
        if (invertSlider) {
            this.slider.setValue(this.sliderMax);
        }
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ZoomPanPanel.this.moved();
            }
        });
        this.slider.setBorder(new EmptyBorder(0, 10, 0, 10));
        Box fixedBox = Box.createVerticalBox();
        fixedBox.add(this.scroll);
        fixedBox.add(this.slider);
        this.setLayout(new BorderLayout());
        this.add((Component)fixedBox, "Last");
    }

    private void moved() {
        for (ZoomPanListener zpl : this.listeners) {
            zpl.zoomedPanned();
        }
    }

    void addListener(ZoomPanListener l) {
        this.listeners.add(l);
    }

    public int getSliderValue() {
        return this.slider.getValue();
    }

    public void setSliderValue(int s) {
        int val = s;
        if (this.slider.getInverted()) {
            val = this.slider.getMaximum() - s;
        }
        this.slider.setValue(val);
    }

    public int getSliderMax() {
        return this.slider.getMaximum();
    }

    public void setSliderMax(int m) {
        this.slider.setMaximum(m);
    }

    public void setSliderMin(int m) {
        this.slider.setMinimum(m);
    }

    public int getSliderBend() {
        return 10;
    }

    public int getSliderExtent() {
        return this.slider.getExtent();
    }

    public boolean isSliderAdjusting() {
        return this.slider.getModel().getValueIsAdjusting();
    }

    public int getScrollValue() {
        return this.scroll.getValue();
    }

    public void setScrollBlockIncrement(int inc) {
        this.scroll.setBlockIncrement(inc);
    }

    public void setScrollUnitIncrement(int inc) {
        this.scroll.setUnitIncrement(inc);
    }

    public void setScrollValue(int v) {
        this.scroll.setValue(v);
    }

    void setScrollValues(int current, int visible, int start, int end) {
        this.scroll.setValues(current, visible, start, end);
    }

    public boolean isScrollAdjusting() {
        return this.scroll.getModel().getValueIsAdjusting();
    }

    void scrollRepaint() {
        this.scroll.repaint();
    }

    static interface ZoomPanListener {
        public void zoomedPanned();
    }
}

