/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class YMagPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JSlider slider = new JSlider(1, 1, 100, 1);
    private String sliderTip = "Use the slider to change the vertical amplitude magnification (zoom).";
    private List<YMagListener> listeners = new ArrayList<YMagListener>();

    YMagPanel() {
        this.slider.setToolTipText(this.sliderTip);
        this.slider.setBackground(Color.WHITE);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                YMagPanel.this.toDoOnAction();
            }
        });
        Box inputYsliderPanel = Box.createVerticalBox();
        inputYsliderPanel.setBackground(Color.WHITE);
        inputYsliderPanel.setOpaque(true);
        JLabel whiteLabel1 = new JLabel(" ");
        whiteLabel1.setBackground(Color.WHITE);
        whiteLabel1.setOpaque(true);
        JLabel whiteLabel2 = new JLabel(" ");
        whiteLabel2.setBackground(Color.WHITE);
        whiteLabel2.setOpaque(true);
        inputYsliderPanel.add(whiteLabel1);
        inputYsliderPanel.add(this.slider);
        inputYsliderPanel.add(whiteLabel2);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add(inputYsliderPanel);
    }

    private void toDoOnAction() {
        for (YMagListener zpl : this.listeners) {
            zpl.yMagEvent();
        }
    }

    void addListener(YMagListener l) {
        this.listeners.add(l);
    }

    public int getSliderValue() {
        return this.slider.getValue();
    }

    public void setSliderValue(int s) {
        this.slider.setValue(s);
    }

    public int getSliderMax() {
        return this.slider.getMaximum();
    }

    static interface YMagListener {
        public void yMagEvent();
    }
}

