/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.RenderingHints;
import java.util.FormatterClosedException;
import java.util.IllegalFormatException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import roundtrip.AnalysisParameters;
import roundtrip.FRTmain;
import roundtrip.FourierTransform;
import roundtrip.SpectrumBinList;
import roundtrip.Utils;
import roundtrip.WindowFunction;

class WindowFunctionWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private FRTmain ourGUI;
    private JFrame ourFrame;
    private JPanel ourPanel;
    private AnalysisParameters analysisParams;
    private final int xMargin = 60;
    private final int yMargin = 30;
    private final int yMargin2 = 40;
    private int plotWidth;
    private int plotHeight;
    private double[] windowFunction;
    private String function;
    private double windowFunctionMax;
    private double parameter;
    private String parameterString = "";
    private String parameterName;
    private double windowFunctionScale;
    private int windowWidth = 5000;
    private int extendedN = 131072;
    private double dBLimit = -100.0;
    private int binLimit = 40;
    private double mlWidth;
    private JLabel mlWidthValue = new JLabel("undefined");
    private double nenbw;
    private double enbwCF;
    private double maxSideLobeF;
    private double maxSideLobeValue;
    private JLabel resultLabel = new JLabel("Ready for a New analysis");
    private JLabel ftWindowXbinsLabel = new JLabel("X max. bins");
    private SpinnerNumberModel ftWindowXbinsModel = new SpinnerNumberModel(40, 3, 10000, 1);
    private JSpinner ftWindowXbinsSpinner = new JSpinner(this.ftWindowXbinsModel);
    private String ftWindowXbinsTip = "Set the number of frequency bins to be shown on the x-axis.";
    private JLabel ftWindowYdBLabel = new JLabel("Y max. -dB");
    private SpinnerNumberModel ftWindowYdBModel = new SpinnerNumberModel(100, 10, 10000, 10);
    private JSpinner ftWindowYdBSpinner = new JSpinner(this.ftWindowYdBModel);
    private String ftWindowYdBTip = "Set the lower limit of the y-axis in dB.";
    private FlowLayout flowLayoutLeft = new FlowLayout(0);
    private FlowLayout flowLayoutCenter = new FlowLayout(1);
    private ChangeListener parameterListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            WindowFunctionWindow.this.ourFrame.repaint();
        }
    };

    WindowFunctionWindow(GraphicsConfiguration gc, FRTmain mainGUI) {
        super(gc);
        this.ourFrame = this;
        this.ourGUI = mainGUI;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().setLayout(new BorderLayout());
        this.ourPanel = new FunctionPanel();
        this.analysisParams = this.ourGUI.getAnalysisParamsWindow();
        JPanel paramsPanel = new JPanel(this.flowLayoutCenter);
        this.ftWindowXbinsLabel.setToolTipText(this.ftWindowXbinsTip);
        this.ftWindowXbinsSpinner.setToolTipText(this.ftWindowXbinsTip);
        this.ftWindowYdBLabel.setToolTipText(this.ftWindowYdBTip);
        this.ftWindowYdBSpinner.setToolTipText(this.ftWindowYdBTip);
        this.ftWindowXbinsSpinner.addChangeListener(this.parameterListener);
        this.ftWindowYdBSpinner.addChangeListener(this.parameterListener);
        paramsPanel.add(this.ftWindowXbinsLabel);
        paramsPanel.add(this.ftWindowXbinsSpinner);
        paramsPanel.add(this.ftWindowYdBLabel);
        paramsPanel.add(this.ftWindowYdBSpinner);
        JPanel resultPanel = new JPanel(this.flowLayoutLeft);
        resultPanel.add(this.resultLabel);
        this.add((Component)paramsPanel, "First");
        this.add((Component)this.ourPanel, "Center");
        this.add((Component)resultPanel, "Last");
        int sizeX = 631;
        this.setPreferredSize(new Dimension(sizeX, 610));
        this.pack();
        this.setVisible(true);
        this.function = this.analysisParams.getFFTWindowFunctionName();
        this.parameterName = this.analysisParams.getFFTParameterName();
        if (this.parameterName.equals("")) {
            this.parameterString = "";
        } else {
            this.parameterString = this.analysisParams.getRawFFTWindowParameter();
            this.parameter = this.analysisParams.getFFTparameterValue();
        }
        this.ourFrame.setTitle("Window Function " + this.function + " " + this.parameterName + " " + this.parameterString);
    }

    private double mainLobeWidth(SpectrumBinList spectrum, double sampleRate) {
        int startSample = (int)Math.floor(sampleRate);
        double currentAmp = spectrum.getBinByIndex(startSample).getAmplitude();
        double result = 0.0;
        int i = startSample;
        while (i < spectrum.getSize()) {
            if (spectrum.getBinByIndex(i).getAmplitude() > currentAmp) break;
            currentAmp = spectrum.getBinByIndex(i).getAmplitude();
            result = (double)i * (double)this.windowWidth / (double)this.extendedN;
            ++i;
        }
        return result;
    }

    private double nenbw(double[] window) {
        double s1 = 0.0;
        double s2 = 0.0;
        int i = 0;
        while (i < window.length) {
            s1 += window[i];
            s2 += window[i] * window[i];
            ++i;
        }
        double result = (double)window.length * s2 / (s1 * s1);
        return result;
    }

    private double enbwCorrection(double nenbw) {
        double result = 10.0 * Math.log10(nenbw);
        return result;
    }

    private class FunctionPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        FunctionPanel() {
            WindowFunctionWindow.this.ourPanel = this;
        }

        @Override
        public void paintComponent(Graphics g) {
            int start;
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(WindowFunctionWindow.this.ourGUI.getSettings().getAnalysisBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            WindowFunctionWindow.this.plotWidth = WindowFunctionWindow.this.ourPanel.getWidth() - 60 - 60;
            WindowFunctionWindow.this.plotHeight = (WindowFunctionWindow.this.ourPanel.getHeight() - 30 - 40 - 30) / 2;
            WindowFunctionWindow.this.binLimit = (Integer)WindowFunctionWindow.this.ftWindowXbinsSpinner.getValue();
            WindowFunctionWindow.this.dBLimit = -((Integer)WindowFunctionWindow.this.ftWindowYdBSpinner.getValue()).intValue();
            WindowFunctionWindow.this.windowWidth = WindowFunctionWindow.this.plotWidth * 4;
            WindowFunctionWindow.this.extendedN = WindowFunctionWindow.this.windowWidth * WindowFunctionWindow.this.binLimit * 10;
            if (Integer.bitCount(WindowFunctionWindow.this.extendedN) != 1) {
                WindowFunctionWindow.this.extendedN = Integer.highestOneBit(WindowFunctionWindow.this.extendedN) << 1;
            }
            double samplesPerPixel = (double)WindowFunctionWindow.this.windowWidth / (double)WindowFunctionWindow.this.plotWidth;
            WindowFunctionWindow.this.windowFunction = WindowFunction.windowFunction(WindowFunctionWindow.this.function, WindowFunctionWindow.this.windowWidth, WindowFunctionWindow.this.parameter);
            WindowFunctionWindow.this.windowFunctionMax = 0.0;
            int i = 0;
            while (i < WindowFunctionWindow.this.windowWidth) {
                WindowFunctionWindow.this.windowFunctionMax = Math.max(WindowFunctionWindow.this.windowFunction[i], WindowFunctionWindow.this.windowFunctionMax);
                ++i;
            }
            WindowFunctionWindow.this.windowFunctionScale = (double)WindowFunctionWindow.this.plotHeight / WindowFunctionWindow.this.windowFunctionMax;
            g2d.setColor(WindowFunctionWindow.this.ourGUI.getSettings().getAxisColor());
            int xBase = 60;
            int yBase = WindowFunctionWindow.this.plotHeight + 30;
            if (WindowFunctionWindow.this.windowFunction.length > 0) {
                g2d.setColor(WindowFunctionWindow.this.ourGUI.getSettings().getAxisColor());
                g2d.drawLine(xBase, yBase, xBase + WindowFunctionWindow.this.plotWidth, yBase);
                Utils.calibrateX(g2d, WindowFunctionWindow.this.plotWidth, 0.0, 1.0, xBase, yBase, Utils.AxisOmit0.KEEP0, Utils.AxisOmitNeg.OMIT_NEG, 5, Utils.getIndexLabel());
                Utils.calibrateY(g2d, WindowFunctionWindow.this.windowFunctionScale, WindowFunctionWindow.this.windowFunctionMax, xBase, yBase, WindowFunctionWindow.this.plotWidth, Utils.AxisOmit0.KEEP0, Utils.AxisOmitNeg.OMIT_NEG, Utils.AxisExtendYticks.No_ExtendYticks, 4, Utils.getAmplitudeLabel());
            }
            g2d.setColor(WindowFunctionWindow.this.ourGUI.getSettings().getFFTWindowColor());
            int prevScaledY = yBase - (int)Math.round(WindowFunctionWindow.this.windowFunction[0] * WindowFunctionWindow.this.windowFunctionScale);
            int i2 = 0;
            while (i2 < WindowFunctionWindow.this.plotWidth) {
                int sample = (int)Math.round((double)i2 * samplesPerPixel);
                sample = Math.min(sample, WindowFunctionWindow.this.windowFunction.length - 1);
                int scaledY = yBase - (int)Math.round(WindowFunctionWindow.this.windowFunction[sample] * WindowFunctionWindow.this.windowFunctionScale);
                g2d.drawLine(xBase + i2, prevScaledY, xBase + i2 + 1, scaledY);
                prevScaledY = scaledY;
                ++i2;
            }
            SpectrumBinList windowFT = FourierTransform.simpleLogFFT(WindowFunctionWindow.this.windowFunction, WindowFunctionWindow.this.extendedN);
            double niceDBLimit = Utils.getNiceAxisTop(WindowFunctionWindow.this.dBLimit);
            WindowFunctionWindow.this.windowFunctionScale = (double)WindowFunctionWindow.this.plotHeight / Utils.getNiceAxisTop(-niceDBLimit);
            double samplesPerFreq = (double)WindowFunctionWindow.this.extendedN / (double)WindowFunctionWindow.this.windowWidth;
            samplesPerPixel = (double)WindowFunctionWindow.this.binLimit / (double)WindowFunctionWindow.this.plotWidth * samplesPerFreq * 2.0;
            g2d.setColor(WindowFunctionWindow.this.ourGUI.getSettings().getAxisColor());
            xBase = 60;
            yBase = WindowFunctionWindow.this.plotHeight + 30 + 40;
            Utils.calibrateY(g2d, WindowFunctionWindow.this.windowFunctionScale, niceDBLimit, xBase, yBase, WindowFunctionWindow.this.plotWidth, Utils.AxisOmit0.KEEP0, Utils.AxisOmitNeg.OMIT_NEG, Utils.AxisExtendYticks.No_ExtendYticks, 4, Utils.getAmplitudeDBLabel());
            Utils.calibrateX(g2d, (double)WindowFunctionWindow.this.plotWidth / 2.0 / (double)WindowFunctionWindow.this.binLimit, 0.0, WindowFunctionWindow.this.binLimit, xBase + WindowFunctionWindow.this.plotWidth / 2, yBase + WindowFunctionWindow.this.plotHeight, Utils.AxisOmit0.KEEP0, Utils.AxisOmitNeg.KEEP_NEG, 5, "Frequency Offset [bins]");
            int prevLeftX = xBase;
            int prevRightX = xBase + WindowFunctionWindow.this.plotWidth;
            double limitedY = Math.max(WindowFunctionWindow.this.dBLimit, windowFT.getBinByIndex((int)Math.round((double)(WindowFunctionWindow.this.plotWidth / 2) * samplesPerPixel)).getAmplitude());
            prevScaledY = yBase - (int)Math.round(limitedY * WindowFunctionWindow.this.windowFunctionScale);
            g2d.setColor(WindowFunctionWindow.this.ourGUI.getSettings().getPlotColor());
            int i3 = WindowFunctionWindow.this.plotWidth / 2;
            while (i3 >= 0) {
                int sample = (int)Math.round((double)i3 * samplesPerPixel);
                limitedY = Math.max(WindowFunctionWindow.this.dBLimit, windowFT.getBinByIndex(sample).getAmplitude());
                int scaledY = yBase - (int)Math.round(limitedY * WindowFunctionWindow.this.windowFunctionScale);
                g2d.drawLine(prevLeftX, prevScaledY, prevLeftX + 1, scaledY);
                g2d.drawLine(prevRightX, prevScaledY, prevRightX - 1, scaledY);
                ++prevLeftX;
                --prevRightX;
                prevScaledY = scaledY;
                --i3;
            }
            WindowFunctionWindow.this.mlWidth = WindowFunctionWindow.this.mainLobeWidth(windowFT, samplesPerFreq);
            WindowFunctionWindow.this.mlWidthValue.setText(String.format("%.3f", WindowFunctionWindow.this.mlWidth));
            int maxSideLobeIdx = start = (int)Math.ceil(WindowFunctionWindow.this.mlWidth) * WindowFunctionWindow.this.extendedN / WindowFunctionWindow.this.windowWidth;
            WindowFunctionWindow.this.maxSideLobeValue = -1.7976931348623157E308;
            int i4 = start;
            while (i4 < windowFT.getSize()) {
                if (windowFT.getBinByIndex(i4).getAmplitude() > WindowFunctionWindow.this.maxSideLobeValue) {
                    WindowFunctionWindow.this.maxSideLobeValue = windowFT.getBinByIndex(i4).getAmplitude();
                    maxSideLobeIdx = i4;
                }
                ++i4;
            }
            WindowFunctionWindow.this.maxSideLobeF = (double)maxSideLobeIdx * (double)WindowFunctionWindow.this.windowWidth / (double)WindowFunctionWindow.this.extendedN;
            WindowFunctionWindow.this.nenbw = WindowFunctionWindow.this.nenbw(WindowFunctionWindow.this.windowFunction);
            WindowFunctionWindow.this.enbwCF = WindowFunctionWindow.this.enbwCorrection(WindowFunctionWindow.this.nenbw);
            Object result = "";
            try {
                result = "<html>Window width: " + WindowFunctionWindow.this.windowWidth + "   Transform width:" + WindowFunctionWindow.this.extendedN + "<br>Main Lobe Width [bins]: " + String.format("%.3f", WindowFunctionWindow.this.mlWidth) + "   NENBW: " + String.format("%.3f", WindowFunctionWindow.this.nenbw) + " Correction Factor: " + String.format("%.3f", WindowFunctionWindow.this.enbwCF) + " dB<br>Max Side Lobe Freq.: " + String.format("%.3f", WindowFunctionWindow.this.maxSideLobeF) + "   Max. Side Lobe dB: " + String.format("%.3f", WindowFunctionWindow.this.maxSideLobeValue) + "<br></html>";
            }
            catch (IllegalFormatException f) {
                System.out.println("Illegal format exception in DFT: " + f.getMessage());
            }
            catch (FormatterClosedException c) {
                System.out.println("Formatter closed exception in DFT:" + c.getMessage());
            }
            WindowFunctionWindow.this.resultLabel.setText((String)result);
        }
    }
}

