/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import roundtrip.AnalysisWindow;
import roundtrip.Utils;

class VideoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel videoPanel;
    private JButton buttonGoToStart = new JButton("<<");
    private JButton buttonGoToEnd = new JButton(">>");
    private String pause = "\u23f8";
    private String fwd = "\u25ba";
    private String bck = "\u25c0";
    private JButton buttonPlayBck = new JButton(this.bck);
    private JButton buttonPlayFwd = new JButton(this.fwd);
    private JButton buttonStepBck = new JButton("<");
    private JButton buttonStepFwd = new JButton(">");
    private String loop = "\u21ba";
    private String bounce = "\u21ba\u21bb";
    private JButton buttonLoop = new JButton(this.loop);
    private JButton buttonBounce = new JButton(this.bounce);
    private String goToStartTip = "Go to the Start of the frames.";
    private String goToEndTip = "Go to the End of the frames.";
    private String playBckTip = "Play backwards.";
    private String playFwdTip = "Play forwards.";
    private String stepBckTip = "Step back to previous frame.";
    private String stepFwdTip = "Step forward to next frame.";
    private String loopTip = "Repeatedly play from the beginning.";
    private String bounceTip = "Continually play forward from the beginning then backwards from the end.";
    private JLabel labelSpeed = new JLabel("Speed");
    private String speedTip = "Adjust the video speed.";
    private JTextField fieldSpeed = new JTextField(5);
    private JLabel frameLabel = new JLabel();
    private NumberFormat decimalFormat;
    private AnalysisWindow parentPanel;
    private boolean playing = false;
    private double speed;
    private static final double defaultSpeed = 0.5;
    private FlowLayout flowLayoutCenter = new FlowLayout(1);
    private List<VideoButtonListener> listeners = new ArrayList<VideoButtonListener>();

    VideoPanel(AnalysisWindow p) {
        this.parentPanel = p;
        this.frameLabel.setText("Frame: " + this.parentPanel.getCurrentFrame());
        this.decimalFormat = NumberFormat.getInstance(Locale.getDefault());
        this.decimalFormat.setMaximumFractionDigits(6);
        this.decimalFormat.setMinimumFractionDigits(1);
        this.buttonGoToStart.setToolTipText(this.goToStartTip);
        this.buttonGoToEnd.setToolTipText(this.goToEndTip);
        this.buttonPlayBck.setToolTipText(this.playBckTip);
        this.buttonPlayFwd.setToolTipText(this.playFwdTip);
        this.buttonStepBck.setToolTipText(this.stepBckTip);
        this.buttonStepFwd.setToolTipText(this.stepFwdTip);
        this.buttonLoop.setToolTipText(this.loopTip);
        this.buttonBounce.setToolTipText(this.bounceTip);
        this.labelSpeed.setToolTipText(this.speedTip);
        this.fieldSpeed.setToolTipText(this.speedTip);
        this.speed = 0.5;
        this.fieldSpeed.setText(this.decimalFormat.format(this.speed));
        this.fieldSpeed.setHorizontalAlignment(2);
        this.fieldSpeed.setCaretPosition(0);
        this.videoPanel = new JPanel(this.flowLayoutCenter);
        this.videoPanel.add(this.buttonGoToStart);
        this.videoPanel.add(this.buttonPlayBck);
        this.videoPanel.add(this.buttonStepBck);
        this.videoPanel.add(this.buttonStepFwd);
        this.videoPanel.add(this.buttonPlayFwd);
        this.videoPanel.add(this.buttonGoToEnd);
        this.videoPanel.add(this.buttonLoop);
        this.videoPanel.add(this.buttonBounce);
        this.videoPanel.add(this.labelSpeed);
        this.videoPanel.add(this.fieldSpeed);
        this.videoPanel.add(this.frameLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.videoPanel, "Last");
        this.buttonGoToStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoPanel.this.parentPanel.stop();
                VideoPanel.this.unPauseButtons();
                VideoPanel.this.toDoOnAction("Start");
            }
        });
        this.buttonGoToEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoPanel.this.parentPanel.stop();
                VideoPanel.this.unPauseButtons();
                VideoPanel.this.toDoOnAction("End");
            }
        });
        this.buttonPlayBck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!VideoPanel.this.playing) {
                    VideoPanel.this.buttonPlayBck.setText(VideoPanel.this.pause);
                    VideoPanel.this.playing = true;
                    VideoPanel.this.toDoOnAction("Bck");
                } else {
                    VideoPanel.this.parentPanel.stop();
                    VideoPanel.this.unPauseButtons();
                }
            }
        });
        this.buttonPlayFwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!VideoPanel.this.playing) {
                    VideoPanel.this.buttonPlayFwd.setText(VideoPanel.this.pause);
                    VideoPanel.this.playing = true;
                    VideoPanel.this.toDoOnAction("Fwd");
                } else {
                    VideoPanel.this.parentPanel.stop();
                    VideoPanel.this.unPauseButtons();
                }
            }
        });
        this.buttonStepBck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoPanel.this.parentPanel.stop();
                VideoPanel.this.unPauseButtons();
                VideoPanel.this.toDoOnAction("StepBck");
            }
        });
        this.buttonStepFwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoPanel.this.parentPanel.stop();
                VideoPanel.this.unPauseButtons();
                VideoPanel.this.toDoOnAction("StepFwd");
            }
        });
        this.buttonLoop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!VideoPanel.this.playing) {
                    VideoPanel.this.buttonLoop.setText(VideoPanel.this.pause);
                    VideoPanel.this.playing = true;
                    VideoPanel.this.toDoOnAction("Loop");
                } else {
                    VideoPanel.this.parentPanel.stop();
                    VideoPanel.this.playing = false;
                }
            }
        });
        this.buttonBounce.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!VideoPanel.this.playing) {
                    VideoPanel.this.buttonBounce.setText(VideoPanel.this.pause);
                    VideoPanel.this.playing = true;
                    VideoPanel.this.toDoOnAction("Bounce");
                } else {
                    VideoPanel.this.parentPanel.stop();
                    VideoPanel.this.playing = false;
                }
            }
        });
        this.fieldSpeed.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(final FocusEvent f) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField field = (JTextField)f.getSource();
                        field.selectAll();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent f) {
                if (f.isTemporary()) {
                    return;
                }
                JTextField field = (JTextField)f.getSource();
                if (field != VideoPanel.this.fieldSpeed) {
                    JOptionPane.showMessageDialog(VideoPanel.this.parentPanel, "Wrong speed field");
                    return;
                }
                double tmp = 1.0;
                tmp = Utils.parseLocalDouble(field.getText());
                if (Double.isNaN(tmp)) {
                    JOptionPane.showMessageDialog(VideoPanel.this.parentPanel, "Invalid number in speed field");
                    return;
                }
                if (tmp < 1.0E-4 || tmp > 1000.0) {
                    JOptionPane.showMessageDialog(VideoPanel.this.parentPanel, "Speed must be between 0.0001 and 1000");
                    return;
                }
                VideoPanel.this.fieldSpeed.setText(VideoPanel.this.decimalFormat.format(tmp));
                VideoPanel.this.speed = tmp;
            }
        });
    }

    private void toDoOnAction(String button) {
        for (VideoButtonListener zpl : this.listeners) {
            zpl.videoEvent(button);
        }
    }

    void addListener(VideoButtonListener l) {
        this.listeners.add(l);
    }

    public void unPauseButtons() {
        this.playing = false;
        this.buttonPlayFwd.setText(this.fwd);
        this.buttonPlayBck.setText(this.bck);
        this.buttonLoop.setText(this.loop);
        this.buttonBounce.setText(this.bounce);
    }

    public double getSpeed() {
        return this.speed;
    }

    public void updateFrame() {
        double timeInFile = (double)(this.parentPanel.getCurrentFrame() * this.parentPanel.getAnalysisParameters().getFtStepSamples() + this.parentPanel.getFtInputPanel().getMark1Samples()) / (double)this.parentPanel.getFtInputPanel().getSampleRate();
        double elapsedTime = (double)(this.parentPanel.getCurrentFrame() * this.parentPanel.getAnalysisParameters().getFtStepSamples()) / (double)this.parentPanel.getFtInputPanel().getSampleRate();
        this.frameLabel.setText("Frame: " + this.parentPanel.getCurrentFrame() + " From start: " + Utils.formatShortTime(elapsedTime) + " in File: " + Utils.formatShortTime(timeInFile));
    }

    static interface VideoButtonListener {
        public void videoEvent(String var1);
    }
}

