/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import javax.swing.JPanel;
import roundtrip.FRTmain;
import roundtrip.SynthesisParameters;
import roundtrip.SynthesisWindow;
import roundtrip.SynthesisedWave;
import roundtrip.Utils;

class SynthesisedWavePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FRTmain ourGUI;
    private SynthesisWindow synthesis;
    private SynthesisParameters ourParams;
    private String noValidCon = "No valid constructor";
    private Graphics2D g2d;
    private SynthesisedWave waveData;
    private int xWaveBase;
    private int yWaveBase;
    private int xWaveWidth;
    private int xFigBase;
    private int yFigBase;
    private double scale;
    private int vectorAngle;
    private double pointRadius = 3.0;
    private static final float[] dash = new float[]{5.0f};

    SynthesisedWavePanel(FRTmain mainGUI, SynthesisWindow s) {
        this.ourGUI = mainGUI;
        this.synthesis = s;
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        double[] figureX;
        super.paintComponent(g);
        this.ourParams = this.ourGUI.getSynthParams();
        this.waveData = this.synthesis.getWave();
        this.scale = this.synthesis.getScale();
        int xMargin = Utils.getXmarginL();
        this.xWaveWidth = this.getWidth() / 2 - xMargin * 2;
        this.xWaveBase = xMargin;
        this.yWaveBase = this.getHeight() / 2;
        this.xFigBase = this.getWidth() * 3 / 4;
        this.yFigBase = this.yWaveBase;
        this.g2d = (Graphics2D)g;
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.setColor(this.ourGUI.getSettings().getSynthesisBackground());
        this.g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.g2d.setStroke(new BasicStroke(1.0f));
        if (this.waveData.getCancelled()) {
            this.g2d.setColor(this.ourGUI.getSettings().getMessageColor());
            this.g2d.drawString("Wave caclulation was cancelled!", 50, 50);
            return;
        }
        this.g2d.setColor(this.ourGUI.getSettings().getAxisColor());
        this.g2d.drawLine(this.xWaveBase, this.yWaveBase, this.xWaveBase + this.xWaveWidth, this.yWaveBase);
        Utils.calibrateX(this.g2d, (double)this.xWaveWidth / 360.0, 0.0, 360.0, this.xWaveBase, this.yWaveBase, Utils.AxisOmit0.KEEP0, Utils.AxisOmitNeg.OMIT_NEG, 4, Utils.getAngleLabel());
        Utils.calibrateY(this.g2d, this.scale, this.waveData.getMaxAmplitude(), this.xWaveBase, this.yWaveBase, this.xWaveWidth, Utils.AxisOmit0.KEEP0, Utils.AxisOmitNeg.KEEP_NEG, Utils.AxisExtendYticks.No_ExtendYticks, 4, Utils.getAmplitudeLabel());
        int waveX1 = this.xWaveBase;
        int waveY1 = this.yWaveBase;
        int waveX2 = 0;
        int waveY2 = 0;
        int figureX1 = this.xFigBase;
        int figureY1 = this.yFigBase;
        int figureX2 = 0;
        int figureY2 = 0;
        this.g2d.setColor(this.ourGUI.getSettings().getWaveColor());
        double[] wave = this.waveData.getWave();
        int i2 = 0;
        while (i2 < wave.length) {
            waveX2 = this.xWaveBase + i2;
            waveY2 = this.yWaveBase - (int)Math.round(wave[i2] * this.scale);
            if (i2 > 0) {
                this.g2d.drawLine(waveX1, waveY1, waveX2, waveY2);
            }
            waveX1 = waveX2;
            waveY1 = waveY2;
            ++i2;
        }
        int dotXidx = (int)Math.round((double)this.xWaveWidth * (double)this.vectorAngle / 360.0);
        dotXidx = Math.min(dotXidx, this.xWaveWidth - 1);
        int dotX = this.xWaveBase + dotXidx;
        int dotY = this.yWaveBase - (int)Math.round(wave[dotXidx] * this.scale);
        Color oldColor = this.g2d.getColor();
        Font oldFont = this.g2d.getFont();
        this.g2d.setColor(this.ourGUI.getSettings().getRefPointColor());
        Ellipse2D.Double circle = new Ellipse2D.Double((double)dotX - this.pointRadius, (double)dotY - this.pointRadius, this.pointRadius * 2.0, this.pointRadius * 2.0);
        this.g2d.fill(circle);
        this.g2d.draw(circle);
        this.g2d.setColor(oldColor);
        boolean plotSound = false;
        if (plotSound) {
            this.g2d.setColor(this.ourGUI.getSettings().getSoundColor());
            byte[] soundWave = this.waveData.getSound();
            int soundBytes = (int)Math.round((double)this.ourParams.getSampleRate() / this.waveData.getRealFrequency());
            byte soundScale = 1;
            int i3 = 0;
            while (i3 <= soundBytes) {
                waveX2 = this.xWaveBase + i3 * 360 / soundBytes;
                waveY2 = this.yWaveBase - Math.round(soundWave[i3] * soundScale);
                if (i3 > 0) {
                    this.g2d.drawLine(waveX1, waveY1, waveX2, waveY2);
                }
                waveX1 = waveX2;
                waveY1 = waveY2;
                ++i3;
            }
        }
        if (this.ourParams.getDisplayConFig() || this.ourParams.getDisplayRefFig()) {
            this.g2d.setColor(this.ourGUI.getSettings().getAxisColor());
            double niceMax = Utils.getNiceAxisTop(this.waveData.getMaxAmplitude());
            Utils.calibrateX(this.g2d, this.synthesis.getScale(), 0.0, niceMax, this.xFigBase, this.yFigBase, Utils.AxisOmit0.KEEP0, Utils.AxisOmitNeg.KEEP_NEG, 4, null);
            Utils.calibrateY(this.g2d, this.synthesis.getScale(), this.waveData.getMaxAmplitude(), this.xFigBase, this.yFigBase, this.xWaveWidth, Utils.AxisOmit0.OMIT0, Utils.AxisOmitNeg.KEEP_NEG, Utils.AxisExtendYticks.No_ExtendYticks, 4, null);
        }
        if (this.ourParams.getDisplayRefFig()) {
            this.g2d.setColor(this.ourGUI.getSettings().getRefFigColor());
            figureX = this.waveData.getFigureX();
            double[] figureY = this.waveData.getFigureY();
            i = 0;
            while (i < figureX.length) {
                figureX2 = this.xFigBase + (int)Math.round(figureX[i] * this.scale);
                figureY2 = this.yFigBase - (int)Math.round(figureY[i] * this.scale);
                if (i > 0) {
                    this.g2d.drawLine(figureX1, figureY1, figureX2, figureY2);
                }
                figureX1 = figureX2;
                figureY1 = figureY2;
                ++i;
            }
            this.plotVector(this.vectorAngle);
        }
        if (this.ourParams.getDisplayConFig()) {
            this.g2d.setColor(this.ourGUI.getSettings().getConFigColor());
            figureX = this.waveData.getConstructorX();
            double[] figureY = this.waveData.getConstructorY();
            i = 0;
            while (i < figureX.length) {
                figureY2 = this.yFigBase - (int)Math.round(figureY[i] * this.scale);
                figureX2 = 0;
                if (Double.isNaN(figureX[i])) {
                    figureX2 = Integer.MAX_VALUE;
                }
                double angle = (double)i * 360.0 / (double)this.xWaveWidth;
                double ourDCBase = this.yFigBase;
                if (this.ourParams.getDisplayConDC()) {
                    ourDCBase -= this.waveData.getTotalDC() * this.scale;
                }
                int ourDCBaseInt = (int)Math.round(ourDCBase);
                if (!(angle > 0.0 && angle < 180.0 && figureY2 <= ourDCBaseInt || angle > 180.0 && angle < 360.0 && figureY2 >= ourDCBaseInt)) {
                    figureX2 = Integer.MAX_VALUE;
                }
                if (figureX2 != Integer.MAX_VALUE) {
                    figureX2 = this.xFigBase + (int)Math.round(figureX[i] * this.scale);
                }
                if (figureX1 != Integer.MAX_VALUE && figureX2 != Integer.MAX_VALUE) {
                    this.g2d.drawLine(figureX1, figureY1, figureX2, figureY2);
                }
                figureX1 = figureX2;
                figureY1 = figureY2;
                if (figureX1 != Integer.MAX_VALUE && figureX2 != Integer.MAX_VALUE && Math.abs((double)this.vectorAngle - angle) < 360.0 / (double)this.xWaveWidth / 2.0) {
                    oldColor = this.g2d.getColor();
                    oldFont = this.g2d.getFont();
                    this.g2d.setColor(this.ourGUI.getSettings().getConPointColor());
                    this.g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f));
                    this.g2d.drawLine(this.xFigBase, ourDCBaseInt, figureX2, figureY2);
                    if (this.ourParams.getDisplayConVerticals()) {
                        this.g2d.drawLine(figureX2, figureY2, figureX2, this.yFigBase);
                        this.g2d.drawLine(dotX, dotY, figureX2, figureY2);
                    }
                    this.g2d.setStroke(new BasicStroke(1.0f));
                    circle = new Ellipse2D.Double((double)figureX2 - this.pointRadius, (double)figureY2 - this.pointRadius, this.pointRadius * 2.0, this.pointRadius * 2.0);
                    this.g2d.fill(circle);
                    this.g2d.draw(circle);
                    this.g2d.setColor(oldColor);
                } else if (Math.abs((double)this.vectorAngle - angle) < 360.0 / (double)this.xWaveWidth / 2.0) {
                    int x = this.xFigBase + (int)Math.round(this.scale * Math.cos(Math.toRadians(angle)));
                    int y = ourDCBaseInt - (int)Math.round(this.scale * Math.sin(Math.toRadians(angle)));
                    int xString = x;
                    if (x < this.xFigBase) {
                        this.g2d.setFont(Utils.getMsgFont());
                        FontMetrics metrics = this.g2d.getFontMetrics(Utils.getMsgFont());
                        xString -= metrics.stringWidth(this.noValidCon);
                    }
                    oldColor = this.g2d.getColor();
                    this.g2d.setColor(this.ourGUI.getSettings().getConPointColor());
                    this.g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f));
                    this.g2d.drawLine(this.xFigBase, ourDCBaseInt, x, y);
                    this.g2d.setStroke(new BasicStroke(1.0f));
                    this.g2d.setFont(Utils.getMsgFont());
                    this.g2d.drawString(this.noValidCon, xString, y);
                    this.g2d.setColor(oldColor);
                    this.g2d.setFont(oldFont);
                }
                ++i;
            }
        }
    }

    public void setVectorAngle(int angle) {
        this.vectorAngle = angle;
    }

    private void plotVector(int angle) {
        if (this.ourParams.getDisplayRefVectors()) {
            Color tmp = this.g2d.getColor();
            this.g2d.setColor(this.ourGUI.getSettings().getRefFigCircleColor());
            Path2D.Double vectorPath = new Path2D.Double();
            vectorPath.moveTo(this.xFigBase, this.yFigBase);
            double[][] vectors = this.waveData.getFigureVectors(angle);
            double x = this.xFigBase;
            double y = this.yFigBase;
            int i = 0;
            while (i < vectors.length) {
                if (this.ourParams.getDisplayRefCircles()) {
                    this.g2d.draw(new Ellipse2D.Double(x - vectors[i][2] * this.scale, y - vectors[i][2] * this.scale, 2.0 * this.scale * vectors[i][2], 2.0 * this.scale * vectors[i][2]));
                }
                vectorPath.lineTo(x += vectors[i][0] * this.scale, y -= vectors[i][1] * this.scale);
                ++i;
            }
            this.g2d.setColor(this.ourGUI.getSettings().getRefFigVectorColor());
            this.g2d.draw(vectorPath);
            this.g2d.setColor(tmp);
        }
    }

    public int getWaveWidth() {
        return this.xWaveWidth;
    }
}

