/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import roundtrip.FRTmain;
import roundtrip.SpectrumBin;
import roundtrip.SpectrumBinList;

class SynthImport {
    private File inFile;
    private BufferedReader in;
    private Integer inLineNo = 0;
    private String errors = "";
    private String sep = "|";
    private FRTmain mainGUI;
    private JFrame mainFrame;
    private SpectrumBinList harmonics;
    private NumberFormat genFormat = NumberFormat.getInstance(Locale.getDefault());
    private static String findNewLine = "\\\\n";
    private static String replaceNewLine = "\n";

    SynthImport(FRTmain parentGUI, File file) {
        this.mainGUI = parentGUI;
        this.mainFrame = parentGUI.getMainWindow();
        this.inFile = file;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean readFile() {
        Boolean result;
        String line = " ";
        this.inLineNo = 1;
        this.errors = "";
        this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.inFile), "UTF8"));
        line = this.in.readLine();
        if (line == null || line.isEmpty() || !line.startsWith("sep=")) {
            JOptionPane.showMessageDialog(this.mainFrame, "First line of input file must be sep=; or sep=, etc.");
            return false;
        }
        this.sep = line.substring(4, 5);
        this.inLineNo = this.inLineNo + 1;
        line = this.in.readLine();
        String[] parts = line.split(this.sep, -1);
        if (!parts[0].equals("Description")) {
            this.errors = this.errors + "Description missing in line " + String.format("%03d", this.inLineNo) + "\n";
        }
        String buffer = SynthImport.buildText(parts, this.sep, 1);
        this.mainGUI.getSynthParams().setDescription(buffer);
        this.inLineNo = this.inLineNo + 1;
        line = this.in.readLine();
        parts = line.split(this.sep, -1);
        if (!parts[0].equals("Frequency")) {
            this.errors = this.errors + "Frequency and sample rate missing in line " + String.format("%03d", this.inLineNo) + "\n";
        }
        double realFreq = 440.0;
        Number partD = 0;
        try {
            partD = this.genFormat.parse(parts[1]);
        }
        catch (NullPointerException | NumberFormatException | ParseException e) {
            this.errors = this.errors + "Frequency invalid value in line " + String.format("%03d", this.inLineNo) + "\n";
        }
        realFreq = partD.doubleValue();
        this.mainGUI.getSynthParams().setFrequency(realFreq);
        int rate = 44000;
        try {
            rate = Integer.parseInt(parts[2]);
        }
        catch (NullPointerException | NumberFormatException e) {
            this.errors = this.errors + "Sample rate invalid value in line " + String.format("%03d", this.inLineNo) + "\n";
        }
        this.mainGUI.getSynthParams().setFrequency(realFreq);
        this.mainGUI.getSynthParams().setSampleRate(rate);
        this.inLineNo = this.inLineNo + 1;
        line = this.in.readLine();
        parts = line.split(this.sep, -1);
        if (!parts[0].equals("Noise")) {
            this.errors = this.errors + "Noise missing in line " + String.format("%03d", this.inLineNo) + "\n";
        }
        if (!parts[1].toLowerCase().equals("true") && !parts[1].toLowerCase().equals("false")) {
            this.errors = this.errors + "Noise invalid boolean in line " + String.format("%03d", this.inLineNo) + "\n";
        }
        if ((result = Boolean.valueOf(parts[1])) == null) {
            this.errors = this.errors + "Noise invalid boolean in line " + String.format("%03d", this.inLineNo) + "\n";
        }
        this.mainGUI.getSynthParams().setNoiseOn(result);
        double peak = 0.0;
        try {
            partD = this.genFormat.parse(parts[2]);
            peak = Double.parseDouble(parts[2]);
        }
        catch (NullPointerException | NumberFormatException | ParseException e) {
            this.errors = this.errors + "Noise invalid peak value in line " + String.format("%03d", this.inLineNo) + "\n";
        }
        peak = partD.doubleValue();
        this.mainGUI.getSynthParams().setNoisePeak(peak);
        this.inLineNo = this.inLineNo + 1;
        line = this.in.readLine();
        if (!line.equals("Frequency;Amplitude;Phase")) {
            this.errors = this.errors + "Column titles missing or incorrect in line " + String.format("%03d", this.inLineNo) + "\n";
        }
        this.inLineNo = this.inLineNo + 1;
        this.harmonics = new SpectrumBinList();
        boolean bl = true;
        while (true) {
            if (!bl || (bl = false) || !true) {
                this.inLineNo = this.inLineNo + 1;
                String tmp = line;
                if (line.trim().length() > 0 && !tmp.trim().startsWith("//")) {
                    parts = line.split(this.sep, -1);
                    partD = 0;
                    try {
                        partD = this.genFormat.parse(parts[0]);
                    }
                    catch (Exception n) {
                        this.errors = this.errors + "Invalid number in frequency in line " + String.format("%03d", this.inLineNo) + "\n";
                    }
                    double freq = partD.doubleValue();
                    try {
                        partD = this.genFormat.parse(parts[1]);
                    }
                    catch (Exception n) {
                        this.errors = this.errors + "Invalid number in amplitude in line " + String.format("%03d", this.inLineNo) + "\n";
                    }
                    double amp = partD.doubleValue();
                    try {
                        partD = this.genFormat.parse(parts[2]);
                    }
                    catch (Exception n) {
                        this.errors = this.errors + "Invalid number in phase in line " + String.format("%03d", this.inLineNo) + "\n";
                    }
                    double phase = partD.doubleValue();
                    if (!this.errors.equals("")) {
                        JOptionPane.showMessageDialog(this.mainFrame, this.errors);
                        return false;
                    }
                    SpectrumBin newH = new SpectrumBin(freq, amp, phase);
                    this.harmonics.addSpectrumBin(newH);
                }
            }
            if ((line = this.in.readLine()) != null) continue;
            break;
        }
        {
            try {
                if (this.in == null) return true;
                this.in.close();
                return true;
            }
            catch (IOException f) {
                JOptionPane.showMessageDialog(this.mainFrame, "Input File: IO Exception closing input file");
                return false;
            }
            catch (IOException e) {}
            JOptionPane.showMessageDialog(this.mainFrame, "Input File: IO Exception reading file");
            return false;
        }
        finally {
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException f) {
                JOptionPane.showMessageDialog(this.mainFrame, "Input File: IO Exception closing input file after read error");
                return false;
            }
        }
    }

    public SpectrumBinList getHarmonics() {
        return this.harmonics;
    }

    private static String buildText(String[] parts, String sep, int start) {
        Object buffer = "";
        Pattern pattern = Pattern.compile(findNewLine);
        int k = start;
        while (k < parts.length) {
            if (k > start) {
                buffer = (String)buffer + sep;
            }
            Matcher matcher = pattern.matcher(parts[k]);
            parts[k] = matcher.replaceAll(Matcher.quoteReplacement(replaceNewLine));
            buffer = (String)buffer + parts[k];
            ++k;
        }
        return buffer;
    }
}

