/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class GraphicsColorEditor
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JDialog ourFrame;
    private JFrame ourParent;
    private String oldName = "";
    private Color oldColor;
    private Color resultColor;
    private String result;
    private JLabel nameLabel = new JLabel("Name:");
    private JTextField nameField = new JTextField(30);
    private JButton buttonOK = new JButton("OK");
    private JButton buttonCancel = new JButton("Cancel");

    GraphicsColorEditor(JFrame ourGUI, String inName, Color inColor) {
        super(ourGUI, "Palette Color Editor", true);
        this.ourFrame = this;
        this.ourParent = ourGUI;
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle("Graphics Colour Editor - " + inName);
        int currentX = this.ourParent.getX();
        int currentY = this.ourParent.getY();
        this.setLocation(currentX - 200, currentY + 100);
        this.oldColor = inColor;
        JPanel namePanel = new JPanel();
        this.nameField.setText(this.oldName);
        this.nameField.selectAll();
        this.nameField.setEditable(false);
        namePanel.add(this.nameLabel);
        namePanel.add(this.nameField);
        final JColorChooser ourChooser = new JColorChooser(this.oldColor);
        this.buttonOK.setToolTipText("Apply the edits and close the window");
        this.buttonOK.setPreferredSize(new Dimension(100, 20));
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ok) {
                GraphicsColorEditor.this.result = "OK";
                GraphicsColorEditor.this.resultColor = ourChooser.getColor();
                GraphicsColorEditor.this.ourFrame.dispose();
            }
        });
        this.buttonCancel.setToolTipText("Close the window");
        this.buttonCancel.setPreferredSize(new Dimension(100, 20));
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent can) {
                GraphicsColorEditor.this.result = "Cancel";
                GraphicsColorEditor.this.resultColor = GraphicsColorEditor.this.oldColor;
                GraphicsColorEditor.this.ourFrame.dispose();
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.buttonOK);
        buttonsPanel.add(this.buttonCancel);
        Box overallBox = Box.createVerticalBox();
        overallBox.add(namePanel);
        overallBox.add(ourChooser);
        overallBox.add(buttonsPanel);
        this.add(overallBox);
        this.pack();
        this.setVisible(true);
    }

    public String getResult() {
        return this.result;
    }

    public Color getResultColor() {
        return this.resultColor;
    }

    public String getResultName() {
        return this.nameField.getText();
    }
}

