/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import roundtrip.AnalysisParameters;
import roundtrip.AnalysisWindow;
import roundtrip.Complex;
import roundtrip.SpectrumBin;
import roundtrip.SpectrumBinList;

class FourierTransform {
    private int n;
    private SpectrumBinList freqResults;
    private AnalysisParameters analysisParams;
    private AnalysisWindow analysisWindow;
    private int progressBarIndex;
    private JProgressBar[] ftProgressBars;
    private int ourFrame;
    private int nFrames;
    private double[] inputWindow;
    private double[] windowedWave;
    private double inputWindowMin;
    private double inputWindowMax;
    private double inputWindowAvg;
    private double[] windowFunction;
    private Complex[] part1Result;
    private int cztLength;
    private boolean cancel;

    FourierTransform(AnalysisParameters caller, JProgressBar[] progressBarsIn, int progressBarIndexIn, int inFrame, int inNframes, int inWinStartSample, int inWinLength, FTtype typeIn) {
        this.analysisParams = caller;
        this.analysisWindow = this.analysisParams.getAnalysisWindow();
        this.progressBarIndex = progressBarIndexIn;
        this.ftProgressBars = progressBarsIn;
        this.ourFrame = inFrame;
        this.nFrames = inNframes;
        this.windowFunction = this.analysisParams.getFFTWindowFunction();
        this.cancel = false;
        this.inputWindow = this.analysisWindow.getFtInputPanel().getSubSample(inWinStartSample, inWinStartSample + inWinLength);
        if (this.analysisParams.getFilterDC()) {
            int sum = 0;
            int i = 0;
            while (i < this.inputWindow.length) {
                sum = (int)((double)sum + this.inputWindow[i]);
                ++i;
            }
            this.inputWindowAvg = (double)sum / (double)this.inputWindow.length;
            i = 0;
            while (i < this.inputWindow.length) {
                this.inputWindow[i] = (int)Math.round(this.inputWindow[i] - this.inputWindowAvg);
                ++i;
            }
        }
        this.windowedWave = new double[this.inputWindow.length];
        this.inputWindowMax = -1.7976931348623157E308;
        this.inputWindowMin = Double.MAX_VALUE;
        if (this.windowFunction != null) {
            int i = 0;
            while (i < this.inputWindow.length) {
                this.inputWindow[i] = (int)Math.round(this.inputWindow[i] * this.windowFunction[i]);
                this.windowedWave[i] = this.inputWindow[i];
                this.inputWindowMin = Math.min(this.inputWindowMin, this.inputWindow[i]);
                this.inputWindowMax = Math.max(this.inputWindowMax, this.inputWindow[i]);
                ++i;
            }
        } else {
            JOptionPane.showMessageDialog(caller, "FourierTransform: Window Function is null");
            return;
        }
        int pad = this.analysisParams.getZeroPadding();
        if (pad > 0) {
            double[] paddedWindow = Arrays.copyOf(this.inputWindow, this.inputWindow.length + pad);
            int i = this.inputWindow.length;
            while (i < this.inputWindow.length + pad) {
                paddedWindow[i] = 0.0;
                ++i;
            }
            this.inputWindow = paddedWindow;
        }
        if (typeIn == FTtype.FFT) {
            double[] expandedWindow = this.windowPower2(this.inputWindow);
            this.inputWindow = expandedWindow;
        }
    }

    private double[] windowPower2(double[] inWindow) {
        double[] expandedWindow;
        int startSize = inWindow.length;
        int expandedWindowWidth = startSize;
        if (Integer.bitCount(expandedWindowWidth) != 1) {
            expandedWindowWidth = Integer.highestOneBit(startSize) << 1;
            expandedWindow = new double[expandedWindowWidth];
            int indexOfWindowStart = (expandedWindowWidth - startSize) / 2;
            int indexOfWindowEnd = indexOfWindowStart + startSize;
            int i = 0;
            while (i < indexOfWindowStart) {
                expandedWindow[i] = 0.0;
                ++i;
            }
            i = indexOfWindowStart;
            while (i < indexOfWindowEnd) {
                expandedWindow[i] = inWindow[i - indexOfWindowStart];
                ++i;
            }
            i = indexOfWindowEnd;
            while (i < expandedWindowWidth) {
                expandedWindow[i] = 0.0;
                ++i;
            }
        } else {
            expandedWindow = inWindow;
        }
        return expandedWindow;
    }

    public Complex[] functionDFTpart1() {
        this.n = this.inputWindow.length;
        this.part1Result = new Complex[this.n / 2 + 1];
        int f = 0;
        while (f < this.n / 2 + 1) {
            double tmpReal = 0.0;
            double tmpImag = 0.0;
            int t = 0;
            while (t < this.n) {
                tmpReal += this.inputWindow[t] * Math.cos(Math.PI * 2 * (double)f * (double)t / (double)this.n);
                tmpImag -= this.inputWindow[t] * Math.sin(Math.PI * 2 * (double)f * (double)t / (double)this.n);
                ++t;
            }
            int soFar = 100 * f / (this.n / 2 + 1);
            this.ftProgressBars[this.progressBarIndex].setString("DFT Frame " + (this.ourFrame + 1) + " of " + this.nFrames + " " + soFar + " %");
            if (this.cancel) {
                return null;
            }
            this.part1Result[f] = new Complex(tmpReal, tmpImag);
            ++f;
        }
        return this.part1Result;
    }

    public Complex[] functionFFTpart1(Complex[] input) {
        int inputWidth = input.length;
        this.part1Result = new Complex[inputWidth];
        this.n = input.length;
        int levels = 31 - Integer.numberOfLeadingZeros(this.n);
        if (1 << levels != this.n) {
            throw new IllegalArgumentException("FFT Length is not a power of 2");
        }
        double[] cosTable = new double[this.n / 2];
        double[] sinTable = new double[this.n / 2];
        int i = 0;
        while (i < this.n / 2) {
            cosTable[i] = Math.cos(Math.PI * 2 * (double)i / (double)this.n);
            sinTable[i] = Math.sin(Math.PI * 2 * (double)i / (double)this.n);
            ++i;
        }
        i = 0;
        while (i < this.n) {
            int j = Integer.reverse(i) >>> 32 - levels;
            if (j > i) {
                Complex temp = input[i];
                input[i] = input[j];
                input[j] = temp;
            }
            ++i;
        }
        int size = 2;
        while (size <= this.n) {
            int halfsize = size / 2;
            int tablestep = this.n / size;
            int i2 = 0;
            while (i2 < this.n) {
                int j = i2;
                int k = 0;
                while (j < i2 + halfsize) {
                    int l = j + halfsize;
                    double tpre = input[l].getReal() * cosTable[k] + input[l].getImag() * sinTable[k];
                    double tpim = -input[l].getReal() * sinTable[k] + input[l].getImag() * cosTable[k];
                    Complex tmpl = new Complex(input[j].getReal() - tpre, input[j].getImag() - tpim);
                    Complex tmpj = new Complex(input[j].getReal() + tpre, input[j].getImag() + tpim);
                    input[l] = tmpl;
                    input[j] = tmpj;
                    ++j;
                    k += tablestep;
                }
                int soFar = 100 * size / this.n;
                this.ftProgressBars[this.progressBarIndex].setString("FFT Frame " + (this.ourFrame + 1) + " of " + this.nFrames + " " + soFar + "%");
                if (this.cancel) {
                    if (this.freqResults != null) {
                        this.freqResults.clearBinList();
                    }
                    return null;
                }
                i2 += size;
            }
            if (size == this.n) break;
            size *= 2;
        }
        i = 0;
        while (i < this.n) {
            this.part1Result[i] = input[i];
            ++i;
        }
        return this.part1Result;
    }

    private Complex[] functionIFFT(Complex[] in) {
        Complex[] working = new Complex[in.length];
        int i = 0;
        while (i < in.length) {
            working[i] = in[i].conjugate();
            ++i;
        }
        Complex[] inv = this.functionFFTpart1(working);
        int i2 = 0;
        while (i2 < in.length) {
            int soFar = 100 * i2 / (in.length + 1);
            this.ftProgressBars[this.progressBarIndex].setString("IFFT Frame " + (this.ourFrame + 1) + " of " + this.nFrames + " " + soFar + " %");
            if (this.cancel) {
                return null;
            }
            working[i2] = inv[i2].conjugate().scalarDivide(in.length);
            ++i2;
        }
        return working;
    }

    public Complex[] functionCZTpart1(Complex[] xComplex, double to, double Dt, double fo, double Df, int M) {
        int N = xComplex.length;
        Complex[] result = new Complex[M];
        double real = 0.0;
        double imag = 0.0;
        int i = 0;
        while (i < M) {
            result[i] = new Complex(0.0, 0.0);
            ++i;
        }
        int k = 1;
        while (k <= M) {
            real = 0.0;
            imag = 0.0;
            int n = 1;
            while (n <= N) {
                double exp = Math.PI * -2 * (to + Dt * (double)(n - 1)) * (fo + Df * (double)(k - 1));
                double reE = Math.cos(exp);
                double imE = Math.sin(exp);
                real += xComplex[n - 1].getReal() * reE;
                imag += xComplex[n - 1].getReal() * imE;
                ++n;
            }
            result[k - 1] = new Complex(real, imag);
            int soFar = 100 * k / M;
            this.ftProgressBars[this.progressBarIndex].setString("CZT Frame " + (this.ourFrame + 1) + " of " + this.nFrames + " " + soFar + " %");
            if (this.cancel) {
                return null;
            }
            ++k;
        }
        this.cztLength = M;
        return result;
    }

    public SpectrumBinList ftPart2(Complex[] complexFT, int nFreq) {
        if (this.cancel) {
            if (this.freqResults != null) {
                this.freqResults.clearBinList();
            }
            return null;
        }
        SpectrumBinList freqResults = new SpectrumBinList();
        this.n = this.inputWindow.length;
        int f = 0;
        while (f < nFreq) {
            double real = complexFT[f].getReal();
            double imag = complexFT[f].getImag();
            double amplitude = Math.sqrt(real * real + imag * imag) * 2.0 / (double)this.n;
            double phase = Math.atan2(imag, real);
            if ((phase += 1.5707963267948966) >= Math.PI * 2) {
                phase -= Math.PI * 2;
            }
            if (phase > Math.PI) {
                phase = -phase + Math.PI;
            }
            if (f == 0) {
                amplitude /= 2.0;
                phase = 0.0;
            }
            freqResults.addSpectrumBin(new SpectrumBin(f, amplitude, phase));
            int soFar = 100 * f / (this.n / 2 + 1);
            this.ftProgressBars[this.progressBarIndex].setString("Part2a Frame " + (this.ourFrame + 1) + " of " + this.nFrames + " " + soFar + " %");
            if (this.cancel) {
                freqResults.clearBinList();
                return null;
            }
            ++f;
        }
        double tmpAmp = 0.0;
        double oldMaxAmp = freqResults.getMaxAmp();
        int i = 0;
        while (i < freqResults.getSize()) {
            tmpAmp = freqResults.getBinByIndex(i).getAmplitude();
            double tmpPhase = freqResults.getBinByIndex(i).getPhase();
            AnalysisParameters.SpectrumScale scaling = this.analysisParams.getFtLinLog();
            switch (scaling) {
                case SpectrumLinear: {
                    break;
                }
                case SpectrumLogFS: {
                    tmpAmp = 20.0 * Math.log10(tmpAmp / (double)this.analysisParams.getRawWave().getMaxAbsSample());
                    break;
                }
                case SpectrumLogRel: {
                    tmpAmp = 20.0 * Math.log10(tmpAmp / oldMaxAmp);
                    break;
                }
                default: {
                    System.out.println("Invalid value for spectrum scaling:" + String.valueOf((Object)scaling));
                }
            }
            freqResults.setAmplitudeOfIndex(i, tmpAmp);
            freqResults.setPhaseOfIndex(i, tmpPhase);
            int soFar = 100 * i / freqResults.getSize();
            this.ftProgressBars[this.progressBarIndex].setString("Part2b Frame " + (this.ourFrame + 1) + " of " + this.nFrames + " " + soFar + " %");
            if (this.cancel) {
                freqResults.clearBinList();
                return null;
            }
            ++i;
        }
        return freqResults;
    }

    public static SpectrumBinList simpleLogFFT(double[] window, int extendedWidthIn) {
        int extendedWidth = extendedWidthIn;
        if (Integer.bitCount(extendedWidth) != 1) {
            throw new IllegalArgumentException("Length is not a power of 2");
        }
        SpectrumBinList freqResults = new SpectrumBinList();
        double[] extendedWindow = new double[extendedWidth];
        if (extendedWidth <= window.length) {
            extendedWindow = window;
        } else {
            int i = 0;
            while (i < window.length) {
                extendedWindow[i] = window[i];
                ++i;
            }
            i = window.length;
            while (i < extendedWidth) {
                extendedWindow[i] = 0.0;
                ++i;
            }
        }
        double[] real = new double[extendedWidth];
        double[] imag = new double[extendedWidth];
        int i = 0;
        while (i < extendedWidth) {
            real[i] = extendedWindow[i];
            imag[i] = 0.0;
            ++i;
        }
        int n = real.length;
        if (n != imag.length) {
            throw new IllegalArgumentException("Mismatched lengths");
        }
        int levels = 31 - Integer.numberOfLeadingZeros(n);
        if (1 << levels != n) {
            throw new IllegalArgumentException("Length is not a power of 2");
        }
        double[] cosTable = new double[n / 2];
        double[] sinTable = new double[n / 2];
        int i2 = 0;
        while (i2 < n / 2) {
            cosTable[i2] = Math.cos(Math.PI * 2 * (double)i2 / (double)n);
            sinTable[i2] = Math.sin(Math.PI * 2 * (double)i2 / (double)n);
            ++i2;
        }
        i2 = 0;
        while (i2 < n) {
            int j = Integer.reverse(i2) >>> 32 - levels;
            if (j > i2) {
                double temp = real[i2];
                real[i2] = real[j];
                real[j] = temp;
                temp = imag[i2];
                imag[i2] = imag[j];
                imag[j] = temp;
            }
            ++i2;
        }
        int size = 2;
        while (size <= n) {
            int halfsize = size / 2;
            int tablestep = n / size;
            int i3 = 0;
            while (i3 < n) {
                int j = i3;
                int k = 0;
                while (j < i3 + halfsize) {
                    int l = j + halfsize;
                    double tpre = real[l] * cosTable[k] + imag[l] * sinTable[k];
                    double tpim = -real[l] * sinTable[k] + imag[l] * cosTable[k];
                    real[l] = real[j] - tpre;
                    imag[l] = imag[j] - tpim;
                    int n2 = j;
                    real[n2] = real[n2] + tpre;
                    int n3 = j++;
                    imag[n3] = imag[n3] + tpim;
                    k += tablestep;
                }
                i3 += size;
            }
            if (size == n) break;
            size *= 2;
        }
        int f = 0;
        while (f < n / 2) {
            double amplitude = Math.sqrt(real[f] * real[f] + imag[f] * imag[f]) * 2.0 / (double)n;
            freqResults.addSpectrumBin(new SpectrumBin(f, amplitude, 0.0));
            ++f;
        }
        double maxAmplitude = freqResults.getMaxAmp();
        int i4 = 0;
        while (i4 < freqResults.getSize()) {
            double ampDb = 20.0 * Math.log10(freqResults.getBinByIndex(i4).getAmplitude() / maxAmplitude);
            freqResults.getBinByIndex(i4).setAmplitude(ampDb);
            ++i4;
        }
        return freqResults;
    }

    public void cancel() {
        this.cancel = true;
    }

    public double[] getWindowedWave() {
        return this.windowedWave;
    }

    public double[] getFinalInput() {
        return this.inputWindow;
    }

    public Complex[] getFinalInputComplex() {
        Complex[] result = new Complex[this.inputWindow.length];
        int i = 0;
        while (i < this.inputWindow.length) {
            result[i] = new Complex(this.inputWindow[i], 0.0);
            ++i;
        }
        return result;
    }

    public int getExpandedWindowWidth() {
        return this.inputWindow.length;
    }

    public int getCztLength() {
        return this.cztLength;
    }

    public Complex[] getComplexResult() {
        return this.part1Result;
    }

    public static enum FTtype {
        DFT,
        FFT,
        CZT;

    }
}

