/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BasicStroke;
import java.awt.Graphics;
import roundtrip.AnalysisParameters;
import roundtrip.AnalysisWindow;
import roundtrip.FRTmain;
import roundtrip.InputPanel;
import roundtrip.Utils;
import roundtrip.WavePanel;

class DecayPanel
extends InputPanel {
    private static final long serialVersionUID = 1L;
    private FRTmain ourGUI;

    DecayPanel(FRTmain mainGUI, AnalysisWindow an, WavePanel wp, InputPanel.InputFtDecay inFT) {
        super(mainGUI, an, wp, inFT);
        this.ourGUI = mainGUI;
        this.setAnalysisIsStale(true);
        this.setFocusable(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.waveSamples == null || !this.analysisParams.getShowAvg()) {
            return;
        }
        if (this.analysisParams.getShowAvg()) {
            if (this.getAnalysisIsStale()) {
                this.g2d.setStroke(new BasicStroke(1.0f));
                this.g2d.setColor(this.ourGUI.getSettings().getFFTStalecolor());
                this.g2d.setFont(Utils.getMsgFont());
                String staleString = "Stale";
                this.metrics = this.g2d.getFontMetrics(Utils.getMsgFont());
                this.g2d.drawString(staleString, 0, this.metrics.getHeight());
            }
            int avgStartPixel = Math.max(this.mark1Pixels, this.xWaveBase);
            int avgEndPixel = Math.min(this.mark2Pixels, this.xWaveBase + this.xWaveWidthPx);
            int currentAvgSample = 0;
            int yBase = this.ftDecay == InputPanel.InputFtDecay.InputFT || this.analysisParams.getAvgLinLog().equals((Object)AnalysisParameters.AvgScale.AvgLinear) ? this.yWaveBase : this.yAxisBase;
            this.g2d.setColor(this.ourGUI.getSettings().getAvgWaveColor());
            this.g2d.setStroke(new BasicStroke());
            int prevAvgXPos = this.mark1Pixels;
            int scaledAvgY1 = yBase;
            int scaledAvgY2 = 0;
            if (this.analysisParams.getAvgWave() != null) {
                double[] avgWave = this.analysisParams.getAvgWave();
                if (this.mark1Samples < this.xStartTimeSamples) {
                    currentAvgSample = this.xStartTimeSamples - this.mark1Samples;
                    prevAvgXPos = this.xWaveBase;
                }
                scaledAvgY1 = yBase - (int)Math.round(avgWave[0] * this.scale);
                int i = avgStartPixel;
                while (i < avgEndPixel) {
                    double pixelSum = 0.0;
                    double pixelAvg = 0.0;
                    int j = currentAvgSample;
                    while (j <= currentAvgSample + this.samplesPerPixel - 1 && j < avgWave.length) {
                        pixelSum += avgWave[j];
                        ++j;
                    }
                    pixelAvg = pixelSum / (double)this.samplesPerPixel;
                    if (this.analysisParams.getAvgLinLog().equals((Object)AnalysisParameters.AvgScale.AvgLogRel)) {
                        double limitedPixelAvg;
                        pixelAvg = limitedPixelAvg = Math.max(pixelAvg, this.niceDBLimit);
                    }
                    scaledAvgY2 = yBase - (int)Math.round(pixelAvg * this.scale);
                    this.g2d.drawLine(prevAvgXPos, scaledAvgY1, prevAvgXPos, scaledAvgY2);
                    scaledAvgY1 = scaledAvgY2;
                    ++prevAvgXPos;
                    currentAvgSample += this.samplesPerPixel;
                    ++i;
                }
                if (this.mark1Pixels > this.xWaveBase && this.mark1Pixels < this.xWaveBase + this.xWaveWidthPx || this.mark2Pixels > this.xWaveBase && this.mark2Pixels < this.xWaveBase + this.xWaveWidthPx) {
                    this.g2d.setColor(this.ourGUI.getSettings().getDecayInterpolationColor());
                    int intStartPixel = Math.max(this.mark1Pixels, this.xWaveBase);
                    int intEndPixel = Math.min(this.mark2Pixels, this.xWaveBase + this.xWaveWidthPx);
                    int decayLineY1 = yBase - (int)Math.round(this.analysisParams.getDecayIntersect() * this.scale);
                    int decayLineY2 = yBase - (int)Math.round((this.analysisParams.getDecayIntersect() + (double)(this.mark2Samples - this.mark1Samples) * this.analysisParams.getDecayGradient()) * this.scale);
                    this.g2d.drawLine(intStartPixel, decayLineY1, intEndPixel, decayLineY2);
                }
                String yUnits = "";
                if (this.analysisParams.getAvgLinLog().equals((Object)AnalysisParameters.AvgScale.AvgLogRel)) {
                    yUnits = "dB";
                }
                this.g2d.setFont(Utils.getAxisFont());
                this.metrics = this.g2d.getFontMetrics(Utils.getAxisFont());
                double decayStartSecs = 0.0;
                if (this.mark1Pixels >= this.xWaveBase && this.mark1Pixels <= this.xWaveBase + this.xWaveWidthPx) {
                    this.g2d.setColor(this.ourGUI.getSettings().getDecayInterpolationColorFull());
                    long timeSmps = this.mark1Samples;
                    decayStartSecs = (double)this.mark1Samples / (double)this.sampleRate;
                    String timeSmpsStr = String.valueOf(timeSmps);
                    String yStr = "";
                    if (!this.getAnalysisIsStale()) {
                        yStr = String.format("%.2f", avgWave[0]);
                    }
                    String markDecayStartLabel = timeSmpsStr + " : " + yStr + yUnits;
                    this.g2d.drawString(markDecayStartLabel, this.mark1Pixels, this.yTop - this.metrics.getDescent());
                }
                if (this.mark2Pixels >= this.xWaveBase && this.mark2Pixels <= this.xWaveBase + this.xWaveWidthPx) {
                    this.g2d.setColor(this.ourGUI.getSettings().getDecayInterpolationColorFull());
                    long timeSmps = this.mark2Samples;
                    double timeSecs = (double)this.mark2Samples / (double)this.sampleRate;
                    String timeSmpsStr = String.valueOf(timeSmps);
                    String yStr = "";
                    Object markDecayDB = "diff. not ready";
                    Object markDecayEndLabel = "";
                    if (!this.getAnalysisIsStale()) {
                        yStr = String.format("%.2f", avgWave[avgWave.length - 1]);
                        double diff = this.analysisParams.getAvgLinLog().equals((Object)AnalysisParameters.AvgScale.AvgLogRel) ? 20.0 * Math.log10(avgWave[avgWave.length - 1] / avgWave[0]) : avgWave[avgWave.length - 1] - avgWave[0];
                        double diffPerSec = diff / (timeSecs - decayStartSecs);
                        markDecayDB = String.format("%.2f", diff) + yUnits + " " + String.format("%.2f", diffPerSec) + yUnits + "/Sec";
                    }
                    markDecayEndLabel = timeSmpsStr + " : " + yStr + yUnits;
                    this.g2d.drawString((String)markDecayEndLabel, this.mark2Pixels - this.metrics.stringWidth((String)markDecayEndLabel), this.yTop - this.metrics.getHeight() * 3);
                    this.g2d.drawString((String)markDecayDB, this.mark2Pixels - this.metrics.stringWidth((String)markDecayDB), this.yTop - this.metrics.getHeight() * 2);
                }
            }
            this.g2d.setColor(this.ourGUI.getSettings().getMark1Color());
            int halfSpanPx = this.analysisParams.getDecaySpan() / 2 / this.samplesPerPixel;
            int halfSpanLeftPx = Math.max(this.mark1Pixels - halfSpanPx, this.xWaveBase);
            int halfSpanRightPx = Math.min(this.mark1Pixels + halfSpanPx, this.xWaveBase + this.xWaveWidthPx);
            if (halfSpanRightPx >= this.xWaveBase && halfSpanLeftPx <= this.xWaveBase + this.xWaveWidthPx) {
                this.g2d.drawLine(halfSpanLeftPx, this.yBottom + this.metrics.getHeight() * 3, halfSpanRightPx, this.yBottom + this.metrics.getHeight() * 3);
            }
            this.g2d.setColor(this.ourGUI.getSettings().getMark2Color());
            halfSpanLeftPx = Math.max(this.mark2Pixels - halfSpanPx, this.xWaveBase);
            halfSpanRightPx = Math.min(this.mark2Pixels + halfSpanPx, this.xWaveBase + this.xWaveWidthPx);
            if (halfSpanLeftPx <= this.xWaveBase + this.xWaveWidthPx && halfSpanRightPx >= this.xWaveBase) {
                this.g2d.drawLine(halfSpanLeftPx, this.yBottom + this.metrics.getHeight() * 3 - 10, halfSpanRightPx, this.yBottom + this.metrics.getHeight() * 3 - 10);
            }
        }
    }
}

