/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import javax.swing.JOptionPane;
import roundtrip.Utils;

class WindowFunction {
    private static double[] windowFunction;
    private static double[] blackmanCoeffs;
    private static double[] exactBlackmanCoeffs;
    private static double[] b4Coefficients;
    private static double[] b7Coefficients;
    private static double[] n3Coefficients;
    private static double[] n3aCoefficients;
    private static double[] n3bCoefficients;
    private static double[] n4Coefficients;
    private static double[] n4aCoefficients;
    private static double[] n4bCoefficients;
    private static double[] n4cCoefficients;
    private static double[] ft3FCoefficients;
    private static double[] ft4FCoefficients;
    private static double[] ft5FCoefficients;
    private static double[] ft3MCoefficients;
    private static double[] ft4MCoefficients;
    private static double[] ft5MCoefficients;
    private static double[] niCoefficients;
    private static double[] hpCoefficients;
    private static double[] srCoefficients;
    private static double[] hft70Coefficients;
    private static double[] hft95Coefficients;
    private static double[] hft90DCoefficients;
    private static double[] hft116DCoefficients;
    private static double[] hft144DCoefficients;
    private static double[] hft169DCoefficients;
    private static double[] hft196DCoefficients;
    private static double[] hft223DCoefficients;
    private static double[] hft248DCoefficients;

    static {
        blackmanCoeffs = new double[]{0.42, -0.5, 0.08};
        exactBlackmanCoeffs = new double[]{0.4265907136715391, -0.4965606190885641, 0.07684866723989682};
        b4Coefficients = new double[]{0.35875, -0.48829, 0.14128, -0.01168};
        b7Coefficients = new double[]{0.27105140069342, -0.43329793923448, 0.21812299954311, -0.06592544638803, 0.01081174209837, -7.7658482522E-4, 1.388721735E-5};
        n3Coefficients = new double[]{0.375, -0.5, 0.125};
        n3aCoefficients = new double[]{0.40897, -0.5, 0.09103};
        n3bCoefficients = new double[]{0.4243801, -0.4973406, 0.0782793};
        n4Coefficients = new double[]{0.3125, -0.46875, 0.1875, -0.03125};
        n4aCoefficients = new double[]{0.338946, -0.481973, 0.161054, -0.018027};
        n4bCoefficients = new double[]{0.355768, -0.487396, 0.144232, -0.012604};
        n4cCoefficients = new double[]{0.3635819, -0.4891775, 0.1365995, -0.0106411};
        ft3FCoefficients = new double[]{0.26526, -0.5, 0.23474};
        ft4FCoefficients = new double[]{0.21706, -0.42103, 0.28294, -0.07897};
        ft5FCoefficients = new double[]{0.1881, -0.36923, 0.28702, -0.13077, 0.02488};
        ft3MCoefficients = new double[]{0.28235, -0.52105, 0.19659};
        ft4MCoefficients = new double[]{0.241906, -0.460841, 0.255381, -0.041872};
        ft5MCoefficients = new double[]{0.209671, -0.407331, 0.281225, -0.092669, 0.0091036};
        niCoefficients = new double[]{0.2810639, -0.5208972, 0.1980399};
        hpCoefficients = new double[]{1.0, -1.912510941, 1.079173272, -0.1832630879};
        srCoefficients = new double[]{1.0, -1.93, 1.29, -0.388, 0.028};
        hft70Coefficients = new double[]{1.0, -1.90796, 1.07349, -0.18199};
        hft95Coefficients = new double[]{1.0, -1.9383379, 1.3045202, -0.402827, 0.0350665};
        hft90DCoefficients = new double[]{1.0, -1.942604, 1.340318, -0.440811, 0.043097};
        hft116DCoefficients = new double[]{1.0, -1.9575375, 1.4780705, -0.6367431, 0.228389, -0.0066288};
        hft144DCoefficients = new double[]{1.0, -1.96760033, 1.57983607, -0.81123644, 0.22583558, -0.02773848, 9.036E-4};
        hft169DCoefficients = new double[]{1.0, -1.97441842, 1.65409888, -0.95788186, 0.3367342, -0.06364621, 0.00521942, -1.0599E-4};
        hft196DCoefficients = new double[]{1.0, -1.97928042, 1.710288951, -1.081629853, 0.448734314, -0.112376628, 0.015122992, -8.71252E-4, 1.1896E-5};
        hft223DCoefficients = new double[]{1.0, -1.98298997309, 1.75556083063, -1.19037717712, 0.56155440797, -0.17296769663, 0.03233247087, -0.00324954578, 1.380104E-4, -1.32725E-6};
        hft248DCoefficients = new double[]{1.0, -1.985844164102, 1.791176438506, -1.282075284005, 0.667777530266, -0.240160796576, 0.056656381764, -0.008134974479, 6.2454465E-4, -1.9808998E-5, 1.32974E-7};
    }

    public static double[] windowFunction(String function, int windowWidth, double param) {
        windowFunction = new double[windowWidth];
        switch (function) {
            case "Rectangle (none)": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = 1.0;
                    ++i;
                }
                break;
            }
            case "Bartlett": {
                int i = 0;
                while (i < windowWidth) {
                    double z = 2.0 * (double)i / (double)windowWidth;
                    WindowFunction.windowFunction[i] = z <= 1.0 ? z : 2.0 - z;
                    ++i;
                }
                break;
            }
            case "Welch": {
                int i = 0;
                while (i < windowWidth) {
                    double z = 2.0 * (double)i / (double)windowWidth;
                    WindowFunction.windowFunction[i] = 1.0 - Math.pow(z - 1.0, 2.0);
                    ++i;
                }
                break;
            }
            case "Hamming": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = 0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)i / (double)windowWidth);
                    ++i;
                }
                break;
            }
            case "Hann": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)i / (double)windowWidth));
                    ++i;
                }
                break;
            }
            case "Blackman": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(blackmanCoeffs, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Exact Blackman": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(exactBlackmanCoeffs, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Blackman-Harris-4": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(b4Coefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Blackman-Harris-7": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(b7Coefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Nuttall-3": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(n3Coefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Nuttall-3a": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(n3aCoefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Nuttall-3b": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(n3bCoefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Nuttall-4": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(n4Coefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Nuttall-4a": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(n4aCoefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Nuttall-4b": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(n4bCoefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Nuttall-4c": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(n4cCoefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Flat-Top-Fast-3": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(ft3FCoefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Flat-Top-Fast-4": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(ft4FCoefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Flat-Top-Fast-5": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(ft5FCoefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Flat-Top-Min.Lobe-3": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(ft3MCoefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Flat-Top-Min.Lobe-4": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(ft4MCoefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Flat-Top-Min.Lobe-5": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(ft5MCoefficients, i, windowWidth);
                    ++i;
                }
                break;
            }
            case "Flat-Top-NI": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(niCoefficients, i, windowWidth) / 1.000001;
                    ++i;
                }
                break;
            }
            case "Flat-Top-HP": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(hpCoefficients, i, windowWidth) / 4.1749473009;
                    ++i;
                }
                break;
            }
            case "Flat-Top-SR785": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(srCoefficients, i, windowWidth) / 4.635999999999999;
                    ++i;
                }
                break;
            }
            case "Flat-Top-HFT70": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(hft70Coefficients, i, windowWidth) / 4.1634400000000005;
                    ++i;
                }
                break;
            }
            case "Flat-Top-HFT95": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(hft95Coefficients, i, windowWidth) / 4.680751600000001;
                    ++i;
                }
                break;
            }
            case "Flat-Top-HFT90D": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(hft90DCoefficients, i, windowWidth) / 4.766830000000001;
                    ++i;
                }
                break;
            }
            case "Flat-Top-HFT116D": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(hft116DCoefficients, i, windowWidth) / 5.3073689;
                    ++i;
                }
                break;
            }
            case "Flat-Top-HFT144D": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(hft144DCoefficients, i, windowWidth) / 5.6131505;
                    ++i;
                }
                break;
            }
            case "Flat-Top-HFT169D": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(hft169DCoefficients, i, windowWidth) / 5.99210498;
                    ++i;
                }
                break;
            }
            case "Flat-Top-HFT196D": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(hft196DCoefficients, i, windowWidth) / 6.348316306;
                    ++i;
                }
                break;
            }
            case "Flat-Top-HFT223D": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(hft223DCoefficients, i, windowWidth) / 6.69917143974;
                    ++i;
                }
                break;
            }
            case "Flat-Top-HFT248D": {
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = WindowFunction.cos2Sum(hft248DCoefficients, i, windowWidth) / 7.032470056319999;
                    ++i;
                }
                break;
            }
            case "Gaussian": {
                double m = (windowWidth - 1) / 2;
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = Math.exp(-0.5 * Math.pow(((double)i - m) / (param * m), 2.0));
                    ++i;
                }
                break;
            }
            case "Kaiser-Bessel": {
                double kaiserPiAlpha = param * Math.PI;
                double bottom = WindowFunction.bessel(kaiserPiAlpha);
                int i = 0;
                while (i < windowWidth) {
                    int np = windowWidth - 1;
                    double z = 2.0 * (double)i / (double)np - 1.0;
                    double root = Math.sqrt(1.0 - Math.pow(z, 2.0));
                    double top = WindowFunction.bessel(kaiserPiAlpha * root);
                    WindowFunction.windowFunction[i] = bottom != 0.0 ? top / bottom : 0.0;
                    ++i;
                }
                break;
            }
            case "Tukey": {
                double alphaN = param * (double)windowWidth;
                double alphaHalfN = alphaN / 2.0;
                double pi2 = Math.PI * 2;
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = (double)i < alphaHalfN ? 0.5 * (1.0 - Math.cos((double)i * pi2 / alphaN)) : (i <= windowWidth / 2 ? 1.0 : windowFunction[windowWidth - i]);
                    ++i;
                }
                break;
            }
            case "Exponential": {
                double tau = param;
                int i = 0;
                while (i < windowWidth) {
                    WindowFunction.windowFunction[i] = Math.exp(-Math.abs((double)i - (double)(windowWidth / 2)) / (double)(windowWidth / 2) / tau);
                    ++i;
                }
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, "Analyis: Fourier Transform Window Function not found : " + function);
            }
        }
        return windowFunction;
    }

    private static double bessel(double x) {
        double bessel = 0.0;
        double error = 1.0E-6;
        int k = 0;
        double y = 10.0;
        while (y > error && k < 10000) {
            y = Math.pow(Math.pow(x / 2.0, k) / Utils.fact(k), 2.0);
            bessel += y;
            ++k;
        }
        return bessel;
    }

    private static double cos2Sum(double[] coefficients, int n, int windowSize) {
        double result = coefficients[0];
        int i = 1;
        while (i < coefficients.length) {
            double term = coefficients[i] * Math.cos(Math.PI * 2 * (double)i * (double)n / (double)windowSize);
            result += term;
            ++i;
        }
        return result;
    }
}

