/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import roundtrip.FRTmain;
import roundtrip.SpectrumBinList;
import roundtrip.SynthesisParameters;
import roundtrip.SynthesisWindow;
import roundtrip.Utils;

class SynthesisedWave {
    private double[] waveResult;
    private double[] figureResultX;
    private double[] figureResultY;
    private double[] constructorResultX;
    private double[] constructorResultY;
    private int sampleRate;
    private int sampleSize;
    private double soundLimit;
    private int duration;
    private int bytesPerSample;
    private byte[] sound;
    private int soundNframes;
    private int soundNsamples;
    private FloatControl gainControl;
    private Clip clip;
    private Thread soundThread = null;
    private boolean soundPlaying;
    private double realFrequency;
    private double maxAmplitude;
    private double niceMaxAmplitude;
    private double totalDC;
    private double peakPos = 0.0;
    private double peakNeg = 0.0;
    private double noisePeak = 0.0;
    private double noise;
    private SynthesisParameters synthParams;
    private SynthesisWindow synthWindow;
    private FRTmain mainGUI;
    private SpectrumBinList ourHarmonics;
    private int numHarmonics;
    private int widthpx;
    private boolean redoWave;
    private boolean redoSound;
    private boolean play;
    private ProgressMonitor progress;
    private int soFar;
    private WaveWork worker;
    private boolean cancelled;

    void waveRenew(FRTmain mainGUI, SpectrumBinList hList, double freq, int widthpxIn, boolean doWave, boolean doSound, boolean playWhenDone) {
        this.mainGUI = mainGUI;
        this.ourHarmonics = hList;
        this.realFrequency = freq;
        this.widthpx = widthpxIn;
        if (this.widthpx < 3) {
            this.widthpx = 3;
        }
        this.redoWave = doWave;
        this.redoSound = doSound;
        this.play = playWhenDone;
        this.cancelled = false;
        this.progress = new ProgressMonitor(mainGUI, "Making Waves", "", 0, 100);
        this.soFar = 0;
        this.progress.setProgress(this.soFar);
        this.progress.setNote(String.format("0 Completed %d%%.\n", this.soFar));
        this.progress.setMillisToDecideToPopup(100);
        this.progress.setMillisToPopup(500);
        this.worker = new WaveWork();
        this.worker.addPropertyChangeListener(new workPropertyChange());
        this.worker.execute();
    }

    public void asyncPlay() {
        if (this.soundPlaying) {
            return;
        }
        Runnable soundr = () -> this.playWaveSound();
        this.soundThread = new Thread(soundr);
        this.soundPlaying = true;
        this.soundThread.start();
    }

    private void playWaveSound() {
        this.synthParams.setEnDisableSoundStart(false);
        this.synthParams.setEnDisableSoundStop(true);
        try {
            try {
                AudioFormat singleChannel = new AudioFormat(this.sampleRate, this.sampleSize, 1, true, false);
                this.clip = AudioSystem.getClip();
                this.clip.open(singleChannel, this.sound, 0, this.sound.length);
                if (this.clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                    this.synthParams.enDisableVolume(true);
                    this.gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
                    this.gainControl.setValue(this.synthParams.getGainDB());
                } else {
                    this.synthParams.enDisableVolume(false);
                }
                int seconds = this.synthParams.getSoundDuration();
                this.clip.setFramePosition(0);
                this.clip.start();
                try {
                    try {
                        Thread.sleep(1000 * seconds, 0);
                    }
                    catch (InterruptedException interruptedException) {
                        this.clip.stop();
                        this.clip.flush();
                        this.clip.drain();
                        this.clip.close();
                    }
                }
                finally {
                    this.clip.stop();
                    this.clip.flush();
                    this.clip.drain();
                    this.clip.close();
                }
            }
            catch (LineUnavailableException e) {
                System.out.println("LineUnavailableException while playing the sound");
                this.clip.stop();
                this.clip.flush();
                this.clip.drain();
                this.clip.close();
            }
        }
        catch (Throwable throwable) {
            this.clip.stop();
            this.clip.flush();
            this.clip.drain();
            this.clip.close();
            throw throwable;
        }
        this.synthParams.setEnDisableSoundStart(true);
        this.synthParams.setEnDisableSoundStop(false);
        this.soundPlaying = false;
    }

    public void setSoundGain(float db) {
        if (this.gainControl != null) {
            this.gainControl.setValue(db);
        }
    }

    public void stopSound() {
        if (this.clip != null) {
            this.clip.stop();
            this.soundThread.interrupt();
        }
    }

    public double[] getWave() {
        return this.waveResult;
    }

    public double[] getFigureX() {
        return this.figureResultX;
    }

    public double[] getFigureY() {
        return this.figureResultY;
    }

    public double[] getConstructorX() {
        return this.constructorResultX;
    }

    public double[] getConstructorY() {
        return this.constructorResultY;
    }

    public double getTotalDC() {
        return this.totalDC;
    }

    public double[][] getFigureVectors(int angle) {
        double[][] xVector = new double[this.ourHarmonics.getSize()][3];
        double freq = 1.0;
        double amp = 1.0;
        double phase = 0.0;
        int i = 0;
        while (i < this.ourHarmonics.getSize()) {
            freq = this.ourHarmonics.getBinByIndex(i).getFreqFactor();
            amp = this.ourHarmonics.getBinByIndex(i).getAmplitude();
            phase = this.ourHarmonics.getBinByIndex(i).getPhase();
            if (freq == 0.0) {
                xVector[i][0] = 0.0;
                xVector[i][1] = amp;
            } else {
                xVector[i][0] = Math.cos(Math.toRadians((double)angle * freq + phase)) * amp;
                xVector[i][1] = Math.sin(Math.toRadians((double)angle * freq + phase)) * amp;
                xVector[i][2] = Math.sqrt(xVector[i][0] * xVector[i][0] + xVector[i][1] * xVector[i][1]);
            }
            ++i;
        }
        return xVector;
    }

    public byte[] getSound() {
        return this.sound;
    }

    public int getBytesPerSample() {
        return this.bytesPerSample;
    }

    public double getRealFrequency() {
        return this.realFrequency;
    }

    public double getMaxAmplitude() {
        return this.niceMaxAmplitude;
    }

    public boolean getCancelled() {
        return this.cancelled;
    }

    private class WaveWork
    extends SwingWorker<Void, Integer> {
        private WaveWork() {
        }

        @Override
        public Void doInBackground() {
            SynthesisedWave.this.synthParams = SynthesisedWave.this.mainGUI.getSynthParams();
            SynthesisedWave.this.synthWindow = SynthesisedWave.this.synthParams.getSynthesisWindow();
            double dAngle = 360.0 / (double)SynthesisedWave.this.widthpx;
            SynthesisedWave.this.numHarmonics = SynthesisedWave.this.ourHarmonics.getSize();
            SynthesisedWave.this.noisePeak = SynthesisedWave.this.synthParams.getNoisePeak();
            SynthesisedWave.this.sampleRate = SynthesisedWave.this.synthParams.getSampleRate();
            SynthesisedWave.this.sampleSize = SynthesisedWave.this.synthParams.getSampleSize();
            SynthesisedWave.this.soundLimit = Math.pow(2.0, SynthesisedWave.this.sampleSize - 1) - 1.0;
            SynthesisedWave.this.bytesPerSample = SynthesisedWave.this.sampleSize / 8;
            SynthesisedWave.this.duration = SynthesisedWave.this.synthParams.getSoundDuration();
            double freq = 1.0;
            double amp = 1.0;
            double phase = 0.0;
            double angle = 0.0;
            double sinAngle = 0.0;
            double r = 0.0;
            int toDo = 0;
            if (SynthesisedWave.this.redoWave) {
                toDo += SynthesisedWave.this.widthpx;
            }
            if (SynthesisedWave.this.redoSound) {
                SynthesisedWave.this.soundNframes = SynthesisedWave.this.duration * SynthesisedWave.this.sampleRate;
                SynthesisedWave.this.soundNsamples = SynthesisedWave.this.soundNframes * SynthesisedWave.this.bytesPerSample;
                SynthesisedWave.this.sound = new byte[SynthesisedWave.this.soundNsamples];
                toDo += SynthesisedWave.this.soundNframes;
            }
            if (SynthesisedWave.this.redoWave) {
                SynthesisedWave.this.waveResult = new double[SynthesisedWave.this.widthpx];
                SynthesisedWave.this.figureResultX = new double[SynthesisedWave.this.widthpx];
                SynthesisedWave.this.figureResultY = new double[SynthesisedWave.this.widthpx];
                SynthesisedWave.this.constructorResultX = new double[SynthesisedWave.this.widthpx];
                SynthesisedWave.this.constructorResultY = new double[SynthesisedWave.this.widthpx];
                SynthesisedWave.this.peakPos = 0.0;
                SynthesisedWave.this.peakNeg = 0.0;
                Random random = new Random();
                int i = 0;
                while (i < SynthesisedWave.this.widthpx) {
                    if (i == SynthesisedWave.this.widthpx - 1) {
                        angle = 360.0;
                    }
                    SynthesisedWave.this.waveResult[i] = 0.0;
                    SynthesisedWave.this.totalDC = 0.0;
                    SynthesisedWave.this.figureResultX[i] = 0.0;
                    SynthesisedWave.this.figureResultY[i] = 0.0;
                    SynthesisedWave.this.constructorResultX[i] = 0.0;
                    SynthesisedWave.this.constructorResultY[i] = 0.0;
                    SynthesisedWave.this.maxAmplitude = 0.0;
                    int j = 0;
                    while (j < SynthesisedWave.this.numHarmonics) {
                        freq = SynthesisedWave.this.ourHarmonics.getBinByIndex(j).getFreqFactor();
                        amp = SynthesisedWave.this.ourHarmonics.getBinByIndex(j).getAmplitude();
                        phase = SynthesisedWave.this.ourHarmonics.getBinByIndex(j).getPhase();
                        if (freq == 0.0) {
                            int n = i;
                            SynthesisedWave.this.waveResult[n] = SynthesisedWave.this.waveResult[n] + amp;
                            SynthesisedWave.this.totalDC += amp;
                        } else {
                            int n = i;
                            SynthesisedWave.this.waveResult[n] = SynthesisedWave.this.waveResult[n] + Math.sin(Math.toRadians(angle * freq + phase)) * amp;
                        }
                        if (SynthesisedWave.this.synthParams.getNoiseOn()) {
                            SynthesisedWave.this.noise = (random.nextDouble() - 0.5) * 2.0 * SynthesisedWave.this.noisePeak;
                            int n = i;
                            SynthesisedWave.this.waveResult[n] = SynthesisedWave.this.waveResult[n] + SynthesisedWave.this.noise;
                        }
                        SynthesisedWave.this.peakPos = Math.max(SynthesisedWave.this.peakPos, SynthesisedWave.this.waveResult[i]);
                        SynthesisedWave.this.peakNeg = Math.min(SynthesisedWave.this.peakNeg, SynthesisedWave.this.waveResult[i]);
                        if (freq != 0.0) {
                            int n = i;
                            SynthesisedWave.this.figureResultX[n] = SynthesisedWave.this.figureResultX[n] + Math.cos(Math.toRadians(angle * freq + phase)) * amp;
                        }
                        SynthesisedWave.this.figureResultY[i] = SynthesisedWave.this.waveResult[i];
                        if (SynthesisedWave.this.synthParams.getNoiseOn()) {
                            int n = i;
                            SynthesisedWave.this.figureResultY[n] = SynthesisedWave.this.figureResultY[n] + SynthesisedWave.this.noise;
                        }
                        ++j;
                    }
                    if (SynthesisedWave.this.synthParams.getDisplayConFig()) {
                        sinAngle = Math.sin(Math.toRadians(angle));
                        double conDC = 0.0;
                        if (SynthesisedWave.this.synthParams.getDisplayConDC()) {
                            conDC = SynthesisedWave.this.totalDC;
                        }
                        double yWithoutDC = SynthesisedWave.this.waveResult[i] - conDC;
                        if (sinAngle != 0.0) {
                            r = yWithoutDC / sinAngle;
                            SynthesisedWave.this.constructorResultX[i] = Math.sqrt(Math.abs(r * r - yWithoutDC * yWithoutDC));
                            if (angle > 90.0 && angle < 270.0) {
                                SynthesisedWave.this.constructorResultX[i] = -SynthesisedWave.this.constructorResultX[i];
                            }
                        } else {
                            r = Double.NaN;
                            SynthesisedWave.this.constructorResultX[i] = Double.NaN;
                        }
                        SynthesisedWave.this.constructorResultY[i] = SynthesisedWave.this.waveResult[i];
                    }
                    angle += dAngle;
                    if (SynthesisedWave.this.progress.isCanceled()) {
                        return null;
                    }
                    SynthesisedWave.this.soFar = i * 100 / toDo;
                    SynthesisedWave.this.progress.setNote(String.format("Waves Completed %d%%.\n", SynthesisedWave.this.soFar));
                    this.publish(SynthesisedWave.this.soFar);
                    ++i;
                }
                SynthesisedWave.this.maxAmplitude = Math.max(Math.abs(SynthesisedWave.this.peakNeg), SynthesisedWave.this.peakPos);
            }
            if (SynthesisedWave.this.redoSound) {
                double soundScale = Math.min(SynthesisedWave.this.soundLimit, SynthesisedWave.this.soundLimit / (Math.max(Math.abs(SynthesisedWave.this.peakNeg), SynthesisedWave.this.peakPos) + Math.abs(SynthesisedWave.this.totalDC)) * 0.9);
                int outIdx = 0;
                int i = 0;
                while (i < SynthesisedWave.this.soundNframes) {
                    double soundResult = 0.0;
                    int j = 0;
                    while (j < SynthesisedWave.this.numHarmonics) {
                        freq = SynthesisedWave.this.ourHarmonics.getBinByIndex(j).getFreqFactor();
                        if (freq != 0.0) {
                            amp = SynthesisedWave.this.ourHarmonics.getBinByIndex(j).getAmplitude();
                            phase = SynthesisedWave.this.ourHarmonics.getBinByIndex(j).getPhase();
                            soundResult += Math.sin(Math.toRadians((double)i * freq * SynthesisedWave.this.realFrequency * (360.0 * (double)SynthesisedWave.this.duration) / (double)SynthesisedWave.this.soundNframes + phase)) * amp;
                        }
                        ++j;
                    }
                    soundResult *= soundScale;
                    soundResult += soundScale * SynthesisedWave.this.totalDC;
                    if (SynthesisedWave.this.synthParams.getNoiseOn()) {
                        Random random = new Random();
                        double noise = (random.nextDouble() - 0.5) * 2.0 * SynthesisedWave.this.noisePeak;
                        soundResult += soundScale * noise;
                    }
                    int soundInt = (int)Math.round(soundResult);
                    switch (SynthesisedWave.this.sampleSize) {
                        case 8: {
                            SynthesisedWave.this.sound[outIdx] = (byte)(soundInt & 0xFF);
                            ++outIdx;
                            break;
                        }
                        case 16: {
                            SynthesisedWave.this.sound[outIdx] = (byte)(soundInt & 0xFF);
                            SynthesisedWave.this.sound[outIdx + 1] = (byte)((soundInt & 0xFF00) >> 8);
                            outIdx += 2;
                            break;
                        }
                        case 24: {
                            SynthesisedWave.this.sound[outIdx] = (byte)(soundInt & 0xFF);
                            SynthesisedWave.this.sound[outIdx + 1] = (byte)((soundInt & 0xFF00) >> 8);
                            SynthesisedWave.this.sound[outIdx + 2] = (byte)((soundInt & 0xFF0000) >> 16);
                            outIdx += 3;
                            break;
                        }
                        case 32: {
                            SynthesisedWave.this.sound[outIdx] = (byte)(soundInt & 0xFF);
                            SynthesisedWave.this.sound[outIdx + 1] = (byte)((soundInt & 0xFF00) >> 8);
                            SynthesisedWave.this.sound[outIdx + 2] = (byte)((soundInt & 0xFF0000) >> 16);
                            SynthesisedWave.this.sound[outIdx + 3] = (byte)((soundInt & 0xFF000000) >> 24);
                            outIdx += 4;
                            break;
                        }
                        default: {
                            JOptionPane.showMessageDialog(SynthesisedWave.this.mainGUI, "SynthesisedWave unknown sample size " + SynthesisedWave.this.sampleSize);
                            return null;
                        }
                    }
                    if (SynthesisedWave.this.progress.isCanceled()) {
                        return null;
                    }
                    SynthesisedWave.this.soFar = (SynthesisedWave.this.widthpx + i) * 100 / toDo;
                    SynthesisedWave.this.progress.setNote(String.format("Sound Completed %d%%.\n", SynthesisedWave.this.soFar));
                    this.publish(SynthesisedWave.this.soFar);
                    ++i;
                }
            }
            SynthesisedWave.this.synthParams.setEnDisableSoundStart(true);
            SynthesisedWave.this.synthParams.setEnDisableSoundSave(true);
            return null;
        }

        @Override
        public void process(List<Integer> progUpdate) {
            if (SynthesisedWave.this.progress.isCanceled()) {
                return;
            }
            SynthesisedWave.this.progress.setProgress(SynthesisedWave.this.soFar);
        }

        @Override
        public void done() {
            double scale = 1.0;
            SynthesisedWave.this.niceMaxAmplitude = Utils.getNiceAxisTop(SynthesisedWave.this.maxAmplitude);
            double calcScale = (double)SynthesisedWave.this.synthWindow.getEffectiveHeight() / SynthesisedWave.this.niceMaxAmplitude / 2.0;
            scale = SynthesisedWave.this.synthParams.isAutoScale() ? calcScale : SynthesisedWave.this.synthParams.getManScale();
            SynthesisedWave.this.synthParams.setAutoScale(String.valueOf(String.format("%.2f", calcScale)));
            SynthesisedWave.this.synthWindow.setScale(scale);
            SynthesisedWave.this.synthWindow.repaint();
            SynthesisedWave.this.synthParams.setEnDisableRedraw(true);
            SynthesisedWave.this.synthWindow.clearInitialising();
            if (SynthesisedWave.this.play) {
                SynthesisedWave.this.asyncPlay();
            }
        }
    }

    private class workPropertyChange
    implements PropertyChangeListener {
        private workPropertyChange() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent p) {
            SynthesisedWave.this.progress.setProgress(SynthesisedWave.this.soFar);
            SynthesisedWave.this.progress.setNote(String.format("Completed %d%%.\n", SynthesisedWave.this.soFar));
            if (SynthesisedWave.this.progress.isCanceled()) {
                SynthesisedWave.this.worker.cancel(true);
                SynthesisedWave.this.cancelled = true;
                SynthesisedWave.this.waveResult = new double[SynthesisedWave.this.widthpx];
                SynthesisedWave.this.figureResultX = new double[SynthesisedWave.this.widthpx];
                SynthesisedWave.this.figureResultY = new double[SynthesisedWave.this.widthpx];
                SynthesisedWave.this.constructorResultX = new double[SynthesisedWave.this.widthpx];
                SynthesisedWave.this.constructorResultY = new double[SynthesisedWave.this.widthpx];
            }
            if (SynthesisedWave.this.progress.isCanceled() || SynthesisedWave.this.worker.isDone()) {
                SynthesisedWave.this.progress.close();
            }
        }
    }
}

