/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.FormatterClosedException;
import java.util.IllegalFormatException;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import roundtrip.AnalysisParameters;
import roundtrip.FRTmain;
import roundtrip.SpectrumBin;
import roundtrip.SpectrumBinList;
import roundtrip.SynthImport;
import roundtrip.SynthesisWindow;
import roundtrip.Utils;

class SynthesisParameters
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FRTmain ourGUI;
    private SynthesisWindow synthesis;
    private SynthesisParameters ourWindow;
    private JCheckBox displayRefFig = new JCheckBox("Reference Figure");
    private String displayRefFigTip = "Select whether to display the Reference Figure.";
    private JCheckBox displayRefVectors = new JCheckBox("Show Vectors");
    private String displayRefVectorsTip = "Select whether to display the vectors of the harmonics.";
    private JCheckBox displayRefCircles = new JCheckBox("Show Circles");
    private String displayRefCirclesTip = "Select whether to display the circles of the harmonics.";
    private JCheckBox displayConFig = new JCheckBox("Constructor Figure");
    private String displayConFigTip = "Select whether to display the Constructor Figure";
    private JCheckBox displayConVerticals = new JCheckBox("Show Vertical");
    private String displayConVertTip = "Select to display vertical height from constructor to wave";
    private JCheckBox displayConDC = new JCheckBox("Show DC as shift");
    private String displayConDCTip = "Select to apply DC as a vertical shift to the constructor figure";
    private JCheckBox displayComponents = new JCheckBox("Components");
    private String displayComponentsTip = "Select to display the component waves";
    private JCheckBox displaySpectrum = new JCheckBox("Spectrum");
    private String displaySpectrumTip = "Select to display the spectrum";
    private JLabel scaleLabel = new JLabel("Scale");
    private JLabel scaleFactorLabel = new JLabel("Scaling Factor:");
    private JTextField scaleFactorField = new JTextField();
    private String scaleTip = "Set the scaling factor manually if the automatic value is not good enough.";
    private JRadioButton scaleManButton = new JRadioButton("Manual");
    private String scaleManTip = "Use the manual scaling factor.";
    private JRadioButton scaleAutButton = new JRadioButton("Automatic");
    private String scaleAutTip = "Use the automatically calculated scaling factor.";
    private ButtonGroup scaleGroup = new ButtonGroup();
    private JLabel autScaleLabel = new JLabel("not set");
    private String autScaleTip = "This is the automatically calculated scaling factor.";
    private JButton buttonRedraw = new JButton("Redraw");
    private String buttonRedrawTip = "Redraw the diagrams with the current parameters.";
    private JCheckBox autoRedraw = new JCheckBox("Auto");
    private String autoRedrawTip = "Select to auatomatically redraw the graphic whenever a parameter is changed.";
    private JLabel soundFrequencyLabel = new JLabel("Frequency");
    private JTextField soundFrequencyField = new JTextField();
    private String soundFrequencyTip = "Set the frequency with which to play the wave as a sound.";
    private JLabel sampleRateLabel = new JLabel("Sample rate");
    private JTextField sampleRateField = new JTextField();
    private String sampleRateTip = "Set the sample rate in samples per second for the saved WAV file.";
    private JLabel sampleSizeLabel = new JLabel("size");
    private Integer[] sampleSizes = new Integer[]{8, 16, 24, 32};
    private JComboBox<Integer> sampleSizeField = new JComboBox<Integer>(this.sampleSizes);
    private String sampleSizeTip = "Set the sample size in bits for the sound and sending to analysis. NOTE: sound is full volume above 16 bits!";
    private JLabel durationLabel = new JLabel("Duration [s]:");
    private String durationTip = "Set the number of seconds for which the sound will be played.";
    private SpinnerModel durationModel = new SpinnerNumberModel(1, 1, 10, 1);
    private JSpinner durationSpinner = new JSpinner(this.durationModel);
    private JLabel volumeLabel = new JLabel("Volume:");
    private JSlider volumeSlider = new JSlider(0, 100, 10);
    private String volumeSliderTip = "Use the slider to change the sound volume.";
    private JCheckBox playSoundOnRedraw = new JCheckBox("Auto-Play");
    private String playSoundonRedrawTip = "If this is checked the sound will be played every time the graphic is redrawn or the frequency is changed.";
    private JButton buttonSoundPlay = new JButton("\u25b6");
    private String buttonSoundPlayTip = "Click this to play the sound for the selected duration.";
    private JButton buttonSoundStop = new JButton("\u23f9");
    private String buttonSoundStopTip = "Click this to stop the sound playing.";
    private JLabel titleLabel = new JLabel("Title:");
    private JTextField titleField = new JTextField(35);
    private String titleTip = "Enter a title text which will be added as metadata to the saved WAV file";
    private JButton buttonSave = new JButton("Save");
    private String buttonSaveTip = "Save the synthesised wave to a sound file .wav.";
    private String newOverwriteDialog = "New output file already exists. Do you want to overwrite it?";
    private JButton buttonToAnalysis = new JButton("Send to Analysis");
    private String buttonToAnalysisTip = "Send the synthesised wave too the analysis function.";
    private JLabel harmonicsLabel = new JLabel("Harmonics:");
    private SpinnerModel harmonicsModel = new SpinnerNumberModel(1, 1, 10000, 1);
    private JSpinner harmonicsSpinner = new JSpinner(this.harmonicsModel);
    private String harmonicsTip = "Set the number of harmonics to generate. (The first overtone is the second harmonic.)";
    private JButton buttonPopulateSt = new JButton("Sawtooth");
    private String buttonPopulateStTip = "<html>Generate the data for an approximation to a sawtooth wave with the selected number of harmonics<br>1*sin(x) + 1/2*sin(2x) + 1/3*sin(3x) + ... or exponential progression</html>";
    private JButton buttonPopulateSq = new JButton("Square");
    private String buttonPopulateSqTip = "<html>Generate the data for an approximation to a square wave with the selected number of harmonics<br>1*sin(x) + 1/3*sin(3x) + 1/5* sin(5x) + ... or exponential progression</html>";
    private JButton buttonPopulateTr = new JButton("Triangle");
    private String buttonPopulateTrTip = "<html>Generate the data for an approximation to a trangular wave with the selected number of harmonics<br>1*sin(x) - (1/3**2)*sin(3x) + (1/5**2)*sin(5x) - ...</html>";
    private JLabel progressionLabel = new JLabel("Progression");
    private JRadioButton linButton = new JRadioButton("1/n");
    private String buttonLinTip = "Select for a 1/n progression of nth harmonic amplitudes. Note: this does not auto-redraw.";
    private JRadioButton expButton = new JRadioButton("x**n");
    private String buttonExpTip = "Select for x**n progression of nth harmonic amplitudes (not available for triangular) Note: this does not auto-redraw..";
    private ButtonGroup progressionGroup = new ButtonGroup();
    private JLabel progressionXlabel = new JLabel("x:");
    private JTextField progressionXfield = new JTextField();
    private String progressionXtip = "Enter the value for x in the x**n harmonic progression.";
    private JCheckBox noiseOn = new JCheckBox("Add Noise");
    private JLabel noiseLabel = new JLabel("Peak");
    private String noiseTip = "Check the box to add white noise and enter the positive peak value.";
    private JTextField noisePeakField = new JTextField();
    private JButton buttonImport = new JButton("Import");
    private String buttonImportTip = "Import harmonics from a CSV file.";
    private JButton buttonExport = new JButton("Export");
    private String buttonExportTip = "Export harmonics to a CSV file.";
    private JButton buttonAdd = new JButton("Add");
    private String buttonAddTip = "Add a row to the data below.";
    private JButton buttonClearPhases = new JButton("0 Phases");
    private String buttonClearPhasesTip = "Set all the phases to zero";
    private String frequencyHeader = "Frequency";
    private String amplitudeHeader = "Amplitude";
    private String phaseHeader = "Phase";
    private String sortUpArrow = "\u2b61";
    private String sortDownArrow = "\u2b63";
    private JButton buttonFreqHeader = new JButton(this.frequencyHeader);
    private JButton buttonAmplHeader = new JButton(this.amplitudeHeader);
    private JButton buttonPhaseHeader = new JButton(this.phaseHeader);
    private SpectrumBinList harmonics;
    private JTextField[] freqFields;
    private NumberFormat genFormat = NumberFormat.getInstance(Locale.getDefault());
    private NumberFormat freqFormat;
    private JTextField[] ampFields;
    private DecimalFormat ampFormat = new DecimalFormat("0.00000");
    private JTextField[] phaseFields;
    private DecimalFormat phaseFormat = new DecimalFormat("0.0");
    private static final int harmonicCols = 10;
    private JButton[] deleteButtons;
    private JPanel harmonicsPanel;
    private JScrollPane hScrollPane;
    private String currentSaveDir = "";
    private String currentImportDir = "";
    private String currentExportDir = "";
    private BufferedWriter outBuffer = null;
    private LineBorder panelsBorder;
    private FlowLayout flowLayoutLeft = new FlowLayout(0);
    private double frequency;
    private int sampleRate;
    private int duration;
    private double calcScale;
    private double manScale;
    private float gainDB;
    private double progressionX;
    private double noisePeak;
    private SpectrumBinList.SpectrumSortBy currentSort;
    private ActionListener componentSpectrumListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SynthesisParameters.this.synthesis != null) {
                if (!SynthesisParameters.this.displayComponents.isSelected() && !SynthesisParameters.this.displaySpectrum.isSelected()) {
                    SynthesisParameters.this.synthesis.setComponentSpectrumVisible(false);
                } else {
                    SynthesisParameters.this.synthesis.setComponentSpectrumVisible(true);
                }
            }
        }
    };
    private ActionListener sortButtonsListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton which = (JButton)e.getSource();
            if (which == SynthesisParameters.this.buttonFreqHeader) {
                if (SynthesisParameters.this.currentSort == SpectrumBinList.SpectrumSortBy.FREQUENCYUP) {
                    SynthesisParameters.this.currentSort = SpectrumBinList.SpectrumSortBy.FREQUENCYDOWN;
                    SynthesisParameters.this.buttonFreqHeader.setText(SynthesisParameters.this.frequencyHeader + SynthesisParameters.this.sortDownArrow);
                } else {
                    SynthesisParameters.this.currentSort = SpectrumBinList.SpectrumSortBy.FREQUENCYUP;
                    SynthesisParameters.this.buttonFreqHeader.setText(SynthesisParameters.this.frequencyHeader + SynthesisParameters.this.sortUpArrow);
                }
                SynthesisParameters.this.buttonAmplHeader.setText(SynthesisParameters.this.amplitudeHeader);
                SynthesisParameters.this.buttonPhaseHeader.setText(SynthesisParameters.this.phaseHeader);
            }
            if (which == SynthesisParameters.this.buttonAmplHeader) {
                if (SynthesisParameters.this.currentSort == SpectrumBinList.SpectrumSortBy.AMPLITUDEUP) {
                    SynthesisParameters.this.currentSort = SpectrumBinList.SpectrumSortBy.AMPLITUDEDOWN;
                    SynthesisParameters.this.buttonAmplHeader.setText(SynthesisParameters.this.amplitudeHeader + SynthesisParameters.this.sortDownArrow);
                } else {
                    SynthesisParameters.this.currentSort = SpectrumBinList.SpectrumSortBy.AMPLITUDEUP;
                    SynthesisParameters.this.buttonAmplHeader.setText(SynthesisParameters.this.amplitudeHeader + SynthesisParameters.this.sortUpArrow);
                }
                SynthesisParameters.this.buttonFreqHeader.setText(SynthesisParameters.this.frequencyHeader);
                SynthesisParameters.this.buttonPhaseHeader.setText(SynthesisParameters.this.phaseHeader);
            }
            if (which == SynthesisParameters.this.buttonPhaseHeader) {
                if (SynthesisParameters.this.currentSort == SpectrumBinList.SpectrumSortBy.PHASEUP) {
                    SynthesisParameters.this.currentSort = SpectrumBinList.SpectrumSortBy.PHASEDOWN;
                    SynthesisParameters.this.buttonPhaseHeader.setText(SynthesisParameters.this.phaseHeader + SynthesisParameters.this.sortDownArrow);
                } else {
                    SynthesisParameters.this.currentSort = SpectrumBinList.SpectrumSortBy.PHASEUP;
                    SynthesisParameters.this.buttonPhaseHeader.setText(SynthesisParameters.this.phaseHeader + SynthesisParameters.this.sortUpArrow);
                }
                SynthesisParameters.this.buttonFreqHeader.setText(SynthesisParameters.this.frequencyHeader);
                SynthesisParameters.this.buttonAmplHeader.setText(SynthesisParameters.this.amplitudeHeader);
            }
            SynthesisParameters.this.getHarmonicList().sortBins(SynthesisParameters.this.currentSort);
            SynthesisParameters.this.createHaFields();
            if (SynthesisParameters.this.autoRedraw.isSelected()) {
                SynthesisParameters.this.reDrawActions();
            }
        }
    };
    private ActionListener hDeleteButtonsListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            int index = Integer.parseInt(cmd);
            SynthesisParameters.this.harmonics = SynthesisParameters.this.getHarmonicList();
            if (SynthesisParameters.this.harmonics.getSize() < 2) {
                return;
            }
            SynthesisParameters.this.harmonics.removeBinByIndex(index);
            SynthesisParameters.this.createHaFields();
            if (SynthesisParameters.this.autoRedraw.isSelected()) {
                SynthesisParameters.this.reDrawActions();
            }
        }
    };
    private FocusListener scaleListener = new FocusListener(){

        @Override
        public void focusGained(final FocusEvent f) {
            if (f.getSource() == SynthesisParameters.this.scaleFactorField) {
                SynthesisParameters.this.scaleManButton.setSelected(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField field = (JTextField)f.getSource();
                        field.selectAll();
                    }
                });
            }
        }

        @Override
        public void focusLost(FocusEvent f) {
            if (f.isTemporary()) {
                return;
            }
            if (f.getSource() == SynthesisParameters.this.scaleFactorField) {
                boolean scaleOK = true;
                Number tmp = 0;
                double tmp2 = 0.0;
                try {
                    tmp = SynthesisParameters.this.genFormat.parse(SynthesisParameters.this.scaleFactorField.getText());
                }
                catch (Exception n) {
                    JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Invalid number in Scaling Factor");
                    scaleOK = false;
                }
                if (scaleOK && (tmp2 = tmp.doubleValue()) < 0.1) {
                    JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Scaling Factor cannot be less than 0.1");
                    scaleOK = false;
                }
                if (scaleOK) {
                    SynthesisParameters.this.manScale = tmp2;
                }
            }
            if (SynthesisParameters.this.synthesis != null && SynthesisParameters.this.autoRedraw.isSelected()) {
                SynthesisParameters.this.synthesis.recalculate(true, false, false);
            }
        }
    };
    private FocusListener fieldListener = new FocusListener(){

        @Override
        public void focusGained(final FocusEvent f) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTextField field = (JTextField)f.getSource();
                    field.selectAll();
                }
            });
        }

        @Override
        public void focusLost(FocusEvent f) {
            if (f.isTemporary()) {
                return;
            }
            JTextField field = (JTextField)f.getSource();
            String name = field.getName();
            if (name == null || name == "" || name.isEmpty()) {
                return;
            }
            String type = name.substring(0, 1);
            int index = 0;
            try {
                index = Integer.parseInt(name.substring(1));
            }
            catch (NumberFormatException n) {
                JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Internal index of field " + name + " is invalid - written when fields created.");
                return;
            }
            switch (type) {
                case "F": {
                    Number tmp;
                    try {
                        tmp = SynthesisParameters.this.genFormat.parse(field.getText());
                    }
                    catch (Exception n) {
                        JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Invalid number in frequency " + index + "\n");
                        field.requestFocus();
                        field.selectAll();
                        return;
                    }
                    double freq = tmp.doubleValue();
                    SynthesisParameters.this.harmonics.setFrequencyOfIndex(index, freq);
                    break;
                }
                case "A": {
                    Number tmp;
                    try {
                        tmp = SynthesisParameters.this.genFormat.parse(field.getText());
                    }
                    catch (Exception n) {
                        JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Invalid number in amplitude " + index + "\n");
                        field.requestFocus();
                        field.selectAll();
                        return;
                    }
                    if (tmp.doubleValue() < 0.0) {
                        JOptionPane.showMessageDialog(SynthesisParameters.this.ourWindow, "Amplitude " + index + " cannot be negative - use the phase.\n");
                        field.requestFocus();
                        field.selectAll();
                        return;
                    }
                    double amp = tmp.doubleValue();
                    SynthesisParameters.this.harmonics.setAmplitudeOfIndex(index, amp);
                    break;
                }
                case "P": {
                    Number tmp;
                    try {
                        tmp = SynthesisParameters.this.genFormat.parse(field.getText());
                    }
                    catch (Exception n) {
                        JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Invalid number in phase " + index + "\n");
                        field.requestFocus();
                        field.selectAll();
                        return;
                    }
                    double phase = tmp.doubleValue();
                    SynthesisParameters.this.harmonics.setPhaseOfIndex(index, phase);
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Internal type of field " + name + " is invalid - written when fields created.");
                }
            }
            if (SynthesisParameters.this.autoRedraw.isSelected()) {
                SynthesisParameters.this.reDrawActions();
            }
        }
    };

    SynthesisParameters(FRTmain parentGUI) {
        this.ourGUI = parentGUI;
        this.ourWindow = this;
        this.panelsBorder = new LineBorder(Color.lightGray, 3);
        SwingUtilities.getRootPane(this.ourGUI).setDefaultButton(this.buttonRedraw);
        float gain = this.volumeSlider.getValue();
        this.gainDB = Utils.convertGainToDB(gain);
        this.harmonics = new SpectrumBinList();
        this.harmonics.makeSawtooth(1, true, 0.9);
        this.currentSort = SpectrumBinList.SpectrumSortBy.FREQUENCYUP;
        this.freqFormat = NumberFormat.getInstance(Locale.getDefault());
        this.freqFormat.setMaximumFractionDigits(5);
        this.freqFormat.setMinimumFractionDigits(1);
        this.scaleFactorLabel.setToolTipText(this.scaleTip);
        this.scaleFactorField.setToolTipText(this.scaleTip);
        this.scaleManButton.setToolTipText(this.scaleManTip);
        this.scaleAutButton.setToolTipText(this.scaleAutTip);
        this.autScaleLabel.setToolTipText(this.autScaleTip);
        this.soundFrequencyLabel.setToolTipText(this.soundFrequencyTip);
        this.soundFrequencyField.setToolTipText(this.soundFrequencyTip);
        this.sampleRateLabel.setToolTipText(this.sampleRateTip);
        this.sampleRateField.setToolTipText(this.sampleRateTip);
        this.sampleSizeLabel.setToolTipText(this.sampleSizeTip);
        this.sampleSizeField.setToolTipText(this.sampleSizeTip);
        this.durationLabel.setToolTipText(this.durationTip);
        this.durationSpinner.setToolTipText(this.durationTip);
        this.titleLabel.setToolTipText(this.titleTip);
        this.titleField.setToolTipText(this.titleTip);
        this.playSoundOnRedraw.setToolTipText(this.playSoundonRedrawTip);
        this.buttonSoundPlay.setToolTipText(this.buttonSoundPlayTip);
        this.buttonSoundStop.setToolTipText(this.buttonSoundStopTip);
        this.buttonSave.setToolTipText(this.buttonSaveTip);
        this.buttonToAnalysis.setToolTipText(this.buttonToAnalysisTip);
        this.volumeSlider.setToolTipText(this.volumeSliderTip);
        this.volumeLabel.setToolTipText(this.volumeSliderTip);
        this.displayRefFig.setToolTipText(this.displayRefFigTip);
        this.displayRefVectors.setToolTipText(this.displayRefVectorsTip);
        this.displayRefCircles.setToolTipText(this.displayRefCirclesTip);
        this.displayConFig.setToolTipText(this.displayConFigTip);
        this.displayConVerticals.setToolTipText(this.displayConVertTip);
        this.displayConDC.setToolTipText(this.displayConDCTip);
        this.displayComponents.setToolTipText(this.displayComponentsTip);
        this.displaySpectrum.setToolTipText(this.displaySpectrumTip);
        this.harmonicsLabel.setToolTipText(this.harmonicsTip);
        this.harmonicsSpinner.setToolTipText(this.harmonicsTip);
        this.buttonPopulateSt.setToolTipText(this.buttonPopulateStTip);
        this.buttonPopulateSq.setToolTipText(this.buttonPopulateSqTip);
        this.buttonPopulateTr.setToolTipText(this.buttonPopulateTrTip);
        this.buttonRedraw.setToolTipText(this.buttonRedrawTip);
        this.autoRedraw.setToolTipText(this.autoRedrawTip);
        this.buttonAdd.setToolTipText(this.buttonAddTip);
        this.buttonImport.setToolTipText(this.buttonImportTip);
        this.buttonExport.setToolTipText(this.buttonExportTip);
        this.buttonClearPhases.setToolTipText(this.buttonClearPhasesTip);
        this.linButton.setToolTipText(this.buttonLinTip);
        this.expButton.setToolTipText(this.buttonExpTip);
        this.progressionXfield.setToolTipText(this.progressionXtip);
        this.noiseOn.setToolTipText(this.noiseTip);
        this.noiseLabel.setToolTipText(this.noiseTip);
        this.noisePeakField.setToolTipText(this.noiseTip);
        this.buttonFreqHeader.setToolTipText("Sort harmonics by ascending or descending frequency");
        this.buttonAmplHeader.setToolTipText("Sort harmonics by ascending or descending amplitude");
        this.buttonPhaseHeader.setToolTipText("Sort harmonics by ascending or descending phase");
        this.buttonRedraw.setEnabled(true);
        JPanel scalePanel = new JPanel(this.flowLayoutLeft);
        this.manScale = 100.0;
        this.scaleFactorField.setColumns(5);
        this.scaleFactorField.setText(this.freqFormat.format(this.manScale));
        this.scaleGroup.add(this.scaleManButton);
        this.scaleGroup.add(this.scaleAutButton);
        this.scaleAutButton.setSelected(true);
        this.scaleFactorField.addFocusListener(this.scaleListener);
        this.scaleFactorField.setName("ScaleField");
        this.scaleAutButton.addFocusListener(this.scaleListener);
        this.scaleAutButton.setName("ScaleAut");
        this.scaleManButton.addFocusListener(this.scaleListener);
        this.scaleManButton.setName("ScaleMan");
        scalePanel.add(this.scaleLabel);
        scalePanel.add(this.scaleAutButton);
        this.autScaleLabel.setText(String.valueOf(String.format("%.8f", this.calcScale)));
        scalePanel.add(this.autScaleLabel);
        scalePanel.add(this.scaleManButton);
        scalePanel.add(this.scaleFactorLabel);
        scalePanel.add(this.scaleFactorField);
        JPanel figuresPanel = new JPanel();
        figuresPanel.setLayout(new GridLayout(3, 3));
        figuresPanel.add(this.displayRefFig);
        figuresPanel.add(this.displayConFig);
        figuresPanel.add(this.displayComponents);
        figuresPanel.add(this.displayRefVectors);
        figuresPanel.add(this.displayConVerticals);
        figuresPanel.add(this.displaySpectrum);
        figuresPanel.add(this.displayRefCircles);
        figuresPanel.add(this.displayConDC);
        this.displayRefFig.setSelected(true);
        this.displayRefVectors.setSelected(true);
        this.displayRefCircles.setSelected(false);
        this.displayConFig.setSelected(false);
        this.displayConVerticals.setSelected(true);
        this.displayConVerticals.setEnabled(false);
        this.displayConDC.setSelected(true);
        this.displayConDC.setEnabled(false);
        this.displayComponents.setSelected(true);
        this.displaySpectrum.setSelected(true);
        this.autoRedraw.setSelected(true);
        this.displayRefFig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SynthesisParameters.this.displayRefFig.isSelected()) {
                    SynthesisParameters.this.displayRefVectors.setEnabled(true);
                    if (SynthesisParameters.this.displayRefVectors.isSelected()) {
                        SynthesisParameters.this.displayRefCircles.setEnabled(true);
                    } else {
                        SynthesisParameters.this.displayRefCircles.setEnabled(false);
                    }
                } else {
                    SynthesisParameters.this.displayRefVectors.setEnabled(false);
                    SynthesisParameters.this.displayRefCircles.setEnabled(false);
                }
                if (SynthesisParameters.this.autoRedraw.isSelected()) {
                    SynthesisParameters.this.reDrawActions();
                }
            }
        });
        this.displayRefVectors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SynthesisParameters.this.displayRefVectors.isSelected()) {
                    SynthesisParameters.this.displayRefCircles.setEnabled(true);
                } else {
                    SynthesisParameters.this.displayRefCircles.setEnabled(false);
                }
                if (SynthesisParameters.this.autoRedraw.isSelected()) {
                    SynthesisParameters.this.reDrawActions();
                }
            }
        });
        this.displayRefCircles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SynthesisParameters.this.autoRedraw.isSelected()) {
                    SynthesisParameters.this.reDrawActions();
                }
            }
        });
        this.displayConFig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SynthesisParameters.this.displayConFig.isSelected()) {
                    SynthesisParameters.this.displayConVerticals.setEnabled(true);
                    SynthesisParameters.this.displayConDC.setEnabled(true);
                } else {
                    SynthesisParameters.this.displayConVerticals.setEnabled(false);
                    SynthesisParameters.this.displayConDC.setEnabled(false);
                }
                if (SynthesisParameters.this.autoRedraw.isSelected()) {
                    SynthesisParameters.this.reDrawActions();
                }
            }
        });
        this.displayConVerticals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SynthesisParameters.this.autoRedraw.isSelected()) {
                    SynthesisParameters.this.reDrawActions();
                }
            }
        });
        this.displayConDC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SynthesisParameters.this.autoRedraw.isSelected()) {
                    SynthesisParameters.this.reDrawActions();
                }
            }
        });
        this.displayComponents.addActionListener(this.componentSpectrumListener);
        this.displaySpectrum.addActionListener(this.componentSpectrumListener);
        JPanel redrawPanel = new JPanel(this.flowLayoutLeft);
        this.buttonRedraw.setPreferredSize(new Dimension(80, 20));
        this.buttonRedraw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynthesisParameters.this.buttonRedraw.requestFocus();
                SynthesisParameters.this.reDrawActions();
            }
        });
        redrawPanel.add(this.buttonRedraw);
        redrawPanel.add(this.autoRedraw);
        Box displayPanel = Box.createVerticalBox();
        TitledBorder displayTitle = new TitledBorder(this.panelsBorder, "Display", 1, 2);
        displayPanel.setBorder(displayTitle);
        displayPanel.add(figuresPanel);
        displayPanel.add(scalePanel);
        displayPanel.add(redrawPanel);
        JPanel soundFreqPanel = new JPanel(this.flowLayoutLeft);
        this.frequency = 440.0;
        this.soundFrequencyField.setColumns(5);
        this.soundFrequencyField.setText(String.valueOf(String.format("%.1f", this.frequency)));
        this.soundFrequencyField.setHorizontalAlignment(2);
        this.soundFrequencyField.setCaretPosition(0);
        this.soundFrequencyField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(final FocusEvent f) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField field = (JTextField)f.getSource();
                        field.selectAll();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent f) {
                if (f.isTemporary()) {
                    return;
                }
                JTextField field = (JTextField)f.getSource();
                double tmp = 0.0;
                tmp = Utils.parseLocalDouble(field.getText());
                if (Double.isNaN(tmp)) {
                    JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Invalid number in frequency field");
                    return;
                }
                if (tmp < 1.0 || tmp > 20000.0) {
                    JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Frequency must be between 1Hz and 20kHz.");
                    return;
                }
                if (tmp != SynthesisParameters.this.frequency) {
                    SynthesisParameters.this.frequency = tmp;
                    if (SynthesisParameters.this.synthesis != null) {
                        SynthesisParameters.this.synthesis.recalculate(false, true, SynthesisParameters.this.playSoundOnRedraw.isSelected());
                    }
                }
            }
        });
        this.sampleRate = 44000;
        this.sampleRateField.setColumns(6);
        this.sampleRateField.setText(String.valueOf(this.sampleRate));
        this.sampleRateField.setHorizontalAlignment(2);
        this.sampleRateField.setCaretPosition(0);
        this.sampleRateField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(final FocusEvent f) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField field = (JTextField)f.getSource();
                        field.selectAll();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent f) {
                if (f.isTemporary()) {
                    return;
                }
                JTextField field = (JTextField)f.getSource();
                int tmp = 0;
                try {
                    tmp = Integer.parseInt(field.getText());
                }
                catch (NumberFormatException n) {
                    JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Invalid number in sample rate field");
                    return;
                }
                if (tmp < 2 || tmp > 440000) {
                    JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Sample rate must be between 2 and 440 000.");
                    return;
                }
                if (tmp != SynthesisParameters.this.sampleRate) {
                    SynthesisParameters.this.sampleRate = tmp;
                    if (SynthesisParameters.this.synthesis != null) {
                        SynthesisParameters.this.synthesis.recalculate(false, true, SynthesisParameters.this.playSoundOnRedraw.isSelected());
                    }
                }
            }
        });
        this.sampleSizeField.setSelectedIndex(1);
        ((JSpinner.DefaultEditor)this.durationSpinner.getEditor()).getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent f) {
            }

            @Override
            public void focusLost(FocusEvent f) {
                if (f.isTemporary()) {
                    return;
                }
                int newDuration = (Integer)SynthesisParameters.this.durationSpinner.getValue();
                if (newDuration != SynthesisParameters.this.duration) {
                    SynthesisParameters.this.duration = newDuration;
                    if (SynthesisParameters.this.synthesis != null) {
                        SynthesisParameters.this.synthesis.recalculate(false, true, SynthesisParameters.this.playSoundOnRedraw.isSelected());
                    }
                }
            }
        });
        this.duration = 1;
        this.durationSpinner.setValue(this.duration);
        soundFreqPanel.add(this.soundFrequencyLabel);
        soundFreqPanel.add(this.soundFrequencyField);
        soundFreqPanel.add(this.sampleRateLabel);
        soundFreqPanel.add(this.sampleRateField);
        soundFreqPanel.add(this.sampleSizeLabel);
        soundFreqPanel.add(this.sampleSizeField);
        soundFreqPanel.add(this.durationLabel);
        soundFreqPanel.add(this.durationSpinner);
        this.volumeSlider.setPaintTicks(false);
        this.volumeSlider.addChangeListener(new VolumeListener());
        this.volumeSlider.setPaintLabels(false);
        JPanel volumePlayPanel = new JPanel(this.flowLayoutLeft);
        volumePlayPanel.add(this.volumeLabel);
        volumePlayPanel.add(this.volumeSlider);
        this.playSoundOnRedraw.setSelected(true);
        volumePlayPanel.add(this.playSoundOnRedraw);
        this.buttonSoundPlay.setEnabled(false);
        this.buttonSoundPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynthesisParameters.this.synthesis.getWave().asyncPlay();
            }
        });
        this.buttonSoundStop.setEnabled(false);
        this.buttonSoundStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynthesisParameters.this.synthesis.getWave().stopSound();
            }
        });
        volumePlayPanel.add(this.buttonSoundPlay);
        volumePlayPanel.add(this.buttonSoundStop);
        this.buttonSave.setEnabled(false);
        this.buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SynthesisParameters.this.synthesis != null) {
                    String dString;
                    int newOverwriteSelection;
                    if (SynthesisParameters.this.currentSaveDir == "") {
                        SynthesisParameters.this.currentSaveDir = System.getProperty("user.home");
                    }
                    JFileChooser outFileChooser = new JFileChooser(SynthesisParameters.this.currentSaveDir);
                    outFileChooser.setDialogTitle("Save to File");
                    outFileChooser.setApproveButtonText("Save");
                    int outfolderChoice = outFileChooser.showOpenDialog(SynthesisParameters.this.ourGUI);
                    if (outfolderChoice != 0) {
                        return;
                    }
                    File chosenFolder = outFileChooser.getSelectedFile();
                    File saveFile = outFileChooser.getSelectedFile();
                    SynthesisParameters.this.currentSaveDir = chosenFolder.getParent();
                    if (saveFile.exists() && (newOverwriteSelection = JOptionPane.showConfirmDialog(SynthesisParameters.this.ourGUI, SynthesisParameters.this.newOverwriteDialog, "That File Already Exists - overwrite it?", 0, 3)) == 1) {
                        return;
                    }
                    String hString = "Frequency=" + SynthesisParameters.this.synthesis.getWave().getRealFrequency() + "Hz. Harmonics";
                    int i = 0;
                    while (i < SynthesisParameters.this.harmonics.getSize()) {
                        SpectrumBin h = SynthesisParameters.this.harmonics.getBinByIndex(i);
                        hString = hString + " " + i + ": Freq.=";
                        hString = hString + h.getFreqFactor();
                        hString = hString + " Ampl.=";
                        hString = hString + h.getAmplitude();
                        hString = hString + " Phase=";
                        hString = hString + h.getPhase();
                        ++i;
                    }
                    if (((hString = hString + "\u0000").length() & 1) != 0) {
                        hString = hString + "\u0000";
                    }
                    if (((dString = SynthesisParameters.this.titleField.getText() + "\u0000").length() & 1) != 0) {
                        dString = dString + "\u0000";
                    }
                    int tagsLength = hString.length() + dString.length() + 28;
                    try {
                        Throwable throwable = null;
                        Object var10_15 = null;
                        try (FileOutputStream out = new FileOutputStream(saveFile);){
                            byte[] sound = SynthesisParameters.this.synthesis.getWave().getSound();
                            int bytesPSample = SynthesisParameters.this.synthesis.getWave().getBytesPerSample();
                            int channels = 1;
                            int bits = bytesPSample * 8;
                            int waveChunkSize = 16;
                            int fileSize = sound.length + tagsLength + 36;
                            out.write("RIFF".getBytes());
                            SynthesisParameters.this.write4ByteValueBE(out, fileSize);
                            out.write("WAVEfmt ".getBytes());
                            SynthesisParameters.this.write4ByteValueBE(out, waveChunkSize);
                            SynthesisParameters.this.write2ByteValueBE(out, 1);
                            SynthesisParameters.this.write2ByteValueBE(out, channels);
                            SynthesisParameters.this.write4ByteValueBE(out, SynthesisParameters.this.sampleRate);
                            SynthesisParameters.this.write4ByteValueBE(out, SynthesisParameters.this.sampleRate * channels * bytesPSample);
                            SynthesisParameters.this.write2ByteValueBE(out, channels * bytesPSample);
                            SynthesisParameters.this.write2ByteValueBE(out, bits);
                            out.write("data".getBytes());
                            SynthesisParameters.this.write4ByteValueBE(out, sound.length);
                            out.write(sound);
                            SynthesisParameters.this.writeTags(out, hString, dString);
                            out.flush();
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Output File: IO Exception opening sound file for write");
                    }
                }
            }
        });
        JPanel titlePanel = new JPanel(this.flowLayoutLeft);
        titlePanel.add(this.titleLabel);
        titlePanel.add(this.titleField);
        titlePanel.add(this.buttonSave);
        this.buttonToAnalysis.setEnabled(false);
        this.buttonToAnalysis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                byte[] sound = SynthesisParameters.this.synthesis.getWave().getSound();
                AnalysisParameters analysisParams = SynthesisParameters.this.ourGUI.getAnalysisParamsWindow();
                analysisParams.waveFromSynthesis(sound, SynthesisParameters.this.sampleRate, SynthesisParameters.this.getSampleSize());
            }
        });
        JPanel soundButtonsPanel = new JPanel(this.flowLayoutLeft);
        soundButtonsPanel.add(this.buttonToAnalysis);
        Box soundPanel = Box.createVerticalBox();
        TitledBorder soundTitle = new TitledBorder(this.panelsBorder, "Sound", 1, 2);
        soundPanel.setBorder(soundTitle);
        soundPanel.add(soundFreqPanel);
        soundPanel.add(volumePlayPanel);
        soundPanel.add(titlePanel);
        soundPanel.add(soundButtonsPanel);
        JPanel presetsShapesPanel = new JPanel(this.flowLayoutLeft);
        presetsShapesPanel.add(this.harmonicsLabel);
        presetsShapesPanel.add(this.harmonicsSpinner);
        presetsShapesPanel.add(this.buttonPopulateSt);
        presetsShapesPanel.add(this.buttonPopulateSq);
        presetsShapesPanel.add(this.buttonPopulateTr);
        this.buttonPopulateSt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynthesisParameters.this.harmonics.clearBinList();
                SynthesisParameters.this.harmonics.makeSawtooth((Integer)SynthesisParameters.this.harmonicsSpinner.getValue(), SynthesisParameters.this.getProgressionLin(), SynthesisParameters.this.progressionX);
                SynthesisParameters.this.createHaFields();
                if (SynthesisParameters.this.autoRedraw.isSelected()) {
                    SynthesisParameters.this.reDrawActions();
                }
            }
        });
        this.buttonPopulateSq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynthesisParameters.this.harmonics.clearBinList();
                SynthesisParameters.this.harmonics.makeSquare((Integer)SynthesisParameters.this.harmonicsSpinner.getValue(), SynthesisParameters.this.getProgressionLin(), SynthesisParameters.this.progressionX);
                SynthesisParameters.this.createHaFields();
                if (SynthesisParameters.this.autoRedraw.isSelected()) {
                    SynthesisParameters.this.reDrawActions();
                }
            }
        });
        this.buttonPopulateTr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynthesisParameters.this.harmonics.clearBinList();
                SynthesisParameters.this.harmonics.makeTriangle((Integer)SynthesisParameters.this.harmonicsSpinner.getValue());
                SynthesisParameters.this.createHaFields();
                if (SynthesisParameters.this.autoRedraw.isSelected()) {
                    SynthesisParameters.this.reDrawActions();
                }
            }
        });
        this.progressionGroup.add(this.linButton);
        this.progressionGroup.add(this.expButton);
        this.linButton.setSelected(true);
        this.linButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SynthesisParameters.this.linButton.isSelected()) {
                    SynthesisParameters.this.progressionXfield.setEnabled(false);
                    SynthesisParameters.this.buttonPopulateTr.setEnabled(true);
                } else {
                    SynthesisParameters.this.progressionXfield.setEnabled(true);
                    SynthesisParameters.this.buttonPopulateTr.setEnabled(false);
                }
            }
        });
        this.progressionXfield.setColumns(5);
        this.progressionXfield.setEnabled(false);
        this.progressionX = 0.9;
        this.expButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SynthesisParameters.this.expButton.isSelected()) {
                    SynthesisParameters.this.progressionXfield.setEnabled(true);
                    SynthesisParameters.this.buttonPopulateTr.setEnabled(false);
                } else {
                    SynthesisParameters.this.progressionXfield.setEnabled(false);
                    SynthesisParameters.this.buttonPopulateTr.setEnabled(true);
                }
            }
        });
        this.progressionXfield.setText(String.valueOf(String.format("%.1f", this.progressionX)));
        this.progressionXfield.setHorizontalAlignment(2);
        this.progressionXfield.setCaretPosition(0);
        this.progressionXfield.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(final FocusEvent f) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField field = (JTextField)f.getSource();
                        field.selectAll();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent f) {
                if (f.isTemporary()) {
                    return;
                }
                JTextField field = (JTextField)f.getSource();
                double tmp = 0.0;
                tmp = Utils.parseLocalDouble(field.getText());
                if (Double.isNaN(tmp)) {
                    JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Invalid number in progression x field");
                    return;
                }
                if (tmp < 0.01 || tmp > 10.0) {
                    JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "x must be between 0.01 and 10.");
                    return;
                }
                if (tmp != SynthesisParameters.this.progressionX) {
                    SynthesisParameters.this.progressionX = tmp;
                    if (SynthesisParameters.this.synthesis != null) {
                        SynthesisParameters.this.synthesis.recalculate(true, true, SynthesisParameters.this.playSoundOnRedraw.isSelected());
                    }
                }
                if (SynthesisParameters.this.autoRedraw.isSelected()) {
                    SynthesisParameters.this.reDrawActions();
                }
            }
        });
        this.noiseOn.setSelected(false);
        this.noisePeakField.setColumns(5);
        this.noisePeakField.setEnabled(false);
        this.noiseLabel.setEnabled(false);
        this.noiseOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynthesisParameters.this.noisePeakField.setEnabled(SynthesisParameters.this.noiseOn.isSelected());
                SynthesisParameters.this.noiseLabel.setEnabled(SynthesisParameters.this.noiseOn.isSelected());
                if (SynthesisParameters.this.autoRedraw.isSelected()) {
                    SynthesisParameters.this.reDrawActions();
                }
            }
        });
        this.noisePeak = 0.8;
        this.noisePeakField.setText(String.valueOf(String.format("%.1f", this.noisePeak)));
        this.noisePeakField.setHorizontalAlignment(2);
        this.noisePeakField.setCaretPosition(0);
        this.noisePeakField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(final FocusEvent f) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField field = (JTextField)f.getSource();
                        field.selectAll();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent f) {
                if (f.isTemporary()) {
                    return;
                }
                JTextField field = (JTextField)f.getSource();
                double tmp = 0.0;
                tmp = Utils.parseLocalDouble(field.getText());
                if (Double.isNaN(tmp)) {
                    JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Invalid number in Noise Peak field");
                    field.requestFocus();
                    field.selectAll();
                    return;
                }
                if (tmp < 0.0) {
                    JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Noise Peak must be greater than 0.");
                    field.requestFocus();
                    field.selectAll();
                    return;
                }
                if (tmp != SynthesisParameters.this.noisePeak) {
                    SynthesisParameters.this.noisePeak = tmp;
                    if (SynthesisParameters.this.synthesis != null && SynthesisParameters.this.autoRedraw.isSelected()) {
                        SynthesisParameters.this.synthesis.recalculate(true, true, SynthesisParameters.this.playSoundOnRedraw.isSelected());
                    }
                }
            }
        });
        JPanel progressionNoisePanel = new JPanel(this.flowLayoutLeft);
        progressionNoisePanel.add(this.progressionLabel);
        progressionNoisePanel.add(this.linButton);
        progressionNoisePanel.add(this.expButton);
        progressionNoisePanel.add(this.progressionXlabel);
        progressionNoisePanel.add(this.progressionXfield);
        progressionNoisePanel.add(this.noiseOn);
        progressionNoisePanel.add(this.noiseLabel);
        progressionNoisePanel.add(this.noisePeakField);
        Box presetsPanel = Box.createVerticalBox();
        TitledBorder presetsTitle = new TitledBorder(this.panelsBorder, "Presets", 1, 2);
        presetsPanel.setBorder(presetsTitle);
        presetsPanel.add(presetsShapesPanel);
        presetsPanel.add(progressionNoisePanel);
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double lastFreq = SynthesisParameters.this.harmonics.getBinByIndex(SynthesisParameters.this.harmonics.getSize() - 1).getFreqFactor();
                SynthesisParameters.this.harmonics.addSpectrumBin(new SpectrumBin(lastFreq + 1.0, 0.0, 0.0));
                SynthesisParameters.this.createHaFields();
                if (SynthesisParameters.this.autoRedraw.isSelected()) {
                    SynthesisParameters.this.reDrawActions();
                }
            }
        });
        this.buttonImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SynthesisParameters.this.currentImportDir == "") {
                    SynthesisParameters.this.currentImportDir = System.getProperty("user.home");
                }
                JFileChooser openChooser = new JFileChooser(SynthesisParameters.this.currentImportDir);
                openChooser.setDialogTitle("Read Parameters from File");
                int openChoice = openChooser.showOpenDialog(SynthesisParameters.this.ourGUI);
                if (openChoice != 0) {
                    return;
                }
                File chosenOpenFile = openChooser.getSelectedFile();
                SynthesisParameters.this.currentImportDir = chosenOpenFile.getParent();
                SynthImport fileIn = new SynthImport(SynthesisParameters.this.ourGUI, chosenOpenFile);
                if (fileIn.readFile()) {
                    SynthesisParameters.this.harmonics.clearBinList();
                    SynthesisParameters.this.harmonics = fileIn.getHarmonics();
                    SynthesisParameters.this.setHarmonicsList(SynthesisParameters.this.harmonics);
                    SynthesisParameters.this.createHaFields();
                    if (SynthesisParameters.this.autoRedraw.isSelected()) {
                        SynthesisParameters.this.reDrawActions();
                    }
                }
            }
        });
        this.buttonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newOverwriteSelection;
                if (SynthesisParameters.this.currentExportDir == "") {
                    SynthesisParameters.this.currentExportDir = System.getProperty("user.home");
                }
                JFileChooser expChooser = new JFileChooser(SynthesisParameters.this.currentExportDir);
                expChooser.setDialogTitle("Save Parameters to File");
                int expChoice = expChooser.showSaveDialog(SynthesisParameters.this.ourGUI);
                if (expChoice != 0) {
                    return;
                }
                File saveFile = expChooser.getSelectedFile();
                SynthesisParameters.this.currentExportDir = saveFile.getParent();
                if (saveFile.exists() && (newOverwriteSelection = JOptionPane.showConfirmDialog(SynthesisParameters.this.ourGUI, SynthesisParameters.this.newOverwriteDialog, "That File Already Exists - overwrite it?", 0, 3)) == 1) {
                    return;
                }
                try {
                    saveFile.createNewFile();
                    String path = saveFile.getAbsolutePath();
                    BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8));
                    SynthesisParameters.this.outBuffer = new BufferedWriter(outWriter);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(SynthesisParameters.this.ourGUI, "Output File: IO Exception opening file for write");
                    return;
                }
                try {
                    Locale here = Locale.getDefault();
                    char decSep = new DecimalFormatSymbols(Locale.getDefault(Locale.Category.FORMAT)).getDecimalSeparator();
                    String sep = ",";
                    if (",".equals(new String(new char[]{decSep}))) {
                        sep = ";";
                    }
                    SynthesisParameters.this.outBuffer.write("sep=" + sep + "\n");
                    Object buffer = SynthesisParameters.this.titleField.getText();
                    SynthesisParameters.this.outBuffer.write("Description" + sep + (String)buffer + "\n");
                    SynthesisParameters.this.outBuffer.write("Frequency" + sep + SynthesisParameters.this.frequency + sep + SynthesisParameters.this.sampleRate + "\n");
                    SynthesisParameters.this.outBuffer.write("Noise" + sep + SynthesisParameters.this.noiseOn.isSelected() + sep + SynthesisParameters.this.noisePeak + "\n");
                    SynthesisParameters.this.outBuffer.write("Frequency" + sep + "Amplitude" + sep + "Phase\n");
                    SpectrumBinList freqResults = SynthesisParameters.this.getHarmonicList();
                    int i = 0;
                    while (i < freqResults.getSize()) {
                        buffer = "";
                        buffer = (String)buffer + String.format(here, "%f", freqResults.getBinByIndex(i).getFreqFactor()) + sep;
                        buffer = (String)buffer + String.format(here, "%f", freqResults.getBinByIndex(i).getAmplitude()) + sep;
                        buffer = (String)buffer + String.format(here, "%f", Math.toDegrees(freqResults.getBinByIndex(i).getPhase())) + "\n";
                        SynthesisParameters.this.outBuffer.write((String)buffer);
                        ++i;
                    }
                    SynthesisParameters.this.outBuffer.flush();
                    SynthesisParameters.this.outBuffer.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.buttonClearPhases.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < SynthesisParameters.this.harmonics.getSize()) {
                    SpectrumBin h = SynthesisParameters.this.harmonics.getBinByIndex(i);
                    h.setPhase(0.0);
                    ++i;
                }
                SynthesisParameters.this.createHaFields();
                if (SynthesisParameters.this.autoRedraw.isSelected()) {
                    SynthesisParameters.this.reDrawActions();
                }
            }
        });
        JPanel okPanel = new JPanel();
        okPanel.add(this.buttonImport);
        okPanel.add(this.buttonExport);
        okPanel.add(this.buttonAdd);
        okPanel.add(this.buttonClearPhases);
        Box top = Box.createVerticalBox();
        top.add(displayPanel);
        top.add(soundPanel);
        top.add(presetsPanel);
        top.add(okPanel);
        Dimension buttonSize = new Dimension(120, 20);
        this.buttonFreqHeader.setText(this.frequencyHeader + this.sortUpArrow);
        this.buttonFreqHeader.setPreferredSize(buttonSize);
        this.buttonFreqHeader.addActionListener(this.sortButtonsListener);
        this.buttonAmplHeader.setText(this.amplitudeHeader);
        this.buttonAmplHeader.setPreferredSize(buttonSize);
        this.buttonAmplHeader.addActionListener(this.sortButtonsListener);
        this.buttonPhaseHeader.setText(this.phaseHeader);
        this.buttonPhaseHeader.setPreferredSize(buttonSize);
        this.buttonPhaseHeader.addActionListener(this.sortButtonsListener);
        this.createHaFields();
        this.setLayout(new BorderLayout());
        this.add((Component)top, "North");
        this.add((Component)this.hScrollPane, "Center");
        this.reCreateHarmonicList();
        if (this.synthesis != null) {
            this.synthesis.recalculate(true, true, this.getPlayOnRedraw());
        }
    }

    private void reDrawActions() {
        String errors = this.checkHarmonicInputs();
        if (!errors.equals("")) {
            return;
        }
        if (this.synthesis == null) {
            this.createSynthesisWindow();
        }
        this.getHarmonicList().sortBins(this.currentSort);
        this.createHaFields();
        this.buttonRedraw.setEnabled(false);
        this.synthesis.getWave().stopSound();
        this.synthesis.recalculate(true, true, this.playSoundOnRedraw.isSelected());
    }

    private String checkHarmonicInputs() {
        this.harmonics = this.getHarmonicList();
        int size = this.harmonics.getSize();
        Object errors = "";
        int i = 0;
        while (i < size) {
            try {
                this.genFormat.parse(this.freqFields[i].getText());
            }
            catch (Exception n) {
                errors = (String)errors + "Invalid number in frequency " + i + "\n";
            }
            try {
                this.genFormat.parse(this.ampFields[i].getText());
            }
            catch (Exception n) {
                errors = (String)errors + "Invalid number in amplitude " + i + "\n";
            }
            try {
                this.genFormat.parse(this.phaseFields[i].getText());
            }
            catch (Exception n) {
                errors = (String)errors + "Invalid number in phase " + i + "\n";
            }
            ++i;
        }
        return errors;
    }

    private void createHaFields() {
        this.harmonics = this.getHarmonicList();
        int size = this.harmonics.getSize();
        this.harmonicsSpinner.setValue(size);
        this.freqFields = new JTextField[size];
        this.ampFields = new JTextField[size];
        this.phaseFields = new JTextField[size];
        this.deleteButtons = new JButton[size];
        if (this.harmonicsPanel != null) {
            this.remove(this.harmonicsPanel);
        }
        if (this.hScrollPane != null) {
            this.remove(this.hScrollPane);
        }
        this.harmonicsPanel = new JPanel();
        TitledBorder hListTitle = new TitledBorder(this.panelsBorder, "Harmonics List", 1, 2);
        this.harmonicsPanel.setBorder(hListTitle);
        GridBagLayout harmonicsGrid = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 19;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        this.harmonicsPanel.setLayout(harmonicsGrid);
        this.hScrollPane = new JScrollPane(this.harmonicsPanel);
        this.hScrollPane.setVerticalScrollBarPolicy(20);
        this.hScrollPane.setHorizontalScrollBarPolicy(31);
        c.gridx = 1;
        c.gridy = 0;
        this.harmonicsPanel.add((Component)this.buttonFreqHeader, c);
        c.gridx = 2;
        c.gridy = 0;
        this.harmonicsPanel.add((Component)this.buttonAmplHeader, c);
        c.gridx = 3;
        c.gridy = 0;
        this.harmonicsPanel.add((Component)this.buttonPhaseHeader, c);
        Dimension labelSize = new Dimension(40, 20);
        int i = 0;
        while (i < size) {
            JLabel rowLabel = new JLabel(i + ":", 4);
            rowLabel.setPreferredSize(labelSize);
            this.freqFields[i] = new JTextField();
            this.freqFields[i].setColumns(10);
            this.freqFields[i].setText(this.freqFormat.format(this.harmonics.getBinByIndex(i).getFreqFactor()));
            this.freqFields[i].setHorizontalAlignment(2);
            this.freqFields[i].setCaretPosition(0);
            this.freqFields[i].addFocusListener(this.fieldListener);
            this.freqFields[i].setName("F" + i);
            this.freqFields[i].setToolTipText("The freqency of the " + i + Utils.ordinalSuffix(i) + " overtone, the N in sin(Nx).");
            this.ampFields[i] = new JTextField();
            this.ampFields[i].setColumns(10);
            this.ampFields[i].setText(this.ampFormat.format(this.harmonics.getBinByIndex(i).getAmplitude()));
            this.ampFields[i].setHorizontalAlignment(2);
            this.ampFields[i].setCaretPosition(0);
            this.ampFields[i].addFocusListener(this.fieldListener);
            this.ampFields[i].setName("A" + i);
            this.ampFields[i].setToolTipText("The amplitude of the " + i + Utils.ordinalSuffix(i) + " overtone, the 1/N in (1/N)*sin(Nx+P)");
            this.phaseFields[i] = new JTextField();
            this.phaseFields[i].setColumns(10);
            this.phaseFields[i].setText(this.phaseFormat.format(this.harmonics.getBinByIndex(i).getPhase()));
            this.phaseFields[i].setHorizontalAlignment(2);
            this.phaseFields[i].setCaretPosition(0);
            this.phaseFields[i].addFocusListener(this.fieldListener);
            this.phaseFields[i].setName("P" + i);
            this.phaseFields[i].setToolTipText("The phase shift in degrees of the " + i + Utils.ordinalSuffix(i) + " overtone, the P in sin(x+P).");
            this.deleteButtons[i] = new JButton("Del.");
            this.deleteButtons[i].setPreferredSize(new Dimension(60, 20));
            this.deleteButtons[i].setActionCommand(String.valueOf(i));
            this.deleteButtons[i].addActionListener(this.hDeleteButtonsListener);
            this.deleteButtons[i].setToolTipText("Delete this row.");
            c.gridx = 0;
            c.gridy = i + 1;
            this.harmonicsPanel.add((Component)rowLabel, c);
            c.gridx = 1;
            c.gridy = i + 1;
            this.harmonicsPanel.add((Component)this.freqFields[i], c);
            this.ampFields[i].setPreferredSize(labelSize);
            c.gridx = 2;
            c.gridy = i + 1;
            this.harmonicsPanel.add((Component)this.ampFields[i], c);
            this.phaseFields[i].setPreferredSize(labelSize);
            c.gridx = 3;
            c.gridy = i + 1;
            this.harmonicsPanel.add((Component)this.phaseFields[i], c);
            c.gridx = 4;
            c.gridy = i + 1;
            if (i == size - 1) {
                c.weightx = 1.0;
                c.weighty = 1.0;
            }
            this.harmonicsPanel.add((Component)this.deleteButtons[i], c);
            ++i;
        }
        this.add(this.hScrollPane);
        this.revalidate();
    }

    private void reCreateHarmonicList() {
        this.harmonics.clearBinList();
        int i = 0;
        while (i < this.freqFields.length) {
            Number number = 0;
            try {
                number = this.genFormat.parse(this.freqFields[i].getText());
            }
            catch (Exception c) {
                JOptionPane.showMessageDialog(this.ourWindow, "Invalid number " + this.freqFields[i].getText() + " in Frequency field " + i);
                number = 0;
            }
            double freq = number.doubleValue();
            try {
                number = this.genFormat.parse(this.ampFields[i].getText());
            }
            catch (Exception c) {
                JOptionPane.showMessageDialog(this.ourWindow, "Invalid number  " + this.ampFields[i].getText() + " in Amplitude field " + i);
                number = 0;
            }
            if (number.doubleValue() < 0.0) {
                JOptionPane.showMessageDialog(this.ourWindow, "Invalid number  " + this.ampFields[i].getText() + " in Amplitude field " + i + " Amplitude cannot be negative - use the phase.");
                number = 0;
            }
            double amp = number.doubleValue();
            try {
                number = this.genFormat.parse(this.phaseFields[i].getText());
            }
            catch (Exception c) {
                JOptionPane.showMessageDialog(this.ourWindow, "Invalid number  " + this.phaseFields[i].getText() + " in Phase field " + i);
                number = 0;
            }
            double ph = number.doubleValue();
            this.harmonics.addSpectrumBin(new SpectrumBin(freq, amp, ph));
            ++i;
        }
    }

    public void spectrumToSynthesis(SpectrumBinList h, double frequency, int nBins) {
        this.harmonics.clearBinList();
        int i = 0;
        while (i < nBins) {
            SpectrumBin tmp = new SpectrumBin(h.getBinByIndex(i).getFreqFactor(), h.getBinByIndex(i).getAmplitude(), h.getBinByIndex(i).getPhase());
            this.harmonics.addSpectrumBin(tmp);
            ++i;
        }
        this.harmonics.radToDeg();
        this.createHaFields();
        this.setFrequency(frequency);
        if (this.getAutoRedraw()) {
            SynthesisWindow synthWin = this.getSynthesisWindow();
            synthWin.recalculate(true, true, this.getPlayOnRedraw());
        }
        this.ourGUI.repaint();
        this.getSynthesisWindow().repaint();
    }

    public void createSynthesisWindow() {
        this.buttonRedraw.setEnabled(true);
        this.synthesis = new SynthesisWindow(this.ourGUI);
    }

    private void write4ByteValueBE(FileOutputStream out, int in) {
        byte[] buffer = new byte[]{(byte)(in & 0xFF), (byte)(in >> 8 & 0xFF), (byte)(in >> 16 & 0xFF), (byte)(in >> 24 & 0xFF)};
        try {
            out.write(buffer);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.ourGUI, "Wave File: IO Exception writing 4 bytes - " + e.getMessage());
        }
    }

    private void write2ByteValueBE(FileOutputStream out, int in) {
        byte[] buffer = new byte[]{(byte)(in & 0xFF), (byte)(in >> 8 & 0xFF)};
        try {
            out.write(buffer);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.ourGUI, "Wave File: IO Exception writing 2 bytes - " + e.getMessage());
        }
    }

    private void writeTags(FileOutputStream out, String harmonics, String description) {
        int dStringLength = description.length();
        int hStringLength = harmonics.length();
        int listLength = dStringLength + hStringLength + 20;
        try {
            out.write("LIST".getBytes());
            this.write4ByteValueBE(out, listLength);
            out.write("INFO".getBytes());
            out.write("INAM".getBytes());
            this.write4ByteValueBE(out, dStringLength);
            out.write(description.getBytes("ISO-8859-1"));
            out.write("ICMT".getBytes());
            this.write4ByteValueBE(out, hStringLength);
            out.write(harmonics.getBytes("ISO-8859-1"));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.ourGUI, "Wave File: IO Exception writing tags - " + e.getMessage());
        }
    }

    public SpectrumBinList getHarmonicList() {
        return this.harmonics;
    }

    public void setHarmonicsList(SpectrumBinList h) {
        this.harmonics = new SpectrumBinList();
        int i = 0;
        while (i < h.getSize()) {
            SpectrumBin tmp = new SpectrumBin(h.getBinByIndex(i).getFreqFactor(), h.getBinByIndex(i).getAmplitude(), h.getBinByIndex(i).getPhase());
            this.harmonics.addSpectrumBin(tmp);
            ++i;
        }
    }

    public SynthesisWindow getSynthesisWindow() {
        return this.synthesis;
    }

    public boolean getDisplayRefFig() {
        return this.displayRefFig.isSelected();
    }

    public boolean getDisplayRefVectors() {
        return this.displayRefVectors.isSelected();
    }

    public boolean getDisplayRefCircles() {
        return this.displayRefCircles.isSelected();
    }

    public boolean getDisplayConFig() {
        return this.displayConFig.isSelected();
    }

    public boolean getDisplayConVerticals() {
        return this.displayConVerticals.isSelected();
    }

    public boolean getDisplayConDC() {
        return this.displayConDC.isSelected();
    }

    public boolean getDisplayComponents() {
        return this.displayComponents.isSelected();
    }

    public boolean getDisplaySpectrum() {
        return this.displaySpectrum.isSelected();
    }

    public double getManScale() {
        return this.manScale;
    }

    public boolean isAutoScale() {
        return this.scaleAutButton.isSelected();
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double freq) {
        this.frequency = freq;
        try {
            this.soundFrequencyField.setText(String.valueOf(String.format("%.3f", this.frequency)));
        }
        catch (IllegalFormatException f) {
            System.out.println("Illegal format exception in set Frequency: " + f.getMessage());
        }
        catch (FormatterClosedException c) {
            System.out.println("Formatter closed exception in set Frequency:" + c.getMessage());
        }
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSize() {
        return (Integer)this.sampleSizeField.getSelectedItem();
    }

    public void setSampleRate(int rate) {
        this.sampleRate = rate;
        try {
            this.sampleRateField.setText(String.valueOf(rate));
        }
        catch (IllegalFormatException f) {
            System.out.println("Illegal format exception in set Sample Rate: " + f.getMessage());
        }
        catch (FormatterClosedException c) {
            System.out.println("Formatter closed exception in set Sample Rate:" + c.getMessage());
        }
    }

    public float getGainDB() {
        return this.gainDB;
    }

    public boolean getAutoRedraw() {
        return this.autoRedraw.isSelected();
    }

    public void setEnDisableRedraw(boolean en) {
        this.buttonRedraw.setEnabled(en);
    }

    public void setEnDisableSoundStop(boolean en) {
        this.buttonSoundStop.setEnabled(en);
    }

    public void setEnDisableSoundStart(boolean en) {
        this.buttonSoundPlay.setEnabled(en);
    }

    public void setEnDisableSoundSave(boolean en) {
        this.buttonSave.setEnabled(en);
        this.buttonToAnalysis.setEnabled(en);
    }

    public int getSoundDuration() {
        return (Integer)this.durationSpinner.getValue();
    }

    public boolean getPlayOnRedraw() {
        return this.playSoundOnRedraw.isSelected();
    }

    public void setAutoScale(String s) {
        this.autScaleLabel.setText(s);
    }

    public void enDisableVolume(boolean x) {
        this.volumeSlider.setEnabled(x);
    }

    public boolean getProgressionLin() {
        return this.linButton.isSelected();
    }

    public double getProgressionX() {
        return this.progressionX;
    }

    public boolean getNoiseOn() {
        return this.noiseOn.isSelected();
    }

    public void setNoiseOn(boolean b) {
        this.noiseOn.setSelected(b);
        this.noisePeakField.setEnabled(b);
        this.noiseLabel.setEnabled(b);
    }

    public double getNoisePeak() {
        return this.noisePeak;
    }

    public void setNoisePeak(double peak) {
        this.noisePeak = peak;
        this.noisePeakField.setText(String.valueOf(peak));
    }

    public void setDescription(String description) {
        this.titleField.setText(description);
        this.titleField.setCaretPosition(0);
    }

    public void focusNew() {
        this.buttonRedraw.requestFocusInWindow();
    }

    public void synthesisClosed() {
        this.synthesis = null;
        this.buttonSoundPlay.setEnabled(false);
        this.buttonSoundStop.setEnabled(false);
        this.buttonSave.setEnabled(false);
        this.buttonToAnalysis.setEnabled(false);
    }

    private class VolumeListener
    implements ChangeListener {
        private VolumeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            float gain = source.getValue();
            SynthesisParameters.this.gainDB = Utils.convertGainToDB(gain);
            if (SynthesisParameters.this.synthesis != null) {
                SynthesisParameters.this.synthesis.getWave().setSoundGain(SynthesisParameters.this.gainDB);
            }
        }
    }
}

