/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import roundtrip.FRTmain;
import roundtrip.GraphicsColor;
import roundtrip.GraphicsColorEditor;
import roundtrip.UtilTableColorRenderer;
import roundtrip.UtilTableGreyRenderer;

class Settings
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private static final int col0Width = 70;
    private static final int col1Width = 70;
    private static final int col2Width = 90;
    private DefaultTableModel paletteTableModel = null;
    private JTable paletteTable = null;
    private JScrollPane paletteScroll;
    private LineBorder tlPanelsBorder = new LineBorder(Color.lightGray, 3);
    private JFrame prefsFrame;
    private FRTmain ourGUI;
    private int synthesisBackground;
    private int analysisBackground;
    private int axisColor;
    private int axisGraticuleColor;
    private int plotColor;
    private int waveColor;
    private int refFigColor;
    private int conFigColor;
    private int refFigVectorColor;
    private int refFigCircleColor;
    private int refPointColor;
    private int conPointColor;
    private int soundColor;
    private int soundWindowColor;
    private int mark1Color;
    private int mark1ColorFull;
    private int mark2Color;
    private int mark2ColorFull;
    private int markZeroColor;
    private int cursorColor;
    private int messageColor;
    private int fftWindowColor;
    private int fftOverlapColor;
    private int fftFinalColor;
    private int ftStaleColor;
    private int avgWaveColor;
    private int decayInterpolationColor;
    private int decayInterpolationColorFull;
    private int spectrumNotesColor;
    private int spectrumHarmonicsColor;
    private List<GraphicsColor> colorList;
    private JButton buttonExport = new JButton("Export");
    private JButton buttonImport = new JButton("Import");
    private JButton buttonDefaults = new JButton("Reset to Defaults");
    private JButton buttonClose = new JButton("Close");
    private String exportTip = "Export all the colours to a file.";
    private String importTip = "Import colours from a previously exported file.";
    private String defaultstip = "Reset all the colours to their original values - you might want to export them first!";
    private String closeTip = "Close the window.";
    private String currentExportDir = "";
    private BufferedWriter outBuffer = null;
    private String newOverwriteDialog = "New output file already exists. Do you want to overwrite it?";
    private String myFilePath = "";
    private String myFileDir = "";
    private BufferedReader in;

    Settings(FRTmain mainGUI) {
        this.prefsFrame = this;
        this.ourGUI = mainGUI;
        this.initColorList();
        Object[] paletteHeader = new String[]{"Color", "GreyScale", "Hex", "Name"};
        this.paletteTableModel = new DefaultTableModel(0, 4){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.paletteTableModel.setColumnIdentifiers(paletteHeader);
        this.paletteTable = new JTable(this.paletteTableModel){
            private static final long serialVersionUID = 1L;
            private Border outside;
            private Border inside;
            private Border highlight;
            private Border noHighlight;
            {
                this.outside = new MatteBorder(1, 0, 1, 0, Color.RED);
                this.inside = new EmptyBorder(0, 1, 0, 1);
                this.highlight = new CompoundBorder(this.outside, this.inside);
                this.noHighlight = new EmptyBorder(0, 1, 0, 1);
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                JComponent jc = (JComponent)c;
                if (this.isRowSelected(row)) {
                    jc.setBorder(this.highlight);
                } else {
                    jc.setBorder(this.noHighlight);
                }
                return c;
            }
        };
        this.paletteTable.setSelectionMode(0);
        this.paletteTable.setFont(new Font("Monospaced", 0, 12));
        this.paletteTable.getColumnModel().getColumn(0).setCellRenderer(new UtilTableColorRenderer());
        this.paletteTable.getColumnModel().getColumn(1).setCellRenderer(new UtilTableGreyRenderer());
        this.paletteTable.getColumnModel().getColumn(0).setMinWidth(70);
        this.paletteTable.getColumnModel().getColumn(0).setMaxWidth(70);
        this.paletteTable.getColumnModel().getColumn(0).setPreferredWidth(70);
        this.paletteTable.getColumnModel().getColumn(1).setMinWidth(70);
        this.paletteTable.getColumnModel().getColumn(1).setMaxWidth(70);
        this.paletteTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.paletteTable.getColumnModel().getColumn(2).setMinWidth(90);
        this.paletteTable.getColumnModel().getColumn(2).setMaxWidth(90);
        this.paletteTable.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.paletteScroll = new JScrollPane(this.paletteTable);
        this.paletteScroll.setPreferredSize(new Dimension(600, 450));
        this.updatePaletteTable();
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)this.paletteScroll, "Center");
        TitledBorder tlColorTitle = new TitledBorder(this.tlPanelsBorder, "", 1, 2);
        tablePanel.setBorder(tlColorTitle);
        this.paletteTable.setAutoResizeMode(3);
        this.paletteTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    Settings.this.editActions();
                }
            }
        });
        JPanel colorsPanel = new JPanel();
        colorsPanel.add(tablePanel);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.buttonExport);
        buttonsPanel.add(this.buttonImport);
        buttonsPanel.add(this.buttonDefaults);
        buttonsPanel.add(this.buttonClose);
        this.buttonExport.setToolTipText(this.exportTip);
        this.buttonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newOverwriteSelection;
                if (Settings.this.currentExportDir == "") {
                    Settings.this.currentExportDir = System.getProperty("user.home");
                }
                JFileChooser expChooser = new JFileChooser(Settings.this.currentExportDir);
                expChooser.setDialogTitle("Export Colours to File");
                int expChoice = expChooser.showSaveDialog(Settings.this.ourGUI);
                if (expChoice != 0) {
                    return;
                }
                File saveFile = expChooser.getSelectedFile();
                Settings.this.currentExportDir = saveFile.getParent();
                if (saveFile.exists() && (newOverwriteSelection = JOptionPane.showConfirmDialog(Settings.this.ourGUI, Settings.this.newOverwriteDialog, "That File Already Exists - overwrite it?", 0, 3)) == 1) {
                    return;
                }
                try {
                    saveFile.createNewFile();
                    String path = saveFile.getAbsolutePath();
                    BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8));
                    Settings.this.outBuffer = new BufferedWriter(outWriter);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(Settings.this.ourGUI, "Output File: IO Exception opening file for write");
                    return;
                }
                try {
                    char decSep = new DecimalFormatSymbols(Locale.getDefault(Locale.Category.FORMAT)).getDecimalSeparator();
                    String sep = ",";
                    if (",".equals(new String(new char[]{decSep}))) {
                        sep = ";";
                    }
                    Settings.this.outBuffer.write("sep=" + sep + "\n");
                    Object buffer = "";
                    int i = 0;
                    while (i < Settings.this.colorList.size()) {
                        GraphicsColor c = Settings.this.colorList.get(i);
                        buffer = (String)buffer + c.getName() + sep + Settings.this.stringFromColor(c.getColor()) + "\n";
                        ++i;
                    }
                    Settings.this.outBuffer.write((String)buffer);
                    Settings.this.outBuffer.flush();
                    Settings.this.outBuffer.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.buttonImport.setToolTipText(this.importTip);
        this.buttonImport.addActionListener(new ActionListener(){

            /*
             * Exception decompiling
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[WHILELOOP]], but top level block is 5[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        this.buttonDefaults.setToolTipText(this.defaultstip);
        this.buttonDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.this.initColorList();
                Settings.this.updatePaletteTable();
                Settings.this.prefsFrame.repaint();
                if (Settings.this.ourGUI.getSynthParams().getSynthesisWindow() != null) {
                    Settings.this.ourGUI.getSynthParams().getSynthesisWindow().repaint();
                }
                if (Settings.this.ourGUI.getAnalysisParamsWindow().getAnalysisWindow() != null) {
                    Settings.this.ourGUI.getAnalysisParamsWindow().getAnalysisWindow().repaint();
                }
            }
        });
        this.buttonClose.setToolTipText(this.closeTip);
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.this.prefsFrame.setVisible(false);
            }
        });
        Box colorsBox = Box.createVerticalBox();
        colorsBox.add(colorsPanel);
        colorsBox.add(buttonsPanel);
        this.tabbedPane.addTab("Colours", null, colorsBox, "Colour settings");
        this.add(this.tabbedPane);
        this.setTitle("Fourier Round Trip Settings");
        this.pack();
    }

    private void editActions() {
        GraphicsColorEditor editor;
        int oldColorIdx;
        Color oldColor = (Color)this.paletteTable.getValueAt(this.paletteTable.getSelectedRow(), 0);
        String oldColorName = (String)this.paletteTable.getValueAt(this.paletteTable.getSelectedRow(), 3);
        if (!oldColorName.equals(this.colorList.get(oldColorIdx = this.getIndexOfColor(oldColorName)).getName())) {
            System.out.println("Name difference in  colors " + oldColorName + " " + this.colorList.get(oldColorIdx).getName());
        }
        if ((editor = new GraphicsColorEditor(this.prefsFrame, oldColorName, this.colorList.get(oldColorIdx).getColor())).getResult() != null && editor.getResult().equals("OK")) {
            Color newColor = editor.getResultColor();
            if (newColor.equals(this.getSynthesisBackground())) {
                JOptionPane.showMessageDialog(this.prefsFrame, "New color " + oldColorName + " is the same as the graphics background, so will not be visible.");
            }
            this.colorList.set(oldColorIdx, new GraphicsColor(oldColorName, newColor));
            this.paletteTable.setValueAt(newColor, this.paletteTable.getSelectedRow(), 0);
            this.paletteTable.setValueAt(newColor, this.paletteTable.getSelectedRow(), 1);
            this.paletteTable.setValueAt(this.stringFromColor(newColor), this.paletteTable.getSelectedRow(), 2);
        } else {
            this.paletteTable.setValueAt(oldColor, this.paletteTable.getSelectedRow(), 0);
            this.paletteTable.setValueAt(oldColor, this.paletteTable.getSelectedRow(), 1);
            this.paletteTable.setValueAt(this.stringFromColor(oldColor), this.paletteTable.getSelectedRow(), 2);
        }
        this.repaint();
        if (this.ourGUI.getSynthParams().getSynthesisWindow() != null) {
            this.ourGUI.getSynthParams().getSynthesisWindow().repaint();
        }
        if (this.ourGUI.getAnalysisParamsWindow().getAnalysisWindow() != null) {
            this.ourGUI.getAnalysisParamsWindow().getAnalysisWindow().repaint();
        }
    }

    private void updatePaletteTable() {
        this.paletteTableModel.setRowCount(0);
        int i = 0;
        while (i < this.colorList.size()) {
            GraphicsColor c = this.colorList.get(i);
            this.paletteTableModel.addRow(new Object[]{c.getColor(), c.getColor(), this.stringFromColor(c.getColor()), c.getName()});
            ++i;
        }
    }

    private void initColorList() {
        this.colorList = new ArrayList<GraphicsColor>();
        this.colorList.add(new GraphicsColor("Synthesis Background", new Color(252, 252, 252, 255)));
        this.synthesisBackground = 0;
        this.colorList.add(new GraphicsColor("Analysis Background", new Color(255, 169, 11, 12)));
        this.analysisBackground = 1;
        this.colorList.add(new GraphicsColor("Axis Color", new Color(0, 0, 0, 181)));
        this.axisColor = 2;
        this.colorList.add(new GraphicsColor("Axis Graticule Color", new Color(0, 0, 0, 60)));
        this.axisGraticuleColor = 3;
        this.colorList.add(new GraphicsColor("Plot Color", new Color(255, 0, 0, 255)));
        this.plotColor = 4;
        this.colorList.add(new GraphicsColor("Wave Color", new Color(255, 0, 0, 255)));
        this.waveColor = 5;
        this.colorList.add(new GraphicsColor("Reference Figure Color", new Color(0, 0, 255, 120)));
        this.refFigColor = 6;
        this.colorList.add(new GraphicsColor("Constructur Figure Color", new Color(237, 125, 49, 180)));
        this.conFigColor = 7;
        this.colorList.add(new GraphicsColor("Reference Figure Vector Color", new Color(0, 204, 51, 255)));
        this.refFigVectorColor = 8;
        this.colorList.add(new GraphicsColor("Reference Figure Circle Color", new Color(0, 153, 0, 97)));
        this.refFigCircleColor = 9;
        this.colorList.add(new GraphicsColor("Reference Figure Point Color", new Color(237, 125, 49, 180)));
        this.refPointColor = 10;
        this.colorList.add(new GraphicsColor("Constructor Figure Point Color", new Color(255, 0, 0, 255)));
        this.conPointColor = 11;
        this.colorList.add(new GraphicsColor("Sound Color", new Color(160, 180, 160, 120)));
        this.soundColor = 12;
        this.colorList.add(new GraphicsColor("Sound Window Color", new Color(0, 255, 0, 120)));
        this.soundWindowColor = 13;
        this.colorList.add(new GraphicsColor("Mark1 Color", new Color(255, 0, 0, 128)));
        this.mark1Color = 14;
        this.colorList.add(new GraphicsColor("Mark1 Label Color", new Color(255, 0, 0, 255)));
        this.mark1ColorFull = 15;
        this.colorList.add(new GraphicsColor("Mark2 Color", new Color(0, 0, 255, 128)));
        this.mark2Color = 16;
        this.colorList.add(new GraphicsColor("Mark2 Label Color", new Color(0, 0, 255, 255)));
        this.mark2ColorFull = 17;
        this.colorList.add(new GraphicsColor("Mark Zero Color", new Color(255, 132, 0, 180)));
        this.markZeroColor = 18;
        this.colorList.add(new GraphicsColor("Cursor Color", new Color(200, 132, 54, 255)));
        this.cursorColor = 19;
        this.colorList.add(new GraphicsColor("Message Color", new Color(255, 50, 50, 255)));
        this.messageColor = 20;
        this.colorList.add(new GraphicsColor("FT Window Color", new Color(0, 0, 0, 180)));
        this.fftWindowColor = 21;
        this.colorList.add(new GraphicsColor("FT Overlap Color", new Color(0, 100, 100, 180)));
        this.fftOverlapColor = 22;
        this.colorList.add(new GraphicsColor("FT Final Color", new Color(255, 132, 0, 180)));
        this.fftFinalColor = 23;
        this.colorList.add(new GraphicsColor("FT Stale Color", new Color(255, 0, 0, 255)));
        this.ftStaleColor = 24;
        this.colorList.add(new GraphicsColor("Average Wave Color", new Color(0, 150, 0, 180)));
        this.avgWaveColor = 25;
        this.colorList.add(new GraphicsColor("Decay Interpolation Color", new Color(180, 0, 255, 180)));
        this.decayInterpolationColor = 26;
        this.colorList.add(new GraphicsColor("Decay Interpolation Color Full", new Color(180, 0, 255, 255)));
        this.decayInterpolationColorFull = 27;
        this.colorList.add(new GraphicsColor("Spectrum Notes Color", new Color(0, 0, 255, 154)));
        this.spectrumNotesColor = 28;
        this.colorList.add(new GraphicsColor("Spectrum Harmonics Color", new Color(0, 120, 0, 214)));
        this.spectrumHarmonicsColor = 29;
    }

    public GraphicsColor getColorByName(String name) {
        int i = 0;
        while (i < this.colorList.size()) {
            if (this.colorList.get(i).getName().equals(name)) {
                return this.colorList.get(i);
            }
            ++i;
        }
        return null;
    }

    private int getIndexOfColor(String name) {
        int i = 0;
        while (i < this.colorList.size()) {
            if (this.colorList.get(i).getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String stringFromColor(Color c) {
        String hex = Integer.toHexString(c.getRGB());
        return "0x" + hex;
    }

    private static Color colorFromString(String in) {
        Long colorIn;
        try {
            colorIn = Long.decode(in);
        }
        catch (Exception NumerFormatException) {
            return null;
        }
        Long blue = colorIn & 0xFFL;
        int blue2 = blue.intValue();
        Long green = colorIn & 0xFF00L;
        green = green >> 8;
        int green2 = green.intValue();
        Long red = colorIn & 0xFF0000L;
        red = red >> 16;
        int red2 = red.intValue();
        Long alpha = colorIn;
        alpha = alpha >> 24;
        alpha = alpha & 0xFFL;
        int alpha2 = alpha.intValue();
        Color newColor = new Color(red2, green2, blue2, alpha2);
        return newColor;
    }

    public Color getSynthesisBackground() {
        return this.colorList.get(this.synthesisBackground).getColor();
    }

    public Color getAnalysisBackground() {
        return this.colorList.get(this.analysisBackground).getColor();
    }

    public Color getAxisColor() {
        return this.colorList.get(this.axisColor).getColor();
    }

    public Color getAxisGraticuleColor() {
        return this.colorList.get(this.axisGraticuleColor).getColor();
    }

    public Color getPlotColor() {
        return this.colorList.get(this.plotColor).getColor();
    }

    public Color getWaveColor() {
        return this.colorList.get(this.waveColor).getColor();
    }

    public Color getRefFigColor() {
        return this.colorList.get(this.refFigColor).getColor();
    }

    public Color getConFigColor() {
        return this.colorList.get(this.conFigColor).getColor();
    }

    public Color getRefFigVectorColor() {
        return this.colorList.get(this.refFigVectorColor).getColor();
    }

    public Color getRefFigCircleColor() {
        return this.colorList.get(this.refFigCircleColor).getColor();
    }

    public Color getRefPointColor() {
        return this.colorList.get(this.refPointColor).getColor();
    }

    public Color getConPointColor() {
        return this.colorList.get(this.conPointColor).getColor();
    }

    public Color getSoundColor() {
        return this.colorList.get(this.soundColor).getColor();
    }

    public Color getSoundWindowColor() {
        return this.colorList.get(this.soundWindowColor).getColor();
    }

    public Color getMark1Color() {
        return this.colorList.get(this.mark1Color).getColor();
    }

    public Color getMark1ColorFull() {
        return this.colorList.get(this.mark1ColorFull).getColor();
    }

    public Color getMark2Color() {
        return this.colorList.get(this.mark2Color).getColor();
    }

    public Color getMarkZeroColor() {
        return this.colorList.get(this.markZeroColor).getColor();
    }

    public Color getMark2ColorFull() {
        return this.colorList.get(this.mark2ColorFull).getColor();
    }

    public Color getCursorColor() {
        return this.colorList.get(this.cursorColor).getColor();
    }

    public Color getMessageColor() {
        return this.colorList.get(this.messageColor).getColor();
    }

    public Color getFFTWindowColor() {
        return this.colorList.get(this.fftWindowColor).getColor();
    }

    public Color getFFTOverlapColor() {
        return this.colorList.get(this.fftOverlapColor).getColor();
    }

    public Color getFFTFinalColor() {
        return this.colorList.get(this.fftFinalColor).getColor();
    }

    public Color getFFTStalecolor() {
        return this.colorList.get(this.ftStaleColor).getColor();
    }

    public Color getAvgWaveColor() {
        return this.colorList.get(this.avgWaveColor).getColor();
    }

    public Color getDecayInterpolationColor() {
        return this.colorList.get(this.decayInterpolationColor).getColor();
    }

    public Color getDecayInterpolationColorFull() {
        return this.colorList.get(this.decayInterpolationColorFull).getColor();
    }

    public Color getSpectrumNotesColor() {
        return this.colorList.get(this.spectrumNotesColor).getColor();
    }

    public Color getSpectrumHarmonicsColor() {
        return this.colorList.get(this.spectrumHarmonicsColor).getColor();
    }
}

