/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import roundtrip.WavePanel;

class QuickPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel quickPanel;
    private JButton buttonGoToStart = new JButton("<<");
    private JButton buttonGoToMark1 = new JButton("1|<");
    private JButton buttonGoToWindow = new JButton(">| |<");
    private JButton buttonGoToMark2 = new JButton(">|2");
    private JButton buttonGoToEnd = new JButton(">>");
    private JButton buttonZoomMin = new JButton("Min");
    private JButton buttonZoomMinus = new JButton("-");
    private JButton buttonZoomPlus = new JButton("+");
    private JButton buttonZoomMax = new JButton("Max");
    private JLabel syncLabel = new JLabel("Sync:");
    private JCheckBox boxSyncZoom = new JCheckBox("Zoom");
    private JCheckBox boxSyncMarks = new JCheckBox("Marks");
    private String goToStartEndTip = "Go to the Start or End of the track.";
    private String goToMarkTip = "Go to the first or second mark.";
    private String goToWindowTip = "Show the time between the marks.";
    private String zoomMaxMinTip = "Set zoom to the maximum or minimum.";
    private String zoomPlusMinusTip = "Zoom in or out by one step.";
    private String SyncTip = "Check to synchronise zoom/pan and/or marks between Input and Average";
    private WavePanel parentPanel;
    private FlowLayout flowLayoutCenter = new FlowLayout(1);
    private List<QuickButtonListener> listeners = new ArrayList<QuickButtonListener>();

    QuickPanel(WavePanel p) {
        this.parentPanel = p;
        this.buttonGoToStart.setToolTipText(this.goToStartEndTip);
        this.buttonGoToEnd.setToolTipText(this.goToStartEndTip);
        this.buttonGoToMark1.setToolTipText(this.goToMarkTip);
        this.buttonGoToWindow.setToolTipText(this.goToWindowTip);
        this.buttonGoToMark2.setToolTipText(this.goToMarkTip);
        this.buttonZoomMax.setToolTipText(this.zoomMaxMinTip);
        this.buttonZoomMin.setToolTipText(this.zoomMaxMinTip);
        this.buttonZoomPlus.setToolTipText(this.zoomPlusMinusTip);
        this.buttonZoomMinus.setToolTipText(this.zoomPlusMinusTip);
        this.boxSyncZoom.setToolTipText(this.SyncTip);
        this.boxSyncMarks.setToolTipText(this.SyncTip);
        this.quickPanel = new JPanel(this.flowLayoutCenter);
        this.quickPanel.add(this.buttonGoToStart);
        this.quickPanel.add(this.buttonGoToMark1);
        this.quickPanel.add(this.buttonGoToWindow);
        this.quickPanel.add(this.buttonGoToMark2);
        this.quickPanel.add(this.buttonGoToEnd);
        this.quickPanel.add(new JLabel(" "));
        this.quickPanel.add(this.buttonZoomMin);
        this.quickPanel.add(this.buttonZoomMinus);
        this.quickPanel.add(this.buttonZoomPlus);
        this.quickPanel.add(this.buttonZoomMax);
        this.quickPanel.add(this.syncLabel);
        this.quickPanel.add(this.boxSyncZoom);
        this.quickPanel.add(this.boxSyncMarks);
        this.setLayout(new BorderLayout());
        this.add((Component)this.quickPanel, "Last");
        this.buttonGoToStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickPanel.this.toDoOnAction("Start");
            }
        });
        this.buttonGoToEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickPanel.this.toDoOnAction("End");
            }
        });
        this.buttonGoToMark1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickPanel.this.toDoOnAction("Mark1");
            }
        });
        this.buttonGoToWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickPanel.this.toDoOnAction("Window");
            }
        });
        this.buttonGoToMark2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickPanel.this.toDoOnAction("Mark2");
            }
        });
        this.buttonZoomPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickPanel.this.toDoOnAction("ZoomIn");
            }
        });
        this.buttonZoomMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickPanel.this.toDoOnAction("ZoomOut");
            }
        });
        this.buttonZoomMax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickPanel.this.toDoOnAction("ToMax");
            }
        });
        this.buttonZoomMin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickPanel.this.toDoOnAction("ToMin");
            }
        });
        this.boxSyncZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickPanel.this.parentPanel.getOtherPanel().getQuickPanel().setZoomSync(QuickPanel.this.boxSyncZoom.isSelected());
                if (QuickPanel.this.boxSyncZoom.isSelected()) {
                    QuickPanel.this.parentPanel.getOtherPanel().getZoomPanPanel().setSliderValue(QuickPanel.this.parentPanel.getZoomPanPanel().getSliderValue());
                    QuickPanel.this.parentPanel.getOtherPanel().getZoomPanPanel().setScrollValue(QuickPanel.this.parentPanel.getZoomPanPanel().getScrollValue());
                }
            }
        });
        this.boxSyncMarks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickPanel.this.parentPanel.getOtherPanel().getQuickPanel().setMarksSynced(QuickPanel.this.boxSyncMarks.isSelected());
                QuickPanel.this.parentPanel.getOtherPanel().getInputOrDecayPanel().setMark1Samples(QuickPanel.this.parentPanel.getInputOrDecayPanel().getMark1Samples());
                QuickPanel.this.parentPanel.getOtherPanel().getInputOrDecayPanel().setMark2Samples(QuickPanel.this.parentPanel.getInputOrDecayPanel().getMark2Samples());
                QuickPanel.this.parentPanel.getOtherPanel().getInputOrDecayPanel().markMovedActions();
                QuickPanel.this.parentPanel.getOtherPanel().getInputOrDecayPanel().repaint();
            }
        });
    }

    private void toDoOnAction(String button) {
        for (QuickButtonListener zpl : this.listeners) {
            zpl.quickEvent(button);
        }
    }

    void addListener(QuickButtonListener l) {
        this.listeners.add(l);
    }

    public boolean isZoomSynced() {
        return this.boxSyncZoom.isSelected();
    }

    public void setZoomSync(boolean z) {
        this.boxSyncZoom.setSelected(z);
    }

    public boolean isMarkSynced() {
        return this.boxSyncMarks.isSelected();
    }

    public void setMarksSynced(boolean m) {
        this.boxSyncMarks.setSelected(m);
    }

    static interface QuickButtonListener {
        public void quickEvent(String var1);
    }
}

