/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;

class FileInfo
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String buffer;
    private String h1 = "<h1 style=\"margin-bottom:0px\">";
    private String h2 = "<h2 style=\"margin-bottom:0px\">";
    private String file;
    private String content = " ";
    private JButton exportButton = new JButton("Export");
    private String exportButtonTip = "Export report to an html file.";
    private JButton printButton = new JButton("Print");
    private String printButtonTip = "Print the summary report. Note the number of pages is not available in the print dialog.";
    private JButton closeButton = new JButton("Close");
    private String closeButtonTip = "Close the summary.";
    private FlowLayout flowLayoutCenter = new FlowLayout(1);
    private String currentExportDir = "";
    private BufferedWriter outBuffer = null;
    private String newOverwriteDialog = "New output file already exists. Do you want to overwrite it?";
    private JFrame infoFrame = this;
    private JEditorPane htmlPane = new JEditorPane("text/html", this.buffer);
    private JScrollPane infoScrollPane;

    public FileInfo() {
        this.htmlPane.setEditable(false);
        this.infoScrollPane = new JScrollPane(this.htmlPane);
        this.printButton.setToolTipText(this.printButtonTip);
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent print) {
                try {
                    FileInfo.this.htmlPane.print(null, new MessageFormat("Page - {0}"));
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                }
            }
        });
        this.exportButton.setToolTipText(this.exportButtonTip);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newOverwriteSelection;
                if (FileInfo.this.currentExportDir == "") {
                    FileInfo.this.currentExportDir = System.getProperty("user.home");
                }
                JFileChooser expChooser = new JFileChooser(FileInfo.this.currentExportDir);
                expChooser.setDialogTitle("Save Report to HTML File");
                expChooser.setMultiSelectionEnabled(false);
                expChooser.setFileSelectionMode(2);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("HTML files", "htm", "html");
                expChooser.setFileFilter(filter);
                expChooser.setFileHidingEnabled(true);
                int expChoice = expChooser.showSaveDialog(FileInfo.this.infoFrame);
                if (expChoice != 0) {
                    return;
                }
                File saveFile = expChooser.getSelectedFile();
                FileInfo.this.currentExportDir = saveFile.getParent();
                if (saveFile.exists() && (newOverwriteSelection = JOptionPane.showConfirmDialog(FileInfo.this.infoFrame, FileInfo.this.newOverwriteDialog, "That File Already Exists - overwrite it?", 0, 3)) == 1) {
                    return;
                }
                try {
                    saveFile.createNewFile();
                    String path = saveFile.getAbsolutePath();
                    BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8));
                    FileInfo.this.outBuffer = new BufferedWriter(outWriter);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(FileInfo.this.infoFrame, "Output File: IO Exception opening file for write" + ex.getMessage());
                    return;
                }
                try {
                    FileInfo.this.outBuffer.write(FileInfo.this.buffer);
                    FileInfo.this.outBuffer.flush();
                    FileInfo.this.outBuffer.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.closeButton.setToolTipText(this.closeButtonTip);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent close) {
                FileInfo.this.infoFrame.dispose();
            }
        });
        JPanel buttonPanel = new JPanel(this.flowLayoutCenter);
        buttonPanel.add(this.exportButton);
        buttonPanel.add(this.printButton);
        buttonPanel.add(this.closeButton);
        Box overallPanel = Box.createVerticalBox();
        overallPanel.add(this.infoScrollPane);
        overallPanel.add(buttonPanel);
        this.add(overallPanel);
        this.pack();
        this.setVisible(false);
        this.setSize(600, 600);
    }

    void showWindow() {
        this.buffer = "";
        this.appendString("<html><head><title>Fourier Round Trip</title>");
        this.appendString("<style>table {width: 100%;}table td {word-wrap: break-word;</style>");
        this.appendString("</head>");
        this.appendString(this.h1 + "Input File Info</h1>");
        this.appendString(this.h2 + "File: " + this.file + "</h2>");
        this.appendString("<table  border=\"1\"");
        this.appendString("<tr> <th>Name</th> <th>Contents</th> <th>Units / Flags</th> </tr>");
        this.appendString(this.content);
        this.appendString("</table></body></html>)");
        this.htmlPane.setText(this.buffer);
        this.htmlPane.setCaretPosition(0);
        this.infoFrame.setVisible(true);
        this.infoFrame.revalidate();
        this.infoFrame.repaint();
    }

    private void appendString(String str) {
        this.buffer = this.buffer + str + "\n";
    }

    public void add(String c1, String c2, String c3) {
        this.content = String.valueOf(this.content) + "<tr>";
        this.content = this.content + "<td>" + c1 + "<td>" + c2 + "<td>" + c3;
        this.content = String.valueOf(this.content) + "</tr>\n";
    }

    public void addFilename(String filename) {
        this.file = filename;
        this.infoFrame.setTitle("File Metadata of " + this.file);
    }

    public String getFilename() {
        return this.file;
    }
}

