/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import roundtrip.AnalysisParameters;
import roundtrip.Complex;
import roundtrip.FourierTransform;
import roundtrip.SpectrumBinList;

class FTrunner {
    private FourierTransform[] runningTransforms;
    private Thread[] threads;
    private Complex[][] part1Result;
    private Complex[] part1Avg;
    private double[] windowedWave;
    private int expandedWindowWidth;
    private int nFreqs = 0;
    private SpectrumBinList[] freqResults;
    private double overallSTFTmaxAmp;
    private AnalysisParameters analysisParams;
    private int startSample;
    private int frameSize;
    private int nFrames;
    private int stepSize;
    private JProgressBar[] ftProgressBars;
    private FourierTransform.FTtype dFTfFTcZT;
    private AnalysisParameters.FTcombine combineType;
    private AtomicInteger stft1NextFrame;
    private AtomicInteger stft2NextFrame;
    private RunFT task;
    private boolean cancelled = false;

    FTrunner(AnalysisParameters caller, int startSampleIn, int frameSizeIn, int nFramesIn, int stepSizeIn, JProgressBar[] progressBarsIn, FourierTransform.FTtype dORfIn, AnalysisParameters.FTcombine ftTypeIn) {
        this.analysisParams = caller;
        this.startSample = startSampleIn;
        this.frameSize = frameSizeIn;
        this.nFrames = nFramesIn;
        this.stepSize = stepSizeIn;
        this.ftProgressBars = progressBarsIn;
        this.dFTfFTcZT = dORfIn;
        this.combineType = ftTypeIn;
        this.stft1NextFrame = new AtomicInteger(0);
        this.stft2NextFrame = new AtomicInteger(0);
        this.runningTransforms = new FourierTransform[this.nFrames];
        this.threads = new Thread[this.ftProgressBars.length];
        this.freqResults = new SpectrumBinList[this.nFrames];
        switch (this.combineType) {
            case FTsingle: {
                this.freqResults[0] = new SpectrumBinList();
                break;
            }
            case FTaveraged: {
                this.freqResults[0] = new SpectrumBinList();
                break;
            }
            case STFT: {
                int i = 0;
                while (i < this.nFrames) {
                    this.freqResults[i] = new SpectrumBinList();
                    ++i;
                }
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.analysisParams, "Unknown FT type in doTransfrom()");
            }
        }
        this.task = new RunFT();
        this.task.execute();
    }

    public int getFFTexpandedSize() {
        return this.expandedWindowWidth;
    }

    public double[] getWindowedWave() {
        return this.windowedWave;
    }

    public SpectrumBinList[] getFTResult() {
        return this.freqResults;
    }

    public double getOverallSTFTmaxAmp() {
        return this.overallSTFTmaxAmp;
    }

    public void cancel() {
        this.cancelled = true;
        int i = 0;
        while (i < this.runningTransforms.length) {
            if (this.runningTransforms[i] != null) {
                this.runningTransforms[i].cancel();
            }
            ++i;
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private class FT1thread
    implements Runnable {
        int processorIdx;

        public FT1thread(int processorIdxIn) {
            this.processorIdx = processorIdxIn;
        }

        @Override
        public void run() {
            int nextFrame = FTrunner.this.stft1NextFrame.getAndIncrement();
            while (nextFrame < FTrunner.this.nFrames) {
                FourierTransform ourFT;
                int offset = nextFrame * FTrunner.this.stepSize;
                int nextSample = FTrunner.this.startSample + offset;
                FTrunner.this.runningTransforms[nextFrame] = ourFT = new FourierTransform(FTrunner.this.analysisParams, FTrunner.this.ftProgressBars, this.processorIdx, nextFrame, FTrunner.this.nFrames, nextSample, FTrunner.this.frameSize, FTrunner.this.dFTfFTcZT);
                switch (FTrunner.this.dFTfFTcZT) {
                    case DFT: {
                        FTrunner.this.expandedWindowWidth = FTrunner.this.frameSize + FTrunner.this.analysisParams.getZeroPadding();
                        FTrunner.this.nFreqs = FTrunner.this.expandedWindowWidth / 2 + 1;
                        FTrunner.this.part1Result[nextFrame] = ourFT.functionDFTpart1();
                        if (FTrunner.this.part1Result[nextFrame] != null) break;
                        return;
                    }
                    case FFT: {
                        FTrunner.this.part1Result[nextFrame] = ourFT.functionFFTpart1(ourFT.getFinalInputComplex());
                        if (FTrunner.this.part1Result[nextFrame] == null) {
                            return;
                        }
                        FTrunner.this.expandedWindowWidth = ourFT.getExpandedWindowWidth();
                        FTrunner.this.nFreqs = FTrunner.this.expandedWindowWidth / 2 + 1;
                        break;
                    }
                    case CZT: {
                        double t0 = 0.0;
                        double dT = 1.0 / (double)FTrunner.this.analysisParams.getAnalysisWindow().getFtInputPanel().getSampleRate();
                        double f0 = FTrunner.this.analysisParams.getCZTf0();
                        double dF = FTrunner.this.analysisParams.getCZTdeltaF();
                        int nF = FTrunner.this.analysisParams.getCZTnF();
                        FTrunner.this.part1Result[nextFrame] = ourFT.functionCZTpart1(ourFT.getFinalInputComplex(), t0, dT, f0, dF, nF);
                        if (FTrunner.this.part1Result[nextFrame] == null) {
                            return;
                        }
                        FTrunner.this.expandedWindowWidth = ourFT.getExpandedWindowWidth();
                        FTrunner.this.nFreqs = ourFT.getCztLength();
                        break;
                    }
                    default: {
                        JOptionPane.showMessageDialog(FTrunner.this.analysisParams, "Unknown FT type in FTrunner.FT1Thread()");
                    }
                }
                nextFrame = FTrunner.this.stft1NextFrame.getAndIncrement();
                if (!FTrunner.this.cancelled) continue;
                return;
            }
        }
    }

    private class FT2thread
    implements Runnable {
        @Override
        public void run() {
            int nextFrame = FTrunner.this.stft2NextFrame.getAndIncrement();
            while (nextFrame < FTrunner.this.nFrames) {
                FTrunner.this.freqResults[nextFrame] = FTrunner.this.runningTransforms[nextFrame].ftPart2(FTrunner.this.part1Result[nextFrame], FTrunner.this.nFreqs);
                nextFrame = FTrunner.this.stft2NextFrame.getAndIncrement();
            }
        }
    }

    private class RunFT
    extends SwingWorker<SpectrumBinList[], Integer> {
        private RunFT() {
        }

        @Override
        public SpectrumBinList[] doInBackground() throws Exception {
            FTrunner.this.cancelled = false;
            switch (FTrunner.this.combineType) {
                case FTsingle: {
                    FourierTransform ourFT;
                    FTrunner.this.part1Result = new Complex[1][];
                    FTrunner.this.runningTransforms[0] = ourFT = new FourierTransform(FTrunner.this.analysisParams, FTrunner.this.ftProgressBars, 0, 0, 1, FTrunner.this.startSample, FTrunner.this.frameSize, FTrunner.this.dFTfFTcZT);
                    switch (FTrunner.this.dFTfFTcZT) {
                        case DFT: {
                            FTrunner.this.expandedWindowWidth = FTrunner.this.frameSize + FTrunner.this.analysisParams.getZeroPadding();
                            FTrunner.this.nFreqs = FTrunner.this.expandedWindowWidth / 2 + 1;
                            FTrunner.this.part1Result[0] = ourFT.functionDFTpart1();
                            break;
                        }
                        case FFT: {
                            FTrunner.this.part1Result[0] = ourFT.functionFFTpart1(ourFT.getFinalInputComplex());
                            if (FTrunner.this.part1Result[0] == null) {
                                JOptionPane.showMessageDialog(FTrunner.this.analysisParams, "FFT failed in FTrunner.RunFT");
                                return null;
                            }
                            FTrunner.this.expandedWindowWidth = ourFT.getExpandedWindowWidth();
                            FTrunner.this.nFreqs = FTrunner.this.expandedWindowWidth / 2 + 1;
                            break;
                        }
                        case CZT: {
                            double t0 = 0.0;
                            double dT = 1.0 / (double)FTrunner.this.analysisParams.getAnalysisWindow().getFtInputPanel().getSampleRate();
                            double f0 = FTrunner.this.analysisParams.getCZTf0();
                            double dF = FTrunner.this.analysisParams.getCZTdeltaF();
                            int nF = FTrunner.this.analysisParams.getCZTnF();
                            FTrunner.this.part1Result[0] = ourFT.functionCZTpart1(ourFT.getFinalInputComplex(), t0, dT, f0, dF, nF);
                            if (FTrunner.this.part1Result[0] == null) {
                                JOptionPane.showMessageDialog(FTrunner.this.analysisParams, "CZT failed in FTrunner.RunFT");
                                return null;
                            }
                            FTrunner.this.expandedWindowWidth = ourFT.getExpandedWindowWidth();
                            FTrunner.this.nFreqs = ourFT.getCztLength();
                            break;
                        }
                        default: {
                            JOptionPane.showMessageDialog(FTrunner.this.analysisParams, "Invalid DFT/FFT/CZT type in FTrunner.RunFT");
                            return null;
                        }
                    }
                    FTrunner.this.freqResults[0] = ourFT.ftPart2(FTrunner.this.part1Result[0], FTrunner.this.nFreqs);
                    FTrunner.this.windowedWave = ourFT.getWindowedWave();
                    FTrunner.this.analysisParams.ftDoneActions();
                    break;
                }
                case FTaveraged: 
                case STFT: {
                    Thread anFT2;
                    FTrunner.this.part1Result = new Complex[FTrunner.this.nFrames][];
                    int i = 0;
                    while (i < FTrunner.this.ftProgressBars.length) {
                        FTrunner.this.threads[i] = anFT2 = new Thread(new FT1thread(i));
                        anFT2.start();
                        ++i;
                    }
                    i = 0;
                    while (i < FTrunner.this.ftProgressBars.length) {
                        try {
                            FTrunner.this.threads[i].join();
                        }
                        catch (InterruptedException anFT2) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (FTrunner.this.cancelled) {
                        return null;
                    }
                    if (FTrunner.this.combineType == AnalysisParameters.FTcombine.FTaveraged) {
                        FTrunner.this.part1Avg = new Complex[FTrunner.this.nFreqs];
                        i = 0;
                        while (i < FTrunner.this.nFreqs) {
                            double realSum = 0.0;
                            double imagSum = 0.0;
                            int j = 0;
                            while (j < FTrunner.this.nFrames) {
                                if (FTrunner.this.cancelled) {
                                    FTrunner.this.freqResults = null;
                                    return null;
                                }
                                realSum += FTrunner.this.part1Result[j][i].getReal();
                                imagSum += FTrunner.this.part1Result[j][i].getImag();
                                ++j;
                            }
                            FTrunner.this.part1Avg[i] = new Complex(realSum / (double)FTrunner.this.nFrames, imagSum / (double)FTrunner.this.nFrames);
                            ++i;
                        }
                        FTrunner.this.freqResults[0] = new FourierTransform(FTrunner.this.analysisParams, FTrunner.this.ftProgressBars, 0, 0, 1, 0, FTrunner.this.frameSize, FTrunner.this.dFTfFTcZT).ftPart2(FTrunner.this.part1Avg, FTrunner.this.nFreqs);
                    } else {
                        i = 0;
                        while (i < FTrunner.this.ftProgressBars.length) {
                            FTrunner.this.threads[i] = anFT2 = new Thread(new FT2thread());
                            anFT2.start();
                            ++i;
                        }
                        i = 0;
                        while (i < FTrunner.this.ftProgressBars.length) {
                            try {
                                FTrunner.this.threads[i].join();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ++i;
                        }
                        if (FTrunner.this.cancelled) {
                            FTrunner.this.freqResults = null;
                            return null;
                        }
                        FTrunner.this.overallSTFTmaxAmp = Double.MIN_VALUE;
                        i = 0;
                        while (i < FTrunner.this.nFrames) {
                            FTrunner.this.overallSTFTmaxAmp = Math.max(FTrunner.this.overallSTFTmaxAmp, FTrunner.this.freqResults[i].getMaxAmp());
                            ++i;
                        }
                    }
                    FTrunner.this.windowedWave = FTrunner.this.runningTransforms[0].getWindowedWave();
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(FTrunner.this.analysisParams, "Unknown FT type in FTrunner.doTransform()");
                }
            }
            return FTrunner.this.freqResults;
        }

        @Override
        public void done() {
            try {
                if (!FTrunner.this.cancelled) {
                    this.get();
                }
                FTrunner.this.analysisParams.ftDoneActions();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

