/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import roundtrip.FRTmain;
import roundtrip.SpectrumBinList;
import roundtrip.SynthesisWindow;
import roundtrip.Utils;

class ComponentPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FRTmain ourGUI;
    private SynthesisWindow synthesis;

    ComponentPanel(FRTmain mainGUI, SynthesisWindow s) {
        this.ourGUI = mainGUI;
        this.synthesis = s;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        double scale = this.synthesis.getScale();
        SpectrumBinList ourHarmonics = this.ourGUI.getSynthParams().getHarmonicList();
        int numHarmonics = ourHarmonics.getSize();
        int yComponentBase = this.getHeight() / 2;
        int xMargin = Utils.getXmarginL();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.ourGUI.getSettings().getSynthesisBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setStroke(new BasicStroke(1.0f));
        int xComponentWidth = this.getWidth() / 2 - xMargin * 2;
        int xComponentBase = xMargin;
        int xSpectrumBase = this.getWidth() / 2 + xMargin;
        int ySpectrumBase = yComponentBase;
        if (this.ourGUI.getSynthParams().getDisplayComponents()) {
            g2d.setColor(this.ourGUI.getSettings().getAxisColor());
            g2d.drawLine(xComponentBase, yComponentBase, xComponentBase + xComponentWidth, yComponentBase);
            Utils.calibrateX(g2d, (double)xComponentWidth / 360.0, 0.0, 360.0, xComponentBase, yComponentBase, Utils.AxisOmit0.KEEP0, Utils.AxisOmitNeg.OMIT_NEG, 4, Utils.getAngleLabel());
            Utils.calibrateY(g2d, scale, this.synthesis.getWave().getMaxAmplitude(), xComponentBase, yComponentBase, xComponentWidth, Utils.AxisOmit0.KEEP0, Utils.AxisOmitNeg.KEEP_NEG, Utils.AxisExtendYticks.No_ExtendYticks, 4, Utils.getAmplitudeLabel());
            g2d.setColor(this.ourGUI.getSettings().getPlotColor());
            int componentX2 = 0;
            int componentY2 = 0;
            double freq = 1.0;
            double amp = 1.0;
            double phase = 0.0;
            double angle = 0.0;
            double dAngle = 360.0 / (double)xComponentWidth;
            double maxFreq = 0.0;
            int j = 0;
            while (j < numHarmonics) {
                freq = ourHarmonics.getBinByIndex(j).getFreqFactor();
                maxFreq = Math.max(maxFreq, freq);
                amp = ourHarmonics.getBinByIndex(j).getAmplitude();
                phase = ourHarmonics.getBinByIndex(j).getPhase();
                int componentX1 = xComponentBase;
                int componentY1 = yComponentBase;
                angle = 0.0;
                int i = 0;
                while (i <= xComponentWidth) {
                    double componentResultY = freq == 0.0 ? amp : Math.sin(Math.toRadians(angle * freq + phase)) * amp;
                    componentX2 = xComponentBase + i;
                    componentY2 = yComponentBase - (int)Math.round(componentResultY * scale);
                    if (i > 0) {
                        g2d.drawLine(componentX1, componentY1, componentX2, componentY2);
                    }
                    componentX1 = componentX2;
                    componentY1 = componentY2;
                    angle += dAngle;
                    ++i;
                }
                ++j;
            }
        }
        if (this.ourGUI.getSynthParams().getDisplaySpectrum()) {
            int spectrumWidth = this.getWidth() / 2 - xMargin * 2;
            this.plotSpectrum(g2d, spectrumWidth, xSpectrumBase, ySpectrumBase, ourHarmonics, scale, this.synthesis.getWave().getMaxAmplitude());
        }
    }

    private void plotSpectrum(Graphics2D g2d, int widthPx, int xBase, int yBase, SpectrumBinList harmonics, double scale, double maxAmp) {
        g2d.setColor(this.ourGUI.getSettings().getAxisColor());
        g2d.setFont(Utils.getAxisFont());
        g2d.drawLine(xBase, yBase, xBase + widthPx, yBase);
        int nFreqs = harmonics.getSize();
        double minFreq = Math.floor(harmonics.getMinFreq());
        if (minFreq > 0.0) {
            minFreq = 0.0;
        }
        double maxFreq = Math.ceil(harmonics.getMaxFreq());
        double pixelsPerHz = (double)widthPx / (maxFreq - minFreq);
        double xBase2 = (double)xBase - minFreq * pixelsPerHz;
        int xPos = 0;
        int nXticks = nFreqs;
        if (nFreqs > 10) {
            nXticks = 5;
        }
        Utils.calibrateX(g2d, (double)widthPx / harmonics.getBinByIndex(harmonics.getSize() - 1).getFreqFactor(), 0.0, harmonics.getBinByIndex(harmonics.getSize() - 1).getFreqFactor(), xBase, yBase, Utils.AxisOmit0.KEEP0, Utils.AxisOmitNeg.OMIT_NEG, nXticks, "Frequency");
        Utils.calibrateY(g2d, scale, maxAmp, (int)Math.round(xBase2), yBase, widthPx, Utils.AxisOmit0.OMIT0, Utils.AxisOmitNeg.OMIT_NEG, Utils.AxisExtendYticks.No_ExtendYticks, 4, null);
        g2d.setColor(this.ourGUI.getSettings().getPlotColor());
        xPos = (int)Math.round(xBase2);
        int i = 0;
        while (i < nFreqs) {
            xPos = (int)Math.round(xBase2 + harmonics.getBinByIndex(i).getFreqFactor() * pixelsPerHz);
            double ampl = harmonics.getBinByIndex(i).getAmplitude();
            double result = ampl * scale;
            int spectrumY2 = yBase - (int)Math.round(result);
            g2d.drawLine(xPos, yBase, xPos, spectrumY2);
            ++i;
        }
    }
}

