/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

class Complex {
    private double real;
    private double imag;

    Complex(double r, double i) {
        this.real = r;
        this.imag = i;
    }

    public double getReal() {
        return this.real;
    }

    public double getImag() {
        return this.imag;
    }

    public Complex add(Complex a) {
        double aR = this.real + a.getReal();
        double aI = this.imag + a.getImag();
        return new Complex(aR, aI);
    }

    public Complex multiply(Complex m) {
        double mR = this.real * m.getReal() - this.imag * m.getImag();
        double mI = this.real * m.getImag() + this.imag * m.getReal();
        return new Complex(mR, mI);
    }

    public Complex conjugate() {
        return new Complex(this.real, -this.imag);
    }

    public Complex scalarDivide(int d) {
        return new Complex(this.real / (double)d, this.imag / (double)d);
    }
}

