/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.FormatterClosedException;
import java.util.IllegalFormatException;
import java.util.Locale;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import roundtrip.AnalysisWindow;
import roundtrip.FRTmain;
import roundtrip.FTrunner;
import roundtrip.FileInfo;
import roundtrip.FourierTransform;
import roundtrip.RawWavFile;
import roundtrip.SpectrumBin;
import roundtrip.SpectrumBinList;
import roundtrip.Temperaments;
import roundtrip.Utils;
import roundtrip.WindowFunction;
import roundtrip.WindowFunctionWindow;

class AnalysisParameters
extends JPanel {
    private static final long serialVersionUID = 1L;
    private LineBorder panelsBorder;
    private FlowLayout flowLayoutLeft = new FlowLayout(0);
    private NumberFormat decimalFormat;
    private NumberFormat genFormat = NumberFormat.getInstance(Locale.getDefault());
    private JPanel analysisParamsFrame;
    private AnalysisParameters analysisParamsObject;
    private FRTmain mainGUI;
    private AnalysisWindow analysis;
    private FileInfo fileInfoWindow;
    private String myFilePath = "";
    private String actualFilePath = "";
    private String currentFileDir = "";
    private long fileSize;
    private File fileIn;
    private BufferedWriter outBuffer = null;
    private RawWavFile rawWave;
    private JLabel channelLabel = new JLabel("Channel");
    private JRadioButton channelLeftButton = new JRadioButton("Left");
    private JRadioButton channelRightButton = new JRadioButton("Right");
    private String channelTip = "Select the stereo channel to read.";
    private JButton buttonOpenFile = new JButton("Open");
    private String openFileTip = "Open a new wave file and read the selected channel.";
    private JButton buttonReread = new JButton("Reread");
    private String rereadTip = "Reread the file with the selected channel";
    private JButton buttonShowInfo = new JButton("Info");
    private String showInfoTip = "Bring up a window with information about the file.";
    private JCheckBox showInput = new JCheckBox("Input");
    private String showInputTip = "Show or hide the Input panel.";
    private JLabel showInputSeparator = new JLabel("-");
    private JCheckBox decayShowBox = new JCheckBox("Decay");
    private String showAvgBoxTip = "Check to show the average and decay analysis.";
    private JCheckBox ftShowWindow = new JCheckBox("Window");
    private String ftShowWindowTip = "Show the window boundaries - if none of window, original and final are selected, the input wave will not be shown";
    private JCheckBox ftShowOriginal = new JCheckBox("Original");
    private String ftShowOriginalTip = "Show the original wave - if none of window, original and final are selected, the input wave will not be shown";
    private JCheckBox ftShowFinal = new JCheckBox("Final");
    private String ftShowFinalTip = "show the final wave after applying the selected window - if none of window, original and final are selected, the input wave will not be shown";
    private JCheckBox ftShowSpectrum = new JCheckBox("Spectrum");
    private String ftShowSpectrumTip = "Show the spectrum diagram";
    private JCheckBox ftShowPhase = new JCheckBox("Phase");
    private String ftShowPhaseTip = "Show Phase diagram";
    private JCheckBox showNotes = new JCheckBox("Notes -");
    private String showNotesTip = "Show the musical notes in the spectrum";
    private JComboBox<String> temperamentBox = new JComboBox();
    private String temperamentTip = "Select the temperament in which to show the frequencies of the notes";
    private JLabel aLabel = new JLabel("A:");
    private JTextField aField = new JTextField();
    private String aTip = "Set the frequency of A for the notes";
    private JLabel aHzLabel = new JLabel("Hz");
    private JCheckBox showHarmonics = new JCheckBox("Harmonics");
    private String showHarmonicsTip = "Check to show the harmonics in the spectrum";
    private JLabel harmonicsFromLabel = new JLabel("from");
    private String harmonicsFromTip = "Set the frequency of the first harmonic (fundamental) in Hz";
    private JTextField harmonicsFromField = new JTextField();
    private JLabel harmonicsHzLabel = new JLabel("Hz");
    private static final double defaultA = 440.0;
    private double freqA = 440.0;
    private static final double defaultFundamental = 256.0;
    private double fundamental = 256.0;
    private JLabel playFromLabel = new JLabel("From");
    private JRadioButton fromStartButton = new JRadioButton("Start");
    private String fromStartButtonTip = "Play from start of file";
    private JRadioButton fromMark1Button = new JRadioButton("Mark1");
    private String fromMark1ButtonTip = "Play from Mark1";
    private JRadioButton fromMark2Button = new JRadioButton("Mark2");
    private String fromMark2ButtonTip = "Play from Mark2";
    private JLabel playToLabel = new JLabel("To");
    private JRadioButton toEndButton = new JRadioButton("End");
    private String toEndButtonTip = "Play to end of file";
    private JRadioButton toMark1Button = new JRadioButton("Mark1");
    private String toMark1ButtonTip = "Play to Mark1";
    private JRadioButton toMark2Button = new JRadioButton("Mark2");
    private String toMark2ButtonTip = "Play to Mark2";
    private JCheckBox playLoopBox = new JCheckBox("Loop");
    private JLabel playLoopTimes = new JLabel("times");
    private String playLoopTip = "Play selected range continually the given number of times.";
    private String playDurationTip = "Set the number of times to play the loop";
    private SpinnerNumberModel playDurationModel = new SpinnerNumberModel(10, 1, 1000000, 1);
    private JSpinner playDurationSpinner = new JSpinner(this.playDurationModel);
    private JLabel volumeLabel = new JLabel("Volume:");
    private JSlider volumeSlider = new JSlider(0, 100, 10);
    private String volumeSliderTip = "Use the slider to change the sound volume.";
    private JButton buttonPlay = new JButton("\u25b6");
    private String buttonPlayTip = "Play the sound";
    private JButton buttonStop = new JButton("\u23f9");
    private String buttonStopTip = "Stop the sound";
    private JLabel decaySpanLabel = new JLabel("Span");
    private SpinnerNumberModel avgSpanModel = new SpinnerNumberModel(1, 1, 100001, 2);
    private JSpinner decaySpanSpinner = new JSpinner(this.avgSpanModel);
    private String avgSpanTip = "Set the number of samples over which to average the input wave. Must be odd.";
    private JRadioButton decayAvgButton = new JRadioButton("Avg.");
    private String avgAvgButtonTip = "Take the average of the samples in the span";
    private JRadioButton decayRmsButton = new JRadioButton("RMS");
    private String avgRmsButtonTip = "Take the Root Mean Square of the samples in the span";
    private JRadioButton decayLinButton = new JRadioButton("Lin");
    private JRadioButton decayLogRelButton = new JRadioButton("Log Rel.");
    private String inLinTip = "Linear scaling for the input file.";
    private String inLogRelTip = "Logarithmic scaling relative to the maximum amplitude for the input file.";
    private JButton decayAnalyseButton = new JButton("Do Decay");
    private String decayAnalyseTip = "Click to calculate decay rate of the input wave between the marks.";
    private ProgressMonitor decayProgress;
    private DecayWorker decayWorker;
    private int soFar;
    private JLabel zeroPadLabel = new JLabel("Zero pad");
    private SpinnerNumberModel zeroPadModel = new SpinnerNumberModel(0, 0, 100000, 1);
    private JSpinner zeroPadSpinner = new JSpinner(this.zeroPadModel);
    private String zeroPadTip = "Set the number of zero amplitude samples to add to the end of the window.";
    private String[] windowNames = new String[]{"Rectangle (none)", "Bartlett", "Welch", "Hamming", "Hann", "Blackman", "Exact Blackman", "Blackman-Harris-4", "Blackman-Harris-7", "Nuttall-3", "Nuttall-3a", "Nuttall-3b", "Nuttall-4", "Nuttall-4a", "Nuttall-4b", "Nuttall-4c", "Flat-Top-Fast-3", "Flat-Top-Fast-4", "Flat-Top-Fast-5", "Flat-Top-Min.Lobe-3", "Flat-Top-Min.Lobe-4", "Flat-Top-Min.Lobe-5", "Flat-Top-NI", "Flat-Top-HP", "Flat-Top-SR785", "Flat-Top-HFT70", "Flat-Top-HFT95", "Flat-Top-HFT90D", "Flat-Top-HFT116D", "Flat-Top-HFT144D", "Flat-Top-HFT169D", "Flat-Top-HFT196D", "Flat-Top-HFT223D", "Flat-Top-HFT248D", "Gaussian", "Kaiser-Bessel", "Tukey", "Exponential"};
    private JLabel functionLabel = new JLabel("Window Function:");
    private JComboBox<String> ftWindowBox = new JComboBox<String>(this.windowNames);
    private String ftWindowBoxTip = "Select the window for smoothing";
    private JLabel ftParameterLabel = new JLabel("none");
    private String ftParameterLabelTip = "Parameter for window function";
    private JTextField ftParameterField = new JTextField();
    private String ftParameterFieldTip = "Parameter for window function";
    private String ftGaussianParameterTip = "The sigma value controls the width of the Gaussian window function";
    private String ftKaiserParameterTip = "The alpha value controls shape of the Kaiser-Bessel window function";
    private String ftTukeyParameterTip = "The alpha value controls the shape of the Tukey window function - 0 = rectangle, 1 = Hann";
    private String ftExponentialParameterTip = "The tau value controls the time constant";
    private JButton ftWindowDetailButton = new JButton("Details");
    private String ftWindowDetailButtonTip = "Show details of the window function in a separate pop-up";
    private JRadioButton dftButton = new JRadioButton("DFT");
    private String dftButtonTip = "Analyse with Discrete Fourier Transform";
    private JRadioButton fftButton = new JRadioButton("FFT");
    private String fftButtonTip = "Analyse with Fast Fourier Transform - Window size will be increased to a power of 2";
    private JRadioButton cztButton = new JRadioButton("CZT");
    private String cztButtonTip = "Analyse with Chirp-Z Transform - set parameters below";
    private JPanel cztPanel = new JPanel(this.flowLayoutLeft);
    private JLabel f0Label = new JLabel("f\u2080");
    private JTextField f0Field = new JTextField(5);
    private String f0Tip = "Enter the starting frequency for the Chirp-Z transform in Hz";
    private JLabel fNLabel = new JLabel("f\u2099");
    private JTextField fMaxField = new JTextField(5);
    private String fMaxtip = "Enter the end frequency for the Chirp-Z transform in Hz";
    private JLabel deltaFLabel = new JLabel("\u0394f");
    private JTextField deltaField = new JTextField(5);
    private String deltaFtip = "Enter the frequency step for the Chirp-Z transform in Hz";
    private JLabel cztStepsLabel = new JLabel("= x steps");
    private String cztStepsTip = "This shows the resulting number of frequency steps";
    private JCheckBox ftFilterDCbox = new JCheckBox("Filter DC");
    private String ftFilterDCTip = "Check to filter out DC before doing Fourier Transform";
    private JRadioButton ftLinButton = new JRadioButton("Lin");
    private String ftLinButtonTip = "Show spectrum on linear amplitude scale";
    private JRadioButton ftLogAbsButton = new JRadioButton("Log FS");
    private String ftLogAbsButtonTip = "Show spectrum on a decibels full scale, i.e. relative to the maximum possible amplitude for the sample size";
    private JRadioButton ftLogRelButton = new JRadioButton("Log Rel.");
    private String ftLogRelButtonTip = "Show the spectrum on a logarithmic dB scale relative to the maximum amplitude of the file";
    private JRadioButton ftSingleButton = new JRadioButton("Single");
    private String ftSingleTip = "Selects a single Fourier Transform (DFT or FFT)";
    private JRadioButton ftAveragedButton = new JRadioButton("Averaged");
    private String ftAveragedtip = "Selects an average of multiple overlapping DFTs or FFTs. Set the number of Frames and the Step between frames";
    private JRadioButton ftStftButton = new JRadioButton("STFT");
    private String ftSftTip = "Selects a Short Time Fourier Transform. Set the number of Frames and the Step between frames";
    private JPanel ftFramesPanel = new JPanel(this.flowLayoutLeft);
    private JLabel nFramesLabel = new JLabel("Frames:");
    private JTextField nFramesField = new JTextField(5);
    private String nFramesTip = "Set the number of analysis frames for averaging or STFT";
    private JLabel stepLabel = new JLabel("Step:");
    private JTextField stepSamplesField = new JTextField(5);
    private String stepTip = "Set the step size, the number of samples between one frame and the next";
    private JLabel durationLabel = new JLabel("");
    private String durationLabelTip = "This shows the overall duration analysed by the averaged or STFT transforms.";
    private JButton buttonAnalyse = new JButton("Do Transform");
    private String analyseTip = "Start the analysis";
    private JButton buttonDFTExport = new JButton("Export");
    private String exportTip = "Export the first n bins as CSV";
    private String newOverwriteDialog = "New output file already exists. Do you want to overwrite it?";
    private JButton buttonToSynth = new JButton("Send to Synthesis");
    private String toSynthTip = "Send the first n bins to the synthesis function";
    private JTextField expToSynthNum = new JTextField(3);
    private JLabel expToSynthNumLabel = new JLabel("No. of Bins");
    private String expToSynthNumTip = "Set the number of bins to export or send to synthesis - 0 includes all.";
    private JScrollPane resultScrollPane;
    private JPanel resultPanel = new JPanel();
    private JButton cancelButton = new JButton("Cancel");
    private String cancelTip = "Cancel the currently running transform.";
    private JTextArea resultArea = new JTextArea();
    private String resultTip = "The result of the Fourier and Decay analyses will be summarised here.";
    private String ftInitialResult = "No Transform done.";
    private String ftCalculatingResult = "Calculating";
    private String ftCancelled = "Transform Cancelled";
    private String ftResultText;
    private String decayInitialResult = "No Average done.";
    private String decayResultText;
    private String avgBtwMarksText;
    private boolean decayRunning;
    private double[] avgWave;
    private double avgWaveAbsMax;
    private double avgBtwMarks;
    private double dBLimit = -100.0;
    private double expLimit;
    private double gradient;
    private double gradientPerSec;
    private double intersect;
    private Temperaments ourTemperaments;
    private boolean resetZoomPan = true;
    private boolean ftRunning;
    private SpectrumBinList[] freqResults;
    private int expToSynthBins = 0;
    private int actualChannel = 0;
    private Clip outClip = null;
    private Thread soundThread = null;
    private boolean soundPlaying;
    private float gainDB;
    private FloatControl gainControl;
    private int cursor = 0;
    private FTrunner ourFTrunner;
    private double[] windowFunction;
    private String functionName;
    private double windowFunctionMax;
    private double ftWindowParameter;
    private double gaussianSigma = 0.5;
    private double kaiserAlpha = 3.0;
    private double tukeyAlpha = 0.5;
    private double exponentialTau = 0.5;
    private WindowFunctionWindow infoWindow;
    private int expandedWindowWidth;
    private long mainStart;
    private JProgressBar[] ftProgressBars;
    private int nUsedProcessors;
    private FourierTransform.FTtype dFTfFTcZT;
    private double cztF0 = 100.0;
    private double cztFmax = 110.0;
    private double cztDeltaF = 1.0;
    private int cztSteps = 100;
    private FTcombine currentFTcombine;
    private SpectrumScale currentSpectrumScale;
    private int nAvailProcessors;
    private int ftStepSamples;
    private int ftNframes = 1;
    private static final int defaultSampleRate = 44000;
    private static final int defaultStepSamples = 50;
    private static final int defaultnFrames = 2;
    private static final int defaultWinSize = 1000;
    private static final double defaultCZTf0 = 100.0;
    private static final double defaultCZTdeltaF = 1.0;
    private static final int defaultCZTnSteps = 100;
    private static final double defaultCZTfMax = 110.0;
    private FocusListener stftFieldListener = new FocusListener(){

        @Override
        public void focusGained(final FocusEvent f) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTextField field = (JTextField)f.getSource();
                    field.selectAll();
                }
            });
        }

        @Override
        public void focusLost(FocusEvent f) {
            if (f.isTemporary()) {
                return;
            }
            JTextField field = (JTextField)f.getSource();
            if (field == AnalysisParameters.this.stepSamplesField) {
                int tmp = 50;
                boolean stepOK = true;
                try {
                    tmp = Integer.parseInt(field.getText());
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "Invalid number in step Samples field");
                    stepOK = false;
                }
                if (stepOK && tmp < 1) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "Step Samples must be at least 1");
                    stepOK = false;
                }
                if (stepOK) {
                    AnalysisParameters.this.ftStepSamples = tmp;
                }
            } else if (field == AnalysisParameters.this.nFramesField) {
                int tmp = 2;
                boolean framesOK = true;
                try {
                    tmp = Integer.parseInt(field.getText());
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "Invalid number in duration Frames field");
                    framesOK = false;
                }
                if (framesOK) {
                    if (tmp < 2) {
                        JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "Frames must be at least 2");
                        framesOK = false;
                    }
                    AnalysisParameters.this.ftNframes = tmp;
                }
            } else {
                JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "Focus listener on non-existent field");
            }
            if (AnalysisParameters.this.analysis != null && AnalysisParameters.this.analysis.getFtInputPanel().getMark1Samples() + (AnalysisParameters.this.ftNframes - 1) * AnalysisParameters.this.ftStepSamples + AnalysisParameters.this.analysis.getFtInputPanel().getWindowSize() > AnalysisParameters.this.rawWave.getFrameLength() - 1) {
                AnalysisParameters.this.ftNframes = (int)(((double)AnalysisParameters.this.rawWave.getFrameLength() - (double)AnalysisParameters.this.analysis.getFtInputPanel().getMark1Samples() - (double)AnalysisParameters.this.analysis.getFtInputPanel().getWindowSize()) / (double)AnalysisParameters.this.ftStepSamples);
                AnalysisParameters.this.nFramesField.setText(String.valueOf(AnalysisParameters.this.ftNframes));
                JOptionPane.showMessageDialog(AnalysisParameters.this.analysisParamsFrame, "The selected frames go beyond the end of the file.\n The number of frames has been reduced to make it fit");
            }
            AnalysisParameters.this.updateDuration();
        }
    };
    private ActionListener decayLogLinButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AnalysisParameters.this.analysis == null) {
                return;
            }
            AnalysisParameters.this.analysis.getDecayInputPanel().setAnalysisIsStale(true);
            AnalysisParameters.this.analysis.repaint();
        }
    };
    private ActionListener ftTypeButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AnalysisParameters.this.dftButton) {
                if (AnalysisParameters.this.dFTfFTcZT != FourierTransform.FTtype.DFT) {
                    AnalysisParameters.this.resetZoomPan = true;
                }
                if (AnalysisParameters.this.dFTfFTcZT == FourierTransform.FTtype.CZT) {
                    AnalysisParameters.this.freqResults = new SpectrumBinList[AnalysisParameters.this.ftNframes];
                    AnalysisParameters.this.freqResults[0] = new SpectrumBinList();
                }
                AnalysisParameters.this.dFTfFTcZT = FourierTransform.FTtype.DFT;
                AnalysisParameters.this.enDisableCZT(false);
            } else if (e.getSource() == AnalysisParameters.this.fftButton) {
                if (AnalysisParameters.this.dFTfFTcZT != FourierTransform.FTtype.FFT) {
                    AnalysisParameters.this.resetZoomPan = true;
                }
                if (AnalysisParameters.this.dFTfFTcZT == FourierTransform.FTtype.CZT) {
                    AnalysisParameters.this.freqResults = new SpectrumBinList[AnalysisParameters.this.ftNframes];
                    AnalysisParameters.this.freqResults[0] = new SpectrumBinList();
                }
                AnalysisParameters.this.dFTfFTcZT = FourierTransform.FTtype.FFT;
                AnalysisParameters.this.enDisableCZT(false);
            } else if (e.getSource() == AnalysisParameters.this.cztButton) {
                if (AnalysisParameters.this.dFTfFTcZT != FourierTransform.FTtype.CZT) {
                    AnalysisParameters.this.resetZoomPan = true;
                }
                if (AnalysisParameters.this.dFTfFTcZT == FourierTransform.FTtype.DFT || AnalysisParameters.this.dFTfFTcZT == FourierTransform.FTtype.FFT) {
                    AnalysisParameters.this.freqResults = new SpectrumBinList[AnalysisParameters.this.ftNframes];
                    AnalysisParameters.this.freqResults[0] = new SpectrumBinList();
                }
                AnalysisParameters.this.dFTfFTcZT = FourierTransform.FTtype.CZT;
                AnalysisParameters.this.enDisableCZT(true);
            } else {
                JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "DDFT/FFT/CZT Type action listener on non-existent field");
                return;
            }
            if (AnalysisParameters.this.analysis != null) {
                AnalysisParameters.this.analysis.getFtInputPanel().setAnalysisIsStale(true);
                AnalysisParameters.this.analysis.repaint();
            }
        }
    };
    private FocusListener cztFieldListener = new FocusListener(){

        @Override
        public void focusGained(final FocusEvent f) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTextField field = (JTextField)f.getSource();
                    field.selectAll();
                }
            });
        }

        @Override
        public void focusLost(FocusEvent f) {
            if (f.isTemporary()) {
                return;
            }
            JTextField field = (JTextField)f.getSource();
            if (field == AnalysisParameters.this.f0Field) {
                boolean f0OK = true;
                Number tmp = 0;
                double tmp2 = 100.0;
                try {
                    tmp = AnalysisParameters.this.genFormat.parse(field.getText());
                }
                catch (Exception n) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "Invalid number in CZT f0");
                    f0OK = false;
                }
                if (f0OK && (tmp2 = tmp.doubleValue()) < 0.0) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "CZT f0 cannot be less than 0");
                    f0OK = false;
                }
                if (f0OK) {
                    AnalysisParameters.this.cztF0 = tmp2;
                }
            } else if (field == AnalysisParameters.this.deltaField) {
                boolean f0OK = true;
                Number tmp = 0;
                double tmp2 = 1.0;
                try {
                    tmp = AnalysisParameters.this.genFormat.parse(field.getText());
                }
                catch (Exception n) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "Invalid number in CZT delta F");
                    f0OK = false;
                }
                if (f0OK && (tmp2 = tmp.doubleValue()) < 0.0) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "CZT delta F cannot be less than 0.0");
                    f0OK = false;
                }
                if (f0OK) {
                    AnalysisParameters.this.cztDeltaF = tmp2;
                }
            } else if (field == AnalysisParameters.this.fMaxField) {
                Number tmp = 0;
                double tmp2 = 110.0;
                boolean nfOK = true;
                try {
                    tmp = AnalysisParameters.this.genFormat.parse(field.getText());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "Invalid number in CZT fN field");
                    nfOK = false;
                }
                if (nfOK) {
                    tmp2 = tmp.doubleValue();
                    if (tmp2 < 0.1) {
                        JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "CZT fN must be at least 0.1");
                        nfOK = false;
                    }
                    if (AnalysisParameters.this.analysis != null && tmp2 > (double)(AnalysisParameters.this.analysis.getFtInputPanel().getSampleRate() / 2)) {
                        JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "The maximum frequency is greater than the Nyquist frequency " + AnalysisParameters.this.analysis.getFtInputPanel().getSampleRate() / 2 + "Hz and would give aliasing.");
                    }
                }
                if (nfOK) {
                    AnalysisParameters.this.cztFmax = tmp2;
                }
            } else {
                JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "Focus listener on non-existent field");
            }
            if (AnalysisParameters.this.cztFmax <= AnalysisParameters.this.cztF0) {
                JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "CZT end frequency must be greater than starting frequency.");
            }
            AnalysisParameters.this.cztSteps = AnalysisParameters.this.calculateCZTsteps();
            AnalysisParameters.this.cztStepsLabel.setText("=" + String.valueOf(AnalysisParameters.this.cztSteps) + " steps");
        }
    };
    private ActionListener ftCombineButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AnalysisParameters.this.ftSingleButton.isSelected()) {
                AnalysisParameters.this.currentFTcombine = FTcombine.FTsingle;
                AnalysisParameters.this.enDisableFrames(false);
            } else if (AnalysisParameters.this.ftAveragedButton.isSelected()) {
                AnalysisParameters.this.currentFTcombine = FTcombine.FTaveraged;
                AnalysisParameters.this.enDisableFrames(true);
            } else {
                AnalysisParameters.this.currentFTcombine = FTcombine.STFT;
                AnalysisParameters.this.enDisableFrames(true);
            }
            if (AnalysisParameters.this.analysis != null) {
                AnalysisParameters.this.analysis.getFtInputPanel().setAnalysisIsStale(true);
                AnalysisParameters.this.analysis.repaint();
            }
        }
    };
    private ActionListener playButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AnalysisParameters.this.playButtonLogic();
        }
    };
    private ActionListener decayAvgRMSListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AnalysisParameters.this.analysis == null) {
                return;
            }
            AnalysisParameters.this.analysis.getDecayInputPanel().setAnalysisIsStale(true);
            AnalysisParameters.this.analysis.repaint();
        }
    };
    private ChangeListener decaySpinnerListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            AnalysisParameters.this.analysis.getDecayInputPanel().setAnalysisIsStale(true);
            AnalysisParameters.this.analysis.repaint();
        }
    };
    private ActionListener ftLogLinButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AnalysisParameters.this.analysis == null) {
                return;
            }
            AnalysisParameters.this.analysis.getFtInputPanel().setAnalysisIsStale(true);
            AnalysisParameters.this.analysis.repaint();
            AnalysisParameters.this.enDisableSendToSynth();
        }
    };
    private ActionListener ftWindowBoxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent a) {
            JComboBox which = (JComboBox)a.getSource();
            switch (AnalysisParameters.this.functionName = (String)which.getSelectedItem()) {
                case "Gaussian": {
                    AnalysisParameters.this.ftParameterLabel.setText("Sigma");
                    AnalysisParameters.this.ftParameterLabel.setToolTipText(AnalysisParameters.this.ftGaussianParameterTip);
                    AnalysisParameters.this.ftParameterLabel.setVisible(true);
                    AnalysisParameters.this.ftParameterField.setText(AnalysisParameters.this.decimalFormat.format(AnalysisParameters.this.gaussianSigma));
                    AnalysisParameters.this.ftParameterField.setToolTipText(AnalysisParameters.this.ftGaussianParameterTip);
                    AnalysisParameters.this.ftParameterField.setVisible(true);
                    break;
                }
                case "Kaiser-Bessel": {
                    AnalysisParameters.this.ftParameterLabel.setText("Alpha");
                    AnalysisParameters.this.ftParameterLabel.setToolTipText(AnalysisParameters.this.ftKaiserParameterTip);
                    AnalysisParameters.this.ftParameterLabel.setVisible(true);
                    AnalysisParameters.this.ftParameterField.setText(AnalysisParameters.this.decimalFormat.format(AnalysisParameters.this.kaiserAlpha));
                    AnalysisParameters.this.ftParameterField.setToolTipText(AnalysisParameters.this.ftKaiserParameterTip);
                    AnalysisParameters.this.ftParameterField.setVisible(true);
                    break;
                }
                case "Tukey": {
                    AnalysisParameters.this.ftParameterLabel.setText("Alpha");
                    AnalysisParameters.this.ftParameterLabel.setToolTipText(AnalysisParameters.this.ftTukeyParameterTip);
                    AnalysisParameters.this.ftParameterLabel.setVisible(true);
                    AnalysisParameters.this.ftParameterField.setText(AnalysisParameters.this.decimalFormat.format(AnalysisParameters.this.tukeyAlpha));
                    AnalysisParameters.this.ftParameterField.setToolTipText(AnalysisParameters.this.ftTukeyParameterTip);
                    AnalysisParameters.this.ftParameterField.setVisible(true);
                    break;
                }
                case "Exponential": {
                    AnalysisParameters.this.ftParameterLabel.setText("Tau");
                    AnalysisParameters.this.ftParameterLabel.setToolTipText(AnalysisParameters.this.ftExponentialParameterTip);
                    AnalysisParameters.this.ftParameterLabel.setVisible(true);
                    AnalysisParameters.this.ftParameterField.setText(AnalysisParameters.this.decimalFormat.format(AnalysisParameters.this.exponentialTau));
                    AnalysisParameters.this.ftParameterField.setToolTipText(AnalysisParameters.this.ftExponentialParameterTip);
                    AnalysisParameters.this.ftParameterField.setVisible(true);
                    break;
                }
                default: {
                    AnalysisParameters.this.ftParameterLabel.setText("");
                    AnalysisParameters.this.ftParameterLabel.setVisible(false);
                    AnalysisParameters.this.ftParameterField.setVisible(false);
                }
            }
            double parameter = Utils.parseLocalDouble(AnalysisParameters.this.ftParameterField.getText());
            if (AnalysisParameters.this.validateParameter((String)AnalysisParameters.this.ftWindowBox.getSelectedItem(), parameter, false)) {
                AnalysisParameters.this.ftParameterField.setText(AnalysisParameters.this.decimalFormat.format(parameter));
            }
            which.transferFocus();
            AnalysisParameters.this.calculateWindowFunction();
        }
    };

    public AnalysisParameters(FRTmain parentGUI) {
        this.mainGUI = parentGUI;
        this.analysisParamsFrame = this;
        this.analysisParamsObject = this;
        this.expLimit = Math.pow(10.0, this.dBLimit / 20.0);
        this.panelsBorder = new LineBorder(Color.lightGray, 3);
        this.decimalFormat = new DecimalFormat("#.###");
        this.decimalFormat = NumberFormat.getInstance(Locale.getDefault());
        this.decimalFormat.setMaximumFractionDigits(5);
        this.decimalFormat.setMinimumFractionDigits(1);
        this.ourTemperaments = new Temperaments();
        this.temperamentBox = new JComboBox<String>(this.ourTemperaments.getTemperamentNames());
        this.aField.setText(this.decimalFormat.format(256.0));
        this.harmonicsFromField.setText(this.decimalFormat.format(256.0));
        this.freqResults = new SpectrumBinList[this.ftNframes];
        int i = 0;
        while (i < this.ftNframes) {
            this.freqResults[i] = new SpectrumBinList();
            this.freqResults[i].addSpectrumBin(new SpectrumBin(1.0, 1.0, 0.0));
            ++i;
        }
        this.nAvailProcessors = Math.max(Runtime.getRuntime().availableProcessors() - 2, 1);
        this.ftWindowBox.setSelectedIndex(0);
        this.functionName = (String)this.ftWindowBox.getSelectedItem();
        this.channelLabel.setToolTipText(this.channelTip);
        this.channelLeftButton.setToolTipText(this.channelTip);
        this.channelRightButton.setToolTipText(this.channelTip);
        this.showInput.setToolTipText(this.showInputTip);
        this.decayShowBox.setToolTipText(this.showAvgBoxTip);
        this.ftShowWindow.setToolTipText(this.ftShowWindowTip);
        this.ftShowOriginal.setToolTipText(this.ftShowOriginalTip);
        this.ftShowFinal.setToolTipText(this.ftShowFinalTip);
        this.ftShowSpectrum.setToolTipText(this.ftShowSpectrumTip);
        this.ftShowPhase.setToolTipText(this.ftShowPhaseTip);
        this.showNotes.setToolTipText(this.showNotesTip);
        this.temperamentBox.setToolTipText(this.temperamentTip);
        this.aField.setToolTipText(this.aTip);
        this.showHarmonics.setToolTipText(this.showHarmonicsTip);
        this.harmonicsFromField.setToolTipText(this.harmonicsFromTip);
        this.fromStartButton.setToolTipText(this.fromStartButtonTip);
        this.fromMark1Button.setToolTipText(this.fromMark1ButtonTip);
        this.fromMark2Button.setToolTipText(this.fromMark2ButtonTip);
        this.toEndButton.setToolTipText(this.toEndButtonTip);
        this.toMark1Button.setToolTipText(this.toMark1ButtonTip);
        this.toMark2Button.setToolTipText(this.toMark2ButtonTip);
        this.playLoopBox.setToolTipText(this.playLoopTip);
        this.playLoopTimes.setToolTipText(this.playLoopTip);
        this.playDurationSpinner.setToolTipText(this.playDurationTip);
        this.volumeLabel.setToolTipText(this.volumeSliderTip);
        this.volumeSlider.setToolTipText(this.volumeSliderTip);
        this.buttonPlay.setToolTipText(this.buttonPlayTip);
        this.buttonStop.setToolTipText(this.buttonStopTip);
        this.decaySpanLabel.setToolTipText(this.avgSpanTip);
        this.decaySpanSpinner.setToolTipText(this.avgSpanTip);
        this.decayAvgButton.setToolTipText(this.avgAvgButtonTip);
        this.decayRmsButton.setToolTipText(this.avgRmsButtonTip);
        this.decayLinButton.setToolTipText(this.inLinTip);
        this.decayLogRelButton.setToolTipText(this.inLogRelTip);
        this.buttonOpenFile.setToolTipText(this.openFileTip);
        this.buttonReread.setToolTipText(this.rereadTip);
        this.buttonShowInfo.setToolTipText(this.showInfoTip);
        this.decayAnalyseButton.setToolTipText(this.decayAnalyseTip);
        this.ftWindowBox.setToolTipText(this.ftWindowBoxTip);
        this.ftParameterLabel.setToolTipText(this.ftParameterLabelTip);
        this.ftParameterField.setToolTipText(this.ftParameterFieldTip);
        this.ftWindowDetailButton.setToolTipText(this.ftWindowDetailButtonTip);
        this.ftSingleButton.setToolTipText(this.ftSingleTip);
        this.ftAveragedButton.setToolTipText(this.ftAveragedtip);
        this.ftStftButton.setToolTipText(this.ftSftTip);
        this.dftButton.setToolTipText(this.dftButtonTip);
        this.fftButton.setToolTipText(this.fftButtonTip);
        this.cztButton.setToolTipText(this.cztButtonTip);
        this.zeroPadLabel.setToolTipText(this.zeroPadTip);
        this.zeroPadSpinner.setToolTipText(this.zeroPadTip);
        this.f0Label.setToolTipText(this.f0Tip);
        this.f0Field.setToolTipText(this.f0Tip);
        this.fMaxField.setToolTipText(this.fMaxtip);
        this.deltaField.setToolTipText(this.deltaFtip);
        this.cztStepsLabel.setToolTipText(this.cztStepsTip);
        this.ftFilterDCbox.setToolTipText(this.ftFilterDCTip);
        this.ftLinButton.setToolTipText(this.ftLinButtonTip);
        this.ftLogAbsButton.setToolTipText(this.ftLogAbsButtonTip);
        this.ftLogRelButton.setToolTipText(this.ftLogRelButtonTip);
        this.buttonAnalyse.setToolTipText(this.analyseTip);
        this.buttonDFTExport.setToolTipText(this.exportTip);
        this.buttonToSynth.setToolTipText(this.toSynthTip);
        this.expToSynthNum.setToolTipText(this.expToSynthNumTip);
        this.nFramesLabel.setToolTipText(this.nFramesTip);
        this.nFramesField.setToolTipText(this.nFramesTip);
        this.stepLabel.setToolTipText(this.stepTip);
        this.stepSamplesField.setToolTipText(this.stepTip);
        this.durationLabel.setToolTipText(this.durationLabelTip);
        this.resultArea.setToolTipText(this.resultTip);
        this.cancelButton.setToolTipText(this.cancelTip);
        this.enDisAbleButtonsForData(false);
        this.ftRunning = false;
        this.decayRunning = false;
        this.setLayout(new BoxLayout(this, 1));
        JPanel filePanel = new JPanel(this.flowLayoutLeft);
        TitledBorder filePanelTitle = new TitledBorder(this.panelsBorder, "Read File", 1, 2);
        filePanel.setBorder(filePanelTitle);
        filePanel.add(this.channelLabel);
        filePanel.add(this.channelLeftButton);
        filePanel.add(this.channelRightButton);
        ButtonGroup channelGroup = new ButtonGroup();
        channelGroup.add(this.channelLeftButton);
        channelGroup.add(this.channelRightButton);
        this.channelLeftButton.setSelected(true);
        filePanel.add(this.buttonOpenFile);
        filePanel.add(this.buttonReread);
        filePanel.add(this.buttonShowInfo);
        this.buttonOpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.outClip != null && AnalysisParameters.this.soundThread != null) {
                    AnalysisParameters.this.outClip.stop();
                    AnalysisParameters.this.soundThread.interrupt();
                }
                AnalysisParameters.this.buttonStop.setEnabled(false);
                AnalysisParameters.this.freqResults[0] = new SpectrumBinList();
                AnalysisParameters.this.windowFunction = null;
                AnalysisParameters.this.ftWindowBox.setSelectedIndex(0);
                AnalysisParameters.this.functionName = (String)AnalysisParameters.this.ftWindowBox.getSelectedItem();
                AnalysisParameters.this.ftParameterLabel.setVisible(false);
                AnalysisParameters.this.ftParameterField.setVisible(false);
                AnalysisParameters.this.decayAnalyseButton.setSelected(false);
                if (AnalysisParameters.this.currentFileDir == "") {
                    AnalysisParameters.this.currentFileDir = System.getProperty("user.home");
                }
                JFileChooser openChooser = new JFileChooser(AnalysisParameters.this.currentFileDir);
                openChooser.setDialogTitle("Open an Existing File");
                int openChoice = openChooser.showOpenDialog(AnalysisParameters.this.mainGUI);
                if (openChoice != 0) {
                    return;
                }
                File chosenOpenFile = openChooser.getSelectedFile();
                AnalysisParameters.this.myFilePath = chosenOpenFile.getAbsolutePath();
                AnalysisParameters.this.currentFileDir = chosenOpenFile.getParent();
                AnalysisParameters.this.fileSize = chosenOpenFile.length();
                AnalysisParameters.this.fileIn = new File(AnalysisParameters.this.myFilePath);
                AnalysisParameters.this.rawWave = new RawWavFile(AnalysisParameters.this.mainGUI, AnalysisParameters.this.fileIn);
                if (AnalysisParameters.this.analysis != null) {
                    AnalysisParameters.this.analysis.dispose();
                }
                AnalysisParameters.this.ourFTrunner = null;
                AnalysisParameters.this.avgWave = null;
                AnalysisParameters.this.rawWave.readFile(RawWavFile.PostProcessing.Logic1);
            }
        });
        this.buttonReread.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.outClip != null) {
                    AnalysisParameters.this.outClip.stop();
                    AnalysisParameters.this.soundThread.interrupt();
                }
                AnalysisParameters.this.buttonStop.setEnabled(false);
                if (!AnalysisParameters.this.actualFilePath.equals("")) {
                    AnalysisParameters.this.myFilePath = AnalysisParameters.this.actualFilePath;
                    AnalysisParameters.this.fileIn = new File(AnalysisParameters.this.actualFilePath);
                    AnalysisParameters.this.rawWave = new RawWavFile(AnalysisParameters.this.mainGUI, AnalysisParameters.this.fileIn);
                    if (AnalysisParameters.this.analysis != null) {
                        AnalysisParameters.this.analysis.dispose();
                    }
                    AnalysisParameters.this.rawWave.readFile(RawWavFile.PostProcessing.Logic1);
                    AnalysisParameters.this.buttonPlay.setEnabled(true);
                    AnalysisParameters.this.analysis.getFtInputPanel().setAnalysisIsStale(true);
                    AnalysisParameters.this.analysis.repaint();
                }
            }
        });
        this.buttonShowInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.analysis != null && AnalysisParameters.this.analysis.getFtInputPanel() != null && AnalysisParameters.this.analysis.getFtInputPanel() != null) {
                    AnalysisParameters.this.fileInfoWindow = AnalysisParameters.this.rawWave.getInfoWindow();
                    AnalysisParameters.this.fileInfoWindow.showWindow();
                }
            }
        });
        JPanel viewPanel1 = new JPanel(this.flowLayoutLeft);
        viewPanel1.add(this.decayShowBox);
        viewPanel1.add(this.ftShowSpectrum);
        viewPanel1.add(this.ftShowPhase);
        JPanel viewPanel2 = new JPanel(this.flowLayoutLeft);
        viewPanel2.add(this.showNotes);
        viewPanel2.add(this.temperamentBox);
        viewPanel2.add(this.aLabel);
        viewPanel2.add(this.aField);
        viewPanel2.add(this.aHzLabel);
        JPanel viewPanel3 = new JPanel(this.flowLayoutLeft);
        viewPanel3.add(this.showHarmonics);
        viewPanel3.add(this.harmonicsFromLabel);
        viewPanel3.add(this.harmonicsFromField);
        viewPanel3.add(this.harmonicsHzLabel);
        JPanel viewPanel4 = new JPanel(this.flowLayoutLeft);
        viewPanel4.add(this.showInput);
        viewPanel4.add(this.showInputSeparator);
        viewPanel4.add(this.ftShowWindow);
        viewPanel4.add(this.ftShowOriginal);
        viewPanel4.add(this.ftShowFinal);
        Box viewPanel = Box.createVerticalBox();
        TitledBorder viewPanelTitle = new TitledBorder(this.panelsBorder, "View", 1, 2);
        viewPanel.setBorder(viewPanelTitle);
        viewPanel.add(viewPanel1);
        viewPanel.add(viewPanel2);
        viewPanel.add(viewPanel3);
        viewPanel.add(viewPanel4);
        this.decayShowBox.setSelected(false);
        this.ftShowSpectrum.setSelected(true);
        this.ftShowPhase.setSelected(false);
        this.showNotes.setSelected(false);
        this.showHarmonics.setSelected(false);
        this.showInput.setSelected(true);
        this.ftShowWindow.setSelected(true);
        this.ftShowOriginal.setSelected(true);
        this.ftShowFinal.setSelected(true);
        this.enDisableNotesHarmonics();
        this.enDisableNotesFields(this.showNotes.isSelected());
        this.enDisableHarmonicsFields(this.showHarmonics.isSelected());
        this.decayShowBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.analysis != null) {
                    AnalysisParameters.this.analysis.configurePanels(true);
                    AnalysisParameters.this.analysis.getDecayInputPanel().getWavePanel().inputPanLimits();
                    AnalysisParameters.this.analysis.repaint();
                }
            }
        });
        this.ftShowSpectrum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.analysis != null) {
                    AnalysisParameters.this.analysis.configurePanels(true);
                    AnalysisParameters.this.analysis.repaint();
                }
                AnalysisParameters.this.enDisableNotesHarmonics();
            }
        });
        this.ftShowPhase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.analysis != null) {
                    AnalysisParameters.this.analysis.configurePanels(true);
                }
            }
        });
        this.showNotes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalysisParameters.this.enDisableNotesFields(AnalysisParameters.this.showNotes.isSelected());
                if (AnalysisParameters.this.analysis != null) {
                    AnalysisParameters.this.analysis.repaint();
                }
            }
        });
        this.temperamentBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.analysis != null) {
                    AnalysisParameters.this.ourTemperaments.setTemperament(AnalysisParameters.this.getSelectedTemperament());
                    AnalysisParameters.this.analysis.repaint();
                }
            }
        });
        this.aField.setText(this.decimalFormat.format(440.0));
        this.aField.setColumns(4);
        this.aField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(final FocusEvent f) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField field = (JTextField)f.getSource();
                        field.selectAll();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent f) {
                if (f.isTemporary()) {
                    return;
                }
                JTextField field = (JTextField)f.getSource();
                boolean f0OK = true;
                Number tmp = 0;
                double tmp2 = 440.0;
                try {
                    tmp = AnalysisParameters.this.genFormat.parse(field.getText());
                }
                catch (Exception n) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "Invalid number in A");
                    f0OK = false;
                }
                if (f0OK && (tmp2 = tmp.doubleValue()) <= 0.0) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "A must be greater than 0");
                    f0OK = false;
                }
                if (f0OK) {
                    AnalysisParameters.this.freqA = tmp2;
                    AnalysisParameters.this.ourTemperaments.setA(AnalysisParameters.this.freqA);
                }
                if (AnalysisParameters.this.analysis != null) {
                    AnalysisParameters.this.analysis.repaint();
                }
            }
        });
        this.showHarmonics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalysisParameters.this.enDisableHarmonicsFields(AnalysisParameters.this.showHarmonics.isSelected());
                if (AnalysisParameters.this.analysis != null) {
                    AnalysisParameters.this.analysis.repaint();
                }
            }
        });
        this.harmonicsFromField.setText(this.decimalFormat.format(256.0));
        this.harmonicsFromField.setColumns(5);
        this.harmonicsFromField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(final FocusEvent f) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField field = (JTextField)f.getSource();
                        field.selectAll();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent f) {
                if (f.isTemporary()) {
                    return;
                }
                JTextField field = (JTextField)f.getSource();
                boolean f0OK = true;
                Number tmp = 0;
                double tmp2 = 256.0;
                try {
                    tmp = AnalysisParameters.this.genFormat.parse(field.getText());
                }
                catch (Exception n) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "Invalid number in first Harmonic");
                    f0OK = false;
                }
                if (f0OK && (tmp2 = tmp.doubleValue()) <= 0.0) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "First Harmonic must be greater than 0");
                    f0OK = false;
                }
                if (f0OK) {
                    AnalysisParameters.this.fundamental = tmp2;
                }
                if (AnalysisParameters.this.analysis != null) {
                    AnalysisParameters.this.analysis.repaint();
                }
            }
        });
        this.showInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.analysis != null) {
                    AnalysisParameters.this.analysis.configurePanels(true);
                    AnalysisParameters.this.analysis.getFtInputPanel().getWavePanel().inputPanLimits();
                    AnalysisParameters.this.analysis.repaint();
                }
            }
        });
        this.ftShowWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.analysis != null) {
                    AnalysisParameters.this.analysis.configurePanels(true);
                    AnalysisParameters.this.analysis.getFtInputPanel().getWavePanel().inputPanLimits();
                    AnalysisParameters.this.analysis.repaint();
                }
            }
        });
        this.ftShowOriginal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.analysis != null) {
                    AnalysisParameters.this.analysis.configurePanels(true);
                    AnalysisParameters.this.analysis.getFtInputPanel().getWavePanel().inputPanLimits();
                    AnalysisParameters.this.analysis.repaint();
                }
            }
        });
        this.ftShowFinal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.analysis != null) {
                    AnalysisParameters.this.analysis.configurePanels(true);
                    AnalysisParameters.this.analysis.getFtInputPanel().getWavePanel().inputPanLimits();
                    AnalysisParameters.this.analysis.repaint();
                }
            }
        });
        Box playPanel = Box.createHorizontalBox();
        TitledBorder playPanelTitle = new TitledBorder(this.panelsBorder, "Play Sound", 1, 2);
        playPanel.setBorder(playPanelTitle);
        ButtonGroup playFromGroup = new ButtonGroup();
        playFromGroup.add(this.fromStartButton);
        playFromGroup.add(this.fromMark1Button);
        playFromGroup.add(this.fromMark2Button);
        ButtonGroup playToGroup = new ButtonGroup();
        playToGroup.add(this.toEndButton);
        playToGroup.add(this.toMark1Button);
        playToGroup.add(this.toMark2Button);
        this.fromStartButton.setSelected(true);
        this.toEndButton.setSelected(true);
        this.fromStartButton.addActionListener(this.playButtonListener);
        this.fromMark1Button.addActionListener(this.playButtonListener);
        this.fromMark2Button.addActionListener(this.playButtonListener);
        this.toEndButton.addActionListener(this.playButtonListener);
        this.toMark1Button.addActionListener(this.playButtonListener);
        this.toMark2Button.addActionListener(this.playButtonListener);
        this.playButtonLogic();
        JPanel playFromToPanel = new JPanel(new GridLayout(4, 2));
        playFromToPanel.add(this.playFromLabel);
        playFromToPanel.add(this.playToLabel);
        playFromToPanel.add(this.fromStartButton);
        playFromToPanel.add(this.toMark1Button);
        playFromToPanel.add(this.fromMark1Button);
        playFromToPanel.add(this.toMark2Button);
        playFromToPanel.add(this.fromMark2Button);
        playFromToPanel.add(this.toEndButton);
        JPanel loopPanel = new JPanel(this.flowLayoutLeft);
        this.playLoopBox.setEnabled(true);
        this.enDisableLoop(false);
        loopPanel.add(this.playLoopBox);
        loopPanel.add(this.playDurationSpinner);
        loopPanel.add(this.playLoopTimes);
        JPanel volumePanel = new JPanel(this.flowLayoutLeft);
        this.volumeSlider.setPaintTicks(false);
        this.volumeSlider.setPaintLabels(false);
        volumePanel.add(this.volumeLabel);
        volumePanel.add(this.volumeSlider);
        JPanel playStopPanel = new JPanel(this.flowLayoutLeft);
        playStopPanel.add(this.buttonPlay);
        playStopPanel.add(this.buttonStop);
        Box rhsPanel = Box.createVerticalBox();
        rhsPanel.add(loopPanel);
        rhsPanel.add(volumePanel);
        rhsPanel.add(playStopPanel);
        playPanel.add(playFromToPanel);
        playPanel.add(Box.createHorizontalGlue());
        playPanel.add(rhsPanel);
        this.playLoopBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalysisParameters.this.enDisableLoop(AnalysisParameters.this.playLoopBox.isSelected());
            }
        });
        this.buttonPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.soundPlaying) {
                    return;
                }
                Runnable soundr = () -> AnalysisParameters.this.play();
                AnalysisParameters.this.soundThread = new Thread(soundr);
                AnalysisParameters.this.soundPlaying = true;
                AnalysisParameters.this.soundThread.start();
                AnalysisParameters.this.buttonPlay.setEnabled(false);
                AnalysisParameters.this.buttonStop.setEnabled(true);
            }
        });
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.outClip != null) {
                    AnalysisParameters.this.outClip.stop();
                    AnalysisParameters.this.soundThread.interrupt();
                }
                AnalysisParameters.this.buttonStop.setEnabled(false);
                AnalysisParameters.this.buttonPlay.setEnabled(true);
            }
        });
        this.volumeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                float gain = source.getValue();
                AnalysisParameters.this.gainDB = Utils.convertGainToDB(gain);
                if (AnalysisParameters.this.gainControl != null) {
                    AnalysisParameters.this.gainControl.setValue(AnalysisParameters.this.gainDB);
                }
            }
        });
        JPanel decayPanel = new JPanel(this.flowLayoutLeft);
        TitledBorder decayPanelTitle = new TitledBorder(this.panelsBorder, "Decay Rate", 1, 2);
        decayPanel.setBorder(decayPanelTitle);
        JComponent decayEd = this.decaySpanSpinner.getEditor();
        Dimension prefSize = decayEd.getPreferredSize();
        prefSize = new Dimension(50, prefSize.height);
        decayEd.setPreferredSize(prefSize);
        ButtonGroup decayGroup = new ButtonGroup();
        decayGroup.add(this.decayAvgButton);
        decayGroup.add(this.decayRmsButton);
        this.decayAvgButton.setSelected(true);
        ButtonGroup decayLogLinGroup = new ButtonGroup();
        decayLogLinGroup.add(this.decayLinButton);
        decayLogLinGroup.add(this.decayLogRelButton);
        this.decayLinButton.setSelected(true);
        this.decayLinButton.addActionListener(this.decayLogLinButtonListener);
        this.decayLogRelButton.addActionListener(this.decayLogLinButtonListener);
        decayPanel.add(this.decaySpanLabel);
        decayPanel.add(this.decaySpanSpinner);
        decayPanel.add(this.decayAvgButton);
        decayPanel.add(this.decayRmsButton);
        decayPanel.add(this.decayLinButton);
        decayPanel.add(this.decayLogRelButton);
        decayPanel.add(this.decayAnalyseButton);
        this.decaySpanSpinner.addChangeListener(this.decaySpinnerListener);
        this.decayAvgButton.addActionListener(this.decayAvgRMSListener);
        this.decayRmsButton.addActionListener(this.decayAvgRMSListener);
        this.decayAnalyseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalysisParameters.this.decayAnalyseButton.setEnabled(false);
                AnalysisParameters.this.decayRunning = true;
                AnalysisParameters.this.decayProgress = new ProgressMonitor(AnalysisParameters.this.mainGUI, "Averaging", "", 0, 100);
                AnalysisParameters.this.soFar = 0;
                AnalysisParameters.this.decayProgress.setProgress(AnalysisParameters.this.soFar);
                AnalysisParameters.this.decayProgress.setNote(String.format("0 Completed %d%%.\n", AnalysisParameters.this.soFar));
                AnalysisParameters.this.decayProgress.setMillisToDecideToPopup(100);
                AnalysisParameters.this.decayProgress.setMillisToPopup(500);
                AnalysisParameters.this.decayWorker = new DecayWorker();
                AnalysisParameters.this.decayWorker.addPropertyChangeListener(new workPropertyChange());
                AnalysisParameters.this.decayWorker.execute();
            }
        });
        JPanel windowFunctionPanel = new JPanel(this.flowLayoutLeft);
        this.ftWindowBox.addActionListener(this.ftWindowBoxListener);
        this.ftWindowBox.setSelectedIndex(0);
        this.ftParameterLabel.setVisible(false);
        this.ftParameterField.setVisible(false);
        this.ftParameterField.setColumns(5);
        this.ftParameterField.setText("1");
        windowFunctionPanel.add(this.functionLabel);
        windowFunctionPanel.add(this.ftWindowBox);
        windowFunctionPanel.add(this.ftParameterLabel);
        windowFunctionPanel.add(this.ftParameterField);
        windowFunctionPanel.add(this.ftWindowDetailButton);
        this.ftParameterField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(final FocusEvent f) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField field = (JTextField)f.getSource();
                        field.selectAll();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent f) {
                if (f.isTemporary()) {
                    return;
                }
                double tmpParameter = Utils.parseLocalDouble(AnalysisParameters.this.ftParameterField.getText());
                if (!AnalysisParameters.this.validateParameter((String)AnalysisParameters.this.ftWindowBox.getSelectedItem(), tmpParameter, true)) {
                    return;
                }
                AnalysisParameters.this.calculateWindowFunction();
            }
        });
        this.ftWindowDetailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] devices = g.getScreenDevices();
                Rectangle virtualBounds = new Rectangle();
                int i = 0;
                while (i < devices.length) {
                    GraphicsDevice gd = devices[i];
                    GraphicsConfiguration[] gc = gd.getConfigurations();
                    int j = 0;
                    while (j < gc.length) {
                        virtualBounds = virtualBounds.union(gc[j].getBounds());
                        ++j;
                    }
                    ++i;
                }
                int newX = 20;
                int newY = 20;
                GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                GraphicsConfiguration gc = gd.getDefaultConfiguration();
                if (AnalysisParameters.this.infoWindow != null) {
                    newX = AnalysisParameters.this.infoWindow.getX() + 20;
                    newY = AnalysisParameters.this.infoWindow.getY() + 20;
                    gc = AnalysisParameters.this.infoWindow.getGraphicsConfiguration();
                }
                AnalysisParameters.this.infoWindow = new WindowFunctionWindow(gc, AnalysisParameters.this.mainGUI);
                Insets insets = AnalysisParameters.this.getToolkit().getScreenInsets(gc);
                if (AnalysisParameters.this.infoWindow.getSize().getHeight() + (double)newY > (double)(virtualBounds.height - insets.bottom - insets.top)) {
                    newY = 40;
                }
                if (AnalysisParameters.this.infoWindow.getSize().getWidth() + (double)newX > (double)(virtualBounds.width - insets.left - insets.right)) {
                    newX = 40;
                }
                AnalysisParameters.this.infoWindow.setLocation(newX, gc.getBounds().y + newY);
            }
        });
        Box transformPanel = Box.createVerticalBox();
        TitledBorder ftPanelTitle = new TitledBorder(this.panelsBorder, "Fourier Transform", 1, 2);
        transformPanel.setBorder(ftPanelTitle);
        JPanel dftFftPanel = new JPanel(this.flowLayoutLeft);
        ButtonGroup ftGroup = new ButtonGroup();
        ftGroup.add(this.dftButton);
        ftGroup.add(this.fftButton);
        ftGroup.add(this.cztButton);
        this.dftButton.setSelected(true);
        this.dFTfFTcZT = FourierTransform.FTtype.DFT;
        this.enDisableCZT(false);
        this.ftFilterDCbox.setSelected(false);
        this.dftButton.addActionListener(this.ftTypeButtonListener);
        this.fftButton.addActionListener(this.ftTypeButtonListener);
        this.cztButton.addActionListener(this.ftTypeButtonListener);
        dftFftPanel.add(this.dftButton);
        dftFftPanel.add(this.fftButton);
        dftFftPanel.add(this.cztButton);
        dftFftPanel.add(this.zeroPadLabel);
        dftFftPanel.add(this.zeroPadSpinner);
        this.zeroPadSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AnalysisParameters.this.analysis.getFtInputPanel().setAnalysisIsStale(true);
                AnalysisParameters.this.analysis.repaint();
            }
        });
        this.cztF0 = 100.0;
        this.f0Field.setText(this.decimalFormat.format(this.cztF0));
        this.f0Field.addFocusListener(this.cztFieldListener);
        this.cztDeltaF = 1.0;
        this.deltaField.setText(this.decimalFormat.format(this.cztDeltaF));
        this.deltaField.addFocusListener(this.cztFieldListener);
        this.cztFmax = 110.0;
        this.fMaxField.setText(this.decimalFormat.format(this.cztFmax));
        this.fMaxField.addFocusListener(this.cztFieldListener);
        this.cztSteps = 100;
        this.cztSteps = this.calculateCZTsteps();
        this.cztStepsLabel.setText("=" + String.valueOf(this.cztSteps) + " steps");
        this.cztPanel.add(this.f0Label);
        this.cztPanel.add(this.f0Field);
        this.cztPanel.add(this.fNLabel);
        this.cztPanel.add(this.fMaxField);
        this.cztPanel.add(this.deltaFLabel);
        this.cztPanel.add(this.deltaField);
        this.cztPanel.add(this.cztStepsLabel);
        JPanel ftScalingPanel = new JPanel(this.flowLayoutLeft);
        ButtonGroup linLogGroup = new ButtonGroup();
        linLogGroup.add(this.ftLinButton);
        linLogGroup.add(this.ftLogAbsButton);
        linLogGroup.add(this.ftLogRelButton);
        this.ftLinButton.addActionListener(this.ftLogLinButtonListener);
        this.ftLogAbsButton.addActionListener(this.ftLogLinButtonListener);
        this.ftLogRelButton.addActionListener(this.ftLogLinButtonListener);
        this.ftLinButton.setSelected(true);
        this.setFtLinLog();
        ftScalingPanel.add(this.ftFilterDCbox);
        ftScalingPanel.add(this.ftLinButton);
        ftScalingPanel.add(this.ftLogAbsButton);
        ftScalingPanel.add(this.ftLogRelButton);
        JPanel ftCombinePanel = new JPanel(this.flowLayoutLeft);
        ButtonGroup ftCombineGroup = new ButtonGroup();
        ftCombineGroup.add(this.ftSingleButton);
        ftCombineGroup.add(this.ftAveragedButton);
        ftCombineGroup.add(this.ftStftButton);
        this.ftSingleButton.setSelected(true);
        this.currentFTcombine = FTcombine.FTsingle;
        this.enDisableFrames(false);
        this.ftSingleButton.addActionListener(this.ftCombineButtonListener);
        this.ftAveragedButton.addActionListener(this.ftCombineButtonListener);
        this.ftStftButton.addActionListener(this.ftCombineButtonListener);
        ftCombinePanel.add(this.ftSingleButton);
        ftCombinePanel.add(this.ftAveragedButton);
        ftCombinePanel.add(this.ftStftButton);
        this.ftFramesPanel.add(this.nFramesLabel);
        this.ftFramesPanel.add(this.nFramesField);
        this.ftFramesPanel.add(this.stepLabel);
        this.ftFramesPanel.add(this.stepSamplesField);
        this.ftFramesPanel.add(this.durationLabel);
        this.ftNframes = 2;
        this.nFramesField.setText(String.valueOf(this.ftNframes));
        this.nFramesField.setHorizontalAlignment(2);
        this.nFramesField.setCaretPosition(0);
        this.nFramesField.addFocusListener(this.stftFieldListener);
        this.ftStepSamples = 50;
        this.stepSamplesField.setText(String.valueOf(this.ftStepSamples));
        this.stepSamplesField.setHorizontalAlignment(2);
        this.stepSamplesField.setCaretPosition(0);
        this.stepSamplesField.addFocusListener(this.stftFieldListener);
        JPanel buttonsPanel = new JPanel(this.flowLayoutLeft);
        this.buttonAnalyse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalysisParameters.this.doTransformActions();
            }
        });
        this.buttonDFTExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newOverwriteSelection;
                String outfolderPath = System.getProperty("user.home");
                JFileChooser outFileChooser = new JFileChooser(outfolderPath);
                outFileChooser.setDialogTitle("Save to File");
                outFileChooser.setApproveButtonText("Save");
                int outfolderChoice = outFileChooser.showOpenDialog(AnalysisParameters.this.mainGUI);
                if (outfolderChoice != 0) {
                    return;
                }
                File chosenFolder = outFileChooser.getSelectedFile();
                outfolderPath = chosenFolder.getAbsolutePath();
                File saveFile = outFileChooser.getSelectedFile();
                if (saveFile.exists() && (newOverwriteSelection = JOptionPane.showConfirmDialog(AnalysisParameters.this.mainGUI, AnalysisParameters.this.newOverwriteDialog, "That File Already Exists - overwrite it?", 0, 3)) == 1) {
                    return;
                }
                try {
                    saveFile.createNewFile();
                    String path = saveFile.getAbsolutePath();
                    BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8));
                    AnalysisParameters.this.outBuffer = new BufferedWriter(outWriter);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.mainGUI, "Output File: IO Exception opening file for write");
                    return;
                }
                try {
                    Locale here = Locale.getDefault();
                    char decSep = new DecimalFormatSymbols(Locale.getDefault(Locale.Category.FORMAT)).getDecimalSeparator();
                    String sep = ",";
                    if (",".equals(new String(new char[]{decSep}))) {
                        sep = ";";
                    }
                    AnalysisParameters.this.outBuffer.write("sep=" + sep + "\n");
                    LocalDateTime now = LocalDateTime.now();
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    String formattedNow = now.format(formatter);
                    String title = AnalysisParameters.this.analysis.getTitle() + " " + formattedNow;
                    AnalysisParameters.this.outBuffer.write("Description" + sep + title + "\n");
                    int nBins = AnalysisParameters.this.expToSynthBins;
                    String freq = "";
                    if (AnalysisParameters.this.dFTfFTcZT == FourierTransform.FTtype.CZT) {
                        freq = String.format(here, "%f", AnalysisParameters.this.cztF0);
                        nBins = AnalysisParameters.this.cztSteps;
                    } else {
                        freq = String.format(here, "%f", (double)AnalysisParameters.this.rawWave.getSampleRate() / (double)AnalysisParameters.this.expandedWindowWidth);
                    }
                    AnalysisParameters.this.outBuffer.write("Frequency" + sep + freq + sep + AnalysisParameters.this.analysis.getFtInputPanel().getSampleRate() + "\n");
                    AnalysisParameters.this.outBuffer.write("Noise" + sep + "false" + sep + "0\n");
                    AnalysisParameters.this.outBuffer.write("Frequency" + sep + "Amplitude" + sep + "Phase\n");
                    int i = 0;
                    while (i < nBins) {
                        Object buffer = "";
                        try {
                            buffer = (String)buffer + String.format(here, "%f", AnalysisParameters.this.freqResults[0].getBinByIndex(i).getFreqFactor()) + sep;
                            buffer = (String)buffer + String.format(here, "%f", AnalysisParameters.this.freqResults[0].getBinByIndex(i).getAmplitude()) + sep;
                            buffer = (String)buffer + String.format(here, "%f", Math.toDegrees(AnalysisParameters.this.freqResults[0].getBinByIndex(i).getPhase())) + "\n";
                        }
                        catch (IllegalFormatException f) {
                            System.out.println("Illegal format exception in DFT: " + f.getMessage());
                        }
                        catch (FormatterClosedException c) {
                            System.out.println("Formatter closed exception in DFT:" + c.getMessage());
                        }
                        AnalysisParameters.this.outBuffer.write((String)buffer);
                        ++i;
                    }
                    AnalysisParameters.this.outBuffer.flush();
                    AnalysisParameters.this.outBuffer.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.buttonToSynth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalysisParameters.this.mainGUI.getSynthParams().getSynthesisWindow() == null) {
                    AnalysisParameters.this.mainGUI.getSynthParams().createSynthesisWindow();
                }
                double freq = 0.0;
                int nBins = 0;
                if (AnalysisParameters.this.dFTfFTcZT == FourierTransform.FTtype.CZT) {
                    freq = AnalysisParameters.this.cztF0;
                    nBins = AnalysisParameters.this.cztSteps;
                } else {
                    freq = AnalysisParameters.this.analysis.getFtInputPanel().getFundamental();
                    nBins = AnalysisParameters.this.expToSynthBins;
                }
                AnalysisParameters.this.mainGUI.getSynthParams().spectrumToSynthesis(AnalysisParameters.this.freqResults[0], freq, nBins);
                AnalysisParameters.this.mainGUI.showSynthesisTab();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).AnalysisParameters.this.mainGUI.getSynthParams().getSynthesisWindow().toFront();
                        (this).AnalysisParameters.this.mainGUI.getSynthParams().getSynthesisWindow().repaint();
                    }
                });
            }
        });
        this.expToSynthBins = 0;
        this.expToSynthNum.setColumns(4);
        this.expToSynthNum.setText(String.valueOf(this.expToSynthBins));
        this.expToSynthNum.setHorizontalAlignment(2);
        this.expToSynthNum.setCaretPosition(0);
        this.expToSynthNum.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(final FocusEvent f) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField field = (JTextField)f.getSource();
                        field.selectAll();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent f) {
                if (f.isTemporary()) {
                    return;
                }
                JTextField field = (JTextField)f.getSource();
                int tmp = 0;
                try {
                    tmp = Integer.parseInt(field.getText());
                }
                catch (NumberFormatException n) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.analysisParamsFrame, "Invalid number in First n bins to synthesis field");
                    return;
                }
                if (tmp < 0 || tmp > AnalysisParameters.this.analysis.getFtInputPanel().getSampleRate() / 2) {
                    JOptionPane.showMessageDialog(AnalysisParameters.this.analysisParamsFrame, "First n bins to synthesis must be between 0 and sample rate / 2 = " + AnalysisParameters.this.analysis.getFtInputPanel().getSampleRate() / 2);
                    return;
                }
                if (tmp != AnalysisParameters.this.expToSynthBins) {
                    AnalysisParameters.this.expToSynthBins = tmp;
                }
            }
        });
        buttonsPanel.add(this.buttonAnalyse);
        buttonsPanel.add(this.buttonDFTExport);
        buttonsPanel.add(this.buttonToSynth);
        buttonsPanel.add(this.expToSynthNumLabel);
        buttonsPanel.add(this.expToSynthNum);
        transformPanel.add(windowFunctionPanel);
        transformPanel.add(dftFftPanel);
        transformPanel.add(this.cztPanel);
        transformPanel.add(ftScalingPanel);
        transformPanel.add(ftCombinePanel);
        transformPanel.add(this.ftFramesPanel);
        transformPanel.add(buttonsPanel);
        this.ftResultText = this.ftInitialResult;
        this.decayResultText = this.decayInitialResult;
        this.avgBtwMarksText = "";
        this.resultArea.setEditable(false);
        this.resultArea.setAlignmentX(0.0f);
        this.resultPanel.setLayout(new BoxLayout(this.resultPanel, 1));
        TitledBorder resultPanelTitle = new TitledBorder(this.panelsBorder, "Results", 1, 2);
        this.resultPanel.setBorder(resultPanelTitle);
        this.updateResults();
        Box top = Box.createVerticalBox();
        top.add(filePanel);
        top.add(viewPanel);
        top.add(playPanel);
        top.add(decayPanel);
        top.add(transformPanel);
        this.resultScrollPane = new JScrollPane(this.resultPanel);
        this.resultScrollPane.setVerticalScrollBarPolicy(20);
        this.resultScrollPane.setHorizontalScrollBarPolicy(31);
        JPanel overallPanel = new JPanel(new BorderLayout());
        overallPanel.add((Component)top, "North");
        overallPanel.setAlignmentX(0.5f);
        overallPanel.add((Component)this.resultPanel, "Center");
        final JScrollPane overallScrollPane = new JScrollPane(overallPanel);
        overallScrollPane.setVerticalScrollBarPolicy(20);
        overallScrollPane.setHorizontalScrollBarPolicy(31);
        this.add(overallScrollPane);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                overallScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
    }

    private void doTransformActions() {
        int nFrames = 1;
        this.nUsedProcessors = 1;
        this.ftRunning = true;
        this.setFtLinLog();
        switch (this.currentFTcombine) {
            case FTsingle: {
                nFrames = 1;
                this.nUsedProcessors = 1;
                break;
            }
            case FTaveraged: {
                nFrames = this.ftNframes;
                this.nUsedProcessors = Math.min(this.nAvailProcessors, this.ftNframes);
                break;
            }
            case STFT: {
                nFrames = this.ftNframes;
                this.nUsedProcessors = Math.min(this.nAvailProcessors, this.ftNframes);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.analysisParamsFrame, "Unknown FT Combine in doTransfrom()");
            }
        }
        if (this.analysis.getFtInputPanel().getMark1Samples() + (nFrames - 1) * this.ftStepSamples + this.analysis.getFtInputPanel().getWindowSize() > this.rawWave.getFrameLength() - 1) {
            JOptionPane.showMessageDialog(this.analysisParamsFrame, "The selected frames go beyond the end of the file.\n Reduce the window size, reduce the number of frames, or shift the window backwards.");
            this.ftRunning = false;
            return;
        }
        this.freqResults = new SpectrumBinList[this.ftNframes];
        int i = 0;
        while (i < this.ftNframes) {
            this.freqResults[i] = new SpectrumBinList();
            ++i;
        }
        this.mainStart = System.nanoTime();
        this.calculateWindowFunction();
        this.buttonOpenFile.setEnabled(false);
        this.buttonReread.setEnabled(false);
        this.buttonAnalyse.setEnabled(false);
        this.buttonToSynth.setEnabled(false);
        this.expToSynthNum.setEnabled(false);
        this.expToSynthNumLabel.setEnabled(false);
        this.buttonDFTExport.setEnabled(false);
        this.ftProgressBars = new JProgressBar[this.nUsedProcessors];
        Box ftProgressPanel = Box.createVerticalBox();
        this.cancelButton.setAlignmentX(0.0f);
        ftProgressPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalysisParameters.this.ourFTrunner.cancel();
                AnalysisParameters.this.ftRunning = false;
                AnalysisParameters.this.analysis.getFtInputPanel().setAnalysisIsStale(true);
                AnalysisParameters.this.ftResultText = AnalysisParameters.this.ftCancelled;
                AnalysisParameters.this.updateResults();
            }
        });
        this.resultArea.setText(this.ftCalculatingResult);
        JPanel cancelPanel = new JPanel(this.flowLayoutLeft);
        cancelPanel.add(this.resultArea);
        cancelPanel.add(this.cancelButton);
        ftProgressPanel.add(cancelPanel);
        int i2 = 0;
        while (i2 < this.nUsedProcessors) {
            JProgressBar tmpPB = new JProgressBar(0, 100);
            tmpPB.setValue(0);
            tmpPB.setStringPainted(true);
            Dimension prefSize = tmpPB.getPreferredSize();
            prefSize.width = 200;
            tmpPB.setPreferredSize(prefSize);
            this.ftProgressBars[i2] = tmpPB;
            JPanel tmpPBpanel = new JPanel(this.flowLayoutLeft);
            JLabel tmpPBlabel = new JLabel("Processor " + (i2 + 1));
            tmpPBpanel.add(tmpPBlabel);
            tmpPBpanel.add(tmpPB);
            ftProgressPanel.add(tmpPBpanel);
            ++i2;
        }
        this.resultPanel.removeAll();
        this.resultPanel.add(ftProgressPanel);
        this.resultPanel.revalidate();
        this.ourFTrunner = new FTrunner(this.analysisParamsObject, this.analysis.getFtInputPanel().getMark1Samples(), this.analysis.getFtInputPanel().getWindowSize(), nFrames, this.ftStepSamples, this.ftProgressBars, this.dFTfFTcZT, this.currentFTcombine);
    }

    private boolean validateParameter(String function, double param, boolean set) {
        switch (function) {
            case "Gaussian": {
                if (Double.isNaN(param) || param == 0.0) {
                    JOptionPane.showMessageDialog(this.mainGUI, "Analyis: Invalid value in Gaussian window function parameter");
                    return false;
                }
                if (set) {
                    this.gaussianSigma = param;
                    break;
                }
                this.ftWindowParameter = this.gaussianSigma;
                this.ftParameterField.setText(this.decimalFormat.format(this.gaussianSigma));
                break;
            }
            case "Kaiser-Bessel": {
                if (Double.isNaN(param) || param == 0.0) {
                    JOptionPane.showMessageDialog(this.mainGUI, "Analyis: Invalid value in Kaiser-Bessel window function parameter");
                    return false;
                }
                if (set) {
                    this.kaiserAlpha = param;
                    break;
                }
                this.ftWindowParameter = this.kaiserAlpha;
                this.ftParameterField.setText(this.decimalFormat.format(this.kaiserAlpha));
                break;
            }
            case "Tukey": {
                if (Double.isNaN(param) || param < 0.0 || param > 1.0) {
                    JOptionPane.showMessageDialog(this.mainGUI, "Analyis: Invalid value in Tukey window function parameter");
                    return false;
                }
                if (set) {
                    this.tukeyAlpha = param;
                    break;
                }
                this.ftWindowParameter = this.tukeyAlpha;
                this.ftParameterField.setText(this.decimalFormat.format(this.tukeyAlpha));
                break;
            }
            case "Exponential": {
                if (Double.isNaN(param) || param < 0.0 || param > 10000.0) {
                    JOptionPane.showMessageDialog(this.mainGUI, "Analyis: Invalid value in Exponentiao window function parameter");
                    return false;
                }
                if (set) {
                    this.exponentialTau = param;
                    break;
                }
                this.ftWindowParameter = this.exponentialTau;
                this.ftParameterField.setText(this.decimalFormat.format(this.exponentialTau));
            }
        }
        return true;
    }

    public void ftDoneActions() {
        this.freqResults = this.ourFTrunner.getFTResult();
        this.buttonOpenFile.setEnabled(true);
        this.buttonReread.setEnabled(true);
        this.buttonAnalyse.setEnabled(true);
        this.buttonDFTExport.setEnabled(true);
        if (!this.ourFTrunner.isCancelled() && this.freqResults != null && this.freqResults[0].getSize() > 0) {
            this.analysis.setCurrentFrame(0);
            this.analysis.getSpectrumPanel().getSpectrumPlotPanel().setFrame(0);
            this.analysis.getVideoPanel().updateFrame();
            if (this.resetZoomPan) {
                this.analysis.getSpectrumPanel().spectrumPanLimits();
                this.analysis.getSpectrumZoomPanel().setSliderValue(0);
                this.analysis.getSpectrumZoomPanel().setScrollValue(0);
                this.resetZoomPan = false;
            }
            this.analysis.getSpectrumPanel().spectrumPanLimits();
            this.analysis.configurePanels(true);
            this.analysis.repaint();
            int paddedSize = this.analysis.getFtInputPanel().getWindowSize() + (Integer)this.zeroPadSpinner.getValue();
            Object paddedSizeString = "";
            this.expandedWindowWidth = this.ourFTrunner.getFFTexpandedSize();
            if ((Integer)this.zeroPadSpinner.getValue() > 0) {
                paddedSizeString = "Padded Window: " + paddedSize + " samples = " + Utils.formatShortTime(Utils.convertSamplesToSecs(paddedSize, this.rawWave.getSampleRate())) + ".\n";
            }
            Object expandedSize = "";
            if (this.dFTfFTcZT == FourierTransform.FTtype.FFT || this.dFTfFTcZT == FourierTransform.FTtype.CZT) {
                expandedSize = "FFT/CZT Expanded Window: " + this.expandedWindowWidth + " samples = " + Utils.formatShortTime(Utils.convertSamplesToSecs(this.expandedWindowWidth, this.rawWave.getSampleRate())) + ".\n";
            }
            String functionString = "Window Function: " + this.functionName;
            if (this.ftParameterField.isVisible()) {
                functionString = functionString + " " + this.ftParameterLabel.getText() + " " + this.ftParameterField.getText();
            }
            Object overlaps = "";
            if (this.currentFTcombine == FTcombine.FTaveraged || this.currentFTcombine == FTcombine.STFT) {
                int windowWidth = this.getAnalysisWindow().getFtInputPanel().getWindowSize();
                overlaps = this.ftNframes + " frames at step size " + this.ftStepSamples + " = " + String.format("%.3f", ((double)windowWidth - (double)this.ftStepSamples) * 100.0 / (double)windowWidth) + " % overlap covering " + Utils.formatShortTime(Utils.convertFramesToSecs(this.ftNframes, this.rawWave.getSampleRate(), this.expandedWindowWidth, this.ftStepSamples)) + ".\n";
            }
            double windowDuration = (double)this.expandedWindowWidth / (double)this.rawWave.getSampleRate();
            String resolution = "Frequency resolution: " + String.format("%.3f", (double)this.rawWave.getSampleRate() / (double)this.expandedWindowWidth) + " Hz.\n";
            Object notes = "";
            if (this.showNotes.isSelected()) {
                notes = "Notes temperament \"" + (String)this.temperamentBox.getSelectedItem() + "\" A = " + this.freqA + " Hz\n";
            }
            Object harmonics = "";
            if (this.showHarmonics.isSelected()) {
                harmonics = "Harmonics from " + this.fundamental + " Hz\n";
            }
            Object cztParameters = "";
            if (this.dFTfFTcZT == FourierTransform.FTtype.CZT) {
                cztParameters = "";
                cztParameters = "Starting Frequency: " + Utils.niceK(this.cztF0, 3) + " Hz, End Freq.: " + Utils.niceK(this.cztFmax, 3) + " Hz, Delta F: " + Utils.niceK(this.cztDeltaF, 3) + " Hz, " + this.cztSteps + " steps.\n";
            }
            long mainEnd = System.nanoTime();
            long mainElapsedl = mainEnd - this.mainStart;
            double mainElapsed = (double)mainElapsedl / 1000000.0;
            this.ftResultText = "";
            try {
                this.ftResultText = "Window: " + this.analysis.getFtInputPanel().getWindowSize() + " samples = " + Utils.formatShortTime(windowDuration) + " from sample " + this.analysis.getFtInputPanel().getMark1Samples() + " = " + Utils.formatShortTime(Utils.convertSamplesToSecs(this.analysis.getFtInputPanel().getMark1Samples(), this.rawWave.getSampleRate())) + ".\n" + (String)paddedSizeString + (String)expandedSize + functionString + ".\n" + (String)overlaps + (String)cztParameters + (String)notes + (String)harmonics + resolution + "Processing Time: " + Utils.formatTime(mainElapsed) + ".";
            }
            catch (IllegalFormatException f) {
                System.out.println("Illegal format exception in AnalysisParamters ftDoneActions(): " + f.getMessage());
            }
            catch (FormatterClosedException c) {
                System.out.println("Formatter closed exception in AnalysisParamters ftDoneActions():" + c.getMessage());
            }
            this.ftRunning = false;
            this.analysis.getFtInputPanel().setAnalysisIsStale(false);
            this.enDisableSendToSynth();
        } else {
            System.out.println("ftDoneActions no input");
        }
        this.updateResults();
    }

    private void doDecay() {
        if (this.analysis != null) {
            double gradient;
            if (this.decayShowBox.isSelected()) {
                int span = (Integer)this.decaySpanSpinner.getValue();
                if ((span & 1) != 1) {
                    this.decaySpanSpinner.setValue(++span);
                }
                int halfSpan = span / 2;
                if (this.analysis.getDecayInputPanel().getMark1Samples() - halfSpan < 0) {
                    this.analysis.getDecayInputPanel().setMark1Samples(Math.max(this.analysis.getDecayInputPanel().getMark1Samples(), halfSpan + 1));
                }
                if (this.analysis.getDecayInputPanel().getMark2Samples() + halfSpan > this.rawWave.getFrameLength()) {
                    this.analysis.getDecayInputPanel().setMark2Samples(Math.min(this.analysis.getDecayInputPanel().getMark2Samples(), this.rawWave.getFrameLength() - halfSpan - 1));
                }
                int avgEndFrame = this.analysis.getDecayInputPanel().getMark2Samples() + 1;
                int avgStartFrame = this.analysis.getDecayInputPanel().getMark1Samples();
                double[] waveIn = this.rawWave.getAudioLin();
                this.avgWave = new double[this.analysis.getDecayInputPanel().getMark2Samples() - this.analysis.getDecayInputPanel().getMark1Samples() + 1];
                this.avgWaveAbsMax = 0.0;
                int avgIdx = 0;
                double sumX = 0.0;
                double sumY = 0.0;
                double sumXsq = 0.0;
                double sumYsq = 0.0;
                double sumXY = 0.0;
                int toDo = this.avgWave.length;
                int i = avgStartFrame;
                while (i < avgEndFrame) {
                    double tmpAvg = 0.0;
                    int j = -halfSpan;
                    while (j <= halfSpan) {
                        if (this.decayProgress != null) {
                            if (this.decayProgress.isCanceled()) {
                                return;
                            }
                            this.soFar = avgIdx * 100 / toDo;
                            this.decayProgress.setProgress(this.soFar);
                            this.decayProgress.setNote(String.format(" Averaging %d%%. Completed\n", this.soFar));
                        }
                        tmpAvg = this.decayAvgButton.isSelected() ? (tmpAvg += Math.abs(waveIn[i + j])) : (tmpAvg += waveIn[i + j] * waveIn[i + j]);
                        ++j;
                    }
                    this.avgWave[avgIdx] = this.decayAvgButton.isSelected() ? tmpAvg / (double)span : Math.sqrt(tmpAvg / (double)span);
                    sumX += (double)avgIdx;
                    sumY += this.avgWave[avgIdx];
                    sumXsq += (double)avgIdx * (double)avgIdx;
                    sumYsq += this.avgWave[avgIdx] * this.avgWave[avgIdx];
                    sumXY += (double)avgIdx * this.avgWave[avgIdx];
                    this.avgWaveAbsMax = Math.max(this.avgWaveAbsMax, this.avgWave[avgIdx]);
                    ++avgIdx;
                    ++i;
                }
                if (this.getAvgLinLog() == AvgScale.AvgLogRel) {
                    sumX = 0.0;
                    sumY = 0.0;
                    sumXsq = 0.0;
                    sumYsq = 0.0;
                    sumXY = 0.0;
                    i = 0;
                    while (i < this.avgWave.length) {
                        if (this.decayProgress != null) {
                            if (this.decayProgress.isCanceled()) {
                                return;
                            }
                            this.soFar = i * 100 / toDo;
                            this.decayProgress.setProgress(this.soFar);
                            this.decayProgress.setNote(String.format(" Log %d%%. Completed\n", this.soFar));
                        }
                        this.avgWave[i] = 20.0 * Math.log10(Math.max(Math.abs(this.avgWave[i]) / this.rawWave.getAbsMaxAmplitude(), this.expLimit));
                        sumX += (double)i;
                        sumY += this.avgWave[i];
                        sumXsq += (double)i * (double)i;
                        sumYsq += this.avgWave[i] * this.avgWave[i];
                        sumXY += (double)i * this.avgWave[i];
                        ++i;
                    }
                    this.avgWaveAbsMax = 0.0;
                    this.avgBtwMarks = sumY / (double)this.avgWave.length;
                    this.avgBtwMarksText = "Avg. between marks: " + String.format("%.2f", this.avgBtwMarks) + "dB";
                }
                this.gradient = ((double)this.avgWave.length * sumXY - sumX * sumY) / ((double)this.avgWave.length * sumXsq - sumX * sumX);
                this.gradientPerSec = this.gradient * (double)this.rawWave.getSampleRate();
                this.intersect = (sumY - this.gradient * sumX) / (double)this.avgWave.length;
                this.analysis.getDecayInputPanel().setAnalysisIsStale(false);
            }
            if (this.getAvgLinLog() == AvgScale.AvgLogRel) {
                gradient = this.gradientPerSec;
            } else {
                double time = (double)(this.analysis.getDecayInputPanel().getMark2Samples() - this.analysis.getDecayInputPanel().getMark1Samples()) / (double)this.analysis.getDecayInputPanel().getSampleRate();
                gradient = 20.0 * Math.log10(this.avgWave[this.avgWave.length - 1] / this.avgWave[0]) / time;
            }
            Object timeTo60 = "";
            if (this.gradientPerSec < 0.0) {
                timeTo60 = "\n";
                timeTo60 = (String)timeTo60 + String.format("%.2f", 60.0 / -gradient) + " Seconds to -60dB.";
            }
            this.decayResultText = "Decay Rate = " + String.format("%.2f", gradient) + " dB/Second." + (String)timeTo60;
            this.updateResults();
            this.analysis.repaint();
        }
    }

    /*
     * Loose catch block
     */
    private void play() {
        int startFrame = 0;
        if (this.fromStartButton.isSelected()) {
            startFrame = 0;
        }
        if (this.fromMark1Button.isSelected()) {
            startFrame = this.analysis.getFtInputPanel().getMark1Samples();
        }
        if (this.fromMark2Button.isSelected()) {
            startFrame = this.analysis.getFtInputPanel().getMark2Samples();
        }
        int endFrame = this.rawWave.getFrameLength();
        if (this.toMark1Button.isSelected()) {
            endFrame = this.analysis.getFtInputPanel().getMark1Samples();
        }
        if (this.toMark2Button.isSelected()) {
            endFrame = this.analysis.getFtInputPanel().getMark2Samples();
        }
        if (this.toEndButton.isSelected()) {
            endFrame = this.rawWave.getFrameLength();
        }
        this.outClip = null;
        float sampleRate = this.rawWave.getSampleRate();
        int sampleSize = this.rawWave.getConvertedSampleSize();
        AudioFormat soundInFormat = new AudioFormat(sampleRate, sampleSize, 1, true, false);
        double[] soundIn = this.rawWave.getAudioLin();
        int lengthToPlay = (endFrame - startFrame + 1) * this.rawWave.getConvertedBytesPerChannel();
        if (lengthToPlay <= 0) {
            return;
        }
        byte[] soundToPlay = new byte[lengthToPlay];
        int outIdx = 0;
        int i = startFrame;
        while (i < endFrame) {
            Integer soundSample = (int)Math.round(soundIn[i]);
            switch (sampleSize) {
                case 8: {
                    soundToPlay[outIdx] = (byte)(soundSample & 0xFF);
                    break;
                }
                case 12: {
                    soundToPlay[outIdx * 2] = (byte)(soundSample & 0xFF);
                    soundToPlay[outIdx * 2 + 1] = (byte)(soundSample >> 8 & 0xFF);
                    break;
                }
                case 16: {
                    soundToPlay[outIdx * 2] = (byte)(soundSample & 0xFF);
                    soundToPlay[outIdx * 2 + 1] = (byte)(soundSample >> 8 & 0xFF);
                    break;
                }
                case 24: {
                    soundToPlay[outIdx * 3] = (byte)(soundSample & 0xFF);
                    soundToPlay[outIdx * 3 + 1] = (byte)(soundSample >> 8 & 0xFF);
                    soundToPlay[outIdx * 3 + 2] = (byte)(soundSample >> 16 & 0xFF);
                    break;
                }
                case 32: {
                    soundToPlay[outIdx * 4] = (byte)(soundSample & 0xFF);
                    soundToPlay[outIdx * 4 + 1] = (byte)(soundSample >> 8 & 0xFF);
                    soundToPlay[outIdx * 4 + 2] = (byte)(soundSample >> 16 & 0xFF);
                    soundToPlay[outIdx * 4 + 3] = (byte)(soundSample >> 24 & 0xFF);
                    break;
                }
                case 64: {
                    soundToPlay[outIdx * 8] = (byte)(soundSample & 0xFF);
                    soundToPlay[outIdx * 8 + 1] = (byte)(soundSample >> 8 & 0xFF);
                    soundToPlay[outIdx * 8 + 2] = (byte)(soundSample >> 16 & 0xFF);
                    soundToPlay[outIdx * 8 + 3] = (byte)(soundSample >> 24 & 0xFF);
                    soundToPlay[outIdx * 8 + 4] = (byte)(soundSample >> 32 & 0xFF);
                    soundToPlay[outIdx * 8 + 5] = (byte)(soundSample >> 40 & 0xFF);
                    soundToPlay[outIdx * 8 + 6] = (byte)(soundSample >> 48 & 0xFF);
                    soundToPlay[outIdx * 8 + 7] = (byte)(soundSample >> 56 & 0xFF);
                    break;
                }
                default: {
                    String error = String.valueOf(sampleSize) + " bits per sample not supported!";
                    JOptionPane.showMessageDialog(this.mainGUI, "Analysis Parameters: " + error);
                }
            }
            ++outIdx;
            ++i;
        }
        int duration = (int)Math.ceil((float)(endFrame - startFrame) / sampleRate);
        if (this.playLoopBox.isSelected()) {
            duration = (int)Math.ceil((float)(((Integer)this.playDurationSpinner.getValue() - 1) * (endFrame - startFrame)) / sampleRate);
        }
        try {
            try {
                this.outClip = AudioSystem.getClip();
                ByteArrayInputStream byteStream = new ByteArrayInputStream(soundToPlay);
                AudioInputStream soundStream = new AudioInputStream(byteStream, soundInFormat, soundToPlay.length);
                this.outClip.open(soundStream);
                if (this.outClip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                    this.volumeSlider.setEnabled(true);
                    float gain = this.volumeSlider.getValue();
                    this.gainDB = Utils.convertGainToDB(gain);
                    this.gainControl = (FloatControl)this.outClip.getControl(FloatControl.Type.MASTER_GAIN);
                    this.gainControl.setValue(this.gainDB);
                } else {
                    this.volumeSlider.setEnabled(false);
                }
                this.outClip.addLineListener(new LineListener(){

                    @Override
                    public void update(LineEvent evt) {
                        if (evt.getType() == LineEvent.Type.STOP) {
                            AnalysisParameters.this.outClip.stop();
                            AnalysisParameters.this.outClip.flush();
                            AnalysisParameters.this.outClip.drain();
                            AnalysisParameters.this.outClip.close();
                            AnalysisParameters.this.soundPlaying = false;
                            AnalysisParameters.this.buttonStop.setEnabled(false);
                            AnalysisParameters.this.buttonPlay.setEnabled(true);
                        }
                    }
                });
                if (this.playLoopBox.isSelected()) {
                    this.outClip.loop((Integer)this.playDurationSpinner.getValue() - 1);
                } else {
                    this.outClip.start();
                }
                try {
                    long elapsedTime = 0L;
                    long updateTime = 42L;
                    int pos = 0;
                    this.cursor = 0;
                    while (elapsedTime < (long)(1000 * duration) && this.outClip != null) {
                        pos = this.outClip.getFramePosition();
                        if (pos > 0) {
                            this.cursor = pos % (endFrame - startFrame) + startFrame;
                            this.analysis.getFtInputPanel().setCursor(this.cursor);
                            this.analysis.getftWavePanel().goToSample(this.cursor);
                        }
                        Thread.sleep(updateTime);
                        elapsedTime += updateTime;
                    }
                    this.cursor = -1;
                    this.analysis.getFtInputPanel().setCursor(this.cursor);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (LineUnavailableException l) {
                JOptionPane.showMessageDialog(this.mainGUI, "Audio Line Unavailable Error!\n" + Utils.displayError(l));
                if (this.outClip != null) {
                    this.outClip.stop();
                    this.outClip.flush();
                    this.outClip.drain();
                    this.outClip.close();
                }
                this.soundPlaying = false;
                this.buttonStop.setEnabled(false);
                this.buttonPlay.setEnabled(true);
            }
            catch (IOException io) {
                block37: {
                    JOptionPane.showMessageDialog(this.mainGUI, "Audio I/O Error!\n" + Utils.displayError(io));
                    if (this.outClip == null) break block37;
                    this.outClip.stop();
                    this.outClip.flush();
                    this.outClip.drain();
                    this.outClip.close();
                }
                this.soundPlaying = false;
                this.buttonStop.setEnabled(false);
                this.buttonPlay.setEnabled(true);
            }
            catch (IllegalArgumentException ia) {
                block38: {
                    JOptionPane.showMessageDialog(this.mainGUI, "Audio I/O Error!\n" + Utils.displayError(ia));
                    if (this.outClip == null) break block38;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    this.outClip.stop();
                    this.outClip.flush();
                    this.outClip.drain();
                    this.outClip.close();
                }
                this.soundPlaying = false;
                this.buttonStop.setEnabled(false);
                this.buttonPlay.setEnabled(true);
            }
        }
        finally {
            if (this.outClip != null) {
                this.outClip.stop();
                this.outClip.flush();
                this.outClip.drain();
                this.outClip.close();
            }
            this.soundPlaying = false;
            this.buttonStop.setEnabled(false);
            this.buttonPlay.setEnabled(true);
        }
    }

    public void analWinCloseActions() {
        if (this.outClip != null) {
            this.outClip.stop();
            this.outClip.flush();
            this.outClip.drain();
            this.outClip.close();
        }
        this.soundPlaying = false;
        this.enDisAbleButtonsForData(false);
        this.buttonOpenFile.setEnabled(true);
    }

    public void postNewLogic(int errors) {
        if (errors == 0) {
            this.analysis = new AnalysisWindow(this.mainGUI);
            this.calculateWindowFunction();
            this.actualFilePath = this.myFilePath;
            this.actualFilePath = this.rawWave.getInfoWindow().getFilename();
            this.actualChannel = this.rawWave.getChannelActuallyRead();
            this.ftResultText = this.ftInitialResult;
            this.updateResults();
            if (this.fileInfoWindow != null) {
                this.fileInfoWindow.dispose();
            }
            this.enDisAbleButtonsForData(true);
            this.buttonDFTExport.setEnabled(false);
            this.buttonToSynth.setEnabled(false);
            this.expToSynthNum.setEnabled(false);
            this.expToSynthNumLabel.setEnabled(false);
            this.buttonStop.setEnabled(false);
            this.analysis.setVisible(true);
            this.analysis.setAnalysisTitle(this.myFilePath + " Channel " + this.actualChannel);
            this.analysis.getFtInputPanel().getWavePanel().inputPanLimits();
            this.analysis.getDecayInputPanel().getWavePanel().inputPanLimits();
            this.analysis.stop();
            this.analysis.setCurrentFrame(0);
            this.updateSTFTParameters();
        } else {
            if (this.analysis != null) {
                this.analysis.dispose();
            }
            this.ourFTrunner = null;
            this.ftResultText = this.ftInitialResult;
            this.updateResults();
            if (this.fileInfoWindow != null) {
                this.fileInfoWindow.dispose();
            }
            this.enDisAbleButtonsForData(false);
        }
    }

    private void updateResults() {
        Object transformTitle = "";
        if (this.dFTfFTcZT == FourierTransform.FTtype.FFT) {
            transformTitle = "FAST FOURIER TRANSFORM";
        } else if (this.dFTfFTcZT == FourierTransform.FTtype.DFT) {
            transformTitle = "DISCRETE FOURIER TRANSFORM";
        } else if (this.dFTfFTcZT == FourierTransform.FTtype.CZT) {
            transformTitle = "CHIRP Z-TRANSFORM";
        }
        if (this.currentFTcombine == FTcombine.FTaveraged) {
            transformTitle = (String)transformTitle + " - AVERAGED";
        }
        if (this.currentFTcombine == FTcombine.STFT) {
            transformTitle = (String)transformTitle + " - SHORT TERM FT ANIMATION";
        }
        Object resultText = "DATA SOURCE\n";
        resultText = (String)resultText + "Input file: " + this.actualFilePath + "\n";
        resultText = (String)resultText + "Channel: " + this.actualChannel + "\n";
        resultText = (String)resultText + (String)transformTitle + "\n";
        resultText = (String)resultText + this.ftResultText + "\n";
        resultText = (String)resultText + "DECAY\n";
        resultText = (String)resultText + this.decayResultText + "\n";
        if (this.getAvgLinLog() == AvgScale.AvgLogRel) {
            resultText = (String)resultText + this.avgBtwMarksText;
        }
        this.resultArea.setText((String)resultText);
        this.resultPanel.removeAll();
        this.resultPanel.add(this.resultArea);
        this.resultPanel.revalidate();
        this.resultPanel.repaint();
    }

    public void updateSTFTParameters() {
        this.updateDuration();
    }

    private int calculateCZTsteps() {
        int s = (int)Math.ceil((this.cztFmax - this.cztF0) / this.cztDeltaF) + 1;
        return s;
    }

    private void enDisableLoop(boolean e) {
        this.playLoopTimes.setEnabled(e);
        this.playDurationSpinner.setEnabled(e);
        this.playLoopTimes.setEnabled(e);
    }

    private void enDisableNotesHarmonics() {
        this.showNotes.setEnabled(this.ftShowSpectrum.isSelected());
        this.enDisableNotesFields(this.showNotes.isSelected());
        this.showHarmonics.setEnabled(this.ftShowSpectrum.isSelected());
        this.enDisableHarmonicsFields(this.showHarmonics.isSelected());
    }

    private void enDisableNotesFields(boolean e) {
        this.temperamentBox.setEnabled(e);
        this.aLabel.setEnabled(e);
        this.aField.setEnabled(e);
        this.aHzLabel.setEnabled(e);
    }

    private void enDisableHarmonicsFields(boolean e) {
        this.harmonicsFromLabel.setEnabled(e);
        this.harmonicsFromField.setEnabled(e);
        this.harmonicsHzLabel.setEnabled(e);
    }

    private void enDisableCZT(boolean e) {
        this.f0Label.setEnabled(e);
        this.f0Field.setEnabled(e);
        this.fNLabel.setEnabled(e);
        this.fMaxField.setEnabled(e);
        this.deltaFLabel.setEnabled(e);
        this.deltaField.setEnabled(e);
        this.cztStepsLabel.setEnabled(e);
    }

    private void enDisableFrames(boolean e) {
        this.nFramesLabel.setEnabled(e);
        this.nFramesField.setEnabled(e);
        this.stepLabel.setEnabled(e);
        this.stepSamplesField.setEnabled(e);
        this.durationLabel.setEnabled(e);
    }

    private void playButtonLogic() {
        if (this.fromStartButton.isSelected()) {
            this.toMark1Button.setEnabled(true);
            this.toMark2Button.setEnabled(true);
            this.toEndButton.setEnabled(true);
        }
        if (this.fromMark1Button.isSelected()) {
            this.toMark1Button.setEnabled(false);
            this.toMark2Button.setEnabled(true);
            this.toEndButton.setEnabled(true);
            if (this.toMark1Button.isSelected()) {
                this.toEndButton.setSelected(true);
            }
        }
        if (this.fromMark2Button.isSelected()) {
            this.toMark1Button.setEnabled(false);
            this.toMark2Button.setEnabled(false);
            this.toEndButton.setEnabled(true);
            this.toEndButton.setSelected(true);
            if (this.toMark1Button.isSelected() || this.toMark2Button.isSelected()) {
                this.toEndButton.setSelected(true);
            }
        }
    }

    private void enDisAbleButtonsForData(boolean x) {
        this.buttonReread.setEnabled(x);
        this.buttonPlay.setEnabled(x);
        this.buttonStop.setEnabled(x);
        this.buttonShowInfo.setEnabled(x);
        this.buttonAnalyse.setEnabled(x);
        this.decayAnalyseButton.setEnabled(x);
        if (x) {
            this.enDisableSendToSynth();
        } else {
            this.buttonToSynth.setEnabled(false);
            this.expToSynthNum.setEnabled(false);
            this.expToSynthNumLabel.setEnabled(false);
        }
        this.buttonDFTExport.setEnabled(x);
    }

    private void enDisableSendToSynth() {
        if (this.ftLinButton.isSelected() && !this.analysis.getFtInputPanel().getAnalysisIsStale()) {
            this.buttonToSynth.setEnabled(true);
            this.expToSynthNum.setEnabled(true);
            this.expToSynthNumLabel.setEnabled(true);
        } else {
            this.buttonToSynth.setEnabled(false);
            this.expToSynthNum.setEnabled(false);
            this.expToSynthNumLabel.setEnabled(false);
        }
    }

    private double updateDuration() {
        int sRate = 44000;
        int winSize = 1000;
        if (this.analysis != null) {
            sRate = this.analysis.getFtInputPanel().getSampleRate();
            winSize = this.analysis.getFtInputPanel().getWindowSize();
            this.getAnalysisWindow().getFtInputPanel().setAnalysisIsStale(true);
            this.getAnalysisWindow().repaint();
        }
        double secs = Utils.convertFramesToSecs(this.ftNframes, sRate, winSize, this.ftStepSamples);
        this.durationLabel.setText("covering " + Utils.formatShortTime(secs));
        return secs;
    }

    public boolean isDecayRunning() {
        return this.decayRunning;
    }

    public boolean isFTrunning() {
        return this.ftRunning;
    }

    public int getChannel() {
        if (this.channelLeftButton.isSelected()) {
            return 0;
        }
        return 1;
    }

    public SpectrumBinList[] getFTresult() {
        return this.freqResults;
    }

    public AnalysisWindow getAnalysisWindow() {
        return this.analysis;
    }

    public RawWavFile getRawWave() {
        return this.rawWave;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public double[] getFFTWindowFunction() {
        return this.windowFunction;
    }

    public String getFFTWindowFunctionName() {
        return (String)this.ftWindowBox.getSelectedItem();
    }

    public double getFFTWindowFunctionMax() {
        return this.windowFunctionMax;
    }

    public String getFFTParameterName() {
        return this.ftParameterLabel.getText();
    }

    public String getRawFFTWindowParameter() {
        return this.ftParameterField.getText();
    }

    public double getFFTparameterValue() {
        return this.ftWindowParameter;
    }

    public FourierTransform.FTtype getFTdORf() {
        return this.dFTfFTcZT;
    }

    public FTcombine getFTcombine() {
        return this.currentFTcombine;
    }

    public int getFtStepSamples() {
        return this.ftStepSamples;
    }

    public void setStftStepSamples(int samplesIn) {
        this.ftStepSamples = samplesIn;
        this.stepSamplesField.setText(String.valueOf(samplesIn));
    }

    public int getFtNframes() {
        return this.ftNframes;
    }

    public int getZeroPadding() {
        return (Integer)this.zeroPadSpinner.getValue();
    }

    public double getCZTf0() {
        return this.cztF0;
    }

    public double getCZTfN() {
        return this.cztFmax;
    }

    public double getCZTdeltaF() {
        return this.cztDeltaF;
    }

    public int getCZTnF() {
        return this.cztSteps;
    }

    public boolean getFFTWindowDetail() {
        return this.ftWindowDetailButton.isSelected();
    }

    public boolean getFFTShowWindow() {
        return this.ftShowWindow.isSelected();
    }

    public boolean getFFTShowOriginal() {
        return this.ftShowOriginal.isSelected();
    }

    public boolean getFFTShowFinal() {
        return this.ftShowFinal.isSelected();
    }

    public boolean getFFTShowSpectrum() {
        return this.ftShowSpectrum.isSelected();
    }

    public boolean getFFTShowInput() {
        return this.showInput.isSelected();
    }

    public boolean getFFTShowPhase() {
        return this.ftShowPhase.isSelected();
    }

    public boolean getShowNotes() {
        return this.showNotes.isSelected();
    }

    public double getFreqA() {
        return this.freqA;
    }

    public String getSelectedTemperament() {
        return (String)this.temperamentBox.getSelectedItem();
    }

    public boolean getShowHarmonics() {
        return this.showHarmonics.isSelected();
    }

    public double getFundamental() {
        return this.fundamental;
    }

    public Temperaments getTemperaments() {
        return this.ourTemperaments;
    }

    public boolean getShowAvg() {
        return this.decayShowBox.isSelected();
    }

    public int getDecaySpan() {
        return (Integer)this.decaySpanSpinner.getValue();
    }

    public void calculateWindowFunction() {
        if (this.analysis == null) {
            return;
        }
        int newWindowSize = this.analysis.getFtInputPanel().getWindowSize();
        if (newWindowSize == 0) {
            return;
        }
        this.windowFunction = WindowFunction.windowFunction(this.functionName, newWindowSize, this.ftWindowParameter);
        this.windowFunctionMax = 0.0;
        int i = 0;
        while (i < newWindowSize) {
            if (this.windowFunction[i] > this.windowFunctionMax) {
                this.windowFunctionMax = this.windowFunction[i];
            }
            ++i;
        }
        this.analysis.getFtInputPanel().setAnalysisIsStale(true);
        this.analysis.repaint();
    }

    public FTrunner getFTrunner() {
        return this.ourFTrunner;
    }

    public boolean getFilterDC() {
        return this.ftFilterDCbox.isSelected();
    }

    private void setFtLinLog() {
        this.currentSpectrumScale = this.ftLinButton.isSelected() ? SpectrumScale.SpectrumLinear : (this.ftLogAbsButton.isSelected() ? SpectrumScale.SpectrumLogFS : SpectrumScale.SpectrumLogRel);
    }

    public SpectrumScale getFtLinLog() {
        return this.currentSpectrumScale;
    }

    public double[] getAvgWave() {
        return this.avgWave;
    }

    public double getAvgWaveAbsMax() {
        return this.avgWaveAbsMax;
    }

    public double getDecayGradient() {
        return this.gradient;
    }

    public double getDecayIntersect() {
        return this.intersect;
    }

    public AvgScale getAvgLinLog() {
        if (this.decayLinButton.isSelected()) {
            return AvgScale.AvgLinear;
        }
        return AvgScale.AvgLogRel;
    }

    public void waveFromSynthesis(byte[] sound, int sampleRate, int sampleSize) {
        this.channelLeftButton.setSelected(true);
        this.freqResults = new SpectrumBinList[this.ftNframes];
        this.freqResults[0] = new SpectrumBinList();
        this.windowFunction = null;
        this.ftWindowBox.setSelectedIndex(0);
        this.ftParameterLabel.setVisible(false);
        this.ftParameterField.setVisible(false);
        this.decayAnalyseButton.setEnabled(false);
        if (this.analysis != null) {
            this.analysis.dispose();
        }
        this.rawWave = new RawWavFile(this.mainGUI, sound, sampleRate, sampleSize);
        this.postNewLogic(0);
        this.calculateWindowFunction();
        this.mainGUI.showAnalysisTab();
        this.analysis.setTitle("Analysis: from Synthesis");
    }

    static enum AvgScale {
        AvgLinear,
        AvgLogRel;

    }

    private class DecayWorker
    extends SwingWorker<Void, Void> {
        private DecayWorker() {
        }

        @Override
        public Void doInBackground() {
            AnalysisParameters.this.doDecay();
            return null;
        }

        @Override
        public void done() {
            AnalysisParameters.this.decayProgress.setProgress(0);
            AnalysisParameters.this.decayAnalyseButton.setEnabled(true);
            AnalysisParameters.this.decayRunning = false;
        }
    }

    static enum FTcombine {
        FTsingle,
        FTaveraged,
        STFT;

    }

    static enum SpectrumScale {
        SpectrumLinear,
        SpectrumLogFS,
        SpectrumLogRel;

    }

    private class workPropertyChange
    implements PropertyChangeListener {
        private workPropertyChange() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent p) {
            AnalysisParameters.this.decayProgress.setProgress(AnalysisParameters.this.soFar);
            AnalysisParameters.this.decayProgress.setNote(String.format("Completed %d%%.\n", AnalysisParameters.this.soFar));
            if (AnalysisParameters.this.decayProgress.isCanceled()) {
                AnalysisParameters.this.decayWorker.cancel(true);
            }
            if (AnalysisParameters.this.decayProgress.isCanceled() || AnalysisParameters.this.decayWorker.isDone()) {
                AnalysisParameters.this.decayAnalyseButton.setEnabled(true);
                AnalysisParameters.this.decayRunning = false;
                AnalysisParameters.this.decayProgress.close();
            }
        }
    }
}

