/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import roundtrip.AnalysisParameters;
import roundtrip.AnalysisWindow;
import roundtrip.DecayPanel;
import roundtrip.FRTmain;
import roundtrip.InputPanel;
import roundtrip.QuickPanel;
import roundtrip.RawWavFile;
import roundtrip.Utils;
import roundtrip.YMagPanel;
import roundtrip.ZoomPanPanel;

class WavePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private InputPanel inputOrDecayPanel;
    private WavePanel thisWindow;
    private AnalysisParameters analysisParams;
    private InputPanel.InputFtDecay ftOrDecay;
    private WavePanel otherPanel;
    private ZoomPanPanel zoomPanPanel;
    private QuickPanel quickPanel;
    private YMagPanel yMagPanel;
    private Box statusBox;
    private int xMarginR;
    private int xMarginL;
    private int xWaveBase;
    private int xWaveWidthPx;
    private int samplesPerPixel;
    private int frameLength;
    private int viewRangeSamples;
    private int startTimeSamples;
    private int endTimeSamples;
    private JLabel statusLine = new JLabel("", 2);

    WavePanel(FRTmain mainGUI, AnalysisWindow an, RawWavFile wave, InputPanel.InputFtDecay inFT) {
        this.thisWindow = this;
        this.ftOrDecay = inFT;
        this.zoomPanPanel = new ZoomPanPanel(false);
        Responder zoomPanResponder = new Responder();
        this.zoomPanPanel.addListener(zoomPanResponder);
        this.quickPanel = new QuickPanel(this.thisWindow);
        QuickResponder quickResponder = new QuickResponder();
        this.quickPanel.addListener(quickResponder);
        this.yMagPanel = new YMagPanel();
        YMagResponder yMagResponder = new YMagResponder();
        this.yMagPanel.addListener(yMagResponder);
        this.inputOrDecayPanel = inFT == InputPanel.InputFtDecay.InputFT ? new InputPanel(mainGUI, an, this.thisWindow, this.ftOrDecay) : new DecayPanel(mainGUI, an, this.thisWindow, this.ftOrDecay);
        this.analysisParams = mainGUI.getAnalysisParamsWindow();
        JPanel inputAndYzoom = new JPanel(new BorderLayout());
        inputAndYzoom.add((Component)this.inputOrDecayPanel, "Center");
        this.yMagPanel.setMaximumSize(new Dimension(25, 2000));
        inputAndYzoom.add((Component)this.yMagPanel, "After");
        this.statusBox = Box.createHorizontalBox();
        this.statusBox.add(this.statusLine);
        Box fixedBox = Box.createVerticalBox();
        fixedBox.add(this.quickPanel);
        fixedBox.add(this.zoomPanPanel);
        fixedBox.add(this.statusBox);
        this.setLayout(new BorderLayout());
        this.add((Component)inputAndYzoom, "Center");
        this.add((Component)fixedBox, "Last");
        this.inputPanLimits();
    }

    public void inputPanLimits() {
        this.xMarginL = Utils.getXmarginL();
        this.xMarginR = Utils.getXmarginR();
        this.xWaveBase = this.xMarginL;
        this.xWaveWidthPx = Math.max(this.inputOrDecayPanel.getWidth() - this.xMarginL - this.xMarginR, 1);
        this.frameLength = this.analysisParams.getRawWave().getFrameLength();
        int maxZoomInt = (int)Math.ceil((double)this.frameLength / (double)this.xWaveWidthPx);
        int bend = this.zoomPanPanel.getSliderBend();
        int v = this.zoomPanPanel.getSliderMax() - this.zoomPanPanel.getSliderValue() + 1;
        this.samplesPerPixel = v <= bend ? v : bend + (v - bend) * (maxZoomInt - bend) / (this.zoomPanPanel.getSliderMax() - bend - 1);
        int panScrollVisible = this.viewRangeSamples = Math.min(this.xWaveWidthPx * this.samplesPerPixel, this.frameLength);
        int panScrollEnd = this.frameLength;
        int panScrollStart = 0;
        this.zoomPanPanel.setScrollBlockIncrement(panScrollVisible / 3);
        this.zoomPanPanel.setScrollUnitIncrement(1);
        int panScrollCurrent = Math.min(this.zoomPanPanel.getScrollValue(), panScrollEnd - panScrollVisible);
        this.zoomPanPanel.setScrollValues(panScrollCurrent, panScrollVisible, panScrollStart, panScrollEnd);
        this.zoomPanPanel.repaint();
        this.startTimeSamples = this.zoomPanPanel.getScrollValue();
        this.startTimeSamples = Math.min(this.startTimeSamples, this.frameLength - this.viewRangeSamples);
        this.endTimeSamples = this.startTimeSamples + this.viewRangeSamples;
        this.endTimeSamples = Math.min(this.endTimeSamples, this.frameLength - 1);
        if (this.ftOrDecay == InputPanel.InputFtDecay.InputFT) {
            this.statusLine.setText("Samples/Pixel: " + this.samplesPerPixel + "; Window: " + this.inputOrDecayPanel.getWindowSize() + " samples = " + Utils.formatShortTime(this.inputOrDecayPanel.getWindowPeriod()) + "; Fundamental: " + String.format("%.3f", this.inputOrDecayPanel.getFundamental()) + " Hz");
        } else {
            this.statusLine.setText("Samples/Pixel: " + this.samplesPerPixel + "; Window: " + this.inputOrDecayPanel.getWindowSize() + " samples = " + Utils.formatShortTime(this.inputOrDecayPanel.getWindowPeriod()));
        }
    }

    private void goToStart() {
        this.startTimeSamples = 0;
        this.zoomPanPanel.setScrollValue(0);
        this.inputPanLimits();
        this.inputOrDecayPanel.revalidate();
        this.inputOrDecayPanel.repaint();
        this.zoomPanPanel.scrollRepaint();
    }

    private void goToEnd() {
        this.startTimeSamples = this.frameLength - this.viewRangeSamples;
        this.zoomPanPanel.setScrollValue(this.analysisParams.getRawWave().getFrameLength());
        this.inputPanLimits();
        this.inputOrDecayPanel.revalidate();
        this.inputOrDecayPanel.repaint();
        this.zoomPanPanel.scrollRepaint();
    }

    private void goToMark1() {
        int mark1Samples;
        this.startTimeSamples = mark1Samples = this.inputOrDecayPanel.getMark1Samples();
        this.startTimeSamples = Math.max(this.startTimeSamples, 0);
        this.zoomPanPanel.setScrollValue(this.startTimeSamples - this.samplesPerPixel);
        this.inputPanLimits();
        this.inputOrDecayPanel.revalidate();
        this.inputOrDecayPanel.repaint();
        this.zoomPanPanel.scrollRepaint();
    }

    private void goToWindow() {
        int mark1Samples = this.inputOrDecayPanel.getMark1Samples();
        int windowEnd = this.inputOrDecayPanel.getMark2Samples();
        int maxZoomInt = (int)Math.ceil((double)this.frameLength / (double)this.xWaveWidthPx);
        int sliderMax = this.zoomPanPanel.getSliderMax();
        int bend = this.zoomPanPanel.getSliderBend();
        double newSamplesPerPixel = (double)(windowEnd - mark1Samples + 1) / (double)this.xWaveWidthPx;
        int newSliderValue = 1;
        if (newSamplesPerPixel <= (double)bend) {
            newSliderValue = sliderMax + 1 - (int)Math.ceil(newSamplesPerPixel);
        } else {
            double gradient = ((double)maxZoomInt - (double)bend) / (double)(sliderMax - bend - 1);
            newSliderValue = sliderMax + 0 - ((int)(Math.ceil(newSamplesPerPixel - (double)bend) / gradient) + bend);
        }
        this.zoomPanPanel.setSliderValue(newSliderValue);
        int newViewRangeSamples = windowEnd - mark1Samples;
        newViewRangeSamples = (int)Math.ceil((double)this.xWaveWidthPx * newSamplesPerPixel);
        int newStartTimeSamples = Math.max(mark1Samples, 0);
        this.zoomPanPanel.setScrollValues(newStartTimeSamples, newViewRangeSamples, 0, this.frameLength);
        this.inputPanLimits();
        this.zoomPanPanel.repaint();
    }

    private void goToMark2() {
        int mark2Samples = this.inputOrDecayPanel.getMark2Samples();
        this.startTimeSamples = mark2Samples - this.viewRangeSamples / 2;
        this.startTimeSamples = Math.max(this.startTimeSamples, 0);
        this.zoomPanPanel.setScrollValue(this.startTimeSamples);
        this.inputPanLimits();
        this.inputOrDecayPanel.revalidate();
        this.inputOrDecayPanel.repaint();
        this.zoomPanPanel.scrollRepaint();
    }

    public void goToSample(int s) {
        this.startTimeSamples = s - this.viewRangeSamples / 2;
        this.startTimeSamples = Math.max(this.startTimeSamples, 0);
        this.zoomPanPanel.setScrollValue(this.startTimeSamples);
        this.inputPanLimits();
        this.inputOrDecayPanel.revalidate();
        this.inputOrDecayPanel.repaint();
        this.zoomPanPanel.scrollRepaint();
    }

    private void zoomIn() {
        this.zoomPanPanel.setSliderValue(Math.min(this.zoomPanPanel.getSliderValue() + 1, this.zoomPanPanel.getSliderMax()));
    }

    private void zoomOut() {
        this.zoomPanPanel.setSliderValue(Math.max(this.zoomPanPanel.getSliderValue() - 1, 0));
    }

    private void zoomToMax() {
        this.zoomPanPanel.setSliderValue(this.zoomPanPanel.getSliderMax());
        this.inputPanLimits();
    }

    private void zoomToMin() {
        this.zoomPanPanel.setSliderValue(0);
        this.zoomPanPanel.setScrollValue(0);
        this.inputPanLimits();
    }

    public int getInputYMag() {
        return this.yMagPanel.getSliderValue();
    }

    public InputPanel getInputOrDecayPanel() {
        return this.inputOrDecayPanel;
    }

    public int getXWaveBase() {
        return this.xWaveBase;
    }

    public int getXWaveWidthPx() {
        return this.xWaveWidthPx;
    }

    public int getStartTimeSamples() {
        return this.startTimeSamples;
    }

    public int getEndTimeSamples() {
        return this.endTimeSamples;
    }

    public int getSamplesPerPixel() {
        return this.samplesPerPixel;
    }

    public QuickPanel getQuickPanel() {
        return this.quickPanel;
    }

    public ZoomPanPanel getZoomPanPanel() {
        return this.zoomPanPanel;
    }

    public WavePanel getOtherPanel() {
        return this.otherPanel;
    }

    public void setOtherPanel(WavePanel other) {
        this.otherPanel = other;
    }

    private class QuickResponder
    implements QuickPanel.QuickButtonListener {
        private QuickResponder() {
        }

        @Override
        public void quickEvent(String button) {
            switch (button) {
                case "Start": {
                    WavePanel.this.goToStart();
                    if (!WavePanel.this.quickPanel.isZoomSynced()) break;
                    WavePanel.this.otherPanel.goToStart();
                    break;
                }
                case "End": {
                    WavePanel.this.goToEnd();
                    if (!WavePanel.this.quickPanel.isZoomSynced()) break;
                    WavePanel.this.otherPanel.goToEnd();
                    break;
                }
                case "Mark1": {
                    WavePanel.this.goToMark1();
                    if (!WavePanel.this.quickPanel.isMarkSynced()) break;
                    WavePanel.this.otherPanel.goToMark1();
                    break;
                }
                case "Window": {
                    WavePanel.this.goToWindow();
                    if (!WavePanel.this.quickPanel.isMarkSynced()) break;
                    WavePanel.this.otherPanel.goToWindow();
                    break;
                }
                case "Mark2": {
                    WavePanel.this.goToMark2();
                    if (!WavePanel.this.quickPanel.isMarkSynced()) break;
                    WavePanel.this.otherPanel.goToMark2();
                    break;
                }
                case "ZoomIn": {
                    WavePanel.this.zoomIn();
                    if (!WavePanel.this.quickPanel.isZoomSynced()) break;
                    WavePanel.this.otherPanel.zoomIn();
                    break;
                }
                case "ZoomOut": {
                    if (WavePanel.this.quickPanel.isZoomSynced()) {
                        WavePanel.this.otherPanel.zoomOut();
                    }
                    WavePanel.this.zoomOut();
                    break;
                }
                case "ToMax": {
                    WavePanel.this.zoomToMax();
                    if (!WavePanel.this.quickPanel.isZoomSynced()) break;
                    WavePanel.this.otherPanel.zoomToMax();
                    break;
                }
                case "ToMin": {
                    WavePanel.this.zoomToMin();
                    if (!WavePanel.this.quickPanel.isZoomSynced()) break;
                    WavePanel.this.otherPanel.zoomToMin();
                    break;
                }
                default: {
                    System.out.println("Unexpected button in quick panel.");
                }
            }
        }
    }

    private class Responder
    implements ZoomPanPanel.ZoomPanListener {
        private Responder() {
        }

        @Override
        public void zoomedPanned() {
            WavePanel.this.inputPanLimits();
            WavePanel.this.inputOrDecayPanel.revalidate();
            WavePanel.this.inputOrDecayPanel.repaint();
            if (WavePanel.this.quickPanel.isZoomSynced()) {
                WavePanel.this.otherPanel.getZoomPanPanel().setSliderValue(WavePanel.this.zoomPanPanel.getSliderValue());
                WavePanel.this.otherPanel.getZoomPanPanel().setScrollValue(WavePanel.this.zoomPanPanel.getScrollValue());
                WavePanel.this.otherPanel.inputPanLimits();
                WavePanel.this.otherPanel.revalidate();
                WavePanel.this.otherPanel.repaint();
            }
        }
    }

    private class YMagResponder
    implements YMagPanel.YMagListener {
        private YMagResponder() {
        }

        @Override
        public void yMagEvent() {
            WavePanel.this.inputOrDecayPanel.revalidate();
            WavePanel.this.inputOrDecayPanel.repaint();
        }
    }
}

