/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

class Utils {
    private static String amplitudeLabel = "Amplitude";
    private static String amplitudeDBLabel = "Amplitude [dB]";
    private static String phaseLabel = "Phase";
    private static String angleLabel = "Angle [\u00b0]";
    private static String frequencyLabel = "Frequency";
    private static String indexjNLabel = "Index [j/N]";
    private static final int xMarginL = 60;
    private static final int xMarginR = 15;
    private static final int yMargin = 25;
    private static final int tickLength = 10;
    private static final int tickTextGap = 2;
    private static final int tickTextTextGap = 2;
    private static Font axisFont = new Font("Serif", 0, 10);
    private static Font msgFont = new Font("Serif", 1, 12);
    private static int[] muLawTable;
    private static int[] aLawTable;

    static {
        int[] nArray = new int[256];
        nArray[0] = -32124;
        nArray[1] = -31100;
        nArray[2] = -30076;
        nArray[3] = -29052;
        nArray[4] = -28028;
        nArray[5] = -27004;
        nArray[6] = -25980;
        nArray[7] = -24956;
        nArray[8] = -23932;
        nArray[9] = -22908;
        nArray[10] = -21884;
        nArray[11] = -20860;
        nArray[12] = -19836;
        nArray[13] = -18812;
        nArray[14] = -17788;
        nArray[15] = -16764;
        nArray[16] = -15996;
        nArray[17] = -15484;
        nArray[18] = -14972;
        nArray[19] = -14460;
        nArray[20] = -13948;
        nArray[21] = -13436;
        nArray[22] = -12924;
        nArray[23] = -12412;
        nArray[24] = -11900;
        nArray[25] = -11388;
        nArray[26] = -10876;
        nArray[27] = -10364;
        nArray[28] = -9852;
        nArray[29] = -9340;
        nArray[30] = -8828;
        nArray[31] = -8316;
        nArray[32] = -7932;
        nArray[33] = -7676;
        nArray[34] = -7420;
        nArray[35] = -7164;
        nArray[36] = -6908;
        nArray[37] = -6652;
        nArray[38] = -6396;
        nArray[39] = -6140;
        nArray[40] = -5884;
        nArray[41] = -5628;
        nArray[42] = -5372;
        nArray[43] = -5116;
        nArray[44] = -4860;
        nArray[45] = -4604;
        nArray[46] = -4348;
        nArray[47] = -4092;
        nArray[48] = -3900;
        nArray[49] = -3772;
        nArray[50] = -3644;
        nArray[51] = -3516;
        nArray[52] = -3388;
        nArray[53] = -3260;
        nArray[54] = -3132;
        nArray[55] = -3004;
        nArray[56] = -2876;
        nArray[57] = -2748;
        nArray[58] = -2620;
        nArray[59] = -2492;
        nArray[60] = -2364;
        nArray[61] = -2236;
        nArray[62] = -2108;
        nArray[63] = -1980;
        nArray[64] = -1884;
        nArray[65] = -1820;
        nArray[66] = -1756;
        nArray[67] = -1692;
        nArray[68] = -1628;
        nArray[69] = -1564;
        nArray[70] = -1500;
        nArray[71] = -1436;
        nArray[72] = -1372;
        nArray[73] = -1308;
        nArray[74] = -1244;
        nArray[75] = -1180;
        nArray[76] = -1116;
        nArray[77] = -1052;
        nArray[78] = -988;
        nArray[79] = -924;
        nArray[80] = -876;
        nArray[81] = -844;
        nArray[82] = -812;
        nArray[83] = -780;
        nArray[84] = -748;
        nArray[85] = -716;
        nArray[86] = -684;
        nArray[87] = -652;
        nArray[88] = -620;
        nArray[89] = -588;
        nArray[90] = -556;
        nArray[91] = -524;
        nArray[92] = -492;
        nArray[93] = -460;
        nArray[94] = -428;
        nArray[95] = -396;
        nArray[96] = -372;
        nArray[97] = -356;
        nArray[98] = -340;
        nArray[99] = -324;
        nArray[100] = -308;
        nArray[101] = -292;
        nArray[102] = -276;
        nArray[103] = -260;
        nArray[104] = -244;
        nArray[105] = -228;
        nArray[106] = -212;
        nArray[107] = -196;
        nArray[108] = -180;
        nArray[109] = -164;
        nArray[110] = -148;
        nArray[111] = -132;
        nArray[112] = -120;
        nArray[113] = -112;
        nArray[114] = -104;
        nArray[115] = -96;
        nArray[116] = -88;
        nArray[117] = -80;
        nArray[118] = -72;
        nArray[119] = -64;
        nArray[120] = -56;
        nArray[121] = -48;
        nArray[122] = -40;
        nArray[123] = -32;
        nArray[124] = -24;
        nArray[125] = -16;
        nArray[126] = -8;
        nArray[127] = -1;
        nArray[128] = 32124;
        nArray[129] = 31100;
        nArray[130] = 30076;
        nArray[131] = 29052;
        nArray[132] = 28028;
        nArray[133] = 27004;
        nArray[134] = 25980;
        nArray[135] = 24956;
        nArray[136] = 23932;
        nArray[137] = 22908;
        nArray[138] = 21884;
        nArray[139] = 20860;
        nArray[140] = 19836;
        nArray[141] = 18812;
        nArray[142] = 17788;
        nArray[143] = 16764;
        nArray[144] = 15996;
        nArray[145] = 15484;
        nArray[146] = 14972;
        nArray[147] = 14460;
        nArray[148] = 13948;
        nArray[149] = 13436;
        nArray[150] = 12924;
        nArray[151] = 12412;
        nArray[152] = 11900;
        nArray[153] = 11388;
        nArray[154] = 10876;
        nArray[155] = 10364;
        nArray[156] = 9852;
        nArray[157] = 9340;
        nArray[158] = 8828;
        nArray[159] = 8316;
        nArray[160] = 7932;
        nArray[161] = 7676;
        nArray[162] = 7420;
        nArray[163] = 7164;
        nArray[164] = 6908;
        nArray[165] = 6652;
        nArray[166] = 6396;
        nArray[167] = 6140;
        nArray[168] = 5884;
        nArray[169] = 5628;
        nArray[170] = 5372;
        nArray[171] = 5116;
        nArray[172] = 4860;
        nArray[173] = 4604;
        nArray[174] = 4348;
        nArray[175] = 4092;
        nArray[176] = 3900;
        nArray[177] = 3772;
        nArray[178] = 3644;
        nArray[179] = 3516;
        nArray[180] = 3388;
        nArray[181] = 3260;
        nArray[182] = 3132;
        nArray[183] = 3004;
        nArray[184] = 2876;
        nArray[185] = 2748;
        nArray[186] = 2620;
        nArray[187] = 2492;
        nArray[188] = 2364;
        nArray[189] = 2236;
        nArray[190] = 2108;
        nArray[191] = 1980;
        nArray[192] = 1884;
        nArray[193] = 1820;
        nArray[194] = 1756;
        nArray[195] = 1692;
        nArray[196] = 1628;
        nArray[197] = 1564;
        nArray[198] = 1500;
        nArray[199] = 1436;
        nArray[200] = 1372;
        nArray[201] = 1308;
        nArray[202] = 1244;
        nArray[203] = 1180;
        nArray[204] = 1116;
        nArray[205] = 1052;
        nArray[206] = 988;
        nArray[207] = 924;
        nArray[208] = 876;
        nArray[209] = 844;
        nArray[210] = 812;
        nArray[211] = 780;
        nArray[212] = 748;
        nArray[213] = 716;
        nArray[214] = 684;
        nArray[215] = 652;
        nArray[216] = 620;
        nArray[217] = 588;
        nArray[218] = 556;
        nArray[219] = 524;
        nArray[220] = 492;
        nArray[221] = 460;
        nArray[222] = 428;
        nArray[223] = 396;
        nArray[224] = 372;
        nArray[225] = 356;
        nArray[226] = 340;
        nArray[227] = 324;
        nArray[228] = 308;
        nArray[229] = 292;
        nArray[230] = 276;
        nArray[231] = 260;
        nArray[232] = 244;
        nArray[233] = 228;
        nArray[234] = 212;
        nArray[235] = 196;
        nArray[236] = 180;
        nArray[237] = 164;
        nArray[238] = 148;
        nArray[239] = 132;
        nArray[240] = 120;
        nArray[241] = 112;
        nArray[242] = 104;
        nArray[243] = 96;
        nArray[244] = 88;
        nArray[245] = 80;
        nArray[246] = 72;
        nArray[247] = 64;
        nArray[248] = 56;
        nArray[249] = 48;
        nArray[250] = 40;
        nArray[251] = 32;
        nArray[252] = 24;
        nArray[253] = 16;
        nArray[254] = 8;
        muLawTable = nArray;
        aLawTable = new int[]{-5504, -5248, -6016, -5760, -4480, -4224, -4992, -4736, -7552, -7296, -8064, -7808, -6528, -6272, -7040, -6784, -2752, -2624, -3008, -2880, -2240, -2112, -2496, -2368, -3776, -3648, -4032, -3904, -3264, -3136, -3520, -3392, -22016, -20992, -24064, -23040, -17920, -16896, -19968, -18944, -30208, -29184, -32256, -31232, -26112, -25088, -28160, -27136, -11008, -10496, -12032, -11520, -8960, -8448, -9984, -9472, -15104, -14592, -16128, -15616, -13056, -12544, -14080, -13568, -344, -328, -376, -360, -280, -264, -312, -296, -472, -456, -504, -488, -408, -392, -440, -424, -88, -72, -120, -104, -24, -8, -56, -40, -216, -200, -248, -232, -152, -136, -184, -168, -1376, -1312, -1504, -1440, -1120, -1056, -1248, -1184, -1888, -1824, -2016, -1952, -1632, -1568, -1760, -1696, -688, -656, -752, -720, -560, -528, -624, -592, -944, -912, -1008, -976, -816, -784, -880, -848, 5504, 5248, 6016, 5760, 4480, 4224, 4992, 4736, 7552, 7296, 8064, 7808, 6528, 6272, 7040, 6784, 2752, 2624, 3008, 2880, 2240, 2112, 2496, 2368, 3776, 3648, 4032, 3904, 3264, 3136, 3520, 3392, 22016, 20992, 24064, 23040, 17920, 16896, 19968, 18944, 30208, 29184, 32256, 31232, 26112, 25088, 28160, 27136, 11008, 10496, 12032, 11520, 8960, 8448, 9984, 9472, 15104, 14592, 16128, 15616, 13056, 12544, 14080, 13568, 344, 328, 376, 360, 280, 264, 312, 296, 472, 456, 504, 488, 408, 392, 440, 424, 88, 72, 120, 104, 24, 8, 56, 40, 216, 200, 248, 232, 152, 136, 184, 168, 1376, 1312, 1504, 1440, 1120, 1056, 1248, 1184, 1888, 1824, 2016, 1952, 1632, 1568, 1760, 1696, 688, 656, 752, 720, 560, 528, 624, 592, 944, 912, 1008, 976, 816, 784, 880, 848};
    }

    static void calibrateY(Graphics2D g2d, double scale, double maxAmplitude, int xBase, int yBase, int xWidth, AxisOmit0 omit0, AxisOmitNeg omitNeg, AxisExtendYticks extTicks, int nTicks, String label) {
        g2d.setFont(axisFont);
        FontMetrics metrics = g2d.getFontMetrics(axisFont);
        int maxLabelWidth = 0;
        int tickXend = extTicks.equals((Object)AxisExtendYticks.ExtendYticks) ? xBase + xWidth : xBase + 5;
        double deltaTick = maxAmplitude / (double)nTicks;
        g2d.drawLine(xBase - 5, yBase, tickXend, yBase);
        String numP = "0.0";
        if (omit0.equals((Object)AxisOmit0.KEEP0)) {
            g2d.drawString(numP, xBase - 2 - metrics.stringWidth(numP) - 5, yBase + metrics.getDescent());
            maxLabelWidth = metrics.stringWidth(numP);
        }
        double currentTick = deltaTick;
        NumberFormat tickFormat = NumberFormat.getInstance();
        tickFormat.setMinimumFractionDigits(0);
        tickFormat.setMaximumFractionDigits(2);
        tickFormat.setGroupingUsed(false);
        int i = 0;
        while (i < nTicks) {
            numP = tickFormat.format(currentTick);
            int tickY = (int)Math.round(scale * currentTick);
            g2d.drawLine(xBase - 5, yBase - tickY, tickXend, yBase - tickY);
            g2d.drawString(numP, xBase - 2 - metrics.stringWidth(numP) - 5, yBase - tickY + metrics.getDescent());
            maxLabelWidth = Math.max(maxLabelWidth, metrics.stringWidth(numP));
            if (omitNeg.equals((Object)AxisOmitNeg.KEEP_NEG)) {
                String numN = tickFormat.format(-currentTick);
                g2d.drawLine(xBase - 5, yBase + tickY, tickXend, yBase + tickY);
                g2d.drawString(numN, xBase - 2 - metrics.stringWidth(numN) - 5, yBase + tickY + metrics.getDescent());
                maxLabelWidth = Math.max(maxLabelWidth, metrics.stringWidth(numN));
            }
            currentTick += deltaTick;
            ++i;
        }
        int bottom = yBase;
        if (omitNeg.equals((Object)AxisOmitNeg.KEEP_NEG)) {
            bottom = yBase + (int)Math.round(scale * maxAmplitude);
        }
        g2d.drawLine(xBase, bottom, xBase, yBase - (int)Math.ceil(scale * maxAmplitude));
        int labelY = yBase;
        if (omitNeg.equals((Object)AxisOmitNeg.OMIT_NEG)) {
            labelY = bottom - (int)Math.round(scale * maxAmplitude) / 2;
        }
        if (label != null) {
            Utils.drawVertical(g2d, label, xBase - maxLabelWidth - 5 - metrics.getDescent() - 2, labelY);
        }
    }

    static void calibrateYPhase(Graphics2D g2d, double scale, int xBase, int yBase, AxisOmitNeg omitNeg, String label) {
        g2d.setFont(axisFont);
        FontMetrics metrics = g2d.getFontMetrics(axisFont);
        int nTicks = 2;
        int maxLabelWidth = 0;
        double top = Math.PI;
        String pi = "\u03c0";
        double deltaTick = top / (double)nTicks;
        g2d.drawLine(xBase - 5, yBase, xBase + 5, yBase);
        Object numP = "0.0";
        g2d.drawString((String)numP, xBase - 2 - metrics.stringWidth((String)numP) - 5, yBase + metrics.getDescent());
        maxLabelWidth = metrics.stringWidth((String)numP);
        double currentTick = top;
        numP = pi;
        int i = 0;
        while (i < nTicks) {
            String numN = "-" + (String)numP;
            int distance = (int)Math.round(scale * currentTick);
            g2d.drawLine(xBase - 5, yBase - distance, xBase + 5, yBase - distance);
            g2d.drawString((String)numP, xBase - 2 - metrics.stringWidth((String)numP) - 5, yBase - distance + metrics.getDescent());
            maxLabelWidth = Math.max(maxLabelWidth, metrics.stringWidth((String)numP));
            if (omitNeg.equals((Object)AxisOmitNeg.KEEP_NEG)) {
                g2d.drawLine(xBase - 5, yBase + distance, xBase + 5, yBase + distance);
                g2d.drawString(numN, xBase - 2 - metrics.stringWidth(numN) - 5, yBase + distance + metrics.getDescent());
                maxLabelWidth = Math.max(maxLabelWidth, metrics.stringWidth(numN));
            }
            currentTick -= deltaTick;
            numP = pi + "/2";
            ++i;
        }
        int bottom = yBase;
        if (omitNeg.equals((Object)AxisOmitNeg.KEEP_NEG)) {
            bottom = yBase + (int)Math.round(scale * top);
        }
        g2d.drawLine(xBase, bottom, xBase, yBase - (int)Math.round(scale * top));
        int labelY = yBase;
        if (omitNeg.equals((Object)AxisOmitNeg.OMIT_NEG)) {
            labelY = bottom - (int)Math.round(scale * top) / 2;
        }
        if (label != null) {
            Utils.drawVertical(g2d, label, xBase - maxLabelWidth - 5 - metrics.getDescent() - 2, labelY);
        }
    }

    static void calibrateX(Graphics2D g2d, double scale, double startValue, double endValue, int xBase, int yBase, AxisOmit0 omit0, AxisOmitNeg omitNeg, int nTicks, String label) {
        g2d.setFont(axisFont);
        FontMetrics metrics = g2d.getFontMetrics(axisFont);
        double deltaTickValue = (endValue - startValue) / (double)nTicks;
        String numP = Utils.niceK(startValue, 3);
        if (omit0.equals((Object)AxisOmit0.KEEP0)) {
            g2d.drawString(numP, xBase - metrics.stringWidth(numP) / 2, yBase + metrics.getAscent() + 5 + 2);
            g2d.drawLine(xBase, yBase - 5, xBase, yBase + 5);
        }
        double currentTickValue = startValue + deltaTickValue;
        int i = 0;
        while (i < nTicks) {
            numP = Utils.niceK(currentTickValue, 3);
            int tickX = (int)Math.round(scale * (currentTickValue - startValue));
            g2d.drawLine(xBase + tickX, yBase + 5, xBase + tickX, yBase - 5);
            g2d.drawString(numP, xBase + tickX - metrics.stringWidth(numP) / 2, yBase + metrics.getAscent() + 5 + 2);
            if (omitNeg.equals((Object)AxisOmitNeg.KEEP_NEG)) {
                String numN = Utils.niceK(-currentTickValue, 3);
                g2d.drawLine(xBase - tickX, yBase + 5, xBase - tickX, yBase - 5);
                g2d.drawString(numN, xBase - tickX - metrics.stringWidth(numN) / 2, yBase + metrics.getAscent() + 5 + 2);
            }
            currentTickValue += deltaTickValue;
            ++i;
        }
        int xStart = xBase;
        if (omitNeg.equals((Object)AxisOmitNeg.KEEP_NEG)) {
            xStart = xBase - (int)Math.round(scale * endValue);
        }
        g2d.drawLine(xStart, yBase, xBase + (int)Math.round(scale * (endValue - startValue)), yBase);
        if (label != null) {
            int centrePx = xBase;
            if (omitNeg.equals((Object)AxisOmitNeg.OMIT_NEG)) {
                centrePx = xBase + (int)Math.round(scale * endValue / 2.0);
            }
            g2d.drawString(label, centrePx - metrics.stringWidth(label) / 2, yBase + metrics.getHeight() + metrics.getAscent() + 5 + 2);
        }
    }

    static void calibrateXint(Graphics2D g2d, double scale, int firstTick, int lastTick, double startFreq, double factor, int xBase, int yBase, String label) {
        g2d.setFont(axisFont);
        FontMetrics metrics = g2d.getFontMetrics(axisFont);
        int deltaTickValue = 1;
        int tickXtick = 0;
        int tickXstring = 0;
        int tickYstring = 0;
        Rectangle2D prevBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        Rectangle2D.Double tickBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        Rectangle2D tickBoundsString = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        int currentTickValue = firstTick;
        while (currentTickValue <= lastTick) {
            String numP = Utils.niceK(startFreq + (double)currentTickValue * factor, 3);
            tickXtick = xBase + (int)Math.round(scale * (double)(currentTickValue - firstTick));
            tickXstring = tickXtick - metrics.stringWidth(numP) / 2;
            tickYstring = yBase + metrics.getAscent() + 5 + 2;
            tickBoundsString = metrics.getStringBounds(numP, g2d);
            ((Rectangle2D)tickBounds).setRect(tickXstring, tickYstring, tickBoundsString.getWidth() + 2.0, tickBoundsString.getHeight());
            if (!tickBounds.intersects(prevBounds)) {
                g2d.drawLine(tickXtick, yBase + 5, tickXtick, yBase - 5);
                g2d.drawString(numP, tickXstring, tickYstring);
                prevBounds = (Rectangle2D)tickBounds.clone();
            }
            currentTickValue += deltaTickValue;
        }
        int xStart = xBase;
        g2d.drawLine(xStart, yBase, xBase + (int)Math.round(scale * (double)(lastTick - firstTick)), yBase);
        if (label != null) {
            int centrePx = xBase + (int)Math.round(scale * (double)lastTick / 2.0);
            g2d.drawString(label, centrePx - metrics.stringWidth(label) / 2, yBase + metrics.getHeight() + metrics.getAscent() + 5 + 2);
        }
    }

    static void calibrateXTime(Graphics2D g2d, int xBase, int widthPx, int xStartTimeSamples, int samplesPerPx, float frameRate, int yBase) {
        g2d.setFont(axisFont);
        FontMetrics metrics = g2d.getFontMetrics(axisFont);
        int nTicks = 20;
        double distBtwTicks = (double)widthPx / (double)nTicks;
        double time = 0.0;
        int xPos = 0;
        double relXPos = 0.0;
        Rectangle2D tickBounds = metrics.getStringBounds("0.000", g2d);
        int tickX = xPos - metrics.stringWidth("0.000") / 2;
        int tickY = yBase + metrics.getAscent() + 5 + 2;
        Rectangle2D prevBounds = new Rectangle2D.Double(tickX, tickY, tickBounds.getWidth() + 2.0, tickBounds.getHeight());
        int i = 0;
        while (i <= nTicks) {
            relXPos = distBtwTicks * (double)i;
            xPos = (int)Math.round((double)xBase + relXPos);
            double sample = relXPos * (double)samplesPerPx;
            time = ((double)xStartTimeSamples + sample) / (double)frameRate;
            String timeStr = String.format("%.3f", time);
            tickBounds = metrics.getStringBounds(timeStr, g2d);
            tickX = xPos;
            tickY = yBase + metrics.getAscent() + 5 + 2;
            tickBounds.setRect(tickX, tickY, tickBounds.getWidth() + 2.0, tickBounds.getHeight());
            if (!tickBounds.intersects(prevBounds)) {
                g2d.drawLine(xPos, yBase + 5, xPos, yBase - 5);
                g2d.drawString(timeStr, xPos - metrics.stringWidth(timeStr) / 2, yBase + metrics.getAscent() + 5 + 2);
                prevBounds = (Rectangle2D)tickBounds.clone();
            }
            ++i;
        }
    }

    private static void drawVertical(Graphics2D g2d, String text, int x, int y) {
        g2d.setFont(axisFont);
        FontMetrics metrics = g2d.getFontMetrics(axisFont);
        AffineTransform orig = g2d.getTransform();
        g2d.rotate(-1.5707963267948966);
        g2d.drawString(text, -y - metrics.stringWidth(text) / 2, x);
        g2d.setTransform(orig);
    }

    static String ordinalSuffix(int num) {
        switch (num % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    static double getNiceAxisTop(double inMax) {
        double top = 0.0;
        double max = Math.abs(inMax);
        if (max < 1.0) {
            top = 1.0;
            while (top > max) {
                top /= 10.0;
            }
            top *= 10.0;
        } else {
            top = max >= 1.0 && max < 10.0 ? Math.ceil(max) : (max >= 10.0 && max < 1000.0 ? Math.ceil(max / 10.0) * 10.0 : Math.ceil(max / 100.0) * 100.0);
        }
        return top * Math.signum(inMax);
    }

    static String niceK(double n, int maxDecimals) {
        NumberFormat tickFormat = NumberFormat.getInstance();
        tickFormat.setMinimumFractionDigits(0);
        tickFormat.setMaximumFractionDigits(maxDecimals);
        tickFormat.setGroupingUsed(false);
        Object numP = Math.abs(n) >= 1000.0 ? tickFormat.format(n / 1000.0) + "k" : tickFormat.format(n);
        return numP;
    }

    static float convertGainToDB(float g) {
        float gain = g;
        if (gain == 0.0f) {
            gain = 0.01f;
        }
        float gainDB = (float)(Math.log(gain / 100.0f) / Math.log(10.0) * 20.0);
        return gainDB;
    }

    static double convertSamplesToSecs(int s, int sRate) {
        double tmpS = (double)s / (double)sRate;
        return tmpS;
    }

    private static int convertFramesToDurationSamples(int frames, int winSize, int step) {
        int samples = step * (frames - 1) + winSize;
        return samples;
    }

    static double convertFramesToSecs(int frames, int sRate, int winSize, int step) {
        int samples = Utils.convertFramesToDurationSamples(frames, winSize, step);
        return Utils.convertSamplesToSecs(samples, sRate);
    }

    static String displayError(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String stackTrace = sw.toString();
        return stackTrace.replace(System.getProperty("line.separator"), "\n");
    }

    static int muLawDecompress(int sample) {
        if (sample < 256 && sample >= 0) {
            return muLawTable[sample];
        }
        return 0;
    }

    static int aLawDecompress(int sample) {
        if (sample < 256 && sample >= 0) {
            return aLawTable[sample];
        }
        return 0;
    }

    static double parseLocalDouble(String text) {
        double numD;
        NumberFormat localNumFmt = NumberFormat.getInstance(Locale.getDefault());
        try {
            Number num = localNumFmt.parse(text);
            numD = num.doubleValue();
        }
        catch (ParseException p) {
            numD = Double.NaN;
        }
        return numD;
    }

    static String formatTime(double msecs) {
        Locale currentLocale = Locale.getDefault();
        DecimalFormatSymbols ourSymbols = new DecimalFormatSymbols(currentLocale);
        ourSymbols.setGroupingSeparator(' ');
        DecimalFormat realFormatter = new DecimalFormat("###,##0.000", ourSymbols);
        double secondsInMilli = 1000.0;
        double minutesInMilli = secondsInMilli * 60.0;
        double hoursInMilli = minutesInMilli * 60.0;
        double daysInMilli = hoursInMilli * 24.0;
        double remainder = msecs;
        long elapsedDays = (long)(remainder / daysInMilli);
        long elapsedHours = (long)((remainder %= daysInMilli) / hoursInMilli);
        long elapsedMinutes = (long)((remainder %= hoursInMilli) / minutesInMilli);
        double elapsedSeconds = (remainder %= minutesInMilli) / secondsInMilli;
        Object result = "";
        if (elapsedDays != 0L) {
            result = (String)result + String.valueOf(elapsedDays) + " Days ";
        }
        if (elapsedHours != 0L) {
            result = (String)result + String.valueOf(elapsedHours) + " Hours ";
        }
        if (elapsedMinutes != 0L) {
            result = (String)result + String.valueOf(elapsedMinutes) + " Minutes ";
        }
        result = (String)result + realFormatter.format(elapsedSeconds) + " Seconds";
        return result;
    }

    static String formatShortTime(double s) {
        double t = s;
        String units = " S";
        if (s < 0.001) {
            t = s * 1000000.0;
            units = " \u00b5S";
        } else if (s < 1.0) {
            t = s * 1000.0;
            units = " mS";
        }
        String result = String.format("%.3f", t) + units;
        return result;
    }

    static double fact(double in) {
        double result = 1.0;
        int i = 1;
        while ((double)i <= in) {
            result *= (double)i;
            ++i;
        }
        return result;
    }

    public static String getAmplitudeLabel() {
        return amplitudeLabel;
    }

    public static String getAmplitudeDBLabel() {
        return amplitudeDBLabel;
    }

    public static String getIndexLabel() {
        return indexjNLabel;
    }

    public static String getPhaseLabel() {
        return phaseLabel;
    }

    public static String getAngleLabel() {
        return angleLabel;
    }

    public static String getFrequencyLabel() {
        return frequencyLabel;
    }

    public static int getXmarginL() {
        return 60;
    }

    public static int getXmarginR() {
        return 15;
    }

    public static int getYmargin() {
        return 25;
    }

    static Font getAxisFont() {
        return axisFont;
    }

    static Font getMsgFont() {
        return msgFont;
    }

    static enum AxisExtendYticks {
        No_ExtendYticks,
        ExtendYticks;

    }

    static enum AxisOmit0 {
        OMIT0,
        KEEP0;

    }

    static enum AxisOmitNeg {
        OMIT_NEG,
        KEEP_NEG;

    }
}

