/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import roundtrip.ComponentPanel;
import roundtrip.FRTmain;
import roundtrip.SynthesisParameters;
import roundtrip.SynthesisedWave;
import roundtrip.SynthesisedWavePanel;
import roundtrip.Utils;

class SynthesisWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private FRTmain ourGUI;
    private SynthesisParameters synthesisParams;
    private SynthesisWindow thisSynth;
    private SynthesisedWavePanel drawing;
    private ComponentPanel components;
    private double scale;
    private SynthesisedWave theWave;
    private boolean initialising = true;
    private LineBorder panelsBorder;
    private Box waveAndSlider = Box.createVerticalBox();
    private JSlider angleSlider = new JSlider(0, 360, 0);
    private String angleSliderTip = "<html>Use the slider to traverse the result wave and the figure.<br>The figure is generated from the vectors (angle and length) of the component waves.</html>";

    SynthesisWindow(FRTmain main) {
        this.setTitle("Synthesis");
        this.ourGUI = main;
        this.thisSynth = this;
        this.synthesisParams = this.ourGUI.getSynthParams();
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.panelsBorder = new LineBorder(Color.lightGray, 3);
        Point newPos = new Point(this.ourGUI.getSynthLastPosition().x, this.ourGUI.getSynthLastPosition().y + 27);
        this.setLocation(newPos);
        this.setPreferredSize(this.ourGUI.getSynthLastSize());
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            boolean dls = (Boolean)tk.getDesktopProperty("awt.dynamicLayoutSupported");
            if (dls) {
                tk.setDynamicLayout(false);
            } else {
                System.out.println("Setting dynamic layout is not supported, so window resizing might have poor performance.");
            }
        }
        catch (HeadlessException h) {
            System.out.println("Headless Exception");
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SynthesisWindow.this.ourGUI.getSynthParams().synthesisClosed();
                SynthesisWindow.this.ourGUI.setSynthLastSize(SynthesisWindow.this.thisSynth.getSize());
                SynthesisWindow.this.ourGUI.setSynthLastPosition(SynthesisWindow.this.thisSynth.getLocation());
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                SynthesisWindow.this.ourGUI.setSynthLastSize(SynthesisWindow.this.thisSynth.getSize());
                SynthesisWindow.this.ourGUI.setSynthLastPosition(SynthesisWindow.this.thisSynth.getLocation());
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ce) {
                if (!SynthesisWindow.this.initialising) {
                    SynthesisWindow.this.recalculate(true, false, false);
                }
            }
        });
        this.drawing = new SynthesisedWavePanel(this.ourGUI, this);
        this.drawing.setPreferredSize(new Dimension(this.getWidth(), this.getHeight() / 2));
        TitledBorder topTitle = new TitledBorder(this.panelsBorder, "Resultant Wave and Figures", 2, 2);
        this.drawing.setBorder(topTitle);
        this.waveAndSlider = Box.createVerticalBox();
        this.waveAndSlider.add(this.drawing);
        this.angleSlider.setMajorTickSpacing(10);
        this.angleSlider.setMinorTickSpacing(1);
        this.angleSlider.setPaintTicks(true);
        this.angleSlider.setPaintLabels(true);
        this.angleSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.angleSlider.addChangeListener(new SliderListener());
        this.angleSlider.setToolTipText(this.angleSliderTip);
        this.waveAndSlider.add(this.angleSlider);
        this.add(this.waveAndSlider);
        this.components = new ComponentPanel(this.ourGUI, this.thisSynth);
        this.components.setPreferredSize(new Dimension(this.getWidth(), this.getHeight() / 2));
        TitledBorder bottomTitle = new TitledBorder(this.panelsBorder, "Component Waves and Spectrum", 2, 2);
        this.components.setBorder(bottomTitle);
        this.add(this.components);
        this.pack();
        this.setVisible(true);
        this.theWave = new SynthesisedWave();
    }

    public void setComponentSpectrumVisible(Boolean v) {
        this.components.setVisible(v);
        this.components.repaint();
    }

    void recalculate(boolean doWave, boolean doSound, boolean play) {
        int waveWidth = this.thisSynth.getWidth() / 2 - Utils.getXmarginL() * 2;
        this.theWave.waveRenew(this.ourGUI, this.synthesisParams.getHarmonicList(), this.synthesisParams.getFrequency(), waveWidth, doWave, doSound, play);
    }

    public ComponentPanel getComponentPanel() {
        return this.components;
    }

    public SynthesisedWave getWave() {
        return this.theWave;
    }

    public void clearInitialising() {
        this.initialising = false;
    }

    public int getEffectiveHeight() {
        return this.getHeight() / 2 - 3 * Utils.getYmargin() - this.angleSlider.getHeight();
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double s) {
        this.scale = s;
    }

    private class SliderListener
    implements ChangeListener {
        private SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            int angle = source.getValue();
            SynthesisWindow.this.drawing.setVectorAngle(angle);
            SynthesisWindow.this.drawing.repaint();
        }
    }
}

