/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import roundtrip.AnalysisParameters;
import roundtrip.FRTmain;
import roundtrip.FourierTransform;
import roundtrip.Temperaments;
import roundtrip.Utils;
import roundtrip.YMagPanel;
import roundtrip.ZoomPanPanel;

class SpectrumPlotPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FRTmain ourGUI;
    private SpectrumPlotPanel ourPanel;
    private AnalysisParameters analysisParams;
    private ZoomPanPanel ourZoomPanel;
    private YMagPanel ourYMagPanel;
    private int frame = 0;
    private static final int spectrumXFirstLine = 10;
    private int spectrumHeight;
    private int freqAxisHeight = 22;
    private int xSpectrumWidthPx;
    private int ySpectrumBase;
    private int yAxisBase;
    private String yAxisLabel;
    private double maxAmplitude;
    private double niceMaxAmplitude;
    private double spectrumYScale;
    private double niceDBLimit;
    private double yTop;

    SpectrumPlotPanel(FRTmain mainGUI, ZoomPanPanel zPanel, YMagPanel yPanel) {
        this.ourGUI = mainGUI;
        this.ourPanel = this;
        this.ourZoomPanel = zPanel;
        this.ourYMagPanel = yPanel;
        this.analysisParams = mainGUI.getAnalysisParamsWindow();
    }

    @Override
    public void paintComponent(Graphics g) {
        int freqPan;
        super.paintComponent(g);
        int yMargin = Utils.getYmargin();
        this.spectrumHeight = this.getHeight() - 3 * yMargin;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.ourGUI.getSettings().getAnalysisBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.frame >= this.analysisParams.getFTresult().length || this.analysisParams.getFTresult()[this.frame] == null || this.analysisParams.getFTrunner() == null) {
            return;
        }
        g2d.setStroke(new BasicStroke(1.0f));
        int xMarginL = Utils.getXmarginL();
        int xMarginR = Utils.getXmarginR();
        int xSpectrumBase = xMarginL;
        int spectrumXstart = 10;
        this.xSpectrumWidthPx = this.getWidth() - xMarginL - xMarginR - 10;
        int yMag = this.ourYMagPanel.getSliderValue();
        if (this.analysisParams.getAnalysisWindow().getFtInputPanel().getAnalysisIsStale()) {
            g2d.setColor(this.ourGUI.getSettings().getFFTStalecolor());
            g2d.setFont(Utils.getMsgFont());
            String staleString = "Stale";
            FontMetrics metrics = g2d.getFontMetrics(Utils.getMsgFont());
            g2d.drawString(staleString, 0, metrics.getHeight());
        }
        int spectrumX1 = 0;
        int spectrumY2 = 0;
        int nFreqs = this.analysisParams.getFTresult()[0].getSize();
        if (nFreqs <= 0) {
            return;
        }
        int panExt = this.ourZoomPanel.getSliderValue();
        int startIdx = freqPan = this.ourZoomPanel.getScrollValue();
        int endIdx = freqPan + panExt;
        if (this.analysisParams.isFTrunning() || endIdx >= this.analysisParams.getFTresult()[0].getSize()) {
            return;
        }
        double endFreq = this.analysisParams.getFTresult()[this.frame].getBinByIndex(endIdx).getFreqFactor();
        double xScale = (double)this.xSpectrumWidthPx / (endFreq - this.analysisParams.getFTresult()[this.frame].getBinByIndex(startIdx).getFreqFactor());
        AnalysisParameters.SpectrumScale scaling = this.analysisParams.getFtLinLog();
        switch (scaling) {
            case SpectrumLinear: {
                this.ySpectrumBase = this.spectrumHeight + yMargin;
                this.maxAmplitude = this.analysisParams.getFTcombine().equals((Object)AnalysisParameters.FTcombine.STFT) ? this.analysisParams.getFTrunner().getOverallSTFTmaxAmp() : this.analysisParams.getFTresult()[this.frame].getMaxAmp();
                this.niceMaxAmplitude = Utils.getNiceAxisTop(this.maxAmplitude / (double)yMag);
                this.spectrumYScale = (double)this.spectrumHeight / this.niceMaxAmplitude;
                this.yAxisBase = this.ySpectrumBase;
                this.yTop = this.niceMaxAmplitude;
                this.yAxisLabel = Utils.getAmplitudeLabel();
                break;
            }
            case SpectrumLogFS: 
            case SpectrumLogRel: {
                this.ySpectrumBase = this.spectrumHeight + yMargin;
                this.maxAmplitude = this.analysisParams.getFTresult()[this.frame].getMinAmp();
                double yMagAsLimit = -((51 - yMag) * 4);
                this.niceDBLimit = Utils.getNiceAxisTop(yMagAsLimit);
                this.yAxisBase = yMargin;
                this.yTop = this.niceDBLimit;
                this.spectrumYScale = (double)this.spectrumHeight / Utils.getNiceAxisTop(-this.niceDBLimit);
                this.yAxisLabel = Utils.getAmplitudeDBLabel();
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.ourGUI, "SpectrumPanel: Invalid value for spectrum scaling:" + String.valueOf((Object)scaling));
            }
        }
        g2d.setColor(this.ourGUI.getSettings().getPlotColor());
        double spectrumStepPx = (double)this.xSpectrumWidthPx / (double)panExt;
        int idx = startIdx;
        double amplitude = 0.0;
        int i = 0;
        while (i <= panExt) {
            amplitude = this.analysisParams.getFTresult()[this.frame].getBinByIndex(idx).getAmplitude();
            spectrumX1 = xSpectrumBase + spectrumXstart + (int)Math.round((double)i * spectrumStepPx);
            if (scaling.equals((Object)AnalysisParameters.SpectrumScale.SpectrumLinear)) {
                spectrumY2 = this.ySpectrumBase - (int)Math.round(amplitude * this.spectrumYScale);
            } else {
                double limitedAmplitude = Math.max(amplitude, this.niceDBLimit);
                spectrumY2 = this.yAxisBase - (int)Math.round(limitedAmplitude * this.spectrumYScale);
            }
            g2d.drawLine(spectrumX1, this.ySpectrumBase, spectrumX1, spectrumY2);
            idx = Math.min(idx + 1, nFreqs - 1);
            ++i;
        }
        int freqAxisYBase = this.spectrumHeight + yMargin + this.freqAxisHeight;
        g2d.setColor(this.ourGUI.getSettings().getAxisColor());
        Utils.calibrateXint(g2d, xScale, startIdx, endIdx, 0.0, 1.0, xSpectrumBase + spectrumXstart, this.ySpectrumBase, null);
        Utils.calibrateY(g2d, this.spectrumYScale, this.yTop, xSpectrumBase, this.yAxisBase, this.xSpectrumWidthPx, Utils.AxisOmit0.KEEP0, Utils.AxisOmitNeg.OMIT_NEG, Utils.AxisExtendYticks.No_ExtendYticks, 4, this.yAxisLabel);
        double startFreq = 0.0;
        double freqDelta = (double)this.analysisParams.getAnalysisWindow().getFtInputPanel().getSampleRate() / (double)this.analysisParams.getFTrunner().getFFTexpandedSize();
        if (this.analysisParams.getFTdORf() == FourierTransform.FTtype.CZT) {
            startFreq = this.analysisParams.getCZTf0();
            freqDelta = this.analysisParams.getCZTdeltaF();
        }
        Utils.calibrateXint(g2d, xScale, startIdx, endIdx, startFreq, freqDelta, xSpectrumBase + spectrumXstart, freqAxisYBase, Utils.getFrequencyLabel());
        FontMetrics metrics = g2d.getFontMetrics(Utils.getAxisFont());
        g2d.drawString("Hz", xSpectrumBase + 10 - metrics.stringWidth("Hz "), freqAxisYBase + metrics.getDescent());
        if (this.analysisParams.getShowNotes()) {
            g2d.setColor(this.ourGUI.getSettings().getSpectrumNotesColor());
            Temperaments music = this.analysisParams.getTemperaments();
            double firstFreq = startFreq + (double)startIdx * freqDelta;
            double lastFreq = startFreq + (double)endIdx * freqDelta;
            Rectangle2D prevBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            Rectangle2D.Double nameBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            Rectangle2D nameBoundsString = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            int nNotes = (int)(Math.log(this.analysisParams.getRawWave().getSampleRate() / 2) / Math.log(2.0) * 12.0);
            int i2 = 0;
            while (i2 < nNotes) {
                Temperaments.ScaleNote note = music.getFrequencyByIndex(i2);
                double freq = note.frequency();
                if (freq >= firstFreq && freq <= lastFreq) {
                    int y1 = this.ySpectrumBase;
                    int y2 = this.ySpectrumBase - this.spectrumHeight;
                    nameBoundsString = metrics.getStringBounds(note.name(), g2d);
                    int x = (int)Math.round((double)(xSpectrumBase + spectrumXstart) + (freq - firstFreq) / freqDelta * xScale);
                    int xString = x - metrics.stringWidth(note.name()) / 2;
                    ((Rectangle2D)nameBounds).setRect(xString, y2, nameBoundsString.getWidth() + 2.0, nameBoundsString.getHeight());
                    if (!nameBounds.intersects(prevBounds)) {
                        g2d.drawLine(x, y1, x, y2);
                        g2d.drawString(note.name(), xString, y2);
                        prevBounds = (Rectangle2D)nameBounds.clone();
                    }
                }
                ++i2;
            }
        }
        if (this.analysisParams.getShowHarmonics()) {
            double fundamental;
            g2d.setColor(this.ourGUI.getSettings().getSpectrumHarmonicsColor());
            double firstFreq = startFreq + (double)startIdx * freqDelta;
            double lastFreq = startFreq + (double)endIdx * freqDelta;
            double freq = fundamental = this.analysisParams.getFundamental();
            int harmonic = 0;
            while (freq <= lastFreq) {
                if (freq >= firstFreq) {
                    int y1 = this.ySpectrumBase;
                    int y2 = this.ySpectrumBase - this.spectrumHeight;
                    int x = (int)Math.round((double)(xSpectrumBase + spectrumXstart) + (freq - firstFreq) / freqDelta * xScale);
                    String harmonicName = String.valueOf(harmonic);
                    int xString = x - metrics.stringWidth(harmonicName) / 2;
                    g2d.drawLine(x, y1, x, y2);
                    g2d.drawString(harmonicName, xString, y2 - metrics.getHeight());
                }
                freq = fundamental * (double)(++harmonic + 1);
            }
        }
    }

    public int getSpectrumPlotWidth() {
        return this.xSpectrumWidthPx;
    }

    public void setFrame(int f) {
        this.frame = f;
        this.ourPanel.repaint();
    }
}

