/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import roundtrip.AnalysisParameters;
import roundtrip.FRTmain;
import roundtrip.SpectrumPlotPanel;
import roundtrip.YMagPanel;
import roundtrip.ZoomPanPanel;

class SpectrumPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private AnalysisParameters analysisParams;
    private ZoomPanPanel zoomPanPanel;
    private YMagPanel yMagPanel;
    private SpectrumPlotPanel plotPanel;
    private int spectrumPanExtent;

    SpectrumPanel(FRTmain mainGUI, ZoomPanPanel zoomPanPanel) {
        this.zoomPanPanel = zoomPanPanel;
        this.analysisParams = mainGUI.getAnalysisParamsWindow();
        this.yMagPanel = new YMagPanel();
        YMagResponder yMagResponder = new YMagResponder();
        this.yMagPanel.addListener(yMagResponder);
        this.plotPanel = new SpectrumPlotPanel(mainGUI, zoomPanPanel, this.yMagPanel);
        JPanel spectrumAndYzoom = new JPanel(new BorderLayout());
        spectrumAndYzoom.add((Component)this.plotPanel, "Center");
        this.yMagPanel.setMaximumSize(new Dimension(25, 2000));
        spectrumAndYzoom.add((Component)this.yMagPanel, "After");
        this.setLayout(new BorderLayout());
        this.add((Component)spectrumAndYzoom, "Center");
        this.spectrumPanLimits();
    }

    void spectrumPanLimits() {
        int XmagCurrent;
        if (this.zoomPanPanel.isSliderAdjusting() && this.zoomPanPanel.isScrollAdjusting()) {
            return;
        }
        int nFreqs = this.analysisParams.getFTresult()[0].getSize();
        if (nFreqs <= 1) {
            return;
        }
        this.zoomPanPanel.setSliderMax(nFreqs - 1);
        this.zoomPanPanel.setSliderMin(1);
        this.spectrumPanExtent = XmagCurrent = this.zoomPanPanel.getSliderValue();
        int panScrollStart = 0;
        int panScrollEnd = nFreqs - 1;
        int panScrollCurrent = Math.min(this.zoomPanPanel.getScrollValue(), panScrollEnd - this.spectrumPanExtent);
        this.zoomPanPanel.setScrollBlockIncrement(Math.max(this.spectrumPanExtent / 3, 1));
        this.zoomPanPanel.setScrollUnitIncrement(1);
        this.zoomPanPanel.setScrollValues(panScrollCurrent, this.spectrumPanExtent, panScrollStart, panScrollEnd);
        this.zoomPanPanel.repaint();
    }

    public SpectrumPlotPanel getSpectrumPlotPanel() {
        return this.plotPanel;
    }

    public YMagPanel getSpectrumYMagPanel() {
        return this.yMagPanel;
    }

    public int getSpectrumPlotWidth() {
        return this.plotPanel.getSpectrumPlotWidth();
    }

    private class YMagResponder
    implements YMagPanel.YMagListener {
        private YMagResponder() {
        }

        @Override
        public void yMagEvent() {
            SpectrumPanel.this.plotPanel.revalidate();
            SpectrumPanel.this.plotPanel.repaint();
        }
    }
}

