/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.util.ArrayList;
import java.util.Comparator;
import roundtrip.SpectrumBin;

class SpectrumBinList {
    private ArrayList<SpectrumBin> bins = new ArrayList();
    private double minFreq = 0.0;
    private double maxFreq = 0.0;
    private double minAmp = 0.0;
    private double maxAmp = 0.0;

    public SpectrumBinList() {
        this.bins.clear();
        this.minFreq = Double.MAX_VALUE;
        this.maxFreq = Double.MIN_VALUE;
        this.minAmp = Double.MAX_VALUE;
        this.maxAmp = Double.MIN_VALUE;
    }

    private void setMinMaxFreq() {
        this.minFreq = Double.MAX_VALUE;
        this.maxFreq = Double.MIN_VALUE;
        if (!this.bins.isEmpty()) {
            int i = 0;
            while (i < this.bins.size()) {
                this.maxFreq = Math.max(this.maxFreq, this.bins.get(i).getFreqFactor());
                this.minFreq = Math.min(this.minFreq, this.bins.get(i).getFreqFactor());
                ++i;
            }
        }
    }

    private void setMinMaxAmp() {
        this.minAmp = Double.MAX_VALUE;
        this.maxAmp = Double.MIN_VALUE;
        if (!this.bins.isEmpty()) {
            int i = 0;
            while (i < this.bins.size()) {
                this.maxAmp = Math.max(this.maxAmp, this.bins.get(i).getAmplitude());
                this.minAmp = Math.min(this.minAmp, this.bins.get(i).getAmplitude());
                ++i;
            }
        }
    }

    public int getSize() {
        return this.bins.size();
    }

    void addSpectrumBin(SpectrumBin f) {
        this.bins.add(f);
        this.maxFreq = Math.max(this.maxFreq, f.getFreqFactor());
        this.minFreq = Math.min(this.minFreq, f.getFreqFactor());
        this.maxAmp = Math.max(this.maxAmp, f.getAmplitude());
        this.minAmp = Math.min(this.minAmp, f.getAmplitude());
    }

    public SpectrumBin getBinByIndex(int idx) {
        return this.bins.get(idx);
    }

    public double[] getFrequenciesAsArray() {
        double[] tmp = new double[this.bins.size()];
        int i = 0;
        while (i < this.bins.size()) {
            tmp[i] = this.bins.get(i).getFreqFactor();
            ++i;
        }
        return tmp;
    }

    public double[] getAmplitudesAsArray() {
        double[] tmp = new double[this.bins.size()];
        int i = 0;
        while (i < this.bins.size()) {
            tmp[i] = this.bins.get(i).getAmplitude();
            ++i;
        }
        return tmp;
    }

    public void removeBinByIndex(int idx) {
        this.bins.remove(idx);
        this.setMinMaxFreq();
        this.setMinMaxAmp();
    }

    public void clearBinList() {
        this.bins.clear();
        this.minFreq = Double.MAX_VALUE;
        this.maxFreq = Double.MIN_VALUE;
        this.minAmp = Double.MAX_VALUE;
        this.maxAmp = Double.MIN_VALUE;
    }

    public double getMaxFreq() {
        return this.maxFreq;
    }

    public double getMinFreq() {
        return this.minFreq;
    }

    public double getMaxAmp() {
        return this.maxAmp;
    }

    public double getMinAmp() {
        return this.minAmp;
    }

    public void setFrequencyOfIndex(int index, double f) {
        SpectrumBin h = this.bins.get(index);
        h.setFreqFactor(f);
        this.bins.set(index, h);
        this.setMinMaxFreq();
    }

    public void setAmplitudeOfIndex(int index, double a) {
        SpectrumBin h = this.bins.get(index);
        h.setAmplitude(a);
        this.bins.set(index, h);
        this.setMinMaxAmp();
    }

    public void setPhaseOfIndex(int index, double p) {
        SpectrumBin h = this.bins.get(index);
        h.setPhase(p);
        this.bins.set(index, h);
    }

    public void radToDeg() {
        int i = 0;
        while (i < this.bins.size()) {
            SpectrumBin tmp = this.bins.get(i);
            tmp.setPhase(Math.toDegrees(tmp.getPhase()));
            this.bins.set(i, tmp);
            ++i;
        }
    }

    public void makeSawtooth(int n, boolean lin, double x) {
        this.clearBinList();
        int i = 1;
        while (i <= n) {
            double f = i;
            double a = 1.0;
            a = lin ? 1.0 / (double)i : Math.pow(x, i - 1);
            SpectrumBin tmp = new SpectrumBin(f, a, 0.0);
            this.addSpectrumBin(tmp);
            ++i;
        }
    }

    public void makeSquare(int n, boolean lin, double x) {
        this.clearBinList();
        int i = 1;
        while (i <= n * 2) {
            double f = i;
            double a = 1.0;
            a = lin ? 1.0 / (double)i : Math.pow(x, i - 1);
            SpectrumBin tmp = new SpectrumBin(f, a, 0.0);
            this.addSpectrumBin(tmp);
            i += 2;
        }
    }

    public void makeTriangle(int n) {
        this.clearBinList();
        int i = 1;
        while (i <= n * 2) {
            double f = i;
            double a = Math.pow(-1.0, (i + 3) / 2) * 1.0 / (double)(i * i);
            SpectrumBin tmp = new SpectrumBin(f, a, 0.0);
            this.addSpectrumBin(tmp);
            i += 2;
        }
    }

    public void sortBins(SpectrumSortBy criterion) {
        switch (criterion) {
            case FREQUENCYUP: {
                this.bins.sort(new FreqSorterUp());
                break;
            }
            case FREQUENCYDOWN: {
                this.bins.sort(new FreqSorterDown());
                break;
            }
            case AMPLITUDEUP: {
                this.bins.sort(new AmpSorterUp());
                break;
            }
            case AMPLITUDEDOWN: {
                this.bins.sort(new AmpSorterDown());
                break;
            }
            case PHASEUP: {
                this.bins.sort(new PhaseSorterUp());
                break;
            }
            case PHASEDOWN: {
                this.bins.sort(new PhaseSorterDown());
                break;
            }
        }
    }

    private class AmpSorterDown
    implements Comparator<SpectrumBin> {
        private AmpSorterDown() {
        }

        @Override
        public int compare(SpectrumBin o1, SpectrumBin o2) {
            if (o1.getAmplitude() > o2.getAmplitude()) {
                return -1;
            }
            if (o1.getAmplitude() < o2.getAmplitude()) {
                return 1;
            }
            if (o1.getAmplitude() == o2.getAmplitude()) {
                return 0;
            }
            return 0;
        }
    }

    private class AmpSorterUp
    implements Comparator<SpectrumBin> {
        private AmpSorterUp() {
        }

        @Override
        public int compare(SpectrumBin o1, SpectrumBin o2) {
            if (o1.getAmplitude() < o2.getAmplitude()) {
                return -1;
            }
            if (o1.getAmplitude() > o2.getAmplitude()) {
                return 1;
            }
            if (o1.getAmplitude() == o2.getAmplitude()) {
                return 0;
            }
            return 0;
        }
    }

    private class FreqSorterDown
    implements Comparator<SpectrumBin> {
        private FreqSorterDown() {
        }

        @Override
        public int compare(SpectrumBin o1, SpectrumBin o2) {
            if (o1.getFreqFactor() > o2.getFreqFactor()) {
                return -1;
            }
            if (o1.getFreqFactor() < o2.getFreqFactor()) {
                return 1;
            }
            if (o1.getFreqFactor() == o2.getFreqFactor()) {
                return 0;
            }
            return 0;
        }
    }

    private class FreqSorterUp
    implements Comparator<SpectrumBin> {
        private FreqSorterUp() {
        }

        @Override
        public int compare(SpectrumBin o1, SpectrumBin o2) {
            if (o1.getFreqFactor() < o2.getFreqFactor()) {
                return -1;
            }
            if (o1.getFreqFactor() > o2.getFreqFactor()) {
                return 1;
            }
            if (o1.getFreqFactor() == o2.getFreqFactor()) {
                return 0;
            }
            return 0;
        }
    }

    private class PhaseSorterDown
    implements Comparator<SpectrumBin> {
        private PhaseSorterDown() {
        }

        @Override
        public int compare(SpectrumBin o1, SpectrumBin o2) {
            if (o1.getPhase() > o2.getPhase()) {
                return -1;
            }
            if (o1.getPhase() < o2.getPhase()) {
                return 1;
            }
            if (o1.getPhase() == o2.getPhase()) {
                return 0;
            }
            return 0;
        }
    }

    private class PhaseSorterUp
    implements Comparator<SpectrumBin> {
        private PhaseSorterUp() {
        }

        @Override
        public int compare(SpectrumBin o1, SpectrumBin o2) {
            if (o1.getPhase() < o2.getPhase()) {
                return -1;
            }
            if (o1.getPhase() > o2.getPhase()) {
                return 1;
            }
            if (o1.getPhase() == o2.getPhase()) {
                return 0;
            }
            return 0;
        }
    }

    public static enum SpectrumSortBy {
        FREQUENCYUP,
        AMPLITUDEUP,
        PHASEUP,
        FREQUENCYDOWN,
        AMPLITUDEDOWN,
        PHASEDOWN;

    }
}

