/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import roundtrip.FRTmain;
import roundtrip.FileInfo;
import roundtrip.Utils;

class RawWavFile {
    private File inFile;
    private Reader reader;
    private Reader buffer;
    private ProgressMonitor progress;
    private ReadWorker readWorker;
    private int soFar;
    private int errorCount;
    private boolean readFileOK = true;
    private PostProcessing post;
    private int fileSize;
    private int actualFileSize;
    private int formatChunkSize;
    private int factChunkSize;
    private int listChunkSize;
    private int dataChunkSize;
    private int id3ChunkSize;
    private int totalLengthRead;
    private boolean gotFormat;
    private int formatCode;
    private Format format;
    private int numChannels;
    private int samplesPerSec;
    private int avgBytesPerSec;
    private int blockAlign;
    private int bitsPerSample;
    private int convertedBitsPerSample;
    private boolean is8bitSigned;
    private int extSize;
    private int validBits;
    private int channelMask;
    private int guidData1;
    private int guidData2;
    private int guidData3;
    private int guidData4;
    private int guidData5;
    private int factSamplesPerChannel;
    private int frameLength;
    private int bytesPerChannel;
    private int convertedBytesPerChannel;
    private double audioDuration;
    private int channelToRead;
    private Map<Integer, Format> formats = new HashMap<Integer, Format>();
    private double[] audioIntLin;
    private double minAmplitude;
    private double maxAmplitude;
    private double absMaxAmplitude;
    private int maxAbsSample;
    private double[] audioIntLog;
    private double absMaxAmplitudeLog;
    private double limitLogDB = -100.0;
    private double limitLogExp;
    private JFrame mainFrame;
    private FRTmain mainGUI;
    private FileInfo fileInfoWindow;

    RawWavFile(FRTmain parentGUI, File file) {
        this.mainGUI = parentGUI;
        this.mainFrame = parentGUI.getMainWindow();
        this.inFile = file;
        try {
            FileInputStream inStream = new FileInputStream(this.inFile);
            this.reader = new InputStreamReader((InputStream)inStream, StandardCharsets.ISO_8859_1);
            this.buffer = new BufferedReader(this.reader);
        }
        catch (IOException e) {
            ++this.errorCount;
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception creating file input stream - " + e.getMessage());
            return;
        }
        this.limitLogExp = Math.pow(10.0, this.limitLogDB / 20.0);
        this.formats.put(1, Format.WAVE_FORMAT_PCM);
        this.formats.put(3, Format.WAVE_FORMAT_IEEE_FLOAT);
        this.formats.put(6, Format.WAVE_FORMAT_ALAW);
        this.formats.put(7, Format.WAVE_FORMAT_MULAW);
        this.formats.put(65534, Format.WAVE_FORMAT_EXTENSIBLE);
        this.fileInfoWindow = new FileInfo();
        this.fileInfoWindow.setVisible(false);
        this.fileInfoWindow.addFilename(this.inFile.getAbsolutePath());
    }

    RawWavFile(FRTmain parentGUI, byte[] audio, int sr, int ss) {
        this.mainGUI = parentGUI;
        this.mainFrame = parentGUI.getMainWindow();
        this.samplesPerSec = sr;
        this.convertedBitsPerSample = this.bitsPerSample = ss;
        this.maxAbsSample = (int)Math.pow(2.0, this.bitsPerSample - 1) - 1;
        ByteArrayInputStream inStream = new ByteArrayInputStream(audio);
        this.reader = new InputStreamReader((InputStream)inStream, StandardCharsets.ISO_8859_1);
        this.buffer = new BufferedReader(this.reader);
        this.dataChunkSize = audio.length;
        this.bytesPerChannel = this.bitsPerSample / 8;
        this.convertedBytesPerChannel = this.bitsPerSample / 8;
        this.blockAlign = this.bytesPerChannel;
        this.frameLength = audio.length / this.blockAlign;
        this.numChannels = 1;
        this.channelToRead = 0;
        this.format = Format.WAVE_FORMAT_PCM;
        this.is8bitSigned = true;
        this.readData(this.buffer, this.channelToRead);
        this.createWaveDB();
        this.fileInfoWindow = new FileInfo();
        this.fileInfoWindow.setVisible(false);
        this.fileInfoWindow.addFilename("Data from Synthesis");
        this.fileInfoWindow.add("Sample Rate", String.valueOf(this.samplesPerSec), "Samples per Second");
        this.fileInfoWindow.add("Bits per Sample", String.valueOf(16), "Bits");
        this.fileInfoWindow.add("Frame Length", String.valueOf(this.frameLength), "Frames");
        this.fileInfoWindow.add("Maximum Amplitude", String.valueOf(this.absMaxAmplitude), "");
        this.fileInfoWindow.add("Calculated Duration", String.valueOf((double)this.frameLength / (double)this.samplesPerSec), "Seconds");
    }

    void readFile(PostProcessing post) {
        this.post = post;
        this.is8bitSigned = false;
        this.progress = new ProgressMonitor(this.mainGUI, "Reading File", "", 0, 100);
        this.soFar = 0;
        this.progress.setProgress(this.soFar);
        this.progress.setNote(String.format("0 Completed %d%%.\n", this.soFar));
        this.progress.setMillisToDecideToPopup(100);
        this.progress.setMillisToPopup(200);
        this.readWorker = new ReadWorker();
        this.readWorker.addPropertyChangeListener(new workPropertyChange());
        this.readWorker.execute();
    }

    /*
     * Exception decompiling
     */
    private boolean readFileDo() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [52[CASE]], but top level block is 29[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int read4LengthRound(Reader inBuf) {
        try {
            int l3 = inBuf.read();
            int l2 = inBuf.read();
            int l1 = inBuf.read();
            int l0 = inBuf.read();
            int length = (l0 & 0xFF) << 24 | (l1 & 0xFF) << 16 | (l2 & 0xFF) << 8 | l3 & 0xFF;
            if ((length & 1) != 0) {
                ++length;
            }
            return length;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading 4-byte length - " + e.getMessage());
            return -1;
        }
    }

    private int read4LengthSyncSafe(Reader inBuf) {
        try {
            int l0 = inBuf.read();
            int l1 = inBuf.read();
            int l2 = inBuf.read();
            int l3 = inBuf.read();
            int length = 0;
            length = (l0 & 0x80) != 0 | (l1 & 0x80) != 0 | (l2 & 0x80) != 0 | (l3 & 0x80) != 0 ? (l0 & 0xFF) << 24 | (l1 & 0xFF) << 16 | (l2 & 0xFF) << 8 | l3 & 0xFF : (l0 & 0x7F) << 23 | (l1 & 0x7F) << 15 | (l2 & 0x7F) << 7 | l3 & 0x7F;
            return length;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading 4-byte sync-safe length - " + e.getMessage());
            return -1;
        }
    }

    private int read2LengthRound(Reader inBuf) {
        try {
            int l1 = inBuf.read();
            int l0 = inBuf.read();
            int length = (l0 & 0xFF) << 8 | l1 & 0xFF;
            if ((length & 1) != 0) {
                ++length;
            }
            return length;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading 2-byte length - " + e.getMessage());
            return -1;
        }
    }

    private String readChunkID(Reader inBuf) {
        Object s = "";
        try {
            int i = 0;
            while (i < 4) {
                char ch = (char)inBuf.read();
                if (ch == '\u0000') {
                    ch = (char)inBuf.read();
                }
                s = (String)s + Character.toString(ch);
                ++i;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading chunk ID - " + e.getMessage());
        }
        return ((String)s).toUpperCase();
    }

    private String readTagName(Reader inBuf) {
        Object s = "";
        try {
            int i = 0;
            while (i < 4) {
                char ch = (char)inBuf.read();
                if (ch == '\u0000') {
                    ch = (char)inBuf.read();
                }
                s = (String)s + Character.toString(ch);
                ++i;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading tag name - " + e.getMessage());
        }
        return s;
    }

    private int read4ByteValue(Reader inBuf) {
        try {
            int l3 = inBuf.read();
            int l2 = inBuf.read();
            int l1 = inBuf.read();
            int l0 = inBuf.read();
            int length = (l0 & 0xFF) << 24 | (l1 & 0xFF) << 16 | (l2 & 0xFF) << 8 | l3 & 0xFF;
            return length;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading 4-byte big-endian length - " + e.getMessage());
            return -1;
        }
    }

    private String read3ByteString(Reader inBuf) {
        try {
            char c0 = (char)(inBuf.read() & 0xFF);
            char c1 = (char)(inBuf.read() & 0xFF);
            char c2 = (char)(inBuf.read() & 0xFF);
            String result = Character.toString(c0) + Character.toString(c1) + Character.toString(c2);
            return result;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading 3-byte string - " + e.getMessage());
            return "";
        }
    }

    private int read2ByteValue(Reader inBuf) {
        try {
            int l1 = inBuf.read();
            int l0 = inBuf.read();
            int length = (l0 & 0xFF) << 8 | l1 & 0xFF;
            return length;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading 2-byte length - " + e.getMessage());
            return -1;
        }
    }

    private int read1ByteValue(Reader inBuf) {
        try {
            int l0 = inBuf.read();
            return l0 &= 0xFF;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading 2-byte length - " + e.getMessage());
            return -1;
        }
    }

    private String readImageString(Reader inBuf, int n) {
        String s = "";
        byte[] asBytes = new byte[n];
        byte[] lineTerminator = new byte[]{10};
        try {
            int i = 0;
            while (i < n) {
                asBytes[i] = (byte)inBuf.read();
                ++i;
            }
            s = Base64.getMimeEncoder(76, lineTerminator).encodeToString(asBytes);
            return s;
        }
        catch (IOException | IllegalArgumentException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception converting to base64 - " + e.getMessage());
            return "";
        }
    }

    private String readNByteStringSkipNulls(Reader inBuf, int n) {
        Object s = "";
        try {
            int i = 0;
            while (i < n) {
                char ch = (char)inBuf.read();
                if (ch != '\u0000') {
                    s = (String)s + Character.toString(ch);
                }
                ++i;
            }
            return s;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading n-byte length - " + e.getMessage());
            return "";
        }
    }

    private String readNullTerminated(Reader inBuf) {
        Object result = "";
        char ch = '\u0001';
        try {
            while (ch != '\u0000') {
                ch = (char)inBuf.read();
                if (ch != '\u0000') {
                    result = (String)result + Character.toString(ch);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading null terminated string - " + e.getMessage());
            return "";
        }
        return result;
    }

    private static boolean testBitMask(int value, int mask) {
        boolean result = false;
        if ((value & mask) != 0) {
            result = true;
        }
        return result;
    }

    private void readInfo(Reader inBuf, int listSize) {
        int done = 4;
        while (done < listSize) {
            String tagName = this.readTagName(inBuf);
            String tagClear = RawWavFile.tagToClear(tagName);
            int tagLength = this.read4LengthRound(inBuf);
            String tag = this.readTagName(tagLength, inBuf);
            done += tagLength + 8;
            this.fileInfoWindow.add("LIST.INFO." + tagName + " " + tagClear, tag, "");
        }
    }

    private static String tagToClear(String tag) {
        String[][] table = new String[][]{{"IART", "Artist"}, {"ICMT", "Comment."}, {"ICOP", "Copyright"}, {"ICRD", "Creation date"}, {"IENG", "Engineer"}, {"IGNR", "Genre"}, {"IKEY", "Keywords"}, {"INAM", "Track title"}, {"IPRD", "Album title"}, {"ISFT", "Software used"}, {"ISRF", "Original form"}, {"ITCH", "Technician"}, {"ITRK", "Track number"}, {"ISBJ", "Subject"}, {"ISRC", "Source"}};
        int i = 0;
        while (i < table.length) {
            if (tag.equals(table[i][0])) {
                return table[i][1];
            }
            ++i;
        }
        return "Unknown tag " + tag;
    }

    private static String id3TagToClear(String tag) {
        String[][] table = new String[][]{{"AENC", "Audio encryption"}, {"APIC", "Attached picture"}, {"ASPI", "Audio seek point index"}, {"COMM", "Comments"}, {"COMR", "Commercial frame"}, {"ENCR", "Encryption method registration"}, {"EQUA", "Equalisation"}, {"EQU2", "Equalisation (2)"}, {"ETCO", "Event timing codes"}, {"GEOB", "General encapsulated object"}, {"GRID", "Group identification registration"}, {"IPLS", "Involved people list"}, {"LINK", "Linked information"}, {"MCDI", "Music CD identifier"}, {"MLLT", "MPEG location lookup table"}, {"OWNE", "Ownership frame"}, {"PRIV", "Private frame"}, {"PCNT", "Play counter"}, {"POPM", "Popularimeter"}, {"POSS", "Position synchronisation frame"}, {"RBUF", "Recommended buffer size"}, {"RVAD", "Relative volume adjustment"}, {"RVA2", "Relative volume adjustment (2)"}, {"RVRB", "Reverb"}, {"SEEK", "Seek frame"}, {"SIGN", "Signature frame"}, {"SYLT", "Synchronised lyric/text"}, {"SYTC", "Synchronised tempo codes"}, {"TALB", "Album/Movie/Show title"}, {"TBPM", "BPM (beats per minute)"}, {"TCOM", "Composer"}, {"TCON", "Content type"}, {"TCOP", "Copyright message"}, {"TDAT", "Date"}, {"TDEN", "Encoding time"}, {"TDLY", "Playlist delay"}, {"TDOR", "Original release time"}, {"TDRC", "Recording time"}, {"TDRL", "Release time"}, {"TDTG", "Tagging time"}, {"TENC", "Encoded by"}, {"TEXT", "Lyricist/Text writer"}, {"TFLT", "File type"}, {"TIME", "Time"}, {"TIPL", "Involved people list"}, {"TIT1", "Content group description"}, {"TIT2", "Title/songname/content description"}, {"TIT3", "Subtitle/Description refinement"}, {"TKEY", "Initial key"}, {"TLAN", "Language(s)"}, {"TLEN", "Length"}, {"TMCL", "Musician credits list"}, {"TMED", "Media type"}, {"TMOO", "Mood"}, {"TOAL", "Original album/movie/show title"}, {"TOFN", "Original filename"}, {"TOLY", "Original lyricist(s)/text writer(s)"}, {"TOPE", "Original artist(s)/performer(s)"}, {"TOWN", "File owner/licensee"}, {"TPE1", "Lead performer(s)/Soloist(s)"}, {"TPE2", "Band/orchestra/accompaniment"}, {"TPE3", "Conductor/performer refinement"}, {"TPE4", "Interpreted, remixed, or otherwise modified by"}, {"TPOS", "Part of a set"}, {"TPRO", "Produced notice"}, {"TPUB", "Publisher"}, {"TRCK", "Track number/Position in set"}, {"TRDA", "Recording dates"}, {"TRSN", "Internet radio station name"}, {"TRSO", "Internet radio station owner"}, {"TSOA", "Album sort order"}, {"TSOP", "Performer sort order"}, {"TSOT", "Title sort order"}, {"TSIZ", "Size"}, {"TSRC", "ISRC (international standard recording code)"}, {"TSSE", "Software/Hardware and settings used for encoding"}, {"TSST", "Set subtitle"}, {"TYER", "Year"}, {"TXXX", "User defined text information frame"}, {"UFID", "Unique file identifier"}, {"USER", "Terms of use"}, {"USLT", "Unsynchronised lyric/text transcription"}, {"WCOM", "Commercial information"}, {"WCOP", "Copyright/Legal information"}, {"WOAF", "Official audio file webpage"}, {"WOAR", "Official artist/performer webpage"}, {"WOAS", "Official audio source webpage"}, {"WORS", "Official Internet radio station homepage"}, {"WPAY", "Payment"}, {"WPUB", "Publishers official webpage"}, {"WXXX", "User defined URL link frame"}};
        int i = 0;
        while (i < table.length) {
            if (tag.equals(table[i][0])) {
                return table[i][1];
            }
            ++i;
        }
        return "Unknown tag " + tag;
    }

    private String textEncodingToClear(int enc) {
        switch (enc) {
            case 0: {
                return "ISO-8859-1";
            }
            case 1: {
                return "UTF-16";
            }
            case 2: {
                return "UTF-16BE";
            }
            case 3: {
                return "UTF-8 ";
            }
        }
        return "Unknown encoding " + enc;
    }

    private String pictureTypeToClear(int type) {
        switch (type) {
            case 0: {
                return "Other";
            }
            case 1: {
                return "32x32 pixels 'file icon' (PNG only)";
            }
            case 2: {
                return "Other file icon";
            }
            case 3: {
                return "Cover (front)";
            }
            case 4: {
                return "Cover (back)";
            }
            case 5: {
                return "Leaflet page";
            }
            case 6: {
                return "Media (e.g. label side of CD)";
            }
            case 7: {
                return "Lead artist/lead performer/soloist";
            }
            case 8: {
                return "Artist/performer";
            }
            case 9: {
                return "Conductor";
            }
            case 10: {
                return "Band/Orchestra";
            }
            case 11: {
                return "Composer";
            }
            case 12: {
                return "Lyricist/text writer";
            }
            case 13: {
                return "Recording Location";
            }
            case 14: {
                return "During recording";
            }
            case 15: {
                return "During performance";
            }
            case 16: {
                return "Movie/video screen capture";
            }
            case 17: {
                return "A bright coloured fish";
            }
            case 18: {
                return "Illustration";
            }
            case 19: {
                return "Band/artist logotype";
            }
            case 20: {
                return "Publisher/Studio logotype";
            }
        }
        return "Unknown picture type " + type;
    }

    private String readTagName(int length, Reader inBuf) {
        Object s = "";
        try {
            int i = 0;
            while (i < length) {
                s = (String)s + Character.toString((char)inBuf.read());
                ++i;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading tag content - " + e.getMessage());
        }
        return s;
    }

    private String readTagContent(int length, Reader inBuf) {
        Object s = "";
        try {
            int i = 0;
            while (i < length) {
                char ch = (char)inBuf.read();
                if (ch != '\u0000') {
                    s = (String)s + Character.toString(ch);
                }
                ++i;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading tag content - " + e.getMessage());
        }
        return s;
    }

    private int readData(Reader buffer, int channel) {
        int frameLength = this.dataChunkSize / this.blockAlign;
        int[] samples = new int[this.bytesPerChannel];
        this.audioIntLin = new double[frameLength];
        this.minAmplitude = 0.0;
        this.maxAmplitude = 0.0;
        int outIdx = 0;
        this.soFar = 0;
        while (outIdx < frameLength) {
            int toSkip = this.bytesPerChannel * channel;
            try {
                buffer.skip(toSkip);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception skipping channels before - " + e.getMessage());
                return -1;
            }
            int i = 0;
            while (i < this.bytesPerChannel) {
                try {
                    samples[i] = buffer.read();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception reading channel sample - " + e.getMessage());
                    return -1;
                }
                ++i;
            }
            toSkip = (this.numChannels - 1 - channel) * this.bytesPerChannel;
            try {
                buffer.skip(toSkip);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: IO Exception skipping channels after - " + e.getMessage());
                return -1;
            }
            int raw = 0;
            int value = 0;
            int index = 0;
            Object error = "";
            block3 : switch (this.bitsPerSample) {
                case 8: {
                    switch (this.format) {
                        case WAVE_FORMAT_PCM: {
                            value = samples[0] & 0xFF;
                            if (!this.is8bitSigned) {
                                value -= 128;
                                break block3;
                            }
                            if ((value & 0x80) == 0) break block3;
                            value |= 0xFFFFFF00;
                            break block3;
                        }
                        case WAVE_FORMAT_ALAW: {
                            raw = samples[0] & 0xFF;
                            if ((raw & 0x80) != 0) {
                                raw |= 0xFFFFFF00;
                            }
                            index = raw + 128;
                            value = Utils.aLawDecompress(index);
                            value = -value;
                            break block3;
                        }
                        case WAVE_FORMAT_MULAW: {
                            raw = samples[0] & 0xFF;
                            if ((raw & 0x80) != 0) {
                                raw |= 0xFFFFFF00;
                            }
                            index = raw + 127;
                            value = Utils.muLawDecompress(index);
                            value = -value;
                            break block3;
                        }
                        case WAVE_FORMAT_EXTENSIBLE: {
                            value = 0;
                            break block3;
                        }
                        default: {
                            error = String.valueOf(this.bitsPerSample) + " bits per sample in audio file not supported with  Encoding " + this.format.toString() + "!";
                            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: " + (String)error);
                            return -1;
                        }
                    }
                }
                case 12: {
                    switch (this.format) {
                        case WAVE_FORMAT_PCM: {
                            value = samples[0] & 0xFF;
                            value |= samples[1] << 8;
                            break block3;
                        }
                    }
                    error = String.valueOf(this.bitsPerSample) + " bits per sample in audio file not supported with  Encoding " + this.format.toString() + "!";
                    JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: " + (String)error);
                    return -1;
                }
                case 16: {
                    switch (this.format) {
                        case WAVE_FORMAT_PCM: {
                            value = samples[0] & 0xFF;
                            if ((samples[1] & 0x80) != 0) {
                                samples[1] = samples[1] | 0xFFFFFF00;
                            }
                            value |= samples[1] << 8;
                            break block3;
                        }
                    }
                    error = String.valueOf(this.bitsPerSample) + " bits per sample in audio file not supported with  Encoding " + this.format.toString() + "!";
                    JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: " + (String)error);
                    return -1;
                }
                case 24: {
                    switch (this.format) {
                        case WAVE_FORMAT_PCM: {
                            raw = samples[2] & 0xFF;
                            if ((raw & 0x80) != 0) {
                                raw |= 0xFFFFFF00;
                            }
                            value = raw << 16 | (samples[1] & 0xFFFF) << 8 | samples[0] & 0xFFFF;
                            break block3;
                        }
                    }
                    error = String.valueOf(this.bitsPerSample) + " bits per sample in audio file not supported with  Encoding " + this.format.toString() + "!";
                    JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: " + (String)error);
                    return -1;
                }
                case 32: {
                    switch (this.format) {
                        case WAVE_FORMAT_PCM: {
                            raw = samples[3] & 0xFF;
                            if ((raw & 0x80) != 0) {
                                raw |= 0xFFFFFF00;
                            }
                            value = raw << 24 | samples[1] & 0xFFFF0000 | samples[2] & 0xFFFF00 | samples[3] & 0xFFFF;
                            break block3;
                        }
                        case WAVE_FORMAT_IEEE_FLOAT: {
                            int binValue = samples[3] << 24 | samples[2] << 16 | samples[1] << 8 | samples[0];
                            double fltValue = Float.intBitsToFloat(binValue);
                            value = (int)Math.round(fltValue * (double)this.maxAbsSample);
                            break block3;
                        }
                    }
                    error = String.valueOf(this.bitsPerSample) + " bits per sample in audio file not supported with  Encoding " + this.format.toString() + "!";
                    JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: " + (String)error);
                    return -1;
                }
                case 64: {
                    switch (this.format) {
                        case WAVE_FORMAT_PCM: {
                            raw = samples[8] & 0xFF;
                            if ((raw & 0x80) != 0) {
                                raw |= 0xFFFFFF00;
                            }
                            value = raw << 24 | samples[7] & 0xFFFF0000 | samples[6] & 0xFFFF00 | samples[5] & 0xFFFF;
                            if ((samples[4] & 0x8000) == 0) break block3;
                            ++value;
                            break block3;
                        }
                        case WAVE_FORMAT_IEEE_FLOAT: {
                            long tmp = 0L;
                            long bin = 0L;
                            tmp = samples[7] & 0xFF;
                            bin |= (tmp <<= 56);
                            tmp = samples[6] & 0xFF;
                            bin |= (tmp <<= 48);
                            tmp = samples[5] & 0xFF;
                            bin |= (tmp <<= 40);
                            tmp = samples[4] & 0xFF;
                            bin |= (tmp <<= 32);
                            tmp = samples[3] & 0xFF;
                            bin |= (tmp <<= 24);
                            tmp = samples[2] & 0xFF;
                            bin |= (tmp <<= 16);
                            tmp = samples[1] & 0xFF;
                            bin |= (tmp <<= 8);
                            tmp = samples[0] & 0xFF;
                            double fltValue = Double.longBitsToDouble(bin |= tmp);
                            value = (int)Math.round(fltValue * (double)this.maxAbsSample);
                            if (value <= this.maxAbsSample) break block3;
                            System.out.println("RawWaveFile - Sample:" + outIdx + " value:" + value + " fltValue:" + fltValue + " bin:" + String.format("%x", bin));
                            break block3;
                        }
                        default: {
                            error = String.valueOf(this.bitsPerSample) + " bits per sample in audio file not supported with  Encoding " + this.format.toString() + "!";
                            JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: " + (String)error);
                            return -1;
                        }
                    }
                }
                default: {
                    error = String.valueOf(this.bitsPerSample) + " bits per sample not supported!";
                    JOptionPane.showMessageDialog(this.mainFrame, "Raw Wave File: " + (String)error);
                    return -1;
                }
            }
            this.audioIntLin[outIdx] = value;
            ++outIdx;
            if ((double)value < this.minAmplitude) {
                this.minAmplitude = value;
            }
            if ((double)value > this.maxAmplitude) {
                this.maxAmplitude = value;
            }
            if (this.progress == null) continue;
            if (this.progress.isCanceled()) {
                return -1;
            }
            this.soFar = Math.round((float)outIdx / (float)frameLength * 100.0f);
            this.progress.setProgress(this.soFar);
            this.progress.setNote(String.format("Completed %d%%.\n", this.soFar));
        }
        this.absMaxAmplitude = Math.max(Math.abs(this.minAmplitude), this.maxAmplitude);
        return 0;
    }

    private void createWaveDB() {
        this.audioIntLog = new double[this.audioIntLin.length];
        int i = 0;
        while (i < this.audioIntLin.length) {
            this.audioIntLog[i] = 20.0 * Math.log10(Math.max(Math.abs(this.audioIntLin[i] / this.absMaxAmplitude), this.limitLogExp));
            ++i;
        }
        this.absMaxAmplitudeLog = 0.0;
    }

    public double getAbsMaxAmplitude() {
        return this.absMaxAmplitude;
    }

    public double getAbsMaxAmplitudeLog() {
        return this.absMaxAmplitudeLog;
    }

    public int getMaxAbsSample() {
        return this.maxAbsSample;
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public int getSampleRate() {
        return this.samplesPerSec;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public int getChannelActuallyRead() {
        return this.channelToRead;
    }

    public int getSampleSize() {
        return this.bitsPerSample;
    }

    public int getConvertedSampleSize() {
        return this.convertedBitsPerSample;
    }

    public int getBytesPerChannel() {
        return this.bytesPerChannel;
    }

    public int getConvertedBytesPerChannel() {
        return this.convertedBytesPerChannel;
    }

    public double[] getAudioLin() {
        return this.audioIntLin;
    }

    public double[] getAudioLog() {
        return this.audioIntLog;
    }

    public FileInfo getInfoWindow() {
        return this.fileInfoWindow;
    }

    private static enum Format {
        WAVE_FORMAT_PCM,
        WAVE_FORMAT_IEEE_FLOAT,
        WAVE_FORMAT_ALAW,
        WAVE_FORMAT_MULAW,
        WAVE_FORMAT_EXTENSIBLE;

    }

    static enum PostProcessing {
        Refresh,
        Logic1;

    }

    private class ReadWorker
    extends SwingWorker<Void, Void> {
        private ReadWorker() {
        }

        @Override
        public Void doInBackground() {
            RawWavFile.this.readFileOK = RawWavFile.this.readFileDo();
            return null;
        }

        @Override
        public void done() {
            RawWavFile.this.progress.setProgress(0);
            if (RawWavFile.this.readFileOK) {
                switch (RawWavFile.this.post) {
                    case Refresh: {
                        RawWavFile.this.mainGUI.getAnalysisParamsWindow().getAnalysisWindow().repaint();
                        break;
                    }
                    case Logic1: {
                        RawWavFile.this.mainGUI.getAnalysisParamsWindow().postNewLogic(RawWavFile.this.errorCount);
                        break;
                    }
                    default: {
                        System.out.println("Invalid post-processing in RawWavFile");
                    }
                }
                RawWavFile.this.createWaveDB();
            }
        }
    }

    private class workPropertyChange
    implements PropertyChangeListener {
        private workPropertyChange() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent p) {
            RawWavFile.this.progress.setProgress(RawWavFile.this.soFar);
            RawWavFile.this.progress.setNote(String.format("Completed %d%%.\n", RawWavFile.this.soFar));
            if (RawWavFile.this.progress.isCanceled()) {
                RawWavFile.this.readWorker.cancel(true);
                RawWavFile.this.readFileOK = false;
            }
            if (RawWavFile.this.progress.isCanceled() || RawWavFile.this.readWorker.isDone()) {
                RawWavFile.this.progress.close();
            }
        }
    }
}

