/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import roundtrip.AnalysisParameters;
import roundtrip.FRTmain;
import roundtrip.Utils;

class PhasePlotPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FRTmain ourGUI;
    private AnalysisParameters analysisParams;
    private static final int phaseXFirstLine = 17;
    private int phaseHeight;
    private int freqAxisHeight = 25;

    PhasePlotPanel(FRTmain mainGUI) {
        this.ourGUI = mainGUI;
        this.analysisParams = mainGUI.getAnalysisParamsWindow();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int yMargin = Utils.getYmargin();
        this.phaseHeight = this.getHeight() - yMargin;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.ourGUI.getSettings().getAnalysisBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.analysisParams.getFTresult()[0] == null || this.analysisParams.getFTrunner() == null) {
            return;
        }
        if (this.analysisParams.getAnalysisWindow().getFtInputPanel().getAnalysisIsStale()) {
            g2d.setColor(this.ourGUI.getSettings().getFFTStalecolor());
            g2d.setFont(Utils.getMsgFont());
            String staleString = "Stale";
            FontMetrics metrics = g2d.getFontMetrics(Utils.getMsgFont());
            g2d.drawString(staleString, 0, metrics.getHeight());
        }
        g2d.setStroke(new BasicStroke(1.0f));
        int xMargin = Utils.getXmarginL();
        if (this.analysisParams.getFFTShowPhase()) {
            int freqPan;
            int nFreqs = this.analysisParams.getFTresult()[0].getSize();
            if (nFreqs == 0) {
                return;
            }
            int xPhaseWidthPx = this.analysisParams.getAnalysisWindow().getSpectrumPanel().getSpectrumPlotWidth();
            int panExt = this.analysisParams.getAnalysisWindow().getSpectrumZoomPanel().getSliderValue();
            int startIdx = freqPan = this.analysisParams.getAnalysisWindow().getSpectrumZoomPanel().getScrollValue();
            int endIdx = freqPan + panExt;
            double startFreq = this.analysisParams.getFTresult()[0].getBinByIndex(startIdx).getFreqFactor();
            double endFreq = this.analysisParams.getFTresult()[0].getBinByIndex(endIdx).getFreqFactor();
            double xScale = (double)xPhaseWidthPx / (endFreq - startFreq);
            double phaseStepPx = (double)xPhaseWidthPx / (double)panExt;
            int freqAxisYBase = this.phaseHeight + this.freqAxisHeight;
            int yPhaseBase = freqAxisYBase - this.phaseHeight / 2;
            int xPhaseBase = xMargin;
            int phaseXstart = 17;
            double phaseScale = (double)this.phaseHeight / 8.0;
            int phaseX1 = 0;
            g2d.setColor(this.ourGUI.getSettings().getPlotColor());
            int idx = startIdx;
            int i = 0;
            while (i < panExt) {
                double phase = this.analysisParams.getFTresult()[0].getBinByIndex(idx).getPhase();
                phaseX1 = xPhaseBase + phaseXstart + (int)Math.round((double)i * phaseStepPx);
                int phaseY2 = yPhaseBase - (int)Math.round(phase * phaseScale);
                g2d.drawLine(phaseX1, yPhaseBase, phaseX1, phaseY2);
                idx = Math.min(idx + 1, nFreqs - 1);
                ++i;
            }
            if (nFreqs > 0) {
                g2d.setColor(this.ourGUI.getSettings().getAxisColor());
                Utils.calibrateXint(g2d, xScale, startIdx, endIdx, 0.0, 1.0, xPhaseBase + phaseXstart, yPhaseBase, null);
                Utils.calibrateYPhase(g2d, phaseScale, xPhaseBase, yPhaseBase, Utils.AxisOmitNeg.KEEP_NEG, Utils.getPhaseLabel());
                int pi = (int)Math.round(Math.PI * phaseScale);
                g2d.setColor(this.ourGUI.getSettings().getAxisGraticuleColor());
                g2d.drawLine(xPhaseBase, yPhaseBase + pi, xPhaseBase + phaseXstart + xPhaseWidthPx, yPhaseBase + pi);
                g2d.drawLine(xPhaseBase, yPhaseBase - pi, xPhaseBase + phaseXstart + xPhaseWidthPx, yPhaseBase - pi);
            }
        }
    }
}

