/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import roundtrip.AnalysisParameters;
import roundtrip.AnalysisWindow;
import roundtrip.FRTmain;
import roundtrip.RawWavFile;
import roundtrip.Utils;
import roundtrip.WavePanel;

class InputPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FRTmain ourGUI;
    private JPanel thisPanel;
    private WavePanel wavePanel;
    protected AnalysisParameters analysisParams;
    protected double[] waveSamples;
    private RawWavFile rawWave;
    protected int sampleRate;
    private int frameLength;
    private double absMaxAmplitude;
    protected Graphics2D g2d;
    private int xMargin;
    private int yMargin;
    protected int xWaveBase;
    protected int xWaveWidthPx;
    private int xEndTimeSamples;
    protected int xStartTimeSamples;
    protected int samplesPerPixel;
    private int currentSample;
    protected int yWaveBase;
    protected int yTop;
    protected int yBottom;
    protected int mark1Samples = 44100;
    protected int mark2Samples = 88200;
    private int markZeroSamples = 88200;
    private int cursorSamples = -1;
    protected int mark1Pixels = 0;
    protected int mark2Pixels = 0;
    private int markZeroPixels = 0;
    private Rectangle2D mark1Bounds = new Rectangle2D.Double();
    private Rectangle2D mark2Bounds = new Rectangle2D.Double();
    private Rectangle2D mark1LabelBounds = new Rectangle2D.Double();
    private Rectangle2D mark2LabelBounds = new Rectangle2D.Double();
    private int boundTolerance = 6;
    private boolean mark1Dragging = false;
    private boolean mark2Dragging = false;
    private boolean mark1Selected = false;
    private boolean mark2Selected = false;
    private int yHeight;
    protected double scale;
    private double niceAxisTop;
    private Utils.AxisOmitNeg keepNeg;
    protected int yAxisBase;
    protected FontMetrics metrics;
    private JPopupMenu rMouseMenu = new JPopupMenu();
    private JMenuItem rMouseMark1Here = new JMenuItem("Mark1 here");
    private JMenuItem rMouseMark2Here = new JMenuItem("Mark2 here");
    private int rMouseX;
    protected InputFtDecay ftDecay;
    protected double niceDBLimit;
    private int scaledYMax;
    private int scaledYMin;
    private double pixelYMax;
    private double pixelYMin;
    private boolean anlysisIsStale = true;

    InputPanel(FRTmain mainGUI, AnalysisWindow an, WavePanel wp, InputFtDecay ftD) {
        this.ourGUI = mainGUI;
        this.wavePanel = wp;
        this.ftDecay = ftD;
        this.thisPanel = this;
        this.analysisParams = this.ourGUI.getAnalysisParamsWindow();
        this.rawWave = this.analysisParams.getRawWave();
        this.setAnalysisIsStale(true);
        this.rMouseMenu.add(this.rMouseMark1Here);
        this.rMouseMark1Here.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputPanel.this.setMark1FromPixelOnScreen(InputPanel.this.rMouseX);
                InputPanel.this.mark1Selected = true;
                InputPanel.this.mark2Selected = false;
                InputPanel.this.repaint();
                InputPanel.this.wavePanel.inputPanLimits();
            }
        });
        this.rMouseMenu.add(this.rMouseMark2Here);
        this.rMouseMark2Here.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputPanel.this.setMark2FromPixelOnScreen(InputPanel.this.rMouseX);
                InputPanel.this.mark2Selected = true;
                InputPanel.this.mark1Selected = false;
                InputPanel.this.repaint();
                InputPanel.this.wavePanel.inputPanLimits();
            }
        });
        this.waveSamples = this.rawWave.getAudioLin();
        this.sampleRate = this.rawWave.getSampleRate();
        this.frameLength = this.rawWave.getFrameLength();
        this.absMaxAmplitude = this.rawWave.getAbsMaxAmplitude();
        this.xMargin = Utils.getXmarginL();
        this.yMargin = Utils.getYmargin();
        this.yHeight = this.thisPanel.getHeight() - this.yMargin * 2;
        this.yWaveBase = this.yMargin + this.yHeight / 2;
        this.xStartTimeSamples = this.wavePanel.getStartTimeSamples();
        this.xEndTimeSamples = this.wavePanel.getEndTimeSamples();
        this.samplesPerPixel = this.wavePanel.getSamplesPerPixel();
        this.scale = (double)this.yHeight / 2.0 / this.rawWave.getAbsMaxAmplitude() * (double)this.wavePanel.getInputYMag();
        this.xWaveBase = this.wavePanel.getXWaveBase();
        this.xWaveWidthPx = this.wavePanel.getXWaveWidthPx();
        this.mark1Pixels = this.xWaveBase;
        this.mark1Samples = 0;
        this.mark2Pixels = this.xWaveBase + this.xWaveWidthPx;
        this.markZeroSamples = this.mark2Samples = Math.min(10, this.rawWave.getFrameLength() - 1);
        this.setFocusable(true);
        this.addKeyListener(new keyb());
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent f) {
                InputPanel.this.mark1Selected = false;
                InputPanel.this.mark2Selected = false;
                InputPanel.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent f) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent c) {
                if (InputPanel.this.ftDecay == InputFtDecay.InputFT && (InputPanel.this.analysisParams.isFTrunning() || InputPanel.this.analysisParams.isDecayRunning() && InputPanel.this.wavePanel.getQuickPanel().isMarkSynced()) || InputPanel.this.ftDecay == InputFtDecay.InputDecay && (InputPanel.this.analysisParams.isDecayRunning() || InputPanel.this.analysisParams.isFTrunning() && InputPanel.this.wavePanel.getQuickPanel().isMarkSynced())) {
                    return;
                }
                InputPanel.this.thisPanel.requestFocusInWindow();
                if (c.getButton() == 3) {
                    if (InputPanel.this.xMargin <= c.getX() && c.getX() < InputPanel.this.xMargin + InputPanel.this.xWaveWidthPx) {
                        InputPanel.this.rMouseMenu.show(c.getComponent(), c.getX(), c.getY());
                        InputPanel.this.rMouseX = c.getX();
                    }
                } else if (c.getButton() == 1) {
                    if (InputPanel.this.mark1Bounds != null && InputPanel.this.mark1Bounds.contains(c.getX(), c.getY())) {
                        InputPanel.this.mark1Selected = true;
                        InputPanel.this.mark2Selected = false;
                    } else if (InputPanel.this.mark2Bounds != null && InputPanel.this.mark2Bounds.contains(c.getX(), c.getY())) {
                        InputPanel.this.mark2Selected = true;
                        InputPanel.this.mark1Selected = false;
                    } else if (InputPanel.this.mark1LabelBounds != null && InputPanel.this.mark1LabelBounds.contains(c.getX(), c.getY())) {
                        InputPanel.this.mark1Selected = true;
                        InputPanel.this.mark2Selected = false;
                    } else if (InputPanel.this.mark2LabelBounds != null && InputPanel.this.mark2LabelBounds.contains(c.getX(), c.getY())) {
                        InputPanel.this.mark2Selected = true;
                        InputPanel.this.mark1Selected = false;
                    } else {
                        InputPanel.this.mark1Selected = false;
                        InputPanel.this.mark2Selected = false;
                    }
                    InputPanel.this.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent c) {
                if (InputPanel.this.ftDecay == InputFtDecay.InputFT && (InputPanel.this.analysisParams.isFTrunning() || InputPanel.this.analysisParams.isDecayRunning() && InputPanel.this.wavePanel.getQuickPanel().isMarkSynced()) || InputPanel.this.ftDecay == InputFtDecay.InputDecay && (InputPanel.this.analysisParams.isDecayRunning() || InputPanel.this.analysisParams.isFTrunning() && InputPanel.this.wavePanel.getQuickPanel().isMarkSynced())) {
                    return;
                }
                if (InputPanel.this.mark1Bounds != null && InputPanel.this.mark1Bounds.contains(c.getX(), c.getY())) {
                    InputPanel.this.mark1Dragging = true;
                    InputPanel.this.mark2Selected = false;
                }
                if (InputPanel.this.mark2Bounds != null && InputPanel.this.mark2Bounds.contains(c.getX(), c.getY())) {
                    InputPanel.this.mark2Dragging = true;
                    InputPanel.this.mark1Selected = false;
                }
                if (InputPanel.this.mark1Dragging && InputPanel.this.mark2Dragging) {
                    if (InputPanel.this.mark1Pixels == InputPanel.this.xWaveBase) {
                        InputPanel.this.mark1Dragging = false;
                    } else {
                        InputPanel.this.mark2Dragging = false;
                    }
                }
                if (InputPanel.this.mark1LabelBounds != null && InputPanel.this.mark1LabelBounds.contains(c.getX(), c.getY())) {
                    InputPanel.this.mark1Selected = true;
                    InputPanel.this.mark2Selected = false;
                }
                if (InputPanel.this.mark2LabelBounds != null && InputPanel.this.mark2LabelBounds.contains(c.getX(), c.getY())) {
                    InputPanel.this.mark2Selected = true;
                    InputPanel.this.mark1Selected = false;
                }
            }

            @Override
            public void mouseReleased(MouseEvent c) {
                if (InputPanel.this.mark1Dragging) {
                    InputPanel.this.moveMark1(c.getX(), c.isShiftDown());
                    InputPanel.this.mark1Dragging = false;
                    InputPanel.this.mark1Selected = true;
                    InputPanel.this.mark2Selected = false;
                    InputPanel.this.repaint();
                }
                if (InputPanel.this.mark2Dragging) {
                    InputPanel.this.moveMark2(c.getX(), c.isShiftDown());
                    InputPanel.this.mark2Dragging = false;
                    InputPanel.this.mark2Selected = true;
                    InputPanel.this.mark1Selected = false;
                    InputPanel.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent c) {
                InputPanel.this.wavePanel.inputPanLimits();
                if (InputPanel.this.mark1Dragging) {
                    InputPanel.this.moveMark1(c.getX(), c.isShiftDown());
                    InputPanel.this.repaint();
                }
                if (InputPanel.this.mark2Dragging) {
                    InputPanel.this.moveMark2(c.getX(), c.isShiftDown());
                    InputPanel.this.repaint();
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        int labelWidth;
        Object yStr;
        double timeSecs;
        super.paintComponent(g);
        this.yMargin = Utils.getYmargin();
        this.yHeight = this.thisPanel.getHeight() - this.yMargin * 2;
        String yLabel = "";
        if (this.ftDecay == InputFtDecay.InputFT || this.analysisParams.getAvgLinLog().equals((Object)AnalysisParameters.AvgScale.AvgLinear)) {
            this.keepNeg = Utils.AxisOmitNeg.KEEP_NEG;
            this.waveSamples = this.rawWave.getAudioLin();
            this.yAxisBase = this.yWaveBase = this.yMargin + this.yHeight / 2;
            this.yTop = this.yAxisBase + this.yHeight / 2;
            this.yBottom = this.yAxisBase - this.yHeight / 2;
            this.absMaxAmplitude = this.rawWave.getMaxAbsSample();
            this.niceAxisTop = Utils.getNiceAxisTop(this.absMaxAmplitude / (double)this.wavePanel.getInputYMag());
            this.scale = (double)this.yHeight / 2.0 / this.niceAxisTop;
            yLabel = Utils.getAmplitudeLabel();
        } else {
            this.keepNeg = Utils.AxisOmitNeg.OMIT_NEG;
            this.waveSamples = this.rawWave.getAudioLog();
            this.yWaveBase = this.yMargin + this.yHeight;
            this.yAxisBase = this.yMargin;
            this.yTop = this.yWaveBase;
            this.yBottom = this.yAxisBase;
            double yMagAsLimit = -((101 - this.wavePanel.getInputYMag()) * 4);
            this.niceDBLimit = Utils.getNiceAxisTop(yMagAsLimit);
            this.absMaxAmplitude = this.analysisParams.getAvgWaveAbsMax();
            this.niceAxisTop = Utils.getNiceAxisTop(yMagAsLimit);
            this.scale = (double)(-this.yHeight) / this.niceAxisTop;
            yLabel = Utils.getAmplitudeDBLabel();
        }
        if (this.waveSamples == null) {
            return;
        }
        this.g2d = (Graphics2D)g;
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.g2d.setColor(this.ourGUI.getSettings().getAnalysisBackground());
        this.g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.g2d.setStroke(new BasicStroke(1.0f));
        this.xMargin = Utils.getXmarginL();
        this.xStartTimeSamples = this.wavePanel.getStartTimeSamples();
        this.xEndTimeSamples = this.wavePanel.getEndTimeSamples();
        this.samplesPerPixel = this.wavePanel.getSamplesPerPixel();
        int pad = this.analysisParams.getZeroPadding();
        this.markZeroSamples = this.mark2Samples + pad;
        this.xWaveBase = this.wavePanel.getXWaveBase();
        this.xWaveWidthPx = this.wavePanel.getXWaveWidthPx();
        this.g2d.setColor(this.ourGUI.getSettings().getAxisColor());
        this.g2d.drawLine(this.xWaveBase, this.yWaveBase, this.xWaveBase + this.xWaveWidthPx, this.yWaveBase);
        Utils.calibrateXTime(this.g2d, this.xWaveBase, this.xWaveWidthPx, this.xStartTimeSamples, this.samplesPerPixel, this.sampleRate, this.yTop);
        this.g2d.setFont(Utils.getAxisFont());
        this.metrics = this.g2d.getFontMetrics(Utils.getAxisFont());
        String xLabel = "Time [seconds]";
        this.g2d.drawString(xLabel, this.xWaveBase + this.xWaveWidthPx / 2 - this.metrics.stringWidth(xLabel) / 2, this.yHeight + this.yMargin * 2 - this.metrics.getDescent());
        Utils.calibrateY(this.g2d, this.scale, this.niceAxisTop, this.xWaveBase, this.yAxisBase, this.xWaveWidthPx, Utils.AxisOmit0.KEEP0, this.keepNeg, Utils.AxisExtendYticks.ExtendYticks, 4, yLabel);
        this.g2d.setColor(this.ourGUI.getSettings().getSoundColor());
        int pixelY1 = this.yWaveBase;
        int pixelY2 = this.yWaveBase;
        boolean draw = true;
        this.currentSample = this.xStartTimeSamples;
        int i = 0;
        while (i < this.xWaveWidthPx) {
            double limitedYMax;
            int maxSample = this.currentSample + this.samplesPerPixel;
            if (i == this.xWaveWidthPx - 1) {
                maxSample = this.xEndTimeSamples;
            }
            if (this.ftDecay == InputFtDecay.InputFT || this.analysisParams.getAvgLinLog().equals((Object)AnalysisParameters.AvgScale.AvgLinear)) {
                double pixelYMax = 0.0;
                double pixelYMin = 0.0;
                int j = this.currentSample;
                while (j < maxSample && j < this.waveSamples.length) {
                    pixelYMax = Math.max(pixelYMax, this.waveSamples[j]);
                    pixelYMin = Math.min(pixelYMin, this.waveSamples[j]);
                    ++j;
                }
                this.scaledYMax = this.yWaveBase - (int)Math.round(pixelYMax * this.scale);
                this.scaledYMin = this.yWaveBase - (int)Math.round(pixelYMin * this.scale);
            } else {
                this.pixelYMax = Double.NEGATIVE_INFINITY;
                this.pixelYMin = Double.POSITIVE_INFINITY;
                int j = this.currentSample;
                while (j < maxSample && j < this.waveSamples.length) {
                    this.pixelYMax = Math.max(this.pixelYMax, this.waveSamples[j]);
                    this.pixelYMin = Math.min(this.pixelYMin, this.waveSamples[j]);
                    ++j;
                }
                limitedYMax = Math.max(this.pixelYMax, this.niceDBLimit);
                this.scaledYMax = this.yAxisBase - (int)Math.round(limitedYMax * this.scale);
                double limitedYMin = Math.max(this.pixelYMin, this.niceDBLimit);
                this.scaledYMin = this.yAxisBase - (int)Math.round(limitedYMin * this.scale);
            }
            if (this.currentSample >= this.mark1Samples && this.currentSample <= this.markZeroSamples) {
                this.g2d.setColor(this.ourGUI.getSettings().getSoundWindowColor());
                draw = this.analysisParams.getFFTShowOriginal();
            } else {
                this.g2d.setColor(this.ourGUI.getSettings().getSoundColor());
                draw = true;
            }
            if (this.samplesPerPixel > 1) {
                if (draw) {
                    this.g2d.drawLine(this.xWaveBase + i, this.scaledYMax, this.xWaveBase + i, this.scaledYMin);
                }
            } else if (this.currentSample < this.waveSamples.length) {
                if (this.ftDecay == InputFtDecay.InputFT || this.analysisParams.getAvgLinLog().equals((Object)AnalysisParameters.AvgScale.AvgLinear)) {
                    pixelY2 = this.yWaveBase - (int)Math.round(this.waveSamples[this.currentSample] * this.scale);
                } else {
                    limitedYMax = Math.max(this.waveSamples[this.currentSample], this.niceDBLimit);
                    pixelY2 = this.yAxisBase - (int)Math.round(limitedYMax * this.scale);
                }
                if (draw) {
                    this.g2d.drawLine(this.xWaveBase + i, pixelY1, this.xWaveBase + i + 1, pixelY2);
                }
                pixelY1 = pixelY2;
            }
            this.currentSample += this.samplesPerPixel;
            ++i;
        }
        this.g2d.setFont(Utils.getAxisFont());
        this.metrics = this.g2d.getFontMetrics(Utils.getAxisFont());
        this.mark1Pixels = this.xWaveBase + (int)Math.round(((double)this.mark1Samples - (double)this.xStartTimeSamples) / (double)this.samplesPerPixel);
        if (this.mark1Pixels >= this.xWaveBase && this.mark1Pixels <= this.xWaveBase + this.xWaveWidthPx) {
            this.g2d.setColor(this.ourGUI.getSettings().getMark1Color());
            this.g2d.drawLine(this.mark1Pixels, this.yBottom, this.mark1Pixels, this.yTop);
            long timeSmps = this.mark1Samples;
            timeSecs = (double)this.mark1Samples / (double)this.sampleRate;
            double mark1Y = this.waveSamples[this.mark1Samples];
            String timeSmpsStr = String.valueOf(timeSmps);
            String timeSecsStr = String.format("%.6f", timeSecs);
            yStr = "";
            if (this.ftDecay == InputFtDecay.InputFT || this.analysisParams.getAvgLinLog().equals((Object)AnalysisParameters.AvgScale.AvgLinear)) {
                yStr = String.format("%.0f", mark1Y);
            } else {
                yStr = String.format("%.2f", mark1Y);
                yStr = (String)yStr + "dB";
            }
            String mark1Label = timeSmpsStr + " : " + (String)yStr;
            this.g2d.setColor(this.ourGUI.getSettings().getMark1ColorFull());
            this.g2d.drawString(timeSecsStr, this.mark1Pixels, this.yBottom + this.metrics.getHeight());
            this.g2d.drawString(mark1Label, this.mark1Pixels, this.yBottom + this.metrics.getHeight() * 2);
            if (this.mark1Bounds == null) {
                this.mark1Bounds = new Rectangle2D.Double();
                this.mark1LabelBounds = new Rectangle2D.Double();
            }
            this.mark1Bounds.setRect(this.mark1Pixels - this.boundTolerance / 2, this.yBottom, this.boundTolerance, this.yHeight);
            labelWidth = Math.max(this.metrics.stringWidth(timeSecsStr), this.metrics.stringWidth(mark1Label));
            this.mark1LabelBounds.setRect(this.mark1Pixels, this.yBottom + this.metrics.getDescent() - 1, labelWidth, this.metrics.getHeight() * 2);
            if (this.mark1Selected) {
                this.g2d.draw(this.mark1LabelBounds);
            }
        } else {
            this.mark1Bounds = null;
            this.mark1LabelBounds = null;
        }
        this.mark2Pixels = this.xWaveBase + (int)Math.floor((double)(this.mark2Samples - this.xStartTimeSamples) / (double)this.samplesPerPixel);
        if (this.mark2Pixels >= this.xWaveBase && this.mark2Pixels <= this.xWaveBase + this.xWaveWidthPx) {
            if (this.mark2Samples > this.xEndTimeSamples - this.samplesPerPixel + 1 && this.xEndTimeSamples >= this.xWaveWidthPx * this.samplesPerPixel) {
                this.mark2Pixels = this.xWaveBase + this.xWaveWidthPx;
            }
            this.g2d.setColor(this.ourGUI.getSettings().getMark2Color());
            this.g2d.drawLine(this.mark2Pixels, this.yBottom - this.metrics.getHeight(), this.mark2Pixels, this.yTop);
            long timeSmps = this.mark2Samples;
            timeSecs = (double)this.mark2Samples / (double)this.sampleRate;
            double mark2Y = this.waveSamples[this.mark2Samples];
            String timeSmpsStr = String.valueOf(timeSmps);
            String timeSecsString = String.format("%.6f", timeSecs);
            yStr = "";
            if (this.ftDecay == InputFtDecay.InputFT || this.analysisParams.getAvgLinLog().equals((Object)AnalysisParameters.AvgScale.AvgLinear)) {
                yStr = String.format("%.0f", mark2Y);
            } else {
                yStr = String.format("%.2f", mark2Y);
                yStr = (String)yStr + "dB";
            }
            String mark2Label = timeSmpsStr + " : " + (String)yStr;
            this.g2d.setColor(this.ourGUI.getSettings().getMark2ColorFull());
            this.g2d.drawString(timeSecsString, this.mark2Pixels - this.metrics.stringWidth(timeSecsString), this.yBottom - this.metrics.getHeight());
            this.g2d.drawString(mark2Label, this.mark2Pixels - this.metrics.stringWidth(mark2Label), this.yBottom - this.metrics.getDescent());
            if (this.mark2Bounds == null) {
                this.mark2Bounds = new Rectangle2D.Double();
                this.mark2LabelBounds = new Rectangle2D.Double();
            }
            this.mark2Bounds.setRect(this.mark2Pixels - this.boundTolerance / 2, this.yBottom, this.boundTolerance, this.yHeight);
            labelWidth = Math.max(this.metrics.stringWidth(timeSecsString), this.metrics.stringWidth(mark2Label));
            this.mark2LabelBounds.setRect(this.mark2Pixels, this.yBottom + this.metrics.getDescent() - 1, labelWidth, this.metrics.getHeight() * 2 + 2);
            this.mark2LabelBounds.setRect(this.mark2Pixels - this.metrics.stringWidth(mark2Label), this.yBottom - this.metrics.getHeight() * 2, labelWidth, this.metrics.getHeight() * 2);
            if (this.mark2Selected) {
                this.g2d.draw(this.mark2LabelBounds);
            }
        } else {
            this.mark2Bounds = null;
            this.mark2LabelBounds = null;
        }
        if (this.ftDecay == InputFtDecay.InputFT) {
            this.markZeroPixels = this.mark2Pixels;
            this.markZeroPixels = this.xWaveBase + (int)Math.floor((double)(this.markZeroSamples - this.xStartTimeSamples) / (double)this.samplesPerPixel);
            if (pad > 0 && this.mark2Samples + pad >= this.xStartTimeSamples && this.mark2Samples + pad <= this.xEndTimeSamples) {
                this.g2d.setColor(this.ourGUI.getSettings().getMarkZeroColor());
                this.g2d.drawLine(this.markZeroPixels, this.yWaveBase, this.markZeroPixels, this.yBottom);
            }
            if (pad > 0 && this.mark2Samples + pad >= this.xStartTimeSamples && this.mark2Samples + pad <= this.xEndTimeSamples || this.mark2Samples >= this.xStartTimeSamples && this.mark2Samples <= this.xEndTimeSamples) {
                this.g2d.setStroke(new BasicStroke(3.0f));
                this.g2d.setColor(this.ourGUI.getSettings().getFFTFinalColor());
                int zeroStart = Math.max(this.mark2Pixels, this.xWaveBase);
                int zeroEnd = Math.min(this.markZeroPixels, this.xWaveBase + this.xWaveWidthPx);
                this.g2d.drawLine(zeroStart, this.yWaveBase, zeroEnd, this.yWaveBase);
                this.g2d.setStroke(new BasicStroke(1.0f));
            }
            if (this.cursorSamples >= 0) {
                int cursorPixels = (this.cursorSamples - this.xStartTimeSamples) / this.samplesPerPixel + this.xWaveBase;
                this.g2d.setColor(this.ourGUI.getSettings().getCursorColor());
                this.g2d.drawLine(cursorPixels, this.yBottom - this.metrics.getHeight(), cursorPixels, this.yTop);
            }
            int nOverlaps = this.analysisParams.getFtNframes();
            int overlapInc = this.analysisParams.getFtStepSamples();
            int lastOverlapEnd = this.mark2Samples + (nOverlaps - 1) * overlapInc;
            if ((this.mark1Samples >= this.xStartTimeSamples && this.mark1Samples <= this.xEndTimeSamples || lastOverlapEnd >= this.xStartTimeSamples && lastOverlapEnd <= this.xEndTimeSamples || this.mark1Samples < this.xStartTimeSamples && lastOverlapEnd > this.xEndTimeSamples) && this.analysisParams.getFFTWindowFunction() != null) {
                if (this.analysisParams.getFFTShowWindow()) {
                    this.g2d.setColor(this.ourGUI.getSettings().getFFTWindowColor());
                    double[] windowFunction = this.analysisParams.getFFTWindowFunction();
                    double windowFunctionYscale = (double)this.yHeight / 2.0 / (double)Math.round(this.analysisParams.getFFTWindowFunctionMax());
                    int overlapsToDo = 1;
                    if (!this.analysisParams.getFTcombine().equals((Object)AnalysisParameters.FTcombine.FTsingle)) {
                        overlapsToDo = nOverlaps;
                    }
                    int w = 0;
                    while (w < overlapsToDo) {
                        if (w != 0) {
                            this.g2d.setColor(this.ourGUI.getSettings().getFFTOverlapColor());
                        }
                        int currentOverlapStartSample = this.mark1Samples + w * overlapInc;
                        int currentOverlapStartPixel = (currentOverlapStartSample - this.xStartTimeSamples) / this.samplesPerPixel;
                        int currentOverlapEndSample = this.mark2Samples + w * overlapInc;
                        int currentOverlapEndPixel = Math.min((currentOverlapEndSample - this.xStartTimeSamples) / this.samplesPerPixel, this.xWaveWidthPx);
                        int yPrev = (int)Math.round(windowFunction[0] * windowFunctionYscale);
                        int xPixel = Math.max(currentOverlapStartPixel, 0);
                        this.g2d.drawLine(xPixel + this.xWaveBase, this.yTop - 5, xPixel + this.xWaveBase, this.yTop - 15);
                        while (xPixel < currentOverlapEndPixel) {
                            if (xPixel >= 0) {
                                int xSample = (xPixel - currentOverlapStartPixel) * this.samplesPerPixel;
                                int yValue = (int)Math.round(windowFunction[xSample] * windowFunctionYscale);
                                this.g2d.drawLine(xPixel + this.xWaveBase, this.yWaveBase + yPrev, xPixel + this.xWaveBase + 1, this.yWaveBase + yValue);
                                this.g2d.drawLine(xPixel + this.xWaveBase, this.yWaveBase - yPrev, xPixel + this.xWaveBase + 1, this.yWaveBase - yValue);
                                yPrev = yValue;
                            }
                            ++xPixel;
                        }
                        ++w;
                    }
                }
                if (this.analysisParams.getFFTShowFinal() && !this.getAnalysisIsStale() && this.analysisParams.getFTrunner().getWindowedWave() != null) {
                    int finalStartPixel = Math.max(this.mark1Pixels, this.xWaveBase);
                    int finalEndPixel = Math.min(this.mark2Pixels, this.xWaveBase + this.xWaveWidthPx);
                    int currentFinalSample = 0;
                    this.g2d.setColor(this.ourGUI.getSettings().getFFTFinalColor());
                    this.g2d.setStroke(new BasicStroke());
                    int prevFinalXPos = this.mark1Pixels;
                    int scaledFinalY1 = this.yWaveBase;
                    int scaledFinalY2 = 0;
                    double[] windowedWave = this.analysisParams.getFTrunner().getWindowedWave();
                    if (this.mark1Samples < this.xStartTimeSamples) {
                        currentFinalSample = this.xStartTimeSamples - this.mark1Samples;
                        prevFinalXPos = this.xWaveBase;
                    }
                    int i2 = finalStartPixel;
                    while (i2 < finalEndPixel) {
                        double pixelYMax = 0.0;
                        double pixelYMin = 0.0;
                        int j = currentFinalSample;
                        while (j <= currentFinalSample + this.samplesPerPixel && j < windowedWave.length) {
                            pixelYMax = Math.max(pixelYMax, windowedWave[j]);
                            pixelYMin = Math.min(pixelYMin, windowedWave[j]);
                            ++j;
                        }
                        int scaledYMax = this.yWaveBase - (int)Math.round(pixelYMax * this.scale);
                        int scaledYMin = this.yWaveBase - (int)Math.round(pixelYMin * this.scale);
                        if (this.samplesPerPixel > 1) {
                            this.g2d.drawLine(prevFinalXPos, scaledYMax, prevFinalXPos, scaledYMin);
                        } else if (currentFinalSample < windowedWave.length) {
                            scaledFinalY2 = i2 == this.xWaveWidthPx - 1 ? this.yWaveBase - (int)Math.round(windowedWave[currentFinalSample] * this.scale) : this.yWaveBase - (int)Math.round(windowedWave[currentFinalSample] * this.scale);
                            this.g2d.drawLine(prevFinalXPos, scaledFinalY1, prevFinalXPos + 1, scaledFinalY2);
                            scaledFinalY1 = scaledFinalY2;
                        }
                        ++prevFinalXPos;
                        currentFinalSample += this.samplesPerPixel;
                        ++i2;
                    }
                }
            }
        }
    }

    public double[] getSubSample(int start, int end) {
        double[] result = Arrays.copyOfRange(this.waveSamples, start, end);
        return result;
    }

    public int getMark1Samples() {
        return this.mark1Samples;
    }

    public void setMark1Samples(int s) {
        this.mark1Samples = s;
        this.mark1Pixels = (this.mark1Samples - this.xStartTimeSamples) / this.samplesPerPixel + this.xWaveBase;
    }

    public int getMark2Samples() {
        return this.mark2Samples;
    }

    public void setMark2Samples(int s) {
        this.mark2Samples = s;
        this.mark2Pixels = (this.mark2Samples - this.xStartTimeSamples) / this.samplesPerPixel + this.xWaveBase;
    }

    public int getWindowSize() {
        return Math.max(this.mark2Samples - this.mark1Samples + 1, 0);
    }

    public double getFundamental() {
        double fundamental = (double)this.sampleRate / (double)this.getWindowSize();
        return fundamental;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public double getWindowPeriod() {
        return (double)this.getWindowSize() / (double)this.sampleRate;
    }

    public void setCursor(int c) {
        this.cursorSamples = c;
        this.repaint();
    }

    private void moveMark1(int newX, boolean shiftDown) {
        int deltaXpx = newX - this.mark1Pixels;
        if (deltaXpx > 0) {
            int fileEndPx;
            if (shiftDown && this.mark2Pixels + deltaXpx >= (fileEndPx = this.xWaveBase + (this.frameLength - 1 - this.wavePanel.getStartTimeSamples()) / this.samplesPerPixel) && (deltaXpx = fileEndPx - this.mark2Pixels) < 0) {
                deltaXpx = 0;
            }
            if (this.mark1Pixels + deltaXpx >= this.xWaveBase + this.xWaveWidthPx) {
                deltaXpx = this.xWaveBase + this.xWaveWidthPx - this.mark1Pixels;
            }
            if (!shiftDown && this.mark1Pixels + deltaXpx >= this.mark2Pixels - 1) {
                deltaXpx = this.mark2Pixels - 1 - this.mark1Pixels;
            }
        } else if (deltaXpx < 0 && this.mark1Pixels + deltaXpx < this.xWaveBase) {
            deltaXpx = -(this.mark1Pixels - this.xWaveBase);
        }
        this.mark1Pixels += deltaXpx;
        this.mark1Samples = (this.mark1Pixels - this.xWaveBase) * this.samplesPerPixel + this.xStartTimeSamples;
        if (this.mark1Samples > this.waveSamples.length - 1) {
            this.mark1Samples = this.waveSamples.length - 1;
        }
        if (shiftDown) {
            this.mark2Pixels += deltaXpx;
            this.mark2Samples = (this.mark2Pixels - this.xWaveBase) * this.samplesPerPixel + this.xStartTimeSamples;
            if (this.mark2Samples > this.waveSamples.length - 1) {
                this.mark2Samples = this.waveSamples.length - 1;
            }
        }
        this.markMovedActions();
    }

    private void moveMark2(int newX, boolean shiftDown) {
        int deltaXpx = newX - this.mark2Pixels;
        if (deltaXpx < 0) {
            int fileStartPx;
            if (shiftDown && this.mark1Pixels + deltaXpx < (fileStartPx = this.xWaveBase - this.wavePanel.getStartTimeSamples() / this.samplesPerPixel)) {
                deltaXpx = fileStartPx - this.mark1Pixels;
            }
            if (this.mark2Pixels + deltaXpx < this.xWaveBase) {
                deltaXpx = this.xWaveBase - this.mark2Pixels;
            }
            if (!shiftDown && this.mark2Pixels + deltaXpx <= this.mark1Pixels + 1) {
                deltaXpx = this.mark1Pixels + 1 - this.mark2Pixels;
            }
        } else if (deltaXpx > 0 && this.mark2Pixels + deltaXpx > this.xWaveBase + this.xWaveWidthPx) {
            deltaXpx = this.xWaveBase + this.xWaveWidthPx - this.mark2Pixels;
        }
        this.mark2Pixels += deltaXpx;
        this.mark2Samples = (this.mark2Pixels - this.xWaveBase) * this.samplesPerPixel + this.xStartTimeSamples;
        if (this.mark2Samples > this.waveSamples.length - 1) {
            this.mark2Samples = this.waveSamples.length - 1;
        }
        if (shiftDown) {
            this.mark1Pixels += deltaXpx;
            this.mark1Samples = (this.mark1Pixels - this.xWaveBase) * this.samplesPerPixel + this.xStartTimeSamples;
            if (this.mark1Samples > this.waveSamples.length - 1) {
                this.mark1Samples = this.waveSamples.length - 1;
            }
        }
        this.markMovedActions();
    }

    private void setMark1FromPixelOnScreen(int x) {
        int targetPx = Math.max(x, this.xWaveBase);
        targetPx = Math.min(targetPx, this.mark2Pixels - 1);
        this.mark1Pixels = targetPx = Math.min(targetPx, this.xWaveBase + this.xWaveWidthPx - 1);
        this.mark1Samples = (targetPx - this.xWaveBase) * this.samplesPerPixel + this.xStartTimeSamples;
        if (this.mark1Samples > this.waveSamples.length - 1) {
            this.mark1Samples = this.waveSamples.length - 1;
        }
        this.markMovedActions();
    }

    private void setMark2FromPixelOnScreen(int x) {
        int targetPx = Math.max(x, this.mark1Pixels + 1);
        this.mark2Pixels = targetPx = Math.max(targetPx, this.xWaveBase + 1);
        this.mark2Samples = (targetPx - this.xWaveBase) * this.samplesPerPixel + this.xStartTimeSamples;
        if (this.mark2Samples > this.waveSamples.length - 1) {
            this.mark2Samples = this.waveSamples.length - 1;
        }
        this.markMovedActions();
    }

    protected void markMovedActions() {
        if (this.wavePanel.getQuickPanel().isMarkSynced()) {
            this.wavePanel.getOtherPanel().getInputOrDecayPanel().setMark1Samples(this.mark1Samples);
            this.wavePanel.getOtherPanel().getInputOrDecayPanel().setMark2Samples(this.mark2Samples);
            this.wavePanel.getOtherPanel().getInputOrDecayPanel().repaint();
            if (this.wavePanel.getOtherPanel().getInputOrDecayPanel().ftDecay == InputFtDecay.InputFT) {
                this.analysisParams.calculateWindowFunction();
                this.analysisParams.updateSTFTParameters();
            } else {
                this.wavePanel.getOtherPanel().getInputOrDecayPanel().setAnalysisIsStale(true);
            }
        }
        if (this.ftDecay == InputFtDecay.InputFT) {
            this.analysisParams.calculateWindowFunction();
            this.analysisParams.updateSTFTParameters();
        } else {
            this.setAnalysisIsStale(true);
        }
    }

    public WavePanel getWavePanel() {
        return this.wavePanel;
    }

    public boolean getAnalysisIsStale() {
        return this.anlysisIsStale;
    }

    public void setAnalysisIsStale(boolean s) {
        this.anlysisIsStale = s;
    }

    static enum InputFtDecay {
        InputFT,
        InputDecay;

    }

    private class keyb
    implements KeyListener {
        private keyb() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 39) {
                if (InputPanel.this.mark1Selected) {
                    if (e.isShiftDown()) {
                        if (InputPanel.this.mark2Samples < InputPanel.this.frameLength - 1 && InputPanel.this.mark1Samples < InputPanel.this.xEndTimeSamples) {
                            ++InputPanel.this.mark1Samples;
                            ++InputPanel.this.mark2Samples;
                        }
                    } else {
                        if (InputPanel.this.mark1Samples + 1 < InputPanel.this.mark2Samples && InputPanel.this.mark1Samples + 1 < InputPanel.this.xEndTimeSamples) {
                            ++InputPanel.this.mark1Samples;
                        }
                        if (InputPanel.this.mark1Samples > InputPanel.this.waveSamples.length - 1) {
                            InputPanel.this.mark1Samples = InputPanel.this.waveSamples.length - 1;
                        }
                    }
                } else if (InputPanel.this.mark2Selected) {
                    if (e.isShiftDown()) {
                        if (InputPanel.this.mark2Samples < InputPanel.this.xEndTimeSamples) {
                            ++InputPanel.this.mark1Samples;
                            ++InputPanel.this.mark2Samples;
                        }
                    } else if (InputPanel.this.mark2Samples < InputPanel.this.xEndTimeSamples) {
                        ++InputPanel.this.mark2Samples;
                    }
                }
            } else if (e.getKeyCode() == 37) {
                if (InputPanel.this.mark1Selected) {
                    if (InputPanel.this.mark1Samples > InputPanel.this.xStartTimeSamples) {
                        --InputPanel.this.mark1Samples;
                    }
                    if (e.isShiftDown()) {
                        --InputPanel.this.mark2Samples;
                    }
                } else if (InputPanel.this.mark2Selected) {
                    if (e.isShiftDown()) {
                        if (InputPanel.this.mark1Samples > 0 && InputPanel.this.mark2Samples > InputPanel.this.xStartTimeSamples) {
                            --InputPanel.this.mark1Samples;
                            --InputPanel.this.mark2Samples;
                        }
                    } else if (InputPanel.this.mark2Samples - 1 > InputPanel.this.mark1Samples) {
                        --InputPanel.this.mark2Samples;
                    }
                }
            }
            if ((e.getKeyCode() == 39 || e.getKeyCode() == 37) && (InputPanel.this.mark1Selected || InputPanel.this.mark2Selected)) {
                InputPanel.this.mark1Pixels = (InputPanel.this.mark1Samples - InputPanel.this.xStartTimeSamples) / InputPanel.this.samplesPerPixel + InputPanel.this.xWaveBase;
                InputPanel.this.mark2Pixels = (InputPanel.this.mark2Samples - InputPanel.this.xStartTimeSamples) / InputPanel.this.samplesPerPixel + InputPanel.this.xWaveBase;
                InputPanel.this.markMovedActions();
                InputPanel.this.wavePanel.inputPanLimits();
                InputPanel.this.repaint();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

