/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import roundtrip.AnalysisParameters;
import roundtrip.Settings;
import roundtrip.SynthesisParameters;
import roundtrip.Utils;

class FRTmain
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final String programName = "Fourier Round Trip";
    private final String programVersion = "08.05";
    private static String exitDialog1 = "Are you sure you want to close this program?\n";
    private JMenuItem itemClose = new JMenuItem("Close");
    private JMenuItem itemSettings = new JMenuItem("Settings");
    private JMenuItem itemAbout = new JMenuItem("About");
    private JMenuItem itemRelNotes = new JMenuItem("Release Notes");
    private JMenuItem itemIHelp = new JMenuItem("Help");
    private JMenuItem itemManual = new JMenuItem("Extract Manual");
    private SynthesisParameters synthParams;
    private Point synthLastPosition = new Point(0, 0);
    private Dimension synthLastSize;
    private AnalysisParameters analysisParams;
    private Point analysisLastPosition = new Point(30, 50);
    private Dimension analysisLastSize;
    private Settings ourSettings;
    private int initialWidth = 550;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private LineBorder panelsBorder;

    public FRTmain() {
        Dimension initialSize;
        Handler ourExceptionHandler = new Handler();
        Thread.setDefaultUncaughtExceptionHandler(ourExceptionHandler);
        this.setTitle("Fourier Round Trip 08.05");
        this.setDefaultCloseOperation(0);
        this.setLayout(new BoxLayout(this.getContentPane(), 0));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension(this.initialWidth, screenSize.height));
        this.ourSettings = new Settings(this);
        this.ourSettings.setResizable(true);
        this.ourSettings.setVisible(false);
        this.panelsBorder = new LineBorder(Color.lightGray, 3);
        this.analysisLastSize = initialSize = new Dimension(950, (int)Math.round((double)screenSize.height * 0.8));
        this.synthLastSize = initialSize;
        this.getMainWindow().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                String exitDialog = exitDialog1;
                if (JOptionPane.showConfirmDialog(FRTmain.this.getMainWindow(), exitDialog, "Close Program?", 0, 3) == 0) {
                    System.exit(0);
                }
            }
        });
        JMenuBar mainMenu = new JMenuBar();
        JMenu menuProgram = new JMenu("Program");
        menuProgram.add(this.itemSettings);
        this.itemSettings.addActionListener(this);
        menuProgram.add(this.itemClose);
        this.itemClose.addActionListener(this);
        JMenu menuHelp = new JMenu("Help");
        menuHelp.add(this.itemRelNotes);
        this.itemRelNotes.addActionListener(this);
        menuHelp.add(this.itemAbout);
        this.itemAbout.addActionListener(this);
        menuHelp.add(this.itemIHelp);
        this.itemIHelp.addActionListener(this);
        menuHelp.add(this.itemManual);
        this.itemManual.addActionListener(this);
        mainMenu.add(menuProgram);
        mainMenu.add(menuHelp);
        this.setJMenuBar(mainMenu);
        this.itemClose.setToolTipText("Close the program");
        this.itemAbout.setToolTipText("Display information about the program");
        this.itemIHelp.setToolTipText("Display help information");
        this.itemManual.setToolTipText("Extract the user manual PDF to your disc and opens it");
        Box leftPanel = Box.createVerticalBox();
        TitledBorder leftTitle = new TitledBorder(this.panelsBorder, "Synthesis Parameters", 1, 2);
        leftPanel.setBorder(leftTitle);
        this.synthParams = new SynthesisParameters(this);
        leftPanel.add(this.synthParams);
        this.synthParams.focusNew();
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        TitledBorder rightTitle = new TitledBorder(this.panelsBorder, "Analysis Parameters", 1, 2);
        rightPanel.setBorder(rightTitle);
        this.analysisParams = new AnalysisParameters(this);
        rightPanel.add((Component)this.analysisParams, "North");
        rightPanel.add(new JPanel());
        this.tabbedPane.addTab("Synthesis", null, this.synthParams, "Synthesis parameters");
        this.tabbedPane.addTab("Analysis", null, this.analysisParams, "Analysis parameters");
        this.tabbedPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)this.tabbedPane, "Center");
        this.pack();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            var2_2 = e.getActionCommand();
            tmp = -1;
            switch (var2_2.hashCode()) {
                case -1836553944: {
                    if (var2_2.equals("Release Notes")) {
                        tmp = 1;
                    }
                    break;
                }
                case -1768732539: {
                    if (var2_2.equals("Extract Manual")) {
                        tmp = 2;
                    }
                    break;
                }
                case 2245473: {
                    if (var2_2.equals("Help")) {
                        tmp = 3;
                    }
                    break;
                }
                case 63058797: {
                    if (var2_2.equals("About")) {
                        tmp = 4;
                    }
                    break;
                }
                case 65203672: {
                    if (var2_2.equals("Close")) {
                        tmp = 5;
                    }
                    break;
                }
                case 1499275331: {
                    if (var2_2.equals("Settings")) {
                        tmp = 6;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 6: {
                    this.ourSettings.setVisible(true);
                    break;
                }
                case 5: {
                    exitDialog = FRTmain.exitDialog1;
                    closeSelection = JOptionPane.showConfirmDialog(this.getMainWindow(), exitDialog, "Close Program?", 0, 3);
                    if (closeSelection == 0) {
                        System.exit(0);
                    }
                    break;
                }
                case 1: {
                    relNotesFrame = new JFrame();
                    relNotesFrame.setDefaultCloseOperation(1);
                    relNotesFrame.setLocation(50, 50);
                    relNotesPane = new JEditorPane();
                    relNotesPane.setEditable(false);
                    relNotesPane.setContentType("text/html");
                    relNotesURL = this.getClass().getClassLoader().getResource("relnotes.html");
                    if (relNotesURL != null) {
                        try {
                            relNotesPane.setPage(relNotesURL);
                        }
                        catch (IOException rne) {
                            rne.printStackTrace();
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Release Notes file not found");
                    }
                    relNotesScrollPane = new JScrollPane(relNotesPane);
                    relNotesScrollPane.setPreferredSize(new Dimension(700, 600));
                    relNotesFrame.setLocation(this.getMainWindow().getX() + 100, this.getMainWindow().getY() + 100);
                    relNotesFrame.add(relNotesScrollPane);
                    relNotesFrame.setSize(700, 600);
                    relNotesFrame.setVisible(true);
                    break;
                }
                case 4: {
                    aboutFrame = new JFrame();
                    aboutFrame.setDefaultCloseOperation(1);
                    aboutFrame.setLocation(50, 50);
                    aboutPane = new JEditorPane();
                    aboutPane.setEditable(false);
                    aboutPane.setContentType("text/html");
                    aboutPane.addHyperlinkListener(new HyperlinkListener(){

                        @Override
                        public void hyperlinkUpdate(HyperlinkEvent hle) {
                            if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                                Desktop desktop = Desktop.getDesktop();
                                try {
                                    desktop.browse(hle.getURL().toURI());
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    });
                    aboutURL = this.getClass().getClassLoader().getResource("about.html");
                    if (aboutURL != null) {
                        try {
                            aboutPane.setPage(aboutURL);
                        }
                        catch (IOException rne) {
                            rne.printStackTrace();
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "About file not found");
                    }
                    versionText = "Program Version: 08.05 Java Version: " + System.getProperty("java.version") + " JRE " + System.getProperty("java.runtime.version");
                    aboutScrollPane = new JScrollPane(aboutPane);
                    aboutScrollPane.setPreferredSize(new Dimension(600, 400));
                    tlIconPanelTitle = new TitledBorder(new LineBorder(Color.lightGray, 3), versionText, 1, 2);
                    aboutScrollPane.setBorder(tlIconPanelTitle);
                    aboutFrame.add(aboutScrollPane);
                    aboutFrame.setSize(600, 400);
                    aboutFrame.setLocation(this.getMainWindow().getX() + 80, this.getMainWindow().getY() + 80);
                    aboutFrame.setVisible(true);
                    break;
                }
                case 3: {
                    helpFrame = new JFrame();
                    helpFrame.setLocation(250, 350);
                    helpFrame.setDefaultCloseOperation(1);
                    helpPane = new JEditorPane();
                    helpPane.setEditable(false);
                    helpPane.setContentType("text/html");
                    helpURL = this.getClass().getClassLoader().getResource("help.html");
                    if (helpURL != null) {
                        try {
                            helpPane.setPage(helpURL);
                        }
                        catch (IOException rne) {
                            rne.printStackTrace();
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Help file not found");
                    }
                    helpScrollPane = new JScrollPane(helpPane);
                    helpScrollPane.setPreferredSize(new Dimension(600, 400));
                    helpFrame.add(helpScrollPane);
                    helpFrame.setSize(550, 350);
                    helpFrame.setLocation(this.getMainWindow().getX() + 60, this.getMainWindow().getY() + 60);
                    helpFrame.setVisible(true);
                    break;
                }
                case 2: {
                    manualFile = null;
                    manualOK = false;
                    jarPath = Paths.get(FRTmain.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    jarPathString = jarPath.toString();
                    if (jarPathString.endsWith(".jar")) {
                        jarPathString = jarPath.getParent().toString();
                    }
                    jarPathString = (String)jarPathString + File.separator + "Fourier Round Trip_08.05.pdf";
                    jarPath = Paths.get((String)jarPathString, new String[0]);
                    manualStream = this.getClass().getResourceAsStream("FRT_Manual.pdf");
                    if (manualStream == null) ** GOTO lbl155
                    try {
                        Files.copy(manualStream, jarPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Manual copied to " + jarPath.toString() + "\nWill now open PDF");
                        manualFile = jarPath.toFile();
                        manualOK = true;
                    }
                    catch (IOException exc1) {
                        JOptionPane.showMessageDialog(this.getMainWindow(), "Manual file could not be written to location of jar file");
                        try {
                            userPath = Paths.get(System.getProperty("user.home") + File.separator + "Fourier Round Trip_08.05.pdf", new String[0]);
                            Files.copy(manualStream, userPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                            JOptionPane.showMessageDialog(this.getMainWindow(), "Manual copied to " + userPath.toString() + "\nWill now open PDF");
                            manualFile = userPath.toFile();
                            manualOK = true;
                            ** GOTO lbl156
                        }
                        catch (IOException exc2) {
                            JOptionPane.showMessageDialog(this.getMainWindow(), "Manual file could not be written to user folder - see Help");
                        }
                    }
                    ** GOTO lbl156
lbl155:
                    // 1 sources

                    JOptionPane.showMessageDialog(this.getMainWindow(), "Manual file not found in jar file");
lbl156:
                    // 4 sources

                    if (manualOK.booleanValue() && Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().open(manualFile);
                        }
                        catch (IOException | IllegalArgumentException exd) {
                            JOptionPane.showMessageDialog(this.getMainWindow(), "Cannot open user manual PDF file in desktop");
                        }
                    }
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this.getMainWindow(), "HGUI: Menu Item Listener called with invalid menu.");
                    break;
                }
            }
        }
        catch (Throwable unforeseen) {
            JOptionPane.showMessageDialog(this.getMainWindow(), "Unhandled Error!\n" + Utils.displayError(unforeseen));
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Could not set Look and Feel to Metal.");
        }
        try {
            Desktop.getDesktop().setQuitHandler(new QuitHandler(){

                @Override
                public void handleQuitRequestWith(QuitEvent q, QuitResponse r) {
                    if (JOptionPane.showConfirmDialog(null, exitDialog1, "Close Program without saving?", 0, 3) == 0) {
                        r.performQuit();
                    }
                    r.cancelQuit();
                }
            });
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        if (System.getProperty("os.name", "").toUpperCase().startsWith("MAC")) {
            InputMap im = (InputMap)UIManager.get("TextField.focusInputMap");
            FRTmain.setMacKeys(im);
            im = (InputMap)UIManager.get("FormattedTextField.focusInputMap");
            FRTmain.setMacKeys(im);
            im = (InputMap)UIManager.get("TextArea.focusInputMap");
            FRTmain.setMacKeys(im);
            im = (InputMap)UIManager.get("TextPane.focusInputMap");
            FRTmain.setMacKeys(im);
            im = (InputMap)UIManager.get("EditorPane.focusInputMap");
            FRTmain.setMacKeys(im);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Toolkit tk = Toolkit.getDefaultToolkit();
                    boolean dls = (Boolean)tk.getDesktopProperty("awt.dynamicLayoutSupported");
                    if (dls) {
                        tk.setDynamicLayout(false);
                    } else {
                        System.out.println("Setting dynamic layout is not supported, so window resizing might have poor performance.");
                    }
                }
                catch (HeadlessException h) {
                    System.out.println("Headless Exception");
                }
                FRTmain mainWindow = new FRTmain();
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice defaultScreen = ge.getDefaultScreenDevice();
                Rectangle rect = defaultScreen.getDefaultConfiguration().getBounds();
                int x = (int)rect.getMaxX() - mainWindow.getWidth();
                int y = 0;
                mainWindow.setLocation(x, y);
                mainWindow.setVisible(true);
                mainWindow.setMaximumSize(new Dimension(Toolkit.getDefaultToolkit().getScreenSize()));
            }
        });
    }

    private static void setMacKeys(InputMap im) {
        im.put(KeyStroke.getKeyStroke(65, 256), "select-all");
        im.put(KeyStroke.getKeyStroke(67, 256), "copy-to-clipboard");
        im.put(KeyStroke.getKeyStroke(86, 256), "paste-from-clipboard");
        im.put(KeyStroke.getKeyStroke(88, 256), "cut-to-clipboard");
        im.put(KeyStroke.getKeyStroke(37, 512), "caret-previous-word");
        im.put(KeyStroke.getKeyStroke(37, 576), "selection-previous-word");
        im.put(KeyStroke.getKeyStroke(37, 256), "caret-begin-line");
        im.put(KeyStroke.getKeyStroke(37, 320), "selection-begin-line");
        im.put(KeyStroke.getKeyStroke(39, 512), "caret-next-word");
        im.put(KeyStroke.getKeyStroke(39, 576), "selection-next-word");
        im.put(KeyStroke.getKeyStroke(39, 256), "caret-end-line");
        im.put(KeyStroke.getKeyStroke(39, 320), "selection-end-line");
        im.put(KeyStroke.getKeyStroke(38, 256), "caret-begin");
        im.put(KeyStroke.getKeyStroke(38, 320), "selection-begin");
        im.put(KeyStroke.getKeyStroke(40, 256), "caret-end");
        im.put(KeyStroke.getKeyStroke(40, 320), "selection-end");
    }

    public String getProgramVersion() {
        return "08.05";
    }

    public String getProgramName() {
        return "Fourier Round Trip";
    }

    public JFrame getMainWindow() {
        return this;
    }

    public SynthesisParameters getSynthParams() {
        return this.synthParams;
    }

    public AnalysisParameters getAnalysisParamsWindow() {
        return this.analysisParams;
    }

    public Settings getSettings() {
        return this.ourSettings;
    }

    public Point getAnalysisLastPosition() {
        return this.analysisLastPosition;
    }

    public void setAnalysisLastPosition(Point analysisLastPosition) {
        this.analysisLastPosition = analysisLastPosition;
    }

    public Dimension getAnalysisLastSize() {
        return this.analysisLastSize;
    }

    public void setAnalysisLastSize(Dimension analysisLastSize) {
        this.analysisLastSize = analysisLastSize;
    }

    public Point getSynthLastPosition() {
        return this.synthLastPosition;
    }

    public void setSynthLastPosition(Point synthLastPosition) {
        this.synthLastPosition = synthLastPosition;
    }

    public Dimension getSynthLastSize() {
        return this.synthLastSize;
    }

    public void setSynthLastSize(Dimension synthLastSize) {
        this.synthLastSize = synthLastSize;
    }

    public void showSynthesisTab() {
        this.tabbedPane.setSelectedIndex(0);
    }

    public void showAnalysisTab() {
        this.tabbedPane.setSelectedIndex(1);
    }

    private class Handler
    implements Thread.UncaughtExceptionHandler {
        private Handler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            System.out.println("FRTMain - Uncaught exception:" + String.valueOf(e) + " in thread:" + String.valueOf(t) + " name: " + t.getName() + " state:" + String.valueOf((Object)t.getState()));
            e.printStackTrace(System.out);
            JOptionPane.showMessageDialog(FRTmain.this.getMainWindow(), "The program has a problem \n" + String.valueOf(e) + "\nand will close.");
            System.exit(-1);
        }
    }
}

