/*
 * Decompiled with CFR 0.152.
 */
package roundtrip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import roundtrip.AnalysisParameters;
import roundtrip.DecayPanel;
import roundtrip.FRTmain;
import roundtrip.InputPanel;
import roundtrip.PhasePlotPanel;
import roundtrip.SpectrumPanel;
import roundtrip.VideoPanel;
import roundtrip.WavePanel;
import roundtrip.ZoomPanPanel;

class AnalysisWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private WavePanel ftWavePanel;
    private WavePanel decayWavePanel;
    private DecayPanel decayInputPanel;
    private InputPanel ftInputPanel;
    private AnalysisWindow thisWindow;
    private AnalysisParameters analysisParams;
    private SpectrumPanel spectrumPanel;
    private VideoPanel videoPanel;
    private int currentFrame = 0;
    private double stdInterval;
    private Thread playThread;
    private boolean stop = false;
    private JPanel phasePanel;
    private PhasePlotPanel phasePlotPanel;
    private ZoomPanPanel spectrumZoomPanel;
    private LineBorder panelsBorder;

    AnalysisWindow(final FRTmain mainGUI) {
        this.setTitle("Analysis");
        this.thisWindow = this;
        this.analysisParams = mainGUI.getAnalysisParamsWindow();
        Point newPos = new Point(mainGUI.getAnalysisLastPosition().x, mainGUI.getAnalysisLastPosition().y + 27);
        this.setLocation(newPos);
        this.setPreferredSize(mainGUI.getAnalysisLastSize());
        this.setSize(mainGUI.getAnalysisLastSize());
        this.panelsBorder = new LineBorder(Color.lightGray, 3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AnalysisWindow.this.analysisParams.analWinCloseActions();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ce) {
                mainGUI.setAnalysisLastSize(AnalysisWindow.this.thisWindow.getSize());
                AnalysisWindow.this.ftWavePanel.inputPanLimits();
                AnalysisWindow.this.decayWavePanel.inputPanLimits();
                AnalysisWindow.this.spectrumPanel.spectrumPanLimits();
                AnalysisWindow.this.configurePanels(false);
            }

            @Override
            public void componentMoved(ComponentEvent ce) {
                mainGUI.setAnalysisLastPosition(AnalysisWindow.this.thisWindow.getLocation());
            }
        });
        this.decayWavePanel = new WavePanel(mainGUI, this, this.analysisParams.getRawWave(), InputPanel.InputFtDecay.InputDecay);
        this.decayInputPanel = (DecayPanel)this.decayWavePanel.getInputOrDecayPanel();
        TitledBorder decayTitle = new TitledBorder(this.panelsBorder, "Average and Decay", 2, 2);
        this.decayWavePanel.setBorder(decayTitle);
        this.ftWavePanel = new WavePanel(mainGUI, this, this.analysisParams.getRawWave(), InputPanel.InputFtDecay.InputFT);
        this.ftInputPanel = this.ftWavePanel.getInputOrDecayPanel();
        TitledBorder ftWaveTitle = new TitledBorder(this.panelsBorder, "Input Wave", 2, 2);
        this.ftWavePanel.setBorder(ftWaveTitle);
        this.spectrumZoomPanel = new ZoomPanPanel(true);
        Responder zoomPanResponder = new Responder();
        this.spectrumZoomPanel.addListener(zoomPanResponder);
        this.decayWavePanel.setOtherPanel(this.ftWavePanel);
        this.ftWavePanel.setOtherPanel(this.decayWavePanel);
        this.spectrumPanel = new SpectrumPanel(mainGUI, this.spectrumZoomPanel);
        TitledBorder spectrumTitle = new TitledBorder(this.panelsBorder, "Fourier Transform Frequency Spectrum", 2, 2);
        this.spectrumPanel.setBorder(spectrumTitle);
        this.videoPanel = new VideoPanel(this.thisWindow);
        VideoResponder videoResponder = new VideoResponder();
        this.videoPanel.addListener(videoResponder);
        this.phasePanel = new JPanel();
        TitledBorder phaseTitle = new TitledBorder(this.panelsBorder, "Fourier Transform Phase Spectrum", 2, 2);
        this.phasePanel.setBorder(phaseTitle);
        this.phasePanel.setLayout(new BorderLayout());
        this.phasePlotPanel = new PhasePlotPanel(mainGUI);
        this.phasePlotPanel.setLayout(new BorderLayout());
        this.phasePanel.add(this.phasePlotPanel);
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.add(this.decayWavePanel);
        this.add(this.ftWavePanel);
        this.add(this.spectrumPanel);
        this.add(this.videoPanel);
        this.add(this.phasePanel);
        this.add(this.spectrumZoomPanel);
        this.spectrumPanel.spectrumPanLimits();
        this.pack();
        this.configurePanels(true);
        this.repaint();
    }

    private void playBck(long time) {
        while (this.currentFrame >= 0 && !this.stop) {
            this.spectrumPanel.getSpectrumPlotPanel().setFrame(this.currentFrame);
            this.setVideoCursor();
            this.videoPanel.updateFrame();
            --this.currentFrame;
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void playFwd(long time) {
        while (this.currentFrame < this.analysisParams.getFtNframes() && !this.stop) {
            this.spectrumPanel.getSpectrumPlotPanel().setFrame(this.currentFrame);
            this.setVideoCursor();
            this.videoPanel.updateFrame();
            ++this.currentFrame;
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void configurePanels(boolean refresh) {
        int panels = 0;
        if (this.analysisParams.getFFTShowInput()) {
            if (this.ftWavePanel != null) {
                this.ftWavePanel.setVisible(true);
                ++panels;
            }
        } else if (this.ftWavePanel != null) {
            this.ftWavePanel.setVisible(false);
        }
        if (this.analysisParams.getFFTShowSpectrum()) {
            if (this.spectrumPanel != null) {
                this.spectrumPanel.setVisible(true);
                ++panels;
                if (this.analysisParams.getFTcombine() == AnalysisParameters.FTcombine.STFT) {
                    this.videoPanel.setVisible(true);
                } else {
                    this.videoPanel.setVisible(false);
                }
            }
        } else {
            if (this.spectrumPanel != null) {
                this.spectrumPanel.setVisible(false);
            }
            this.videoPanel.setVisible(false);
        }
        if (this.analysisParams.getFFTShowPhase()) {
            if (this.phasePanel != null) {
                this.phasePanel.setVisible(true);
                ++panels;
            }
        } else if (this.phasePanel != null) {
            this.phasePanel.setVisible(false);
        }
        if (this.analysisParams.getShowAvg()) {
            if (this.decayWavePanel != null) {
                this.decayWavePanel.setVisible(true);
                ++panels;
            }
        } else if (this.decayWavePanel != null) {
            this.decayWavePanel.setVisible(false);
        }
        int spectrumZoomHeight = 0;
        if (this.analysisParams.getFFTShowSpectrum() || this.analysisParams.getFFTShowPhase()) {
            this.spectrumZoomPanel.setVisible(true);
            spectrumZoomHeight = this.spectrumZoomPanel.getHeight();
        } else {
            this.spectrumZoomPanel.setVisible(false);
        }
        int insets = this.thisWindow.getInsets().top;
        int availableHeight = (int)Math.ceil(this.thisWindow.getHeight() - insets - spectrumZoomHeight);
        if (this.videoPanel.isVisible()) {
            availableHeight -= this.videoPanel.getHeight();
        }
        int height = availableHeight / Math.max(panels, 1);
        this.ftWavePanel.setPreferredSize(new Dimension(this.ftWavePanel.getWidth(), height));
        this.spectrumPanel.setPreferredSize(new Dimension(this.ftWavePanel.getWidth(), height));
        this.phasePanel.setPreferredSize(new Dimension(this.ftWavePanel.getWidth(), height));
        this.decayWavePanel.setPreferredSize(new Dimension(this.ftWavePanel.getWidth(), height));
        if (refresh) {
            this.thisWindow.revalidate();
        }
    }

    private void setVideoCursor() {
        int cursor = this.getFtInputPanel().getMark1Samples() + this.analysisParams.getFtStepSamples() * this.currentFrame;
        this.ftInputPanel.setCursor(cursor);
    }

    public AnalysisParameters getAnalysisParameters() {
        return this.analysisParams;
    }

    public SpectrumPanel getSpectrumPanel() {
        return this.spectrumPanel;
    }

    public ZoomPanPanel getSpectrumZoomPanel() {
        return this.spectrumZoomPanel;
    }

    public WavePanel getftWavePanel() {
        return this.ftWavePanel;
    }

    public InputPanel getFtInputPanel() {
        return this.ftInputPanel;
    }

    public DecayPanel getDecayInputPanel() {
        return this.decayInputPanel;
    }

    public VideoPanel getVideoPanel() {
        return this.videoPanel;
    }

    public void setAnalysisTitle(String t) {
        this.thisWindow.setTitle("Analysis: " + t);
    }

    public void setCurrentFrame(int f) {
        this.currentFrame = f;
        this.videoPanel.repaint();
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public void stop() {
        this.stop = true;
        if (this.playThread != null) {
            this.playThread.interrupt();
        }
    }

    private class Responder
    implements ZoomPanPanel.ZoomPanListener {
        private Responder() {
        }

        @Override
        public void zoomedPanned() {
            if (AnalysisWindow.this.spectrumPanel != null) {
                AnalysisWindow.this.spectrumPanel.spectrumPanLimits();
                AnalysisWindow.this.spectrumPanel.revalidate();
                AnalysisWindow.this.spectrumPanel.repaint();
            }
            if (AnalysisWindow.this.phasePanel != null) {
                AnalysisWindow.this.phasePanel.revalidate();
                AnalysisWindow.this.phasePanel.repaint();
            }
        }
    }

    private class VideoResponder
    implements VideoPanel.VideoButtonListener {
        private VideoResponder() {
        }

        @Override
        public void videoEvent(String button) {
            switch (button) {
                case "Start": {
                    AnalysisWindow.this.currentFrame = 0;
                    AnalysisWindow.this.videoPanel.updateFrame();
                    AnalysisWindow.this.spectrumPanel.getSpectrumPlotPanel().setFrame(AnalysisWindow.this.currentFrame);
                    AnalysisWindow.this.setVideoCursor();
                    break;
                }
                case "End": {
                    AnalysisWindow.this.currentFrame = AnalysisWindow.this.analysisParams.getFtNframes() - 1;
                    AnalysisWindow.this.videoPanel.updateFrame();
                    AnalysisWindow.this.spectrumPanel.getSpectrumPlotPanel().setFrame(AnalysisWindow.this.currentFrame);
                    AnalysisWindow.this.setVideoCursor();
                    break;
                }
                case "Bck": {
                    AnalysisWindow.this.stop = false;
                    AnalysisWindow.this.playThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ((VideoResponder)VideoResponder.this).AnalysisWindow.this.stdInterval = (double)((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getFtStepSamples() / (double)((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getAnalysisWindow().getFtInputPanel().getSampleRate() * 1000.0;
                            long time = (long)(((VideoResponder)VideoResponder.this).AnalysisWindow.this.stdInterval / ((VideoResponder)VideoResponder.this).AnalysisWindow.this.videoPanel.getSpeed());
                            AnalysisWindow.this.playBck(time);
                            ((VideoResponder)VideoResponder.this).AnalysisWindow.this.videoPanel.unPauseButtons();
                            if (((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame < 0) {
                                ((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame = 0;
                            }
                        }
                    });
                    AnalysisWindow.this.playThread.start();
                    break;
                }
                case "Fwd": {
                    AnalysisWindow.this.stop = false;
                    AnalysisWindow.this.playThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ((VideoResponder)VideoResponder.this).AnalysisWindow.this.stdInterval = (double)((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getFtStepSamples() / (double)((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getAnalysisWindow().getFtInputPanel().getSampleRate() * 1000.0;
                            long time = (long)(((VideoResponder)VideoResponder.this).AnalysisWindow.this.stdInterval / ((VideoResponder)VideoResponder.this).AnalysisWindow.this.videoPanel.getSpeed());
                            AnalysisWindow.this.playFwd(time);
                            ((VideoResponder)VideoResponder.this).AnalysisWindow.this.videoPanel.unPauseButtons();
                            if (((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame >= ((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getFtNframes()) {
                                ((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame = ((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getFtNframes() - 1;
                            }
                        }
                    });
                    AnalysisWindow.this.playThread.start();
                    break;
                }
                case "StepBck": {
                    int tmp = AnalysisWindow.this.currentFrame - 1;
                    if (tmp < 0) {
                        tmp = 0;
                    }
                    AnalysisWindow.this.currentFrame = tmp;
                    AnalysisWindow.this.spectrumPanel.getSpectrumPlotPanel().setFrame(AnalysisWindow.this.currentFrame);
                    AnalysisWindow.this.setVideoCursor();
                    AnalysisWindow.this.videoPanel.updateFrame();
                    break;
                }
                case "StepFwd": {
                    int tmp = AnalysisWindow.this.currentFrame + 1;
                    AnalysisWindow.this.currentFrame = Math.min(tmp, AnalysisWindow.this.analysisParams.getFtNframes() - 1);
                    AnalysisWindow.this.spectrumPanel.getSpectrumPlotPanel().setFrame(AnalysisWindow.this.currentFrame);
                    AnalysisWindow.this.setVideoCursor();
                    AnalysisWindow.this.videoPanel.updateFrame();
                    break;
                }
                case "Loop": {
                    AnalysisWindow.this.stop = false;
                    AnalysisWindow.this.playThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (!((VideoResponder)VideoResponder.this).AnalysisWindow.this.stop) {
                                ((VideoResponder)VideoResponder.this).AnalysisWindow.this.stdInterval = (double)((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getFtStepSamples() / (double)((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getAnalysisWindow().getFtInputPanel().getSampleRate() * 1000.0;
                                long time = (long)(((VideoResponder)VideoResponder.this).AnalysisWindow.this.stdInterval / ((VideoResponder)VideoResponder.this).AnalysisWindow.this.videoPanel.getSpeed());
                                if (!((VideoResponder)VideoResponder.this).AnalysisWindow.this.stop) {
                                    AnalysisWindow.this.playFwd(time);
                                }
                                ((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame = 0;
                            }
                            ((VideoResponder)VideoResponder.this).AnalysisWindow.this.videoPanel.unPauseButtons();
                            if (((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame < 0) {
                                ((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame = 0;
                            }
                            if (((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame >= ((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getFtNframes()) {
                                ((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame = ((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getFtNframes() - 1;
                            }
                        }
                    });
                    AnalysisWindow.this.playThread.start();
                    break;
                }
                case "Bounce": {
                    AnalysisWindow.this.stop = false;
                    AnalysisWindow.this.playThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (!((VideoResponder)VideoResponder.this).AnalysisWindow.this.stop) {
                                ((VideoResponder)VideoResponder.this).AnalysisWindow.this.stdInterval = (double)((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getFtStepSamples() / (double)((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getAnalysisWindow().getFtInputPanel().getSampleRate() * 1000.0;
                                long time = (long)(((VideoResponder)VideoResponder.this).AnalysisWindow.this.stdInterval / ((VideoResponder)VideoResponder.this).AnalysisWindow.this.videoPanel.getSpeed());
                                if (!((VideoResponder)VideoResponder.this).AnalysisWindow.this.stop) {
                                    AnalysisWindow.this.playFwd(time);
                                }
                                --((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame;
                                if (!((VideoResponder)VideoResponder.this).AnalysisWindow.this.stop) {
                                    AnalysisWindow.this.playBck(time);
                                }
                                if (((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame < 0) {
                                    ((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame = 0;
                                }
                                if (((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame < ((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getFtNframes()) continue;
                                ((VideoResponder)VideoResponder.this).AnalysisWindow.this.currentFrame = ((VideoResponder)VideoResponder.this).AnalysisWindow.this.analysisParams.getFtNframes() - 1;
                            }
                            ((VideoResponder)VideoResponder.this).AnalysisWindow.this.videoPanel.unPauseButtons();
                        }
                    });
                    AnalysisWindow.this.playThread.start();
                    break;
                }
                default: {
                    System.out.println("Unexpected button in STFT video panel.");
                }
            }
        }
    }
}

