/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;

class WindowManager {
    private GraphicsConfiguration mainWindowConfig;
    private GraphicsDevice graphicsDevice;
    private CDgui mainWindow;
    private int newScreenIndex;
    private int oldScreenIndex;
    private GraphicsEnvironment env;
    private GraphicsDevice[] allScreens;
    private Insets insets;
    private int currentScreenX;
    private int currentScreenY;
    private int xStart_Left;
    private int xStart_Right;
    private int yStart_Top;
    private int xNext_Left;
    private int xNext_Right;
    private int yNext_Top;
    private int xPos = 0;
    private int yPos = 0;
    private static final int xCascade = 20;
    private static final int yCascade = 20;
    private int openWindows = 0;

    WindowManager(CDgui mainWindow) {
        this.mainWindow = mainWindow;
        this.setCurrentConfig();
    }

    public <T extends JFrame> void positionWindow(T window, ScreenSide where) {
        this.setCurrentConfig();
        if (this.newScreenIndex != this.oldScreenIndex) {
            this.resetWindows();
            this.oldScreenIndex = this.newScreenIndex;
        }
        int w = window.getWidth();
        int h = window.getHeight();
        Point result = new Point(0, 0);
        switch (where) {
            case TOP_LEFT: {
                result.setLocation(this.currentScreenX, this.currentScreenY);
                break;
            }
            case TOP_RIGHT: {
                this.xPos = this.currentScreenX + this.allScreens[this.newScreenIndex].getDefaultConfiguration().getBounds().width - this.insets.right - w;
                this.yPos = this.currentScreenY + this.insets.top;
                result.setLocation(this.xPos, this.yPos);
                break;
            }
            case BOTTOM_LEFT: {
                this.xPos = this.currentScreenX;
                this.yPos = this.currentScreenY + this.allScreens[this.newScreenIndex].getDefaultConfiguration().getBounds().height - this.insets.bottom - h;
                result.setLocation(this.xPos, this.yPos);
                break;
            }
            case BOTTOM_RIGHT: {
                this.xPos = this.currentScreenX + this.allScreens[this.newScreenIndex].getDefaultConfiguration().getBounds().width - this.insets.right - w;
                this.yPos = this.currentScreenY + this.allScreens[this.newScreenIndex].getDefaultConfiguration().getBounds().height - this.insets.bottom - h;
                result.setLocation(this.xPos, this.yPos);
                break;
            }
            case CASCADE_TL: {
                this.xNext_Left += 20;
                this.yNext_Top += 20;
                result.setLocation(this.currentScreenX + this.xNext_Left, this.currentScreenY + this.yNext_Top);
                break;
            }
            case CASCADE_TR: {
                this.xNext_Right -= 20;
                if (this.openWindows <= 0) {
                    this.xNext_Right -= w;
                }
                this.yNext_Top += 20;
                result.setLocation(this.currentScreenX + this.xNext_Right, this.currentScreenY + this.yNext_Top);
                break;
            }
            default: {
                System.out.println("*** Bad position argument in WindowManager");
            }
        }
        window.setLocation(result);
        window.setResizable(true);
        window.setVisible(true);
        if (where.equals((Object)ScreenSide.CASCADE_TL) || where.equals((Object)ScreenSide.CASCADE_TR)) {
            ++this.openWindows;
        }
    }

    public void closeWindow() {
        --this.openWindows;
        if (this.openWindows <= 0) {
            this.xNext_Right = this.xStart_Right;
            this.yNext_Top = this.yStart_Top;
        }
        if (this.openWindows < 0) {
            System.out.println("WindowManager closed too many windows " + this.openWindows);
        }
    }

    public void resetWindows() {
        this.resetCascade();
        this.openWindows = 0;
    }

    private void setCurrentConfig() {
        this.mainWindowConfig = this.mainWindow.getGraphicsConfiguration();
        this.insets = Toolkit.getDefaultToolkit().getScreenInsets(this.mainWindowConfig);
        this.graphicsDevice = this.mainWindowConfig.getDevice();
        this.env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.allScreens = this.env.getScreenDevices();
        this.newScreenIndex = -1;
        int j = 0;
        while (j < this.allScreens.length) {
            if (this.allScreens[j].equals(this.graphicsDevice)) {
                this.newScreenIndex = j;
                this.currentScreenX = (int)this.allScreens[j].getDefaultConfiguration().getBounds().getX();
                this.currentScreenY = (int)this.allScreens[j].getDefaultConfiguration().getBounds().getY();
                break;
            }
            ++j;
        }
    }

    private void resetCascade() {
        this.xStart_Right = this.allScreens[this.newScreenIndex].getDefaultConfiguration().getBounds().width - this.insets.right;
        this.xStart_Left = this.insets.left;
        this.yStart_Top = this.insets.top;
        this.xNext_Left = this.xStart_Left;
        this.xNext_Right = this.xStart_Right;
        this.yNext_Top = this.yStart_Top;
    }

    public Rectangle2D getCurrentScreenBounds() {
        return this.allScreens[this.newScreenIndex].getDefaultConfiguration().getBounds();
    }

    static enum ScreenSide {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        CASCADE_TR,
        CASCADE_TL;

    }
}

