/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.CommonData;
import culturalDynamics.Connection;
import culturalDynamics.ConnectionData;
import culturalDynamics.Event;
import culturalDynamics.EventData;
import culturalDynamics.Find;
import culturalDynamics.Palette;
import culturalDynamics.Preferences;
import culturalDynamics.Row;
import culturalDynamics.RowData;
import culturalDynamics.Segment;
import culturalDynamics.SegmentList;
import culturalDynamics.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class TimePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Color exportBackground = Color.WHITE;
    private final Color graphicBackground = new Color(250, 250, 250);
    private final Color eventNameBoundsColor = Color.LIGHT_GRAY;
    private final int untimedXgap = 5;
    private final int untimedYgap = 10;
    private int untimedAreaHeight;
    private int minEventDistanceBelow = 5;
    private int emptyRowHeight = 20;
    private double segmentAscent;
    private int segmentAscentInt;
    private double segmentHeight;
    private int segmentHeightInt;
    private int xAxisHeight;
    private int maxSegLine;
    private int maxYscreen;
    private boolean screenEnabled = true;
    private CDgui ourGUI;
    private Graphics2D g2dScreen;
    private boolean rowLabelsChoice;
    private int waveAmplitude = 5;
    private int wavelength = 10;
    private int waveSteps = 20;
    private double[] halfWave1 = new double[this.waveSteps];
    private double[] halfWave2 = new double[this.waveSteps];
    private double helixAmplitude = 5.0;
    private int helixPitch = 10;
    private int helixSteps = 30;
    private double[] circleX = new double[this.helixSteps];
    private double[] circleY = new double[this.helixSteps];
    private double pFactor = (double)this.helixPitch * this.helixAmplitude / (Math.PI * 2);
    private double helixDX = 0.0;
    private double bezCtrlX = 0.1;
    private double bezCtrlY = 0.2;
    private int arrowLength = 20;
    private int arrowTail = 5;
    private int arrowHWidth = 6;
    private boolean showAges = true;
    private int ageTickHeight = 10;
    private int bracketHeight = 10;
    private int highlightWidth = 50;
    private int highlightHeight = this.bracketHeight * 2 + 4;
    private int panelWidth = 1000;
    private int marginLeft;
    private int marginRight;
    private int marginTop;
    private int marginBottom;
    private final int xAxisTickLength;
    private int nTicks;
    private Find.Found foundItem = null;
    private HighlightEnd foundCnSrc = HighlightEnd.SRC;
    private final RowData rowData;
    private final ConnectionData connectionData;
    private Preferences prefs;

    TimePanel(CDgui mainGUI, ConnectionData connectionDataIn, int nTicks) {
        this.ourGUI = mainGUI;
        if (this.getWidth() != 0) {
            this.panelWidth = this.getWidth();
        }
        this.xAxisTickLength = 20;
        this.connectionData = connectionDataIn;
        this.nTicks = nTicks;
        this.prefs = this.ourGUI.getPreferences();
        this.rowData = this.ourGUI.getRowData();
    }

    public void export(Layout layout, XaxisPaging xAxisPerPage, SplitRows splitRows, int dpi, double scale, int imageWidthPx, int imageHeightPx, LocalDate startDate, int rangeDays, File exportFileIn, String fileType, Scaling print) {
        this.ourGUI.setViewPortTop();
        File exportFile = exportFileIn;
        int finalWidth = 0;
        int basicWidth = 0;
        double scaleFactor = 1.0;
        if (print.equals((Object)Scaling.PRINTER)) {
            finalWidth = imageWidthPx;
            scaleFactor = (double)dpi / 72.0;
            basicWidth = (int)Math.round((double)imageWidthPx / scaleFactor);
        } else {
            finalWidth = (int)((double)imageWidthPx * scale);
            scaleFactor = scale;
            basicWidth = imageWidthPx;
        }
        int basicHeight = this.maxYscreen;
        int scaledHeight = (int)Math.round(scaleFactor * (double)basicHeight);
        int scaledXAxisHeight = (int)Math.round(scaleFactor * (double)this.xAxisHeight);
        int pageCounter = 1;
        BufferedImage exportImage = new BufferedImage(finalWidth, 100, 1);
        BufferedImage xAxisImage = null;
        Graphics2D g2dExport = this.initaliseImage(exportImage, finalWidth, 100, scaleFactor);
        FontMetrics metrics = g2dExport.getFontMetrics(this.prefs.getTimeAxisFont());
        this.xAxisHeight = metrics.getHeight() * 2 + this.xAxisTickLength + metrics.getDescent() + 1;
        this.ourGUI.getExportDialog().setWorking("Exporting");
        this.ourGUI.setViewportTopLeft();
        switch (layout) {
            case SINGLE_IMAGE: 
            case MULTIPLE_HIGH: {
                this.prefs = this.ourGUI.getPreferences();
                this.getPreferences(this.ourGUI);
                LocalDate endDate = startDate.plusDays(rangeDays);
                if (this.showAges) {
                    this.ageTickHeight = g2dExport.getFontMetrics(this.prefs.getTlNameFont()).getHeight();
                }
                int maxHeight = this.drawData(g2dExport, startDate, endDate, basicWidth, -1);
                maxHeight = Math.max(maxHeight, 100);
                int scaledMaxHeight = (int)Math.ceil((double)(maxHeight += g2dExport.getFontMetrics(this.prefs.getTimeAxisFont()).getHeight()) * scaleFactor);
                exportImage = new BufferedImage(finalWidth, scaledMaxHeight, 1);
                g2dExport = this.initaliseImage(exportImage, finalWidth, scaledMaxHeight, scaleFactor);
                this.drawData(g2dExport, startDate, endDate, basicWidth, scaledMaxHeight);
                this.drawYearLines(g2dExport, startDate, endDate, basicWidth, maxHeight, BottomMargin.NO_MARGIN);
                String[] xAxis = this.createXAxis(startDate, endDate);
                xAxisImage = new BufferedImage(finalWidth, scaledXAxisHeight, 1);
                Graphics2D xAxis2d = xAxisImage.createGraphics();
                xAxis2d.scale(scaleFactor, scaleFactor);
                xAxis2d.setColor(this.exportBackground);
                xAxis2d.fillRect(0, 0, finalWidth, scaledXAxisHeight);
                this.drawXAxis(xAxis2d, xAxis, basicWidth, this.xAxisHeight, BottomMargin.NO_MARGIN);
                xAxis2d.dispose();
                break;
            }
            case FULL_DIAGRAM: {
                JOptionPane.showMessageDialog(this, "Full Diagram - Not implemented yet");
                this.ourGUI.getExportDialog().setWorking("Export failed");
                return;
            }
            default: {
                JOptionPane.showMessageDialog(this, "Export called with invalid layout " + String.valueOf((Object)layout));
                this.ourGUI.getExportDialog().setWorking("Export failed");
                return;
            }
        }
        Object biggerPages = "";
        switch (layout) {
            case SINGLE_IMAGE: {
                exportImage = this.appendXAxis(exportImage, xAxisImage);
                try {
                    if (!ImageIO.write((RenderedImage)exportImage, fileType, exportFile)) {
                        JOptionPane.showMessageDialog(this, "TimePanel write export image: No writer for image type ");
                    }
                }
                catch (IOException io) {
                    JOptionPane.showMessageDialog(this, "Error writing export image file " + exportFile.getAbsolutePath() + " Error: " + String.valueOf(io));
                    this.ourGUI.getExportDialog().setWorking("Export failed");
                }
                ++pageCounter;
                break;
            }
            case MULTIPLE_HIGH: {
                pageCounter = 1;
                String exportPath = exportFile.getAbsolutePath();
                String[] pathParts = exportPath.split("\\.");
                if (splitRows.equals((Object)SplitRows.SPLIT)) {
                    int currentY = 0;
                    int pageHeight = imageHeightPx;
                    if (xAxisPerPage.equals((Object)XaxisPaging.EVERY_PAGE)) {
                        pageHeight -= scaledXAxisHeight;
                    }
                    boolean lastPage = false;
                    while (currentY < scaledHeight - scaledXAxisHeight) {
                        BufferedImage pageImage = new BufferedImage(finalWidth, pageHeight, 1);
                        if (currentY + pageHeight > scaledHeight) {
                            pageHeight = scaledHeight - currentY;
                            lastPage = true;
                        }
                        pageImage = exportImage.getSubimage(0, currentY, finalWidth, pageHeight);
                        if (xAxisPerPage.equals((Object)XaxisPaging.EVERY_PAGE) || lastPage) {
                            pageImage = this.appendXAxis(pageImage, xAxisImage);
                        }
                        String newPath = pathParts[0] + "_" + String.valueOf(pageCounter) + "." + pathParts[1];
                        exportFile = new File(newPath);
                        try {
                            this.ourGUI.getExportDialog().setWorking("Exporting " + newPath);
                            if (!ImageIO.write((RenderedImage)pageImage, fileType, exportFile)) {
                                JOptionPane.showMessageDialog(this, "TimePanel write export image: No writer for image type ");
                            }
                        }
                        catch (IOException io) {
                            JOptionPane.showMessageDialog(this, "Error writing export image file " + exportFile.getAbsolutePath() + " Error: " + String.valueOf(io));
                            this.ourGUI.getExportDialog().setWorking("Export failed");
                        }
                        currentY += pageHeight + 1;
                        ++pageCounter;
                    }
                    break;
                }
                int pageHeight = imageHeightPx;
                if (xAxisPerPage.equals((Object)XaxisPaging.EVERY_PAGE)) {
                    pageHeight -= scaledXAxisHeight;
                }
                int pageStart = 0;
                int pageEnd = pageHeight;
                int r = 1;
                while (r < this.rowData.getSize()) {
                    int rowY;
                    if (this.rowData.getRowByIndex(r).isShown() && (rowY = (int)Math.round((double)this.rowData.getRowByIndex(r).getRowY() * scaleFactor)) >= pageEnd) {
                        pageEnd = (int)Math.round((double)this.rowData.getRowByIndex(r - 1).getRowY() * scaleFactor);
                        if (pageEnd - pageStart > pageHeight) {
                            biggerPages = (String)biggerPages + pageCounter + " ";
                        }
                        BufferedImage pageImage = new BufferedImage(finalWidth, pageEnd - pageStart, 1);
                        pageImage = exportImage.getSubimage(0, pageStart, finalWidth, pageEnd - pageStart);
                        if (xAxisPerPage.equals((Object)XaxisPaging.EVERY_PAGE)) {
                            pageImage = this.appendXAxis(pageImage, xAxisImage);
                        }
                        String newPath = pathParts[0] + "_" + String.valueOf(pageCounter) + "." + pathParts[1];
                        exportFile = new File(newPath);
                        try {
                            this.ourGUI.getExportDialog().setWorking("Exporting " + newPath);
                            if (!ImageIO.write((RenderedImage)pageImage, fileType, exportFile)) {
                                JOptionPane.showMessageDialog(this, "TimePanel write export image: No writer for image type ");
                            }
                        }
                        catch (IOException io) {
                            JOptionPane.showMessageDialog(this, "Error writing export image file " + exportFile.getAbsolutePath() + " Error: " + String.valueOf(io));
                            this.ourGUI.getExportDialog().setWorking("Export failed");
                        }
                        pageStart = pageEnd + 1;
                        pageEnd = pageStart + pageHeight;
                        ++pageCounter;
                    }
                    ++r;
                }
                if (pageStart >= scaledHeight) break;
                pageEnd = scaledHeight;
                BufferedImage pageImage = new BufferedImage(finalWidth, pageEnd - pageStart, 1);
                pageImage = exportImage.getSubimage(0, pageStart, finalWidth, pageEnd - pageStart);
                if ((pageImage = this.appendXAxis(pageImage, xAxisImage)).getHeight() > pageHeight) {
                    biggerPages = (String)biggerPages + pageCounter + " ";
                }
                String newPath = pathParts[0] + "_" + String.valueOf(pageCounter) + "." + pathParts[1];
                exportFile = new File(newPath);
                try {
                    this.ourGUI.getExportDialog().setWorking("Exporting " + newPath);
                    if (!ImageIO.write((RenderedImage)pageImage, fileType, exportFile)) {
                        JOptionPane.showMessageDialog(this, "TimePanel write export image: No writer for image type ");
                    }
                }
                catch (IOException io) {
                    JOptionPane.showMessageDialog(this, "Error writing export image file " + exportFile.getAbsolutePath() + " Error: " + String.valueOf(io));
                    this.ourGUI.getExportDialog().setWorking("Export failed");
                }
                ++pageCounter;
                break;
            }
            case FULL_DIAGRAM: {
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this, "Export called with invalid layout " + String.valueOf((Object)layout));
                this.ourGUI.getExportDialog().setWorking("Export failed");
            }
        }
        if (!((String)biggerPages).equals("")) {
            biggerPages = " The following pages are taller: " + (String)biggerPages;
        }
        this.ourGUI.getExportDialog().setWorking("Export done " + String.valueOf(pageCounter - 1) + " pages." + (String)biggerPages);
        this.repaint();
    }

    private Graphics2D initaliseImage(BufferedImage img, int w, int h, double scaling) {
        Graphics2D g2d = img.createGraphics();
        g2d.scale(scaling, scaling);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setColor(this.exportBackground);
        g2d.fillRect(0, 0, w, h);
        return g2d;
    }

    private BufferedImage appendXAxis(BufferedImage image1, BufferedImage image2) {
        int totalHeight = image1.getHeight() + image2.getHeight() + 1;
        BufferedImage totalImage = new BufferedImage(image1.getWidth(), totalHeight, 1);
        Graphics2D g2D = totalImage.createGraphics();
        g2D.drawImage(image1, null, 0, 0);
        g2D.drawImage(image2, null, 0, image1.getHeight() + 1);
        g2D.dispose();
        return totalImage;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.panelWidth, this.maxYscreen);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.screenEnabled) {
            return;
        }
        super.paintComponent(g);
        this.g2dScreen = (Graphics2D)g;
        this.getPreferences(this.ourGUI);
        FontMetrics metrics = g.getFontMetrics(this.prefs.getTimeAxisFont());
        this.xAxisHeight = metrics.getHeight() * 2 + this.xAxisTickLength + metrics.getDescent() + 1;
        this.ourGUI.getXAxis().revalidate();
        this.ourGUI.getXAxis().repaint();
        LocalDate newStartDate = this.ourGUI.getViewStartDate();
        LocalDate newEndDate = newStartDate.plusDays(this.ourGUI.getViewRangeDays());
        if (this.showAges) {
            this.ageTickHeight = g.getFontMetrics(this.prefs.getTlNameFont()).getHeight();
        }
        this.g2dScreen.setColor(this.graphicBackground);
        this.g2dScreen.fillRect(0, 0, this.panelWidth, this.getHeight());
        int rowMargin = this.getRowLabelMargin(this.g2dScreen);
        this.g2dScreen.clipRect(this.marginLeft - rowMargin, this.ourGUI.getTimeScrollPane().getVerticalScrollBar().getValue() + this.marginTop, this.panelWidth - this.marginLeft - this.marginRight - this.ourGUI.getTimeScrollPane().getVerticalScrollBar().getWidth(), this.ourGUI.getTimeScrollPane().getHeight() - this.marginTop);
        this.maxYscreen = this.drawData(this.g2dScreen, newStartDate, newEndDate, this.panelWidth - this.ourGUI.getTimeScrollPane().getVerticalScrollBar().getWidth(), -1);
    }

    public String[] createXAxis(LocalDate startDate, LocalDate endDate) {
        String[] axis = new String[this.nTicks + 1];
        double increment = ChronoUnit.DAYS.between(startDate, endDate) / (long)this.nTicks;
        LocalDate axisDate = startDate;
        int i = 0;
        while (i < this.nTicks + 1) {
            axis[i] = Utils.dayFormatterAxis.format(axisDate);
            axisDate = axisDate.plusDays(Math.round(increment));
            ++i;
        }
        return axis;
    }

    public void drawXAxis(Graphics2D g2d, String[] xAxis, int inWidth, int inHeight, BottomMargin withMargin) {
        int x;
        int margin = 0;
        if (withMargin.equals((Object)BottomMargin.MARGIN)) {
            margin = this.marginBottom;
        }
        int width = inWidth - this.marginLeft - this.marginRight;
        double pixelGap = width / (xAxis.length - 1);
        int x1 = x = this.marginLeft;
        FontMetrics metrics = g2d.getFontMetrics(this.prefs.getTimeAxisFont());
        this.xAxisHeight = metrics.getHeight() * 2 + this.xAxisTickLength + metrics.getDescent() + 1;
        int y = inHeight - margin - this.xAxisHeight + 1;
        g2d.setColor(Color.BLACK);
        Utils.setGraphicsFont(g2d, this.prefs.getTimeAxisFont());
        g2d.setStroke(new BasicStroke(2.0f));
        int i = 0;
        while (i < xAxis.length) {
            g2d.drawLine(x, y, x, y + this.xAxisTickLength);
            double a = x - metrics.stringWidth(xAxis[i]) / 4;
            double b = y + this.xAxisTickLength + metrics.getHeight();
            ArrayList<String> lines = this.splitString(xAxis[i]);
            this.drawSplitString(g2d, metrics, lines, a, b, DrawOrCalculate.DRAW);
            x = (int)((double)x + pixelGap);
            ++i;
        }
        g2d.drawLine(x1, y, x - (int)pixelGap, y);
    }

    private ArrayList<String> splitString(String text) {
        ArrayList<String> linesOut = new ArrayList<String>();
        String[] stringArray = text.split("\\\\n|\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            linesOut.add(line);
            ++n2;
        }
        return linesOut;
    }

    private Rectangle2D drawSplitString(Graphics g, FontMetrics metrics, ArrayList<String> text, double xIn, double yIn, DrawOrCalculate draw) {
        String longest = "";
        double width = 0.0;
        double nextY = yIn;
        int i = 0;
        while (i < text.size()) {
            if (draw.equals((Object)DrawOrCalculate.DRAW)) {
                g.drawString(text.get(i), (int)xIn, (int)nextY);
            }
            nextY += (double)metrics.getHeight();
            if (text.get(i).length() > longest.length()) {
                longest = text.get(i);
            }
            ++i;
        }
        width = metrics.getStringBounds(longest, g).getWidth();
        return new Rectangle2D.Double(xIn, yIn - (double)metrics.getHeight() + (double)metrics.getDescent(), (int)width, metrics.getHeight() * text.size());
    }

    public void drawYearLines(Graphics2D g2d, LocalDate startDate, LocalDate endDate, int inWidth, int inHeight, BottomMargin withMargin) {
        int margin = 0;
        if (withMargin.equals((Object)BottomMargin.MARGIN)) {
            margin = this.marginBottom;
        }
        MonthDay startMD = MonthDay.from(startDate);
        MonthDay endMD = MonthDay.from(endDate);
        if (startDate.getYear() != endDate.getYear() || startDate.getYear() == endDate.getYear() && (startMD.isAfter(MonthDay.of(1, 1)) || startMD.equals(MonthDay.of(1, 1))) && (endMD.isBefore(MonthDay.of(12, 31)) || endMD.equals(MonthDay.of(12, 31)))) {
            long years = ChronoUnit.YEARS.between(startDate, endDate);
            if (years == 0L) {
                years = 1L;
            }
            long yearsToMark = years;
            if (years > 11L) {
                yearsToMark = 11L;
            }
            long yearInc = Math.round((double)years / (double)yearsToMark);
            LocalDate currentYear = LocalDate.of(startDate.getYear(), 1, 1);
            if (currentYear.isBefore(startDate)) {
                currentYear = currentYear.plusYears(1L);
            }
            Utils.setGraphicsFont(g2d, this.prefs.getTimeAxisFont());
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setColor(Utils.dateAxisColor);
            while (!currentYear.isAfter(endDate)) {
                long days1 = ChronoUnit.DAYS.between(startDate, currentYear);
                int width = inWidth - this.marginLeft - this.marginRight;
                double pxPerDay = (double)width / (double)ChronoUnit.DAYS.between(startDate, endDate);
                int yearX = this.marginLeft + (int)Math.round((double)days1 * pxPerDay);
                g2d.drawLine(yearX, this.marginTop, yearX, inHeight - margin);
                int intYear = currentYear.getYear();
                if (intYear <= 0) {
                    --intYear;
                }
                g2d.drawString(String.valueOf(intYear), yearX, inHeight - margin - 5);
                currentYear = currentYear.plusYears(yearInc);
            }
        }
    }

    private int drawData(Graphics2D g2d, LocalDate startDate, LocalDate endDate, int inWidth, int exportHeight) {
        int maxY;
        block153: {
            FontMetrics metrics;
            maxY = 0;
            int x = this.marginLeft;
            int y = this.marginTop;
            int width = inWidth - this.marginLeft - this.marginRight;
            double pxPerDay = (double)width / (double)ChronoUnit.DAYS.between(startDate, endDate);
            Palette ourPalette = this.ourGUI.getPreferences().getPalette();
            List<Event> untimedEventList = this.ourGUI.getInput().getEventData().getListOfUntimedEvents(true);
            this.untimedAreaHeight = 0;
            if (untimedEventList.size() > 0) {
                Utils.setGraphicsFont(g2d, this.prefs.getUntimedNameFont());
                metrics = g2d.getFontMetrics(this.prefs.getUntimedNameFont());
                g2d.setStroke(new BasicStroke(1.0f));
                int textBoxInnerMargin = this.prefs.getMarginInner();
                int rightEdgeX = inWidth - this.marginLeft;
                int untimedX = this.marginLeft + textBoxInnerMargin;
                int untimedY = this.marginTop + metrics.getAscent() + textBoxInnerMargin * 2;
                EventData.sortEventsBySequence(untimedEventList);
                boolean anyShown = false;
                int maxUntimedHeight = 0;
                int i = 0;
                while (i < untimedEventList.size()) {
                    Event ev = untimedEventList.get(i);
                    if (ev.isShown()) {
                        anyShown = true;
                        ArrayList<String> nameLines = this.splitString(ev.getName());
                        int evNameHeight = metrics.getHeight() * nameLines.size();
                        Rectangle2D eventNameSize = this.drawSplitString(g2d, metrics, nameLines, 0.0, 0.0, DrawOrCalculate.CALCULATE_ONLY);
                        int evNameWidth = (int)Math.round(eventNameSize.getWidth());
                        if (untimedX + evNameWidth + 5 + textBoxInnerMargin * 2 > rightEdgeX) {
                            untimedY = untimedY + maxUntimedHeight + 10;
                            untimedX = this.marginLeft + textBoxInnerMargin;
                            maxUntimedHeight = 0;
                        }
                        maxUntimedHeight = Math.max(maxUntimedHeight, evNameHeight);
                        Rectangle2D.Double eventNameBounds = new Rectangle2D.Double(untimedX, untimedY, eventNameSize.getWidth(), eventNameSize.getHeight());
                        ev.setNameBounds(eventNameBounds);
                        ev.setPosition(untimedX + evNameWidth / 2 + textBoxInnerMargin, untimedY + metrics.getDescent() + textBoxInnerMargin);
                        untimedX = untimedX + evNameWidth + 5 + textBoxInnerMargin * 2;
                    }
                    ++i;
                }
                if (anyShown) {
                    this.untimedAreaHeight = untimedY + maxUntimedHeight - this.marginTop + textBoxInnerMargin + 2;
                    y += this.untimedAreaHeight;
                }
            }
            int currentRowIdx = 0;
            while (currentRowIdx < this.rowData.getSize()) {
                Row currentRow = this.rowData.getRowByIndex(currentRowIdx);
                int rowNameY = y;
                if (!this.ourGUI.getFilterEditor().isFilterOn() || !this.ourGUI.getFilterEditor().isHideEmptyRows() || currentRow.isShown()) {
                    int nextRowYInc = 0;
                    currentRow.setRowY(y);
                    rowNameY = y += currentRow.rowMaxHeightAbove(this.prefs, g2d);
                    List<Event> eventsOfRow = currentRow.getEvents();
                    int maxGenEvIconHeight = 0;
                    if (eventsOfRow != null && eventsOfRow.size() != 0) {
                        int tlHeight = this.prefs.getTimelineThickness();
                        int tlHalfHeight = Math.round(tlHeight / 2);
                        float tlHeightFloat = tlHeight;
                        BasicStroke tlStroke = new BasicStroke(tlHeightFloat);
                        g2d.setStroke(tlStroke);
                        long daysToEarlyStart = 0L;
                        int pxToEarlyStart = 0;
                        long daysToLateStart = 0L;
                        int pxToLateStart = 0;
                        int pxToRealStart = 0;
                        long daysToLateEnd = 0L;
                        int pxToLateEnd = 0;
                        int pxToRealEnd = 0;
                        int tlMaxYinc = 0;
                        double maxEventNameY = 0.0;
                        int i = 0;
                        while (i < eventsOfRow.size()) {
                            tlMaxYinc = 0;
                            maxEventNameY = 0.0;
                            Event event = eventsOfRow.get(i);
                            if (event.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                                if (event.isShown()) {
                                    EventData events;
                                    int pxToEarlyEnd;
                                    int tlTopY = y - tlHalfHeight;
                                    int tlBottomY = y + tlHalfHeight;
                                    int ageY = tlTopY - g2d.getFontMetrics(this.prefs.getTlNameFont()).getHeight();
                                    LocalDate tlEarlyStartDate = event.getDates().getEarlyStartDate();
                                    daysToEarlyStart = ChronoUnit.DAYS.between(startDate, tlEarlyStartDate);
                                    pxToRealStart = pxToEarlyStart = x + (int)Math.round((double)daysToEarlyStart * pxPerDay);
                                    LocalDate lateStartDate = event.getDates().getLateStartDate();
                                    if (lateStartDate != null) {
                                        daysToLateStart = ChronoUnit.DAYS.between(startDate, lateStartDate);
                                        pxToRealStart = pxToLateStart = x + (int)Math.round((double)daysToLateStart * pxPerDay);
                                    }
                                    LocalDate earlyEndDate = event.getDates().getEarlyEndDate();
                                    long daysToEarlyEnd = ChronoUnit.DAYS.between(startDate, earlyEndDate);
                                    pxToRealEnd = pxToEarlyEnd = x + (int)Math.round((double)daysToEarlyEnd * pxPerDay);
                                    LocalDate lateEndDate = event.getDates().getLateEndDate();
                                    if (lateEndDate != null) {
                                        daysToLateEnd = ChronoUnit.DAYS.between(startDate, lateEndDate);
                                        pxToRealEnd = pxToLateEnd = x + (int)Math.round((double)daysToLateEnd * pxPerDay);
                                    }
                                    String text = event.getName();
                                    int startIconHeight = 0;
                                    int startIconWidth = 0;
                                    if (event.getIcon() != null) {
                                        startIconHeight = event.getIcon().getIconHeight();
                                        startIconWidth = event.getIcon().getIconWidth();
                                    }
                                    int endIconHeight = 0;
                                    int endIconWidth = 0;
                                    if (event.getEndIcon() != null) {
                                        endIconHeight = event.getEndIcon().getIconHeight();
                                        endIconWidth = event.getEndIcon().getIconWidth();
                                    }
                                    Utils.setGraphicsFont(g2d, this.prefs.getTlNameFont());
                                    metrics = g2d.getFontMetrics(this.prefs.getTlNameFont());
                                    g2d.setColor(ourPalette.getColorByName(event.getColor()));
                                    int tlNameX = this.marginLeft;
                                    LocalDate tmpEndDate = earlyEndDate;
                                    if (lateEndDate != null) {
                                        tmpEndDate = lateEndDate;
                                    }
                                    if (!tmpEndDate.isBefore(startDate)) {
                                        if (!tlEarlyStartDate.isBefore(startDate)) {
                                            tlNameX = pxToRealStart + startIconWidth;
                                        }
                                        int tlNameY = tlTopY - metrics.getDescent() + metrics.getLeading();
                                        g2d.drawString(text, tlNameX, tlNameY);
                                        Rectangle2D tlNameBounds = metrics.getStringBounds(text, g2d);
                                        tlNameBounds.setRect(tlNameBounds.getX() + (double)tlNameX, tlNameBounds.getY() + (double)tlNameY, tlNameBounds.getWidth(), tlNameBounds.getHeight());
                                        event.setNameBounds(tlNameBounds);
                                    }
                                    if (lateStartDate == null) {
                                        g2d.setStroke(tlStroke);
                                        g2d.drawLine(pxToEarlyStart + tlHalfHeight, y, pxToEarlyEnd - tlHalfHeight, y);
                                    } else {
                                        g2d.setStroke(tlStroke);
                                        g2d.drawLine(pxToLateStart + tlHalfHeight, y, pxToEarlyEnd - tlHalfHeight, y);
                                    }
                                    if (event.getIcon() != null) {
                                        event.getIcon().paintIcon(this, g2d, pxToEarlyStart, y - startIconHeight / 2);
                                        tlMaxYinc = Math.max(tlMaxYinc, startIconHeight / 2);
                                    }
                                    if (lateStartDate != null) {
                                        float[] dash2 = new float[]{2.0f, 0.0f, 2.0f};
                                        BasicStroke dashed = new BasicStroke(tlHeightFloat, 0, 1, 1.0f, dash2, 2.0f);
                                        g2d.setStroke(dashed);
                                        g2d.drawLine(pxToEarlyStart, y, pxToLateStart, y);
                                    }
                                    if (this.showAges) {
                                        Color tmpColor = g2d.getColor();
                                        g2d.setColor(ourPalette.getColorByName(event.getColor()));
                                        Utils.setGraphicsFont(g2d, this.prefs.getTlAgeFont());
                                        metrics = g2d.getFontMetrics(this.prefs.getTlAgeFont());
                                        g2d.setStroke(new BasicStroke(1.0f));
                                        g2d.drawLine(pxToEarlyEnd, ageY, pxToEarlyEnd, tlTopY);
                                        int tmpAge = Period.between(tlEarlyStartDate, earlyEndDate).getYears();
                                        String ageString = String.valueOf(tmpAge);
                                        int segNameX = pxToEarlyEnd - metrics.stringWidth(ageString) / 2;
                                        int segNameY = ageY;
                                        g2d.drawString(ageString, segNameX, segNameY);
                                        g2d.setColor(tmpColor);
                                    }
                                    if (event.getEndIcon() != null) {
                                        event.getEndIcon().paintIcon(this, g2d, pxToRealEnd - endIconWidth, y - endIconHeight / 2);
                                        tlMaxYinc = Math.max(tlMaxYinc, endIconHeight / 2);
                                    }
                                    if (lateEndDate != null) {
                                        float[] dash2 = new float[]{2.0f, 0.0f, 2.0f};
                                        BasicStroke dashed = new BasicStroke(tlHeightFloat, 0, 1, 1.0f, dash2, 2.0f);
                                        g2d.setStroke(dashed);
                                        g2d.drawLine(pxToEarlyEnd, y, pxToLateEnd, y);
                                    }
                                    event.setPosition(pxToEarlyStart, y);
                                    SegmentList tlSegments = event.getTlSegmentList();
                                    this.maxSegLine = 0;
                                    metrics = g2d.getFontMetrics(this.prefs.getTlSegmentFont());
                                    this.segmentHeight = metrics.getHeight();
                                    this.segmentHeightInt = (int)Math.round(this.segmentHeight);
                                    this.segmentAscent = metrics.getAscent();
                                    this.segmentAscentInt = (int)Math.round(this.segmentAscent);
                                    if (tlSegments != null) {
                                        Utils.setGraphicsFont(g2d, this.prefs.getTlSegmentFont());
                                        int j = 0;
                                        while (j < tlSegments.getNumberOfSegments()) {
                                            String ageString;
                                            Color bgEndColor;
                                            Color bgStartColor;
                                            Segment tmpSeg = tlSegments.getASegment(j);
                                            this.maxSegLine = Math.max(this.maxSegLine, tmpSeg.getLine());
                                            int segY = tlBottomY + this.segmentHeightInt * (tmpSeg.getLine() - 1);
                                            LocalDate earlySegStartDate = tmpSeg.getDates().getEarlyStartDate();
                                            daysToEarlyStart = ChronoUnit.DAYS.between(startDate, earlySegStartDate);
                                            pxToRealStart = pxToEarlyStart = x + (int)Math.round((double)daysToEarlyStart * pxPerDay);
                                            LocalDate lateSegStartDate = tmpSeg.getDates().getLateStartDate();
                                            if (lateSegStartDate != null) {
                                                daysToLateStart = ChronoUnit.DAYS.between(startDate, lateSegStartDate);
                                                pxToRealStart = pxToLateStart = x + (int)Math.round((double)daysToLateStart * pxPerDay);
                                            }
                                            LocalDate earlySegEndDate = tmpSeg.getDates().getEarlyEndDate();
                                            daysToEarlyEnd = ChronoUnit.DAYS.between(startDate, earlySegEndDate);
                                            pxToRealEnd = pxToEarlyEnd = x + (int)Math.round((double)daysToEarlyEnd * pxPerDay);
                                            LocalDate lateSegEndDate = tmpSeg.getDates().getLateEndDate();
                                            if (lateSegEndDate != null) {
                                                daysToLateEnd = ChronoUnit.DAYS.between(startDate, lateSegEndDate);
                                                pxToRealEnd = pxToLateEnd = x + (int)Math.round((double)daysToLateEnd * pxPerDay);
                                            }
                                            g2d.setStroke(new BasicStroke(1.0f));
                                            if (lateSegStartDate != null) {
                                                bgStartColor = this.prefs.getPalette().getColorByName(tmpSeg.getColorOuterStart());
                                                bgEndColor = this.prefs.getPalette().getColorByName(tmpSeg.getColorOuterEnd());
                                                Color[] gradStartColors = new Color[]{bgStartColor, bgEndColor};
                                                if (pxToLateStart == pxToEarlyStart) {
                                                    ++pxToLateStart;
                                                }
                                                Point2D.Float gradStart = new Point2D.Float(pxToEarlyStart, segY);
                                                Point2D.Float gradEnd = new Point2D.Float(pxToLateStart, segY);
                                                float[] gradDistance = new float[]{0.0f, 1.0f};
                                                LinearGradientPaint greydient = new LinearGradientPaint(gradStart, gradEnd, gradDistance, gradStartColors);
                                                g2d.setPaint(greydient);
                                                g2d.fill(new Rectangle2D.Double(pxToEarlyStart, segY + 1, pxToLateStart - pxToEarlyStart, this.segmentHeight));
                                            } else {
                                                g2d.setColor(ourPalette.getColorByName(tmpSeg.getColorOuterStart()));
                                                g2d.drawLine(pxToEarlyStart, segY + 1, pxToEarlyStart, segY + this.segmentHeightInt);
                                            }
                                            if (this.showAges) {
                                                Utils.setGraphicsFont(g2d, this.prefs.getTlAgeFont());
                                                metrics = g2d.getFontMetrics(this.prefs.getTlAgeFont());
                                                int tmpAge = Period.between(tlEarlyStartDate, earlySegStartDate).getYears();
                                                ageString = String.valueOf(tmpAge);
                                                int segNameX = pxToEarlyStart - metrics.stringWidth(ageString) / 2;
                                                if (tmpAge != 0) {
                                                    g2d.setColor(ourPalette.getColorByName(tmpSeg.getColorFG()));
                                                    g2d.setStroke(new BasicStroke(1.0f));
                                                    g2d.drawLine(pxToEarlyStart, ageY, pxToEarlyStart, y);
                                                    g2d.drawString(ageString, segNameX, ageY);
                                                }
                                            }
                                            g2d.setStroke(new BasicStroke(1.0f));
                                            if (lateSegEndDate != null) {
                                                bgStartColor = this.prefs.getPalette().getColorByName(tmpSeg.getColorOuterStart());
                                                bgEndColor = this.prefs.getPalette().getColorByName(tmpSeg.getColorOuterEnd());
                                                float[] gradLateDistance = new float[]{0.0f, 1.0f};
                                                Color[] gradEndColors = new Color[]{bgEndColor, bgStartColor};
                                                if (pxToLateEnd == pxToEarlyEnd) {
                                                    ++pxToLateEnd;
                                                }
                                                Point2D.Float gradStart = new Point2D.Float(pxToEarlyEnd, segY);
                                                Point2D.Float gradEnd = new Point2D.Float(pxToLateEnd, segY);
                                                LinearGradientPaint greydientNeg = new LinearGradientPaint(gradStart, gradEnd, gradLateDistance, gradEndColors);
                                                g2d.setPaint(greydientNeg);
                                                g2d.fill(new Rectangle2D.Double(pxToEarlyEnd, segY + 1, pxToLateEnd - pxToEarlyEnd, this.segmentHeight));
                                            } else {
                                                g2d.setColor(ourPalette.getColorByName(tmpSeg.getColorOuterStart()));
                                                g2d.drawLine(pxToEarlyEnd, segY, pxToEarlyEnd, segY + this.segmentHeightInt);
                                            }
                                            if (this.showAges) {
                                                g2d.setColor(ourPalette.getColorByName(tmpSeg.getColorFG()));
                                                Utils.setGraphicsFont(g2d, this.prefs.getTlAgeFont());
                                                metrics = g2d.getFontMetrics(this.prefs.getTlAgeFont());
                                                g2d.setStroke(new BasicStroke(1.0f));
                                                g2d.drawLine(pxToEarlyEnd, ageY, pxToEarlyEnd, y);
                                                int tmpAge = Period.between(tlEarlyStartDate, earlySegEndDate).getYears();
                                                ageString = String.valueOf(tmpAge);
                                                int segNameX = pxToEarlyEnd - metrics.stringWidth(ageString) / 2;
                                                if (tmpAge != 0) {
                                                    g2d.drawString(ageString, segNameX, ageY);
                                                }
                                            }
                                            g2d.setColor(ourPalette.getColorByName(tmpSeg.getColorInner()));
                                            g2d.fill(new Rectangle2D.Double(pxToRealStart, segY + 1, pxToEarlyEnd - pxToRealStart, this.segmentHeight));
                                            Utils.setGraphicsFont(g2d, this.prefs.getTlSegmentFont());
                                            metrics = g2d.getFontMetrics(this.prefs.getTlSegmentFont());
                                            int segNameX = pxToRealStart + (pxToEarlyEnd - pxToRealStart) / 2 - metrics.stringWidth(tmpSeg.getText()) / 2;
                                            int segNameY = segY + 1 + metrics.getAscent();
                                            g2d.setStroke(new BasicStroke(1.0f));
                                            Rectangle2D segNameBounds = metrics.getStringBounds(tmpSeg.getText(), g2d);
                                            segNameBounds.setRect(segNameBounds.getX() + (double)segNameX, segNameBounds.getY() + (double)segNameY, segNameBounds.getWidth(), segNameBounds.getHeight());
                                            tmpSeg.setNameBounds(segNameBounds);
                                            g2d.fill(segNameBounds);
                                            g2d.setColor(ourPalette.getColorByName(tmpSeg.getColorFG()));
                                            g2d.drawString(tmpSeg.getText(), segNameX, segNameY);
                                            ++j;
                                        }
                                        tlMaxYinc = Math.max(tlMaxYinc, this.segmentHeightInt * this.maxSegLine);
                                    }
                                    if ((events = event.getTlEventList()) != null) {
                                        float eventWidth = this.prefs.getEventThickness();
                                        BasicStroke eventStroke = new BasicStroke(eventWidth);
                                        g2d.setStroke(eventStroke);
                                        ArrayList<Rectangle2D.Double> evBoundsList = new ArrayList<Rectangle2D.Double>();
                                        int j = events.getNumberOfEventsOnly() - 1;
                                        while (j >= 0) {
                                            Event tmpEvent = events.getEventByIndex(j);
                                            if (tmpEvent.isShown()) {
                                                int iw;
                                                int ih;
                                                Event tmpTimeline = tmpEvent.getEventTimeline();
                                                Integer pxToEventEarlyStart = 0;
                                                Integer pxToEventEarlyEnd = null;
                                                Integer pxToEventLateEnd = null;
                                                Integer pxToEventLateStart = null;
                                                Integer pxToEventRealEnd = null;
                                                pxToEventEarlyStart = this.dateToPx(startDate, tmpEvent.getDates().getEarlyStartDate(), pxPerDay, this.marginLeft);
                                                if (tmpEvent.getDates().getLateStartDate() != null) {
                                                    pxToEventLateStart = this.dateToPx(startDate, tmpEvent.getDates().getLateStartDate(), pxPerDay, this.marginLeft);
                                                }
                                                if (tmpEvent.getDates().getEarlyEndDate() != null) {
                                                    pxToEventEarlyEnd = this.dateToPx(startDate, tmpEvent.getDates().getEarlyEndDate(), pxPerDay, this.marginLeft);
                                                }
                                                if (tmpEvent.getDates().getLateEndDate() != null) {
                                                    pxToEventLateEnd = this.dateToPx(startDate, tmpEvent.getDates().getLateEndDate(), pxPerDay, this.marginLeft);
                                                }
                                                pxToEventRealEnd = this.dateToPx(startDate, tmpEvent.getDates().getRealEndDate(), pxPerDay, this.marginLeft);
                                                int pxToEventMid = pxToEventEarlyStart + (pxToEventRealEnd - pxToEventEarlyStart) / 2;
                                                double eventY = y + tlHalfHeight + this.bracketHeight / 2;
                                                if (tmpTimeline != null) {
                                                    eventY = tmpTimeline.getPositionY() + (double)(this.bracketHeight / 2);
                                                }
                                                if (tmpEvent.getIcon() != null) {
                                                    ih = tmpEvent.getIcon().getIconHeight();
                                                    iw = tmpEvent.getIcon().getIconWidth();
                                                } else {
                                                    ih = Utils.getDefaultIcon().getIconHeight();
                                                    iw = Utils.getDefaultIcon().getIconWidth();
                                                }
                                                metrics = g2d.getFontMetrics(this.prefs.getEventNameFont());
                                                int evNameHeight = 0;
                                                ArrayList<String> nameLines = this.splitString(tmpEvent.getName());
                                                Rectangle2D nameBoundsSize = this.drawSplitString(g2d, metrics, nameLines, 0.0, 0.0, DrawOrCalculate.CALCULATE_ONLY);
                                                evNameHeight = (int)nameBoundsSize.getHeight();
                                                int evNameDescent = metrics.getDescent();
                                                int eventDistanceBelow = tlHalfHeight + this.segmentHeightInt * this.maxSegLine;
                                                double eventIconY = (eventY += (double)eventDistanceBelow) + (double)(this.bracketHeight / 2);
                                                double eventNameY = eventIconY + (double)ih + (double)Math.round(metrics.getAscent()) + 1.0;
                                                double eventNameX = pxToEventMid - (int)Math.round(nameBoundsSize.getWidth() / 2.0);
                                                Rectangle2D.Double eventNameBounds = new Rectangle2D.Double(eventNameX, eventNameY, nameBoundsSize.getWidth(), nameBoundsSize.getHeight());
                                                maxEventNameY = Math.max(maxEventNameY, eventIconY + (double)ih + nameBoundsSize.getHeight());
                                                if (this.prefs.getStackEvents()) {
                                                    double eventBoxX = (int)Math.min(eventNameBounds.getX(), (double)pxToEventEarlyStart.intValue());
                                                    double eventBoxY = eventY - (double)this.bracketHeight;
                                                    double eventBoxW = (int)Math.max(eventNameBounds.getWidth(), (double)(pxToEventRealEnd - pxToEventEarlyStart)) + 1;
                                                    double eventBoxH = this.bracketHeight + ih + evNameHeight + evNameDescent + 1;
                                                    Rectangle2D.Double eventBoxBounds = new Rectangle2D.Double(eventBoxX, eventBoxY, eventBoxW, eventBoxH);
                                                    boolean done = false;
                                                    while (!done) {
                                                        int k = 0;
                                                        while (k < evBoundsList.size()) {
                                                            if (eventBoxBounds.intersects((Rectangle2D)evBoundsList.get(k))) {
                                                                double yInc = ((Rectangle2D)evBoundsList.get(k)).getY() + ((Rectangle2D)evBoundsList.get(k)).getHeight() - ((RectangularShape)eventBoxBounds).getY() + 1.0;
                                                                eventY += yInc;
                                                                eventNameY += yInc;
                                                                eventIconY += yInc;
                                                                eventNameBounds.setRect(eventNameBounds.getX(), eventNameBounds.getY() + yInc, eventNameBounds.getWidth(), eventNameBounds.getHeight());
                                                                ((Rectangle2D)eventBoxBounds).setRect(((RectangularShape)eventBoxBounds).getX(), ((RectangularShape)eventBoxBounds).getY() + yInc, ((RectangularShape)eventBoxBounds).getWidth(), ((RectangularShape)eventBoxBounds).getHeight());
                                                                k = 0;
                                                            }
                                                            maxEventNameY = Math.max(maxEventNameY, eventNameY + (double)evNameDescent);
                                                            ++k;
                                                        }
                                                        done = true;
                                                    }
                                                    evBoundsList.add(eventBoxBounds);
                                                }
                                                g2d.setColor(ourPalette.getColorByName(tmpEvent.getColor()));
                                                this.drawEventBracket(g2d, eventWidth, pxToEventEarlyStart, pxToEventLateStart, pxToEventEarlyEnd, pxToEventLateEnd, (int)eventY);
                                                if (tmpEvent.getIcon() != null) {
                                                    tmpEvent.getIcon().paintIcon(this, g2d, pxToEventMid - iw / 2, (int)eventIconY);
                                                } else {
                                                    Utils.getDefaultIcon().paintIcon(this, g2d, pxToEventMid - iw / 2, (int)eventIconY);
                                                }
                                                tmpEvent.setPosition(pxToEventMid, eventIconY);
                                                if (this.showAges) {
                                                    Color tmpColor = g2d.getColor();
                                                    Utils.setGraphicsFont(g2d, this.prefs.getTlAgeFont());
                                                    metrics = g2d.getFontMetrics(this.prefs.getTlAgeFont());
                                                    g2d.setColor(ourPalette.getColorByName(tmpEvent.getColor()));
                                                    g2d.setStroke(new BasicStroke(1.0f));
                                                    g2d.drawLine(pxToEventMid, ageY, pxToEventMid, y);
                                                    int tmpAge = Period.between(tmpTimeline.getDates().getEarlyStartDate(), tmpEvent.getDates().getEarlyStartDate()).getYears();
                                                    if (tmpEvent.getDates().getEarlyEndDate() != null) {
                                                        tmpAge += Period.between(tmpEvent.getDates().getEarlyStartDate(), tmpEvent.getDates().getRealEndDate()).getYears() / 2;
                                                    }
                                                    if (tmpAge != 0) {
                                                        String ageString = String.valueOf(tmpAge);
                                                        int ageNameX = pxToEventMid - metrics.stringWidth(ageString) / 2;
                                                        g2d.drawString(ageString, ageNameX, ageY);
                                                    }
                                                    g2d.setColor(tmpColor);
                                                }
                                                g2d.setColor(ourPalette.getColorByName(tmpEvent.getColor()));
                                                Utils.setGraphicsFont(g2d, this.prefs.getEventNameFont());
                                                metrics = g2d.getFontMetrics(this.prefs.getEventNameFont());
                                                Rectangle2D finalEvBounds = this.drawSplitString(g2d, metrics, nameLines, eventNameX, eventNameY, DrawOrCalculate.DRAW);
                                                g2d.setColor(this.eventNameBoundsColor);
                                                g2d.draw(finalEvBounds);
                                                tmpEvent.setNameBounds(finalEvBounds);
                                            }
                                            --j;
                                        }
                                    }
                                }
                                nextRowYInc = Math.max(nextRowYInc, tlMaxYinc);
                                nextRowYInc = Math.max(nextRowYInc, (int)(maxEventNameY - (double)y));
                            } else if (event.isShown()) {
                                float eventWidth = this.prefs.getEventThickness();
                                BasicStroke eventStroke = new BasicStroke(eventWidth);
                                g2d.setStroke(eventStroke);
                                Integer pxToEventEarlyStart = 0;
                                Integer pxToEventLateStart = null;
                                Integer pxToEventEarlyEnd = null;
                                Integer pxToEventLateEnd = null;
                                Integer pxToEventRealEnd = null;
                                pxToEventEarlyStart = this.dateToPx(startDate, event.getDates().getEarlyStartDate(), pxPerDay, this.marginLeft);
                                if (event.getDates().getLateStartDate() != null) {
                                    pxToEventLateStart = this.dateToPx(startDate, event.getDates().getLateStartDate(), pxPerDay, this.marginLeft);
                                }
                                if (event.getDates().getEarlyEndDate() != null) {
                                    pxToEventEarlyEnd = this.dateToPx(startDate, event.getDates().getEarlyEndDate(), pxPerDay, this.marginLeft);
                                }
                                if (event.getDates().getLateEndDate() != null) {
                                    pxToEventLateEnd = this.dateToPx(startDate, event.getDates().getLateEndDate(), pxPerDay, this.marginLeft);
                                }
                                pxToEventRealEnd = this.dateToPx(startDate, event.getDates().getRealEndDate(), pxPerDay, this.marginLeft);
                                int pxToEventMid = pxToEventEarlyStart + (pxToEventRealEnd - pxToEventEarlyStart) / 2;
                                int eventIconY = y;
                                int ih = 0;
                                int eventNameX = pxToEventMid;
                                if (!event.getAsTitle()) {
                                    int eventY = y;
                                    eventIconY += this.bracketHeight / 2;
                                    g2d.setColor(ourPalette.getColorByName(event.getColor()));
                                    if (event.getIcon() != null) {
                                        ih = event.getIcon().getIconHeight();
                                        iw = event.getIcon().getIconWidth();
                                        event.getIcon().paintIcon(this, g2d, pxToEventMid - iw / 2, eventIconY);
                                    } else {
                                        ih = Utils.getDefaultIcon().getIconHeight();
                                        iw = Utils.getDefaultIcon().getIconWidth();
                                        Utils.getDefaultIcon().paintIcon(this, g2d, pxToEventMid - iw / 2, eventIconY);
                                    }
                                    g2d.setColor(ourPalette.getColorByName(event.getColor()));
                                    this.drawEventBracket(g2d, eventWidth, pxToEventEarlyStart, pxToEventLateStart, pxToEventEarlyEnd, pxToEventLateEnd, eventY);
                                }
                                event.setPosition(pxToEventMid, eventIconY);
                                if (event.getAsTitle()) {
                                    Utils.setGraphicsFont(g2d, this.prefs.getTitlesFont());
                                    metrics = g2d.getFontMetrics(this.prefs.getTitlesFont());
                                    eventNameX = pxToEventEarlyStart;
                                } else {
                                    Utils.setGraphicsFont(g2d, this.prefs.getEventNameFont());
                                    metrics = g2d.getFontMetrics(this.prefs.getEventNameFont());
                                    eventNameX = pxToEventMid;
                                }
                                g2d.setColor(ourPalette.getColorByName(event.getColor()));
                                ArrayList<String> textLines = this.splitString(event.getName());
                                Rectangle2D textBoundSize = this.drawSplitString(g2d, metrics, textLines, 0.0, 0.0, DrawOrCalculate.CALCULATE_ONLY);
                                if (!event.getAsTitle()) {
                                    eventNameX -= (int)Math.round(textBoundSize.getWidth() / 2.0);
                                }
                                int eventNameY = eventIconY + ih + metrics.getAscent() + 2;
                                Rectangle2D textBoundRect = this.drawSplitString(g2d, metrics, textLines, eventNameX, eventNameY, DrawOrCalculate.DRAW);
                                textBoundRect.setRect(eventNameX, eventNameY - metrics.getAscent(), textBoundSize.getWidth(), textBoundSize.getHeight());
                                event.setNameBounds(textBoundRect);
                                g2d.setColor(this.eventNameBoundsColor);
                                g2d.draw(textBoundRect);
                                maxGenEvIconHeight = !event.getAsTitle() ? Math.max(maxGenEvIconHeight, ih + this.bracketHeight / 2 + (int)textBoundRect.getHeight()) : Math.max(maxGenEvIconHeight, (int)textBoundRect.getHeight());
                            }
                            ++i;
                        }
                    }
                    nextRowYInc = Math.max(nextRowYInc, maxGenEvIconHeight);
                    y += Math.max(nextRowYInc, this.prefs.getRowMinYGap());
                    int rowMargin = this.getRowLabelMargin(g2d);
                    if (this.rowLabelsChoice) {
                        rowNameY += nextRowYInc / 2;
                        metrics = g2d.getFontMetrics(this.prefs.getRowLabelsFont());
                        metrics = g2d.getFontMetrics(this.prefs.getRowLabelsFont());
                        String rowLabelString = String.valueOf(currentRowIdx + 1);
                        Utils.setGraphicsFont(g2d, this.prefs.getRowLabelsFont());
                        g2d.setStroke(new BasicStroke(1.0f));
                        Rectangle2D rowNameBounds = metrics.getStringBounds(rowLabelString, g2d);
                        int rowH = (int)Math.round(rowNameBounds.getHeight());
                        int rowW = (int)Math.round(rowNameBounds.getWidth());
                        int rowX = this.marginLeft - rowMargin;
                        g2d.setColor(Utils.rowColor);
                        g2d.drawString(rowLabelString, rowX, rowNameY);
                        rowNameBounds.setRect(rowNameBounds.getX() + (double)rowX, rowNameBounds.getY() + (double)rowNameY, rowW, rowH);
                        currentRow.setNameBounds(rowNameBounds);
                    }
                }
                maxY = y;
                ++currentRowIdx;
            }
            int tstWidth = (int)(pxPerDay * (double)ChronoUnit.DAYS.between(this.ourGUI.getRangeStart(), this.ourGUI.getRangeEnd())) + (this.marginLeft + this.marginRight);
            this.setPreferredSize(new Dimension(tstWidth, maxY));
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            if (!this.ourGUI.getFilterEditor().isHideConnections()) {
                List<Connection> connections = this.connectionData.getConnections();
                int i = 0;
                while (i < connections.size()) {
                    Connection cn = connections.get(i);
                    if (cn.isShown() && (cn.getSourceEvent().getEventType() != CommonData.EventType.UNTIMED && this.isTimelineOnScreen(cn.getSourceEvent(), startDate, endDate) && cn.getSourceEvent().isShown() || cn.getDestEvent().getEventType() != CommonData.EventType.UNTIMED && this.isTimelineOnScreen(cn.getDestEvent(), startDate, endDate) && cn.getDestEvent().isShown())) {
                        g2d.setColor(ourPalette.getColorByName(cn.getColor()));
                        BasicStroke cnStroke = new BasicStroke(1.0f);
                        Point2D.Double srcCenter = new Point2D.Double();
                        Path2D srcBracket = null;
                        srcCenter = this.calcCenter(cn.getSourceEvent(), null, null);
                        if (cn.getSourceEvent().getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                            int srcPoint = cn.getSourceTimelinePoint();
                            switch (srcPoint) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    LocalDate srcEarly = cn.getDates().getSrcEarlyDate();
                                    LocalDate srcLate = cn.getDates().getSrcLateDate();
                                    long eDays = ChronoUnit.DAYS.between(startDate, srcEarly);
                                    x1 = x + (int)Math.round((double)eDays * pxPerDay);
                                    y1 = cn.getSourceEvent().getPositionY();
                                    if (this.showAges) {
                                        Color tmpColor = g2d.getColor();
                                        this.drawAge(g2d, ourPalette.getColorByName(cn.getColor()), x1, y1, Period.between(cn.getSourceEvent().getDates().getEarlyStartDate(), srcEarly).getYears());
                                        g2d.setColor(tmpColor);
                                    }
                                    if (srcLate != null) {
                                        long lDays = ChronoUnit.DAYS.between(startDate, srcLate);
                                        int xl = x + (int)Math.round((double)lDays * pxPerDay);
                                        boolean above = false;
                                        int yOffset = this.bracketHeight;
                                        y2 = cn.getDestEvent().getPositionY();
                                        if (y2 < y1) {
                                            above = true;
                                            yOffset = -yOffset;
                                        }
                                        srcBracket = this.prepareTlBracket(x1, xl, y1, this.bracketHeight, above);
                                        x1 += ((double)xl - x1) / 2.0;
                                        y1 += (double)yOffset;
                                    }
                                    srcCenter.setLocation(x1, y1);
                                    break;
                                }
                                case 2: {
                                    x1 = cn.getSourceEvent().getNameBounds().getX();
                                    y1 = cn.getSourceEvent().getNameBounds().getY();
                                    int yOffset = g2d.getFontMetrics(this.prefs.getTlNameFont()).getHeight() / 2;
                                    Line2D.Double l = new Line2D.Double(x1, y1 + (double)yOffset, x1 - (double)yOffset, y1 + (double)yOffset);
                                    g2d.draw(l);
                                    x1 -= (double)yOffset;
                                    y1 += (double)yOffset;
                                    break;
                                }
                                default: {
                                    JOptionPane.showMessageDialog(this.ourGUI, "TimePanel: Invalid Source Point on timeline " + String.valueOf(srcPoint));
                                }
                            }
                        }
                        Point2D.Double dstCenter = new Point2D.Double();
                        Path2D dstBracket = null;
                        dstCenter = this.calcCenter(cn.getDestEvent(), null, null);
                        if (cn.getDestEvent().getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                            int dstPoint = cn.getDestTimelinePoint();
                            switch (dstPoint) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    y1 = cn.getSourceEvent().getPositionY();
                                    LocalDate dstEarly = cn.getDates().getDstEarlyDate();
                                    LocalDate dstLate = cn.getDates().getDstLateDate();
                                    long cDays = ChronoUnit.DAYS.between(startDate, dstEarly);
                                    x2 = x + (int)Math.round((double)cDays * pxPerDay);
                                    y2 = cn.getDestEvent().getPositionY();
                                    if (this.showAges) {
                                        Color tmpColor = g2d.getColor();
                                        this.drawAge(g2d, ourPalette.getColorByName(cn.getColor()), x2, y2, Period.between(cn.getDestEvent().getDates().getEarlyStartDate(), dstEarly).getYears());
                                        g2d.setColor(tmpColor);
                                    }
                                    if (dstLate != null) {
                                        long lDays = ChronoUnit.DAYS.between(startDate, dstLate);
                                        int xl = x + (int)Math.round((double)lDays * pxPerDay);
                                        boolean above = false;
                                        int yOffset = this.bracketHeight;
                                        if (y1 < y2) {
                                            above = true;
                                            yOffset = -yOffset;
                                        }
                                        dstBracket = this.prepareTlBracket(x2, xl, y2, this.bracketHeight, above);
                                        x2 += ((double)xl - x2) / 2.0;
                                        y2 += (double)yOffset;
                                    }
                                    dstCenter.setLocation(x2, y2);
                                    break;
                                }
                                case 2: {
                                    x2 = cn.getDestEvent().getNameBounds().getX();
                                    y2 = cn.getDestEvent().getNameBounds().getY();
                                    int yOffset = g2d.getFontMetrics(this.prefs.getTlNameFont()).getHeight() / 2;
                                    Line2D.Double l = new Line2D.Double(x2, y2 + (double)yOffset, x2 - (double)yOffset, y2 + (double)yOffset);
                                    g2d.draw(l);
                                    x2 -= (double)yOffset;
                                    y2 += (double)yOffset;
                                    break;
                                }
                                default: {
                                    JOptionPane.showMessageDialog(this.ourGUI, "TimePanel: Invalid Destination Point on timeline " + String.valueOf(dstPoint));
                                }
                            }
                        }
                        g2d.setStroke(cnStroke);
                        if (srcBracket != null) {
                            g2d.draw(srcBracket);
                        }
                        if (dstBracket != null) {
                            g2d.draw(dstBracket);
                        }
                        Path2D.Double linePath = new Path2D.Double();
                        Point2D.Double bezTransformedCtrlPoint = new Point2D.Double();
                        Point2D.Double arrowLineEnd = new Point2D.Double();
                        Point2D.Double arrowLineStart = new Point2D.Double();
                        Path2D.Double arrowPathFwd = new Path2D.Double();
                        Path2D.Double arrowPathBck = new Path2D.Double();
                        if (cn.getArrowForward()) {
                            arrowPathFwd = this.prepareArrow2();
                        } else {
                            arrowPathFwd.moveTo(-this.arrowTail - this.arrowLength, 0.0);
                            arrowPathFwd.lineTo(0.0, 0.0);
                        }
                        if (cn.getArrowBack()) {
                            arrowPathBck = this.prepareArrow2();
                        } else {
                            arrowPathBck.moveTo(-this.arrowTail - this.arrowLength, 0.0);
                            arrowPathBck.lineTo(0.0, 0.0);
                        }
                        int directionSrc = this.eventDirection(srcCenter, dstCenter, SrcDst.SRC);
                        int directionDst = this.eventDirection(srcCenter, dstCenter, SrcDst.DST);
                        if (cn.getCurve()) {
                            double dx = dstCenter.getX() - srcCenter.getX();
                            double dy = dstCenter.getY() - srcCenter.getY();
                            double lineLength = Math.sqrt(dx * dx + dy * dy);
                            lineLength = dstCenter.distance(srcCenter);
                            this.bezCtrlX = cn.getBezCtrlX();
                            this.bezCtrlY = cn.getBezCtrlY();
                            Point2D.Double bezCtrlPoint = new Point2D.Double(cn.getBezCtrlX(), cn.getBezCtrlY());
                            bezTransformedCtrlPoint = this.pointTransform(bezCtrlPoint, srcCenter, dstCenter, lineLength);
                            double leftX = this.marginLeft;
                            double rightX = width + this.marginLeft;
                            Rectangle view = this.ourGUI.getViewPort().getViewRect();
                            double topY = view.getMinY() + (double)this.marginTop;
                            double bottomY = view.getMaxY();
                            if (exportHeight != -1) {
                                topY = this.marginTop;
                                bottomY = exportHeight;
                            }
                            this.bezCtrlX = Math.max(bezTransformedCtrlPoint.getX(), leftX);
                            this.bezCtrlX = Math.min(this.bezCtrlX, rightX);
                            this.bezCtrlY = Math.max(bezTransformedCtrlPoint.getY(), topY);
                            this.bezCtrlY = Math.min(this.bezCtrlY, bottomY);
                            bezTransformedCtrlPoint = new Point2D.Double(this.bezCtrlX, this.bezCtrlY);
                            directionSrc = this.eventDirection(srcCenter, bezTransformedCtrlPoint, SrcDst.SRC);
                            directionDst = this.eventDirection(bezTransformedCtrlPoint, dstCenter, SrcDst.DST);
                        }
                        Point2D.Double srcConnect = this.calcEdgePoint(cn, DoingLabel.OTHER, SrcDst.SRC, directionSrc, srcCenter.getX(), srcCenter.getY());
                        Point2D.Double dstConnect = this.calcEdgePoint(cn, DoingLabel.OTHER, SrcDst.DST, directionDst, dstCenter.getX(), dstCenter.getY());
                        if (cn.getCurve()) {
                            arrowLineEnd = dstConnect;
                            transformedForwArrowPath = this.pathTransform(arrowPathFwd, bezTransformedCtrlPoint, dstConnect, dstConnect);
                            g2d.draw(transformedForwArrowPath);
                            g2d.fill(transformedForwArrowPath);
                            tail = new Point2D.Double(this.arrowLength + this.arrowTail, 0.0);
                            arrowLineEnd = this.pointTransform(tail, dstConnect, bezTransformedCtrlPoint, null);
                            arrowLineStart = srcConnect;
                            transformedBackArrowPath = this.pathTransform(arrowPathBck, bezTransformedCtrlPoint, srcConnect, srcConnect);
                            g2d.draw(transformedBackArrowPath);
                            arrowLineStart = this.pointTransform(tail, srcConnect, bezTransformedCtrlPoint, null);
                        } else {
                            arrowLineEnd = dstConnect;
                            transformedForwArrowPath = this.pathTransform(arrowPathFwd, srcConnect, dstConnect, dstConnect);
                            g2d.draw(transformedForwArrowPath);
                            g2d.fill(transformedForwArrowPath);
                            tail = new Point2D.Double(this.arrowLength + this.arrowTail, 0.0);
                            arrowLineEnd = this.pointTransform(tail, dstConnect, srcConnect, null);
                            arrowLineStart = srcConnect;
                            transformedBackArrowPath = this.pathTransform(arrowPathBck, dstConnect, srcConnect, srcConnect);
                            g2d.draw(transformedBackArrowPath);
                            arrowLineStart = this.pointTransform(tail, srcConnect, dstConnect, null);
                        }
                        double arrowLineX1 = arrowLineStart.getX();
                        double arrowLineY1 = arrowLineStart.getY();
                        double arrowLineX2 = arrowLineEnd.getX();
                        double arrowLineY2 = arrowLineEnd.getY();
                        Connection.DashType dashType = cn.getDashType();
                        BasicStroke dashStroke = new BasicStroke(1.0f);
                        switch (dashType) {
                            case PLAIN: {
                                dashStroke = new BasicStroke(1.0f);
                                break;
                            }
                            case DOT: {
                                float[] dots = new float[]{this.prefs.getNewDotMark(), this.prefs.getNewDotGap()};
                                dashStroke = new BasicStroke(1.0f, 2, 0, 1.0f, dots, 0.0f);
                                break;
                            }
                            case DASH: {
                                float[] dashes = new float[]{this.prefs.getNewDashMark(), this.prefs.getNewDashGap()};
                                dashStroke = new BasicStroke(1.0f, 2, 0, 1.0f, dashes, 0.0f);
                                break;
                            }
                            case DOT_DASH: {
                                float[] dotDashes = new float[]{this.prefs.getNewDotDashMark1(), this.prefs.getNewDotDashGap1(), this.prefs.getNewDotDashMark2(), this.prefs.getNewDotDashGap2()};
                                dashStroke = new BasicStroke(1.0f, 2, 0, 1.0f, dotDashes, 0.0f);
                                break;
                            }
                            default: {
                                JOptionPane.showMessageDialog(this.ourGUI, "TimePanel: Invalid Dash Type " + String.valueOf((Object)dashType));
                            }
                        }
                        g2d.setStroke(dashStroke);
                        if (cn.getSrcNameSelected() || cn.getDstNameSelected() || this.foundItem != null && this.foundItem.getType().equals("connection") && this.foundItem.getName().equals(cn.getNiceID().toLowerCase())) {
                            g2d.setStroke(new BasicStroke(3.0f));
                        } else {
                            g2d.setStroke(dashStroke);
                        }
                        switch (cn.getLineType()) {
                            case WAVY: {
                                Path2D wavePath = new Path2D.Double();
                                wavePath = cn.getCurve() ? this.drawCurveWave(arrowLineX1, arrowLineY1, arrowLineX2, arrowLineY2, bezTransformedCtrlPoint) : this.drawStraightWave(arrowLineX1, arrowLineY1, arrowLineX2, arrowLineY2);
                                g2d.draw(wavePath);
                                cn.setClickPath(wavePath);
                                break;
                            }
                            case HELIX: {
                                Path2D helixPath = new Path2D.Double();
                                helixPath = cn.getCurve() ? this.drawCurveHelix(arrowLineX1, arrowLineY1, arrowLineX2, arrowLineY2, bezTransformedCtrlPoint) : this.drawStraightHelix(arrowLineX1, arrowLineY1, arrowLineX2, arrowLineY2);
                                g2d.draw(helixPath);
                                cn.setClickPath(helixPath);
                                break;
                            }
                            default: {
                                if (cn.getCurve()) {
                                    linePath.reset();
                                    linePath.moveTo(arrowLineX1, arrowLineY1);
                                    linePath.quadTo(this.bezCtrlX, this.bezCtrlY, arrowLineX2, arrowLineY2);
                                    g2d.draw(linePath);
                                    cn.setClickPath(linePath);
                                    break;
                                }
                                linePath = new Path2D.Double(new Line2D.Double(arrowLineX1, arrowLineY1, arrowLineX2, arrowLineY2));
                                g2d.draw(new Line2D.Double(arrowLineX1, arrowLineY1, arrowLineX2, arrowLineY2));
                                cn.setClickPath(linePath);
                            }
                        }
                        if (!this.ourGUI.getFilterEditor().isHideCnNames()) {
                            int boundsX;
                            Rectangle2D cnNameBounds;
                            if (cn.getShowAtSrc()) {
                                Utils.setGraphicsFont(g2d, this.prefs.getConnectionFont());
                                metrics = g2d.getFontMetrics(this.prefs.getConnectionFont());
                                String cnName = Utils.decodeEscapes(cn.getName());
                                ArrayList<String> cnNameLines = this.splitString(cnName);
                                double nameX = arrowLineX1 + cn.getPosNameSource().getX();
                                double nameY = arrowLineY1 + cn.getPosNameSource().getY() + (double)metrics.getDescent();
                                cnNameBounds = this.drawSplitString(g2d, metrics, cnNameLines, nameX, nameY, DrawOrCalculate.DRAW);
                                if (cn.getSrcNameSelected() || this.foundItem != null && this.foundItem.getType().equals("connection") && this.foundItem.getName().equals(cn.getNiceID().toLowerCase())) {
                                    g2d.setStroke(new BasicStroke(2.0f));
                                } else {
                                    g2d.setStroke(new BasicStroke(1.0f));
                                }
                                int nameHeight = (int)cnNameBounds.getHeight();
                                int nameWidth = (int)cnNameBounds.getWidth();
                                int textBoxInnerMargin = this.prefs.getMarginInner();
                                boundsX = (int)Math.round(nameX - (double)textBoxInnerMargin);
                                int boundsY = (int)Math.round(nameY - (double)textBoxInnerMargin - (double)metrics.getAscent());
                                int boundsW = Math.round(nameWidth + textBoxInnerMargin * 2);
                                int boundsH = Math.round(nameHeight + textBoxInnerMargin * 2);
                                double centreX = boundsX + boundsW / 2;
                                double centreY = nameY + (double)(boundsH / 2);
                                g2d.drawRect(boundsX, boundsY, boundsW, boundsH);
                                cn.setBoundsNameSource(new Rectangle2D.Double(boundsX, boundsY, boundsW, boundsH));
                                int eventPointSrc = this.eventDirection(new Point2D.Double((int)arrowLineX1, (int)arrowLineY1), new Point2D.Double(centreX, centreY), SrcDst.DST);
                                Point2D.Double movedSrc = this.calcEdgePoint(cn, DoingLabel.LABEL, SrcDst.SRC, eventPointSrc, centreX, centreY);
                                double movedX = movedSrc.getX();
                                double movedY = movedSrc.getY();
                                g2d.drawLine((int)movedX, (int)movedY, (int)arrowLineX1, (int)arrowLineY1);
                            }
                            if (cn.getShowAtDst()) {
                                Utils.setGraphicsFont(g2d, this.prefs.getConnectionFont());
                                metrics = g2d.getFontMetrics(this.prefs.getConnectionFont());
                                String cnName = Utils.decodeEscapes(cn.getName());
                                ArrayList<String> cnNameLines = this.splitString(cnName);
                                double nameX = arrowLineX2 + cn.getPosNameDestination().getX();
                                double nameY = arrowLineY2 + cn.getPosNameDestination().getY() + (double)metrics.getDescent();
                                cnNameBounds = this.drawSplitString(g2d, metrics, cnNameLines, (int)nameX, (int)nameY, DrawOrCalculate.DRAW);
                                if (cn.getDstNameSelected() || this.foundItem != null && this.foundItem.getType().equals("connection") && this.foundItem.getName().equals(cn.getNiceID().toLowerCase())) {
                                    g2d.setStroke(new BasicStroke(2.0f));
                                } else {
                                    g2d.setStroke(new BasicStroke(1.0f));
                                }
                                int nameHeight = (int)cnNameBounds.getHeight();
                                int nameWidth = (int)cnNameBounds.getWidth();
                                int textBoxInnerMargin = this.prefs.getMarginInner();
                                boundsX = (int)Math.round(nameX - (double)textBoxInnerMargin);
                                int boundsY = (int)Math.round(nameY - (double)textBoxInnerMargin - (double)metrics.getAscent());
                                int boundsW = Math.round(nameWidth + textBoxInnerMargin * 2);
                                int boundsH = Math.round(nameHeight + textBoxInnerMargin * 2);
                                double centreX = boundsX + boundsW / 2;
                                double centreY = nameY + (double)(boundsH / 2);
                                g2d.drawRect(boundsX, boundsY, boundsW, boundsH);
                                cn.setBoundsNameDestination(new Rectangle2D.Double(boundsX, boundsY, boundsW, boundsH));
                                int eventPointDst = this.eventDirection(new Point2D.Double((int)arrowLineX2, (int)arrowLineY2), new Point2D.Double(centreX, centreY), SrcDst.DST);
                                Point2D.Double movedDst = this.calcEdgePoint(cn, DoingLabel.LABEL, SrcDst.DST, eventPointDst, centreX, centreY);
                                double movedX = movedDst.getX();
                                double movedY = movedDst.getY();
                                g2d.drawLine((int)movedX, (int)movedY, (int)arrowLineX2, (int)arrowLineY2);
                            }
                        }
                    }
                    ++i;
                }
            }
            if (untimedEventList.size() > 0) {
                Utils.setGraphicsFont(g2d, this.prefs.getUntimedNameFont());
                metrics = g2d.getFontMetrics(this.prefs.getUntimedNameFont());
                g2d.setStroke(new BasicStroke(1.0f));
                int i = 0;
                while (i < untimedEventList.size()) {
                    Event ev = untimedEventList.get(i);
                    if (ev.isShown()) {
                        Rectangle2D evNameBounds = ev.getNameBounds();
                        double untimedX = evNameBounds.getX() + 1.0;
                        double untimedY = ev.getPositionY();
                        double evNameWidth = evNameBounds.getWidth();
                        double evNameHeight = evNameBounds.getHeight();
                        int textBoxInnerMargin = this.prefs.getMarginInner();
                        g2d.setColor(Color.WHITE);
                        g2d.fillRect((int)untimedX - textBoxInnerMargin, (int)untimedY - metrics.getAscent() - textBoxInnerMargin, (int)evNameWidth + textBoxInnerMargin * 2, (int)evNameHeight + textBoxInnerMargin * 2);
                        g2d.setColor(ourPalette.getColorByName(ev.getColor()));
                        g2d.drawRect((int)untimedX - textBoxInnerMargin, (int)untimedY - metrics.getAscent() - textBoxInnerMargin, (int)evNameWidth + textBoxInnerMargin * 2, (int)evNameHeight + textBoxInnerMargin * 2);
                        ArrayList<String> lines = this.splitString(ev.getName());
                        this.drawSplitString(g2d, metrics, lines, untimedX, ev.getPositionY(), DrawOrCalculate.DRAW);
                    }
                    ++i;
                }
            }
            if (this.foundItem == null) break block153;
            Rectangle2D foundHighlight = new Rectangle2D.Float(0.0f, 0.0f, this.highlightWidth, this.highlightHeight);
            switch (this.foundItem.getType()) {
                case "timeline": 
                case "general_event": 
                case "timeline_event": {
                    Event tmpTl = (Event)this.foundItem.getItem();
                    foundHighlight.setRect(tmpTl.getNameBounds().getX() - 2.0, tmpTl.getNameBounds().getY() - 2.0, tmpTl.getNameBounds().getWidth() + 4.0, tmpTl.getNameBounds().getHeight() + 4.0);
                    break;
                }
                case "untimed": {
                    Event tmpTl = (Event)this.foundItem.getItem();
                    foundHighlight.setRect(tmpTl.getNameBounds().getX() - 2.0, tmpTl.getNameBounds().getY() - 6.0, tmpTl.getNameBounds().getWidth() + 6.0, tmpTl.getNameBounds().getHeight() + 6.0);
                    break;
                }
                case "segment": {
                    Segment tmpSeg = (Segment)this.foundItem.getItem();
                    foundHighlight.setRect(tmpSeg.getNameBounds().getX() - 2.0, tmpSeg.getNameBounds().getY() - 2.0, tmpSeg.getNameBounds().getWidth() + 4.0, tmpSeg.getNameBounds().getHeight() + 4.0);
                    break;
                }
                case "connection": {
                    Connection tmpCn = (Connection)this.foundItem.getItem();
                    if (this.foundCnSrc.equals((Object)HighlightEnd.SRC)) {
                        if (!tmpCn.getSourceEvent().getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                            foundHighlight.setRect(tmpCn.getSourceEvent().getNameBounds().getX() - 2.0, tmpCn.getSourceEvent().getNameBounds().getY() - 2.0, tmpCn.getSourceEvent().getNameBounds().getWidth() + 4.0, tmpCn.getSourceEvent().getNameBounds().getHeight() + 4.0);
                            break;
                        }
                        if (tmpCn.getSourceTimelinePoint() == 1) {
                            LocalDate srcEarly = tmpCn.getDates().getSrcEarlyDate();
                            LocalDate srcLate = tmpCn.getDates().getSrcLateDate();
                            long eDays = ChronoUnit.DAYS.between(startDate, srcEarly);
                            x1 = (int)Math.round((double)eDays * pxPerDay);
                            if (srcLate != null) {
                                long lDays = ChronoUnit.DAYS.between(startDate, srcLate);
                                int xl = (int)Math.round((double)lDays * pxPerDay);
                                x1 += ((double)xl - x1) / 2.0;
                            }
                            y1 = tmpCn.getSourceEvent().getPositionY() - (double)(this.highlightHeight / 2);
                            foundHighlight.setRect((double)this.marginLeft + x1 - (double)(this.highlightWidth / 2), y1, this.highlightWidth, this.highlightHeight);
                            break;
                        }
                        foundHighlight.setRect(tmpCn.getSourceEvent().getNameBounds().getX() - 2.0, tmpCn.getSourceEvent().getNameBounds().getY() - 2.0, tmpCn.getSourceEvent().getNameBounds().getWidth() + 4.0, tmpCn.getSourceEvent().getNameBounds().getHeight() + 4.0);
                        break;
                    }
                    if (!tmpCn.getDestEvent().getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                        foundHighlight.setRect(tmpCn.getDestEvent().getNameBounds().getX() - 2.0, tmpCn.getDestEvent().getNameBounds().getY() - 2.0, tmpCn.getDestEvent().getNameBounds().getWidth() + 4.0, tmpCn.getDestEvent().getNameBounds().getHeight() + 4.0);
                        break;
                    }
                    if (tmpCn.getDestTimelinePoint() == 1) {
                        LocalDate dstEarly = tmpCn.getDates().getDstEarlyDate();
                        LocalDate dstLate = tmpCn.getDates().getDstLateDate();
                        long eDays = ChronoUnit.DAYS.between(startDate, dstEarly);
                        x1 = (int)Math.round((double)eDays * pxPerDay);
                        if (dstLate != null) {
                            long lDays = ChronoUnit.DAYS.between(startDate, dstLate);
                            int xl = (int)Math.round((double)lDays * pxPerDay);
                            x1 += ((double)xl - x1) / 2.0;
                        }
                        y1 = tmpCn.getDestEvent().getPositionY() - (double)(this.highlightHeight / 2);
                        foundHighlight.setRect((double)this.marginLeft + x1 - (double)(this.highlightWidth / 2), y1, this.highlightWidth, this.highlightHeight);
                        break;
                    }
                    foundHighlight = tmpCn.getDestEvent().getNameBounds();
                    foundHighlight.setRect(tmpCn.getDestEvent().getNameBounds().getX() - 2.0, tmpCn.getDestEvent().getNameBounds().getY() - 2.0, tmpCn.getDestEvent().getNameBounds().getWidth() + 4.0, tmpCn.getDestEvent().getNameBounds().getHeight() + 4.0);
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this.ourGUI, "TimePanel: Invalid found item type " + this.foundItem.getType() + " Name: " + this.foundItem.getName());
                }
                case "introduction": 
            }
            g2d.setColor(Color.RED);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.draw(foundHighlight);
        }
        return maxY;
    }

    private Path2D drawStraightWave(double x1, double y1, double x2, double y2) {
        double lineLength = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        int halfCycles = Math.max(1, (int)Math.floor(lineLength / ((double)this.wavelength / 2.0)));
        double xInc = (double)this.wavelength / 2.0 / (double)this.waveSteps;
        int nPoints = (int)lineLength;
        int remainder = nPoints % halfCycles;
        double startLine = remainder / 2;
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(x1, y1);
        Point2D.Double tmp = new Point2D.Double(0.0, 0.0);
        Point2D.Double tmp2 = new Point2D.Double(0.0, 0.0);
        tmp.setLocation(startLine, 0.0);
        tmp2 = this.pointTransformXY(tmp.getX(), tmp.getY(), x1, y1, x2, y2, null);
        ((Path2D)path).lineTo(tmp2.getX(), tmp2.getY());
        double currentX = startLine;
        int i = 0;
        while (i < halfCycles) {
            int j = 0;
            while (j < this.waveSteps) {
                if (i % 2 == 0) {
                    tmp.setLocation(currentX, this.halfWave1[j]);
                } else {
                    tmp.setLocation(currentX, this.halfWave2[j]);
                }
                tmp2 = this.pointTransformXY(tmp.getX(), tmp.getY(), x1, y1, x2, y2, null);
                ((Path2D)path).lineTo(tmp2.getX(), tmp2.getY());
                currentX += xInc;
                ++j;
            }
            ++i;
        }
        tmp.setLocation(currentX, 0.0);
        tmp2 = this.pointTransformXY(tmp.getX(), tmp.getY(), x1, y1, x2, y2, null);
        ((Path2D)path).lineTo(tmp2.getX(), tmp2.getY());
        currentX += 1.0;
        ((Path2D)path).lineTo(x2, y2);
        return path;
    }

    private Path2D drawCurveWave(double x1, double y1, double x2, double y2, Point2D.Double ctrl) {
        Path2D.Double curvePath = new Path2D.Double();
        Point2D.Double[] pointsOnCurve = this.approxBezier(x1, y1, x2, y2, this.wavelength / 2, ctrl);
        int nPoints = pointsOnCurve.length;
        double xInc = (double)this.wavelength / 2.0 / (double)this.waveSteps;
        Point2D.Double currentPoint = new Point2D.Double(x1, y1);
        Point2D.Double currentScaledPoint = new Point2D.Double(x1, y1);
        Point2D.Double prevScaledPoint = new Point2D.Double(x1, y1);
        ((Path2D)curvePath).moveTo(x1, y1);
        boolean pos = true;
        int i = 0;
        while (i < nPoints - 1) {
            double segLength = Math.hypot(pointsOnCurve[i + 1].getX() - prevScaledPoint.getX(), pointsOnCurve[i + 1].getY() - prevScaledPoint.getY());
            int halfCycles = (int)Math.floor(segLength / ((double)this.wavelength / 2.0));
            double currentX = 0.0;
            int j = 0;
            while (j < halfCycles) {
                int k = 0;
                while (k < this.waveSteps) {
                    if (pos) {
                        currentPoint.setLocation(currentX, this.halfWave1[k]);
                    } else {
                        currentPoint.setLocation(currentX, this.halfWave2[k]);
                    }
                    currentScaledPoint = this.pointTransformXY(currentPoint.getX(), currentPoint.getY(), prevScaledPoint.getX(), prevScaledPoint.getY(), pointsOnCurve[i + 1].getX(), pointsOnCurve[i + 1].getY(), null);
                    ((Path2D)curvePath).lineTo(currentScaledPoint.getX(), currentScaledPoint.getY());
                    currentX += xInc;
                    ++k;
                }
                pos = !pos;
                ++j;
            }
            prevScaledPoint = currentScaledPoint;
            ++i;
        }
        double segLength = Math.hypot(x2 - prevScaledPoint.getX(), y2 - prevScaledPoint.getY());
        if (segLength < (double)this.wavelength / 2.0) {
            ((Path2D)curvePath).lineTo(x2, y2);
        } else {
            int halfCycles = (int)Math.floor(segLength / ((double)this.wavelength / 2.0));
            double currentX = 0.0;
            int j = 0;
            while (j < halfCycles) {
                int k = 0;
                while (k < this.waveSteps) {
                    if (pos) {
                        currentPoint.setLocation(currentX, this.halfWave1[k]);
                    } else {
                        currentPoint.setLocation(currentX, this.halfWave2[k]);
                    }
                    currentScaledPoint = this.pointTransformXY(currentPoint.getX(), currentPoint.getY(), prevScaledPoint.getX(), prevScaledPoint.getY(), x2, y2, null);
                    ((Path2D)curvePath).lineTo(currentScaledPoint.getX(), currentScaledPoint.getY());
                    currentX += xInc;
                    ++k;
                }
                pos = !pos;
                ++j;
            }
            ((Path2D)curvePath).lineTo(x2, y2);
        }
        return curvePath;
    }

    private Path2D drawStraightHelix(double x1, double y1, double x2, double y2) {
        double lineLength = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        int loops = (int)Math.floor(lineLength / this.helixDX);
        if (loops <= 0) {
            loops = 1;
        }
        int nPoints = (int)lineLength;
        int remainder = nPoints % loops;
        int startLine = remainder / 2;
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(x1, y1);
        Point2D.Double tmp = new Point2D.Double(0.0, 0.0);
        Point2D.Double tmp2 = new Point2D.Double(0.0, 0.0);
        tmp.setLocation(startLine, 0.0);
        tmp2 = this.pointTransformXY(tmp.getX(), tmp.getY(), x1, y1, x2, y2, null);
        ((Path2D)path).lineTo(tmp2.getX(), tmp2.getY());
        int loopStartX = startLine;
        int currentX = 0;
        int currentY = 0;
        int i = 0;
        while (i < loops) {
            int j = 0;
            while (j < this.helixSteps) {
                currentX = loopStartX + (int)Math.round(this.circleX[j]);
                currentY = (int)Math.round(this.circleY[j]);
                tmp.setLocation(currentX, currentY);
                tmp2 = this.pointTransformXY(tmp.getX(), tmp.getY(), x1, y1, x2, y2, null);
                ((Path2D)path).lineTo(tmp2.getX(), tmp2.getY());
                ++j;
            }
            loopStartX = (int)Math.round(tmp.getX());
            ++i;
        }
        tmp.setLocation(currentX, 0.0);
        tmp2 = this.pointTransformXY(tmp.getX(), tmp.getY(), x1, y1, x2, y2, null);
        ((Path2D)path).lineTo(tmp2.getX(), tmp2.getY());
        ++currentX;
        ((Path2D)path).lineTo(x2, y2);
        return path;
    }

    private Path2D drawCurveHelix(double x1, double y1, double x2, double y2, Point2D.Double ctrl) {
        Path2D.Double curvePath = new Path2D.Double();
        Point2D.Double[] pointsOnCurve = this.approxBezier(x1, y1, x2, y2, (int)Math.ceil(this.helixDX), ctrl);
        int nPoints = pointsOnCurve.length;
        Point2D.Double currentPoint = new Point2D.Double(x1, y1);
        Point2D.Double currentScaledPoint = new Point2D.Double(x1, y1);
        Point2D.Double prevScaledPoint = new Point2D.Double(x1, y1);
        ((Path2D)curvePath).moveTo(x1, y1);
        int currentX = 0;
        int currentY = 0;
        int loopStartX = 0;
        int i = 0;
        while (i < nPoints - 1) {
            double segLength = Math.hypot(pointsOnCurve[i + 1].getX() - prevScaledPoint.getX(), pointsOnCurve[i + 1].getY() - prevScaledPoint.getY());
            int loops = (int)Math.floor(segLength / this.helixDX);
            loopStartX = 0;
            int j = 0;
            while (j < loops) {
                int k = 0;
                while (k < this.helixSteps) {
                    currentX = loopStartX + (int)Math.round(this.circleX[k]);
                    currentY = (int)Math.round(this.circleY[k]);
                    currentPoint.setLocation(currentX, currentY);
                    currentScaledPoint = this.pointTransformXY(currentPoint.getX(), currentPoint.getY(), prevScaledPoint.getX(), prevScaledPoint.getY(), pointsOnCurve[i + 1].getX(), pointsOnCurve[i + 1].getY(), null);
                    ((Path2D)curvePath).lineTo(currentScaledPoint.getX(), currentScaledPoint.getY());
                    ++k;
                }
                loopStartX = (int)Math.round(currentPoint.getX());
                ++j;
            }
            prevScaledPoint = currentScaledPoint;
            ++i;
        }
        double segLength = Math.hypot(x2 - prevScaledPoint.getX(), y2 - prevScaledPoint.getY());
        if (segLength < this.helixDX) {
            ((Path2D)curvePath).lineTo(x2, y2);
        } else {
            int loops = (int)Math.floor(segLength / this.helixDX);
            if (loops <= 0) {
                loops = 1;
            }
            currentX = 0;
            currentY = 0;
            loopStartX = 0;
            int j = 0;
            while (j < loops) {
                int k = 0;
                while (k < this.helixSteps) {
                    currentX = loopStartX + (int)Math.round(this.circleX[k]);
                    currentY = (int)Math.round(this.circleY[k]);
                    currentPoint.setLocation(currentX, currentY);
                    currentScaledPoint = this.pointTransformXY(currentPoint.getX(), currentPoint.getY(), prevScaledPoint.getX(), prevScaledPoint.getY(), x2, y2, null);
                    ((Path2D)curvePath).lineTo(currentScaledPoint.getX(), currentScaledPoint.getY());
                    ++k;
                }
                loopStartX = (int)Math.round(currentPoint.getX());
                ++j;
            }
        }
        ((Path2D)curvePath).lineTo(x2, y2);
        return curvePath;
    }

    private Point2D.Double[] approxBezier(double x1, double y1, double x2, double y2, int min, Point2D.Double ctrl) {
        double ctrlX = ctrl.getX();
        double ctrlY = ctrl.getY();
        Point2D.Double startPoint = new Point2D.Double(x1, y1);
        Point2D.Double endPoint = new Point2D.Double(x2, y2);
        double ctrlLine1Length = Math.hypot(ctrlX - x1, ctrlY - y1);
        double ctrlLine2Length = Math.hypot(x2 - ctrlX, y2 - ctrlY);
        double shorterLine = Math.min(ctrlLine1Length, ctrlLine2Length);
        double div = (double)min / shorterLine;
        int nPoints = (int)Math.ceil(shorterLine / (double)min);
        if (nPoints == 0) {
            nPoints = 1;
        }
        Point2D.Double[] pointsOnLine1 = new Point2D.Double[nPoints];
        Point2D.Double[] pointsOnLine2 = new Point2D.Double[nPoints];
        Point2D.Double[] pointsOnCurve = new Point2D.Double[nPoints];
        int i = 0;
        while (i < nPoints) {
            pointsOnLine1[i] = this.divLine(div * (double)i, startPoint, ctrl);
            pointsOnLine2[i] = this.divLine(div * (double)i, ctrl, endPoint);
            ++i;
        }
        pointsOnCurve[0] = startPoint;
        i = 1;
        while (i < nPoints) {
            pointsOnCurve[i] = this.divLine(div * (double)i, pointsOnLine1[i], pointsOnLine2[i]);
            ++i;
        }
        return pointsOnCurve;
    }

    private Point2D.Double findY(double targetX, double ctrlX, double ctrlY) {
        double x = 0.0;
        double y = 0.0;
        double t = 0.0;
        while (t < 1.0) {
            x = 2.0 * t * (1.0 - t) * ctrlX + t * t;
            if (x >= targetX) {
                y = 2.0 * t * (1.0 - t) * ctrlY;
                break;
            }
            t += 0.01;
        }
        Point2D.Double result = new Point2D.Double(x, y);
        return result;
    }

    private Point2D.Double pointTransformXY(double myX, double myY, double x1, double y1, double x2, double y2, Double scale) {
        double oldX = myX;
        double oldY = myY;
        double angleRad = Math.atan2(y2 - y1, x2 - x1);
        double cosAngle = Math.cos(angleRad);
        double sinAngle = Math.sin(angleRad);
        double newX = 0.0;
        double newY = 0.0;
        double a = cosAngle;
        double b = -sinAngle;
        double c = sinAngle;
        double d = cosAngle;
        if (scale != null) {
            a *= scale.doubleValue();
            b *= scale.doubleValue();
            c *= scale.doubleValue();
            d *= scale.doubleValue();
        }
        newX = x1 + oldX * a + oldY * b;
        newY = y1 + oldX * c + oldY * d;
        return new Point2D.Double(newX, newY);
    }

    private Point2D.Double pointTransform(Point2D.Double myPoint, Point2D.Double point1, Point2D.Double point2, Double scale) {
        double oldX = myPoint.getX();
        double oldY = myPoint.getY();
        double angleRad = Math.atan2(point2.getY() - point1.getY(), point2.getX() - point1.getX());
        double cosAngle = Math.cos(angleRad);
        double sinAngle = Math.sin(angleRad);
        double newX = 0.0;
        double newY = 0.0;
        double a = cosAngle;
        double b = -sinAngle;
        double c = sinAngle;
        double d = cosAngle;
        if (scale != null) {
            a *= scale.doubleValue();
            b *= scale.doubleValue();
            c *= scale.doubleValue();
            d *= scale.doubleValue();
        }
        newX = point1.getX() + oldX * a + oldY * b;
        newY = point1.getY() + oldX * c + oldY * d;
        return new Point2D.Double(newX, newY);
    }

    private Point2D.Double inversePointTransform(double myX, double myY, double x1, double y1, double x2, double y2, Double scale) {
        double oldX = myX;
        double oldY = myY;
        double angleRad = Math.atan2(y2 - y1, x2 - x1);
        double cosAngle = Math.cos(angleRad);
        double sinAngle = Math.sin(angleRad);
        double newX = 0.0;
        double newY = 0.0;
        double a = cosAngle;
        double b = -sinAngle;
        double c = sinAngle;
        double d = cosAngle;
        oldX -= x1;
        oldY -= y1;
        double determinantR = 1.0 / (a * d - b * c);
        if (scale != null) {
            determinantR /= scale.doubleValue();
        }
        newX = (d * oldX - b * oldY) * determinantR;
        newY = (-c * oldX + a * oldY) * determinantR;
        return new Point2D.Double(newX, newY);
    }

    private Path2D.Double pathTransform(Path2D.Double inPath, Point2D.Double point1, Point2D.Double point2, Point2D.Double point3) {
        double angleRad = Math.atan2(point2.getY() - point1.getY(), point2.getX() - point1.getX());
        Path2D.Double resultPath = new Path2D.Double();
        AffineTransform ourTransform = new AffineTransform();
        ourTransform.translate(point3.getX(), point3.getY());
        ourTransform.rotate(angleRad);
        resultPath = (Path2D.Double)inPath.clone();
        resultPath.transform(ourTransform);
        return resultPath;
    }

    private void getPreferences(CDgui gui) {
        Preferences ourPrefs = gui.getPreferences();
        this.emptyRowHeight = ourPrefs.getRowMinYGap();
        this.rowLabelsChoice = ourPrefs.getShowRowNosChoice();
        this.marginLeft = ourPrefs.getMarginLeft();
        this.marginRight = ourPrefs.getMarginRight();
        this.marginTop = ourPrefs.getMarginTop();
        this.marginBottom = ourPrefs.getMarginBottom();
        this.showAges = ourPrefs.getTimelineShowAgesChoice();
        this.waveAmplitude = ourPrefs.getWaveAmplitude();
        this.wavelength = ourPrefs.getWaveLength();
        this.prepareSineWave(this.waveAmplitude, this.waveSteps);
        this.helixAmplitude = ourPrefs.getHelixAmplitude();
        this.helixPitch = ourPrefs.getHelixPitch();
        this.prepareHelix(this.helixAmplitude);
        this.arrowLength = ourPrefs.getArrowLength();
        this.arrowTail = ourPrefs.getArrowTail();
        this.arrowHWidth = ourPrefs.getArrowWidth();
        this.bezCtrlX = ourPrefs.getBezierCtrlX();
        this.bezCtrlY = ourPrefs.getBezierCtrlY();
    }

    private Path2D.Double prepareArrow2() {
        Path2D.Double resultPath = new Path2D.Double();
        resultPath.moveTo(-this.arrowTail - this.arrowLength, 0.0);
        resultPath.lineTo(-this.arrowLength, 0.0);
        resultPath.lineTo(-this.arrowLength, this.arrowHWidth);
        resultPath.lineTo(0.0, 0.0);
        resultPath.lineTo(-this.arrowLength, -this.arrowHWidth);
        resultPath.lineTo(-this.arrowLength, 0.0);
        return resultPath;
    }

    private Path2D prepareTlBracket(double x1, double x2, double y, double h, boolean above) {
        Path2D.Double bPath = new Path2D.Double();
        double height = h;
        if (above) {
            height = -height;
        }
        bPath.moveTo(x1, y);
        bPath.lineTo(x1, y + height);
        bPath.lineTo(x2, y + height);
        bPath.lineTo(x2, y);
        return bPath;
    }

    private void drawEventBracket(Graphics2D g2d, float thickness, Integer xES, Integer xLS, Integer xEE, Integer xLE, Integer y) {
        float[] dash = new float[]{2.0f, 0.0f, 2.0f};
        BasicStroke solid = new BasicStroke(thickness);
        Stroke savedStroke = null;
        int mode = 1;
        if (xLS != null) {
            mode += 2;
        }
        if (xEE != null) {
            mode += 4;
        }
        if (xLE != null) {
            mode += 8;
        }
        int h = this.bracketHeight;
        switch (mode) {
            case 1: {
                Stroke savedStroke1 = g2d.getStroke();
                g2d.setStroke(solid);
                g2d.drawLine(xES, y - h / 2, xES, y + h / 2);
                g2d.setStroke(savedStroke1);
                break;
            }
            case 3: {
                savedStroke = g2d.getStroke();
                g2d.setStroke(solid);
                g2d.drawLine(xES, y - h / 2, xES, y + h / 2);
                g2d.drawLine(xLS, y - h / 2, xLS, y + h / 2);
                BasicStroke dashed = new BasicStroke(thickness, 0, 1, 1.0f, dash, 2.0f);
                g2d.setStroke(dashed);
                g2d.drawLine(xES, y, xLS, y);
                g2d.setStroke(savedStroke);
                break;
            }
            case 5: {
                savedStroke = g2d.getStroke();
                g2d.setStroke(solid);
                g2d.drawLine(xES, y - h / 2, xES, y + h / 2);
                g2d.drawLine(xES, y, xEE, y);
                g2d.drawLine(xEE, y - h / 2, xEE, y + h / 2);
                g2d.setStroke(savedStroke);
                break;
            }
            case 7: {
                savedStroke = g2d.getStroke();
                BasicStroke dashed7 = new BasicStroke(thickness, 0, 1, 1.0f, dash, 2.0f);
                g2d.setStroke(dashed7);
                g2d.drawLine(xES, y, xLS, y);
                g2d.setStroke(solid);
                g2d.drawLine(xLS, y, xEE, y);
                g2d.setStroke(solid);
                g2d.drawLine(xES, y - h / 2, xES, y + h / 2);
                g2d.drawLine(xLS, y - h / 2, xLS, y + h / 2);
                g2d.drawLine(xEE, y - h / 2, xEE, y + h / 2);
                g2d.setStroke(savedStroke);
                break;
            }
            case 13: {
                savedStroke = g2d.getStroke();
                g2d.setStroke(solid);
                g2d.drawLine(xES, y - h / 2, xES, y + h / 2);
                g2d.drawLine(xEE, y - h / 2, xEE, y + h / 2);
                g2d.drawLine(xLE, y - h / 2, xLE, y + h / 2);
                g2d.drawLine(xES, y, xEE, y);
                BasicStroke dashed13 = new BasicStroke(thickness, 0, 1, 1.0f, dash, 2.0f);
                g2d.setStroke(dashed13);
                g2d.drawLine(xEE, y, xLE, y);
                g2d.setStroke(savedStroke);
                break;
            }
            case 15: {
                savedStroke = g2d.getStroke();
                g2d.setStroke(solid);
                g2d.drawLine(xES, y - h / 2, xES, y + h / 2);
                g2d.drawLine(xLS, y - h / 2, xLS, y + h / 2);
                g2d.drawLine(xEE, y - h / 2, xEE, y + h / 2);
                g2d.drawLine(xLE, y - h / 2, xLE, y + h / 2);
                BasicStroke dashed15 = new BasicStroke(thickness, 0, 1, 1.0f, dash, 2.0f);
                g2d.setStroke(dashed15);
                g2d.drawLine(xES, y, xLS, y);
                g2d.setStroke(solid);
                g2d.drawLine(xLS, y, xEE, y);
                g2d.setStroke(dashed15);
                g2d.drawLine(xEE, y, xLE, y);
                g2d.setStroke(savedStroke);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.ourGUI, "TimePanel: Invalid combination of start and end types for bracket mode " + mode);
                return;
            }
        }
    }

    private Point2D.Double calcCenter(Event ev, Connection cn, SrcDst asSource) {
        double x = 0.0;
        double y = 0.0;
        if (ev == null && cn == null) {
            JOptionPane.showMessageDialog(this.ourGUI, "TimePanel: Both event and connection arguments are null in getCenter()");
            Point2D.Double result = new Point2D.Double(x, y);
            return result;
        }
        if (ev != null) {
            x = ev.getPositionX();
            y = ev.getPositionY();
            switch (ev.getEventType()) {
                case TIMELINE_EVENT: 
                case GENERAL_EVENT: {
                    if (!ev.getAsTitle()) {
                        if (ev.getIcon() == null) break;
                        y += (double)(ev.getIcon().getIconHeight() / 2);
                        break;
                    }
                    x += ev.getNameBounds().getWidth() / 2.0;
                    y += ev.getNameBounds().getHeight() / 2.0;
                    break;
                }
                case TIMELINE: {
                    x = ev.getPositionX();
                    if (ev.getIcon() != null) {
                        x += (double)(ev.getIcon().getIconWidth() / 2);
                    }
                    y = ev.getPositionY();
                    break;
                }
                case UNTIMED: {
                    y += (double)((int)ev.getNameBounds().getHeight() / 2);
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this.ourGUI, "TimePanel: Invalid event type in getCenter()");
                }
            }
        }
        if (cn != null) {
            if (asSource.equals((Object)SrcDst.SRC)) {
                x = cn.getBoundsNameSource().getCenterX();
                y = cn.getBoundsNameSource().getCenterY();
            } else {
                x = cn.getBoundsNameDestination().getCenterX();
                y = cn.getBoundsNameDestination().getCenterY();
            }
        }
        Point2D.Double result = new Point2D.Double(x, y);
        return result;
    }

    private int eventDirection(Point2D.Double start, Point2D.Double end, SrcDst asSource) {
        int result = 1;
        double dx = end.getX() - start.getX();
        double dy = end.getY() - start.getY();
        if (dx == 0.0) {
            result = dy < 0.0 ? (asSource.equals((Object)SrcDst.SRC) ? 6 : 2) : (asSource.equals((Object)SrcDst.SRC) ? 2 : 6);
        } else {
            double dydx = dy / dx;
            if (dydx > -0.5 && dydx <= 0.5) {
                result = dx < 0.0 ? (asSource.equals((Object)SrcDst.SRC) ? 4 : 8) : (asSource.equals((Object)SrcDst.SRC) ? 8 : 4);
            } else if (dydx > 0.5 && dydx <= 2.0) {
                result = dx > 0.0 ? (asSource.equals((Object)SrcDst.SRC) ? 1 : 5) : (asSource.equals((Object)SrcDst.SRC) ? 5 : 1);
            } else if (dydx >= -2.0 && dydx <= -0.5) {
                result = dx < 0.0 ? (asSource.equals((Object)SrcDst.SRC) ? 3 : 7) : (asSource.equals((Object)SrcDst.SRC) ? 7 : 3);
            } else if (dydx > 2.0 || dydx < -2.0) {
                result = dy > 0.0 ? (asSource.equals((Object)SrcDst.SRC) ? 2 : 6) : (asSource.equals((Object)SrcDst.SRC) ? 6 : 2);
            }
        }
        return result;
    }

    private Point2D.Double calcEdgePoint(Connection c, DoingLabel doName, SrcDst asSource, int direction, double xIn, double yIn) {
        double y;
        double x;
        block35: {
            block37: {
                block36: {
                    if (doName.equals((Object)DoingLabel.LABEL) && c != null) {
                        Rectangle2D cnNameBounds = null;
                        if (asSource.equals((Object)SrcDst.SRC) && c.getShowAtSrc() && c.getBoundsNameSource() != null) {
                            cnNameBounds = c.getBoundsNameSource();
                        }
                        if (asSource.equals((Object)SrcDst.DST) && c.getShowAtDst() && c.getBoundsNameDestination() != null) {
                            cnNameBounds = c.getBoundsNameDestination();
                        }
                        Point2D.Double resultPoint = this.adjustToNameBounds(cnNameBounds, direction);
                        return resultPoint;
                    }
                    x = xIn;
                    y = yIn;
                    Event e = null;
                    if (doName.equals((Object)DoingLabel.OTHER)) {
                        e = asSource.equals((Object)SrcDst.SRC) ? c.getSourceEvent() : c.getDestEvent();
                    }
                    if (e.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) && e.getAsTitle()) {
                        Point2D.Double resultPoint = this.adjustToNameBounds(e.getNameBounds(), direction);
                        return resultPoint;
                    }
                    if (e.getEventType().equals((Object)CommonData.EventType.GENERAL_EVENT) && !e.getAsTitle() || e.getEventType().equals((Object)CommonData.EventType.TIMELINE_EVENT)) {
                        switch (direction) {
                            case 1: {
                                x = e.getNameBounds().getMaxX();
                                y = e.getNameBounds().getMaxY();
                                break;
                            }
                            case 2: {
                                x = e.getNameBounds().getCenterX();
                                y = e.getNameBounds().getMaxY();
                                break;
                            }
                            case 3: {
                                x = e.getNameBounds().getX();
                                y = e.getNameBounds().getMaxY();
                                break;
                            }
                            case 4: {
                                x = e.getPositionX();
                                y = e.getPositionY();
                                if (e.getIcon() == null) break;
                                x -= (double)(e.getIcon().getIconWidth() / 2);
                                y += (double)(e.getIcon().getIconHeight() / 2);
                                break;
                            }
                            case 5: {
                                if (e.getIcon() != null) {
                                    x = e.getPositionX() - (double)(e.getIcon().getIconWidth() / 2);
                                }
                                y = e.getPositionY();
                                break;
                            }
                            case 6: {
                                x = e.getPositionX();
                                y = e.getPositionY();
                                break;
                            }
                            case 7: {
                                x = e.getPositionX();
                                y = e.getPositionY();
                                if (e.getIcon() == null) break;
                                x += (double)(e.getIcon().getIconWidth() / 2);
                                break;
                            }
                            case 8: {
                                x = e.getPositionX();
                                y = e.getPositionY();
                                if (e.getIcon() == null) break;
                                x += (double)(e.getIcon().getIconWidth() / 2);
                                y += (double)(e.getIcon().getIconHeight() / 2);
                                break;
                            }
                            default: {
                                System.out.println("TimePanel connection destination switch has bad source event point " + direction);
                            }
                        }
                        return new Point2D.Double(x, y);
                    }
                    if (e.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
                        Point2D.Double resultPoint = this.adjustToNameBounds(e.getNameBounds(), direction);
                        double newX = resultPoint.getX();
                        double newY = resultPoint.getY();
                        return new Point2D.Double(newX, newY);
                    }
                    if (!e.getEventType().equals((Object)CommonData.EventType.TIMELINE)) break block35;
                    if ((!asSource.equals((Object)SrcDst.SRC) || c.getSourceTimelinePoint() != 0) && (!asSource.equals((Object)SrcDst.DST) || c.getDestTimelinePoint() != 0)) break block36;
                    x = e.getPositionX();
                    y = e.getPositionY();
                    switch (direction) {
                        case 1: {
                            if (e.getIcon() != null) {
                                x += (double)e.getIcon().getIconWidth();
                                y += (double)(e.getIcon().getIconHeight() / 2);
                                break;
                            }
                            break block37;
                        }
                        case 2: {
                            if (e.getIcon() != null) {
                                x += (double)(e.getIcon().getIconWidth() / 2);
                                y += (double)(e.getIcon().getIconHeight() / 2);
                                break;
                            }
                            break block37;
                        }
                        case 3: {
                            if (e.getIcon() != null) {
                                y += (double)(e.getIcon().getIconHeight() / 2);
                                break;
                            }
                            break block37;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            if (e.getIcon() != null) {
                                y -= (double)(e.getIcon().getIconHeight() / 2);
                                break;
                            }
                            break block37;
                        }
                        case 6: {
                            if (e.getIcon() != null) {
                                x += (double)(e.getIcon().getIconWidth() / 2);
                                y -= (double)(e.getIcon().getIconHeight() / 2);
                                break;
                            }
                            break block37;
                        }
                        case 7: {
                            if (e.getIcon() != null) {
                                x += (double)e.getIcon().getIconWidth();
                                y -= (double)(e.getIcon().getIconHeight() / 2);
                                break;
                            }
                            break block37;
                        }
                        case 8: {
                            if (e.getIcon() != null) {
                                x += (double)e.getIcon().getIconWidth();
                                break;
                            }
                            break block37;
                        }
                        default: {
                            System.out.println("TimePanel connection destination switch has bad source event point " + direction);
                            break;
                        }
                    }
                    break block37;
                }
                x = xIn;
                y = yIn;
            }
            return new Point2D.Double(x, y);
        }
        System.out.println("TimePanel adjustjoin shouldn't get here.");
        return new Point2D.Double(x, y);
    }

    private Point2D.Double adjustToNameBounds(Rectangle2D cnNameBounds, int direction) {
        Point2D.Double result = new Point2D.Double(0.0, 0.0);
        switch (direction) {
            case 1: {
                result.setLocation(cnNameBounds.getMaxX(), cnNameBounds.getMaxY());
                break;
            }
            case 2: {
                result.setLocation(cnNameBounds.getCenterX(), cnNameBounds.getMaxY());
                break;
            }
            case 3: {
                result.setLocation(cnNameBounds.getX(), cnNameBounds.getMaxY());
                break;
            }
            case 4: {
                result.setLocation(cnNameBounds.getMinX(), cnNameBounds.getCenterY());
                break;
            }
            case 5: {
                result.setLocation(cnNameBounds.getMinX(), cnNameBounds.getMinY());
                break;
            }
            case 6: {
                result.setLocation(cnNameBounds.getCenterX(), cnNameBounds.getMinY());
                break;
            }
            case 7: {
                result.setLocation(cnNameBounds.getMaxX(), cnNameBounds.getMinY());
                break;
            }
            case 8: {
                result.setLocation(cnNameBounds.getMaxX(), cnNameBounds.getCenterY());
                break;
            }
            default: {
                System.out.println("TimePanel connection destination switch has bad direction " + direction);
            }
        }
        return result;
    }

    private void prepareSineWave(int amp, int len) {
        double increment = Math.PI / (double)len;
        double t = 0.0;
        int i = 0;
        while (i < len) {
            this.halfWave1[i] = (double)amp * Math.sin(t);
            this.halfWave2[i] = -this.halfWave1[i];
            t += increment;
            ++i;
        }
        this.halfWave1[len - 1] = 0.0;
        this.halfWave2[len - 1] = 0.0;
    }

    private void prepareHelix(double amp) {
        double increment = Math.PI * 2 / (double)this.helixSteps;
        this.pFactor = (double)this.helixPitch / (Math.PI * 2);
        double t = 0.0;
        int i = 0;
        while (i < this.helixSteps) {
            this.circleX[i] = amp * Math.sin(t) + this.pFactor * t;
            this.circleY[i] = amp * Math.cos(t) - amp;
            t += increment;
            ++i;
        }
        this.circleX[this.helixSteps - 1] = this.helixPitch;
        this.circleY[this.helixSteps - 1] = 0.0;
        this.helixDX = this.circleX[this.helixSteps - 1];
    }

    private Point2D.Double divLine(double div, Point2D.Double start, Point2D.Double end) {
        double x = start.getX() + (end.getX() - start.getX()) * div;
        double y = start.getY() + (end.getY() - start.getY()) * div;
        return new Point2D.Double(x, y);
    }

    private void drawAge(Graphics2D g2d, Color ageColor, double x1, double y1, int age) {
        if (age != 0) {
            Utils.setGraphicsFont(g2d, this.prefs.getTlAgeFont());
            FontMetrics metrics = g2d.getFontMetrics(this.prefs.getTlAgeFont());
            g2d.setColor(ageColor);
            Line2D.Double tick = new Line2D.Double(x1, y1, x1, y1 - (double)this.ageTickHeight);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.draw(tick);
            String ageString = String.valueOf(age);
            int ageX = (int)Math.round(x1) - metrics.stringWidth(ageString) / 2;
            int ageY = (int)Math.round(y1) - this.ageTickHeight;
            g2d.drawString(ageString, ageX, ageY);
        }
    }

    private Integer dateToPx(LocalDate ref, LocalDate date, double pxPerDay, int margin) {
        return margin + (int)Math.round((double)ChronoUnit.DAYS.between(ref, date) * pxPerDay);
    }

    private boolean isTimelineOnScreen(Event tl, LocalDate screenStart, LocalDate screenEnd) {
        LocalDate tmpEndDate = tl.getDates().getRealEndDate();
        return !tmpEndDate.isBefore(screenStart) && !tl.getDates().getEarlyStartDate().isAfter(screenEnd);
    }

    private int getRowLabelMargin(Graphics2D g2d) {
        int rowMargin = 0;
        if (this.rowLabelsChoice) {
            FontMetrics metrics = g2d.getFontMetrics(this.prefs.getRowLabelsFont());
            if (this.prefs.getShowRowNosChoice()) {
                int nRows = this.ourGUI.getRowData().getSize();
                rowMargin = (int)metrics.getStringBounds(String.valueOf(nRows), g2d).getWidth();
            }
        }
        return rowMargin;
    }

    public void setWidth(int w) {
        this.panelWidth = w;
    }

    public void setFound(Find.Found f, HighlightEnd cnSrc) {
        this.foundItem = f;
        this.foundCnSrc = cnSrc;
        this.repaint();
    }

    public Color getExportBackground() {
        return this.exportBackground;
    }

    public Graphics2D getGraphicsContext() {
        return this.g2dScreen;
    }

    public Color getGraphicBackground() {
        return this.graphicBackground;
    }

    public int getXaxisHeight() {
        return this.xAxisHeight;
    }

    public void setScreenEnabled(boolean e) {
        this.screenEnabled = e;
    }

    static enum BottomMargin {
        MARGIN,
        NO_MARGIN;

    }

    private static enum DoingLabel {
        LABEL,
        OTHER;

    }

    private static enum DrawOrCalculate {
        DRAW,
        CALCULATE_ONLY;

    }

    static enum HighlightEnd {
        SRC,
        DST;

    }

    static enum Layout {
        SINGLE_IMAGE,
        MULTIPLE_HIGH,
        FULL_DIAGRAM;

    }

    static enum Scaling {
        SCREEN,
        PRINTER;

    }

    static enum SplitRows {
        SPLIT,
        NO_SPLIT;

    }

    private static enum SrcDst {
        SRC,
        DST;

    }

    static enum XaxisPaging {
        ONLY_FIRST_PAGE,
        EVERY_PAGE;

    }
}

