/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.ActiveFilterStage;
import culturalDynamics.CDgui;
import culturalDynamics.Connection;
import culturalDynamics.ConnectionData;
import culturalDynamics.Event;
import culturalDynamics.EventData;
import culturalDynamics.Filter;
import culturalDynamics.FilterEditor;
import culturalDynamics.SavedFilterData;
import culturalDynamics.TagList;
import culturalDynamics.TagRename;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.text.Position;

class TagSelector
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FlowLayout flowLayoutLeft = new FlowLayout(0);
    private FlowLayout flowLayoutRight = new FlowLayout(2);
    private JPanel ourFrame;
    private CDgui ourGUI;
    private JButton addTagButton = new JButton("<");
    private JButton remTagButton = new JButton(">");
    private JButton defineTagButton = new JButton("Define");
    private JButton deleteTagButton = new JButton("Delete");
    private JButton renameTagButton = new JButton("Rename");
    private String tagKeySequence = "";
    private JList<String> newTagsField;
    private JList<String> availableTagsField;
    private JScrollPane availableScroll;
    private TagList masterList;
    private TagList availableList;
    private TagList newTagsList;
    private JScrollPane isScroll;
    private JTextField defineTagField = new JTextField(18);
    private String allowedTags = "[\\p{Ll}0-9_]*";

    TagSelector(CDgui mainGUI, TagList isListIn, final AllowDefine allowDefine) {
        this.ourGUI = mainGUI;
        this.ourFrame = this;
        this.newTagsList = isListIn;
        if (this.newTagsList == null) {
            this.newTagsList = new TagList();
        }
        this.masterList = this.ourGUI.getMasterTags();
        this.isScroll = new JScrollPane();
        this.isScroll.setPreferredSize(new Dimension(200, 80));
        String[] emptyNew = new String[]{"Empty"};
        this.newTagsField = new JList<String>(emptyNew);
        this.newTagsField.setLayoutOrientation(0);
        this.newTagsField.setSelectionMode(2);
        this.isScroll.setViewportView(this.newTagsField);
        this.updateNewTags(this.newTagsList);
        this.newTagsField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                String tag;
                TagSelector.this.availableTagsField.clearSelection();
                if (me.getClickCount() == 2 && (tag = TagSelector.this.newTagsField.getSelectedValue()) != null) {
                    TagSelector.this.availableList.addTag(tag);
                    TagSelector.this.availableList.sortTags();
                    TagSelector.this.availableTagsField.setListData((String[])TagSelector.this.availableList.getTagsAsArray());
                    TagSelector.this.newTagsList.removeTagByName(tag);
                    TagSelector.this.newTagsField.setListData((String[])TagSelector.this.newTagsList.getTagsAsArray());
                    if (!allowDefine.equals((Object)AllowDefine.DEFINE)) {
                        TagSelector.this.ourGUI.getFilterEditor().savedFilterChanged();
                    }
                }
                if (!TagSelector.this.newTagsField.isSelectionEmpty()) {
                    TagSelector.this.deleteTagButton.setEnabled(false);
                }
                TagSelector.this.defineTagButton.setEnabled(false);
                if (TagSelector.this.newTagsField.getSelectedIndices().length == 1) {
                    TagSelector.this.renameTagButton.setEnabled(true);
                }
                TagSelector.this.updateAddRemButtons();
                TagSelector.this.ourFrame.revalidate();
                TagSelector.this.ourFrame.repaint();
            }
        });
        ActionListener resetTagSearch = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent t) {
                TagSelector.this.tagKeySequence = "";
            }
        };
        final Timer searchResetTimerNew = new Timer(1000, resetTagSearch);
        this.newTagsField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent k) {
                if (TagSelector.this.newTagsField.getModel().getSize() > 0) {
                    int id = k.getID();
                    char c = k.getKeyChar();
                    String key = String.valueOf(c).toLowerCase();
                    if (id == 400 && key.matches("[a-z]|[0-9]|_")) {
                        searchResetTimerNew.restart();
                        TagSelector.this.tagKeySequence = String.valueOf(TagSelector.this.tagKeySequence) + key;
                        int idx = TagSelector.this.newTagsField.getNextMatch("#" + TagSelector.this.tagKeySequence, 0, Position.Bias.Forward);
                        TagSelector.this.newTagsField.setSelectedIndex(idx);
                        TagSelector.this.newTagsField.ensureIndexIsVisible(idx);
                    }
                    if (!TagSelector.this.newTagsField.isSelectionEmpty()) {
                        TagSelector.this.deleteTagButton.setEnabled(false);
                    }
                    TagSelector.this.defineTagButton.setEnabled(false);
                    if (TagSelector.this.availableTagsField.getSelectedIndices().length == 1) {
                        TagSelector.this.renameTagButton.setEnabled(true);
                    }
                }
            }
        });
        searchResetTimerNew.setRepeats(false);
        JLabel newLabel = new JLabel("Use");
        Box newPanel = Box.createVerticalBox();
        newPanel.add(newLabel);
        newPanel.add(this.isScroll);
        this.availableScroll = new JScrollPane();
        this.availableScroll.setPreferredSize(new Dimension(200, 80));
        String[] emptyAvail = new String[]{"Empty"};
        this.availableTagsField = new JList<String>(emptyAvail);
        this.availableTagsField.setLayoutOrientation(0);
        this.availableTagsField.setSelectionMode(2);
        this.availableScroll.setViewportView(this.availableTagsField);
        this.updateAvailableTags();
        this.availableTagsField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                String tag;
                TagSelector.this.newTagsField.clearSelection();
                if (me.getClickCount() == 2 && (tag = TagSelector.this.availableTagsField.getSelectedValue()) != null) {
                    TagSelector.this.newTagsList.addTag(tag);
                    TagSelector.this.newTagsList.sortTags();
                    TagSelector.this.newTagsField.setListData((String[])TagSelector.this.newTagsList.getTagsAsArray());
                    TagSelector.this.availableList.removeTagByName(tag);
                    TagSelector.this.availableTagsField.setListData((String[])TagSelector.this.availableList.getTagsAsArray());
                    if (!allowDefine.equals((Object)AllowDefine.DEFINE)) {
                        TagSelector.this.ourGUI.getFilterEditor().savedFilterChanged();
                    }
                }
                TagSelector.this.deleteTagButton.setEnabled(!TagSelector.this.availableTagsField.isSelectionEmpty());
                TagSelector.this.defineTagButton.setEnabled(false);
                if (TagSelector.this.availableTagsField.getSelectedIndices().length == 1) {
                    TagSelector.this.renameTagButton.setEnabled(true);
                }
                TagSelector.this.updateAddRemButtons();
                TagSelector.this.ourFrame.revalidate();
                TagSelector.this.ourFrame.repaint();
            }
        });
        final Timer searchResetTimerAv = new Timer(1000, resetTagSearch);
        this.availableTagsField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent k) {
                if (TagSelector.this.availableTagsField.getModel().getSize() > 0) {
                    int id = k.getID();
                    char c = k.getKeyChar();
                    String key = String.valueOf(c).toLowerCase();
                    if (id == 400 && key.matches("[a-z]|[0-9]|_")) {
                        searchResetTimerAv.restart();
                        TagSelector.this.tagKeySequence = String.valueOf(TagSelector.this.tagKeySequence) + key;
                        int idx = TagSelector.this.availableTagsField.getNextMatch("#" + TagSelector.this.tagKeySequence, 0, Position.Bias.Forward);
                        TagSelector.this.availableTagsField.setSelectedIndex(idx);
                        TagSelector.this.availableTagsField.ensureIndexIsVisible(idx);
                    }
                    TagSelector.this.deleteTagButton.setEnabled(!TagSelector.this.availableTagsField.isSelectionEmpty());
                    TagSelector.this.defineTagButton.setEnabled(false);
                    if (TagSelector.this.availableTagsField.getSelectedIndices().length == 1) {
                        TagSelector.this.renameTagButton.setEnabled(true);
                    }
                }
            }
        });
        searchResetTimerAv.setRepeats(false);
        JLabel availableLabel = new JLabel("Available");
        Box availablePanel = Box.createVerticalBox();
        availablePanel.add(availableLabel);
        availablePanel.add(this.availableScroll);
        Box tagButtonsBox = Box.createVerticalBox();
        this.addTagButton.setToolTipText("Add the selected tags from the available list (right)");
        tagButtonsBox.add(this.addTagButton);
        this.addTagButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent add) {
                List<String> selectedTags = TagSelector.this.availableTagsField.getSelectedValuesList();
                for (String tag : selectedTags) {
                    TagSelector.this.newTagsList.addTag(tag);
                    TagSelector.this.newTagsList.sortTags();
                    TagSelector.this.newTagsField.setListData((String[])TagSelector.this.newTagsList.getTagsAsArray());
                    TagSelector.this.availableList.removeTagByName(tag);
                    TagSelector.this.availableTagsField.setListData((String[])TagSelector.this.availableList.getTagsAsArray());
                    if (allowDefine.equals((Object)AllowDefine.DEFINE)) continue;
                    TagSelector.this.ourGUI.getFilterEditor().savedFilterChanged();
                }
                TagSelector.this.updateAddRemButtons();
                TagSelector.this.ourFrame.revalidate();
                TagSelector.this.ourFrame.repaint();
            }
        });
        this.remTagButton.setToolTipText("Remove selected tags from the new tags list (left)");
        tagButtonsBox.add(this.remTagButton);
        this.remTagButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent rem) {
                List<String> selectedTags = TagSelector.this.newTagsField.getSelectedValuesList();
                for (String tag : selectedTags) {
                    TagSelector.this.availableList.addTag(tag);
                    TagSelector.this.availableList.sortTags();
                    TagSelector.this.availableTagsField.setListData((String[])TagSelector.this.availableList.getTagsAsArray());
                    TagSelector.this.newTagsList.removeTagByName(tag);
                    TagSelector.this.newTagsField.setListData((String[])TagSelector.this.newTagsList.getTagsAsArray());
                    if (allowDefine.equals((Object)AllowDefine.DEFINE)) continue;
                    TagSelector.this.ourGUI.getFilterEditor().savedFilterChanged();
                }
                TagSelector.this.updateAddRemButtons();
                TagSelector.this.ourFrame.revalidate();
                TagSelector.this.ourFrame.repaint();
            }
        });
        JPanel definePanel = new JPanel(this.flowLayoutLeft);
        if (allowDefine.equals((Object)AllowDefine.DEFINE)) {
            this.defineTagField.setToolTipText("Enter new tag, starting with #");
            this.defineTagField.setText("#");
            this.defineTagButton.setEnabled(false);
            this.defineTagField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent f) {
                    TagSelector.this.defineTagButton.setEnabled(true);
                    TagSelector.this.deleteTagButton.setEnabled(false);
                    TagSelector.this.renameTagButton.setEnabled(false);
                    TagSelector.this.newTagsField.clearSelection();
                    TagSelector.this.availableTagsField.clearSelection();
                    TagSelector.this.updateAddRemButtons();
                }

                @Override
                public void focusLost(FocusEvent f) {
                }
            });
            definePanel.add(this.defineTagField);
            this.defineTagButton.setToolTipText("Define a new tag");
            this.defineTagButton.setEnabled(false);
            definePanel.add(this.defineTagButton);
            this.deleteTagButton.setToolTipText("Delete selected tag from available list");
            this.deleteTagButton.setEnabled(false);
            definePanel.add(this.deleteTagButton);
            definePanel.add(this.renameTagButton);
            this.defineTagButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent n) {
                    if (TagSelector.this.defineTagField.getText().isEmpty() || TagSelector.this.defineTagField.getText() == "") {
                        return;
                    }
                    if (!TagSelector.this.defineTagField.getText().substring(0, 1).equals("#")) {
                        JOptionPane.showMessageDialog(TagSelector.this.ourFrame, "Tag Selector: tag must start with #");
                        return;
                    }
                    if (TagSelector.this.defineTagField.getText().length() < 2 || !TagSelector.this.defineTagField.getText().substring(1).matches(TagSelector.this.allowedTags)) {
                        JOptionPane.showMessageDialog(TagSelector.this.ourFrame, "Tag Selector: tag may only contain lower case letters and numbers and underline and only one tag can be defined at a a time");
                        return;
                    }
                    if (TagSelector.this.masterList.tagExists(TagSelector.this.defineTagField.getText())) {
                        JOptionPane.showMessageDialog(TagSelector.this.ourFrame, "Tag Selector: tag already exists");
                        return;
                    }
                    TagSelector.this.masterList.addTag(TagSelector.this.defineTagField.getText());
                    TagSelector.this.masterList.sortTags();
                    TagSelector.this.newTagsList.addTag(TagSelector.this.defineTagField.getText());
                    TagSelector.this.newTagsList.sortTags();
                    TagSelector.this.newTagsField.setListData((String[])TagSelector.this.newTagsList.getTagsAsArray());
                    TagSelector.this.updateAddRemButtons();
                    TagSelector.this.ourFrame.revalidate();
                    TagSelector.this.ourFrame.repaint();
                }
            });
            this.deleteTagButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent d) {
                    Object tagUsage = "";
                    EventData ed = TagSelector.this.ourGUI.getInput().getEventData();
                    ConnectionData cd = TagSelector.this.ourGUI.getInput().getConnections();
                    SavedFilterData fd = TagSelector.this.ourGUI.getSavedFilterData();
                    for (String tag : TagSelector.this.availableTagsField.getSelectedValuesList()) {
                        int i = 0;
                        while (i < ed.getTotalNumberOfEvents()) {
                            if (ed.getEventByIndex(i).getTags() != null && ed.getEventByIndex(i).getTags().tagExists(tag)) {
                                tagUsage = (String)tagUsage + tag + " from event " + ed.getEventByIndex(i).getName() + "\n";
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < cd.getNumberOfConnections()) {
                            if (cd.getConnection(i).getTags() != null && cd.getConnection(i).getTags().tagExists(tag)) {
                                tagUsage = (String)tagUsage + tag + " from connection " + cd.getConnection(i).getName() + "\n";
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < fd.getNumFilters()) {
                            int j = 0;
                            while (j < fd.getSavedFilterByIndex(i).getNumFilterStages()) {
                                if (fd.getSavedFilterByIndex(i).getFilterStageSaved(j).getTags() != null && fd.getSavedFilterByIndex(i).getFilterStageSaved(j).getTags().tagExists(tag)) {
                                    tagUsage = (String)tagUsage + tag + " filter " + fd.getSavedFilterByIndex(i).getName() + "\n";
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    if (!((String)tagUsage).equals("")) {
                        JOptionPane.showMessageDialog(TagSelector.this.ourFrame, "Tag Selector: the tags cannot be deleted until removed from\n" + (String)tagUsage);
                        return;
                    }
                    TagSelector.this.masterList.removeMultipleTags(TagSelector.this.availableTagsField.getSelectedValuesList());
                    TagSelector.this.masterList.sortTags();
                    TagSelector.this.availableList = TagSelector.this.masterList.getCopyOfTags();
                    TagSelector.this.availableTagsField.setListData((String[])TagSelector.this.availableList.getTagsAsArray());
                    TagSelector.this.newTagsList.removeMultipleTags(TagSelector.this.availableTagsField.getSelectedValuesList());
                    TagSelector.this.newTagsList.sortTags();
                    TagSelector.this.newTagsField.setListData((String[])TagSelector.this.newTagsList.getTagsAsArray());
                    TagSelector.this.ourFrame.revalidate();
                    TagSelector.this.ourFrame.repaint();
                }
            });
            this.renameTagButton.setToolTipText("Opens a dialogue to rename the selected tag in either list");
            this.renameTagButton.setEnabled(false);
            this.renameTagButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent n) {
                    TagSelector ourTS;
                    int index;
                    List<String> selectedTags = TagSelector.this.availableTagsField.getSelectedValuesList();
                    if (selectedTags.size() == 0) {
                        selectedTags = TagSelector.this.newTagsField.getSelectedValuesList();
                    }
                    if (selectedTags.size() != 1) {
                        JOptionPane.showMessageDialog(TagSelector.this.ourFrame, "Tag Selector: Select only one tag from either list for rename.");
                        return;
                    }
                    String oldTag = selectedTags.get(0);
                    TagRename renameDialogue = new TagRename(TagSelector.this.ourFrame, oldTag);
                    String result = renameDialogue.getResult();
                    if (result.equals("Cancel")) {
                        return;
                    }
                    if (result.isEmpty() || result == "") {
                        JOptionPane.showMessageDialog(TagSelector.this.ourFrame, "Tag Selector: New tag name was empty");
                        return;
                    }
                    if (!result.substring(0, 1).equals("#")) {
                        JOptionPane.showMessageDialog(TagSelector.this.ourFrame, "Tag Selector: tag must start with #");
                        return;
                    }
                    if (result.length() < 2 || !result.substring(1).matches(TagSelector.this.allowedTags)) {
                        JOptionPane.showMessageDialog(TagSelector.this.ourFrame, "Tag Selector: tag may only contain lower case letters and numbers and underline  and only one tag can be defined at a a time");
                        return;
                    }
                    if (TagSelector.this.masterList.tagExists(result)) {
                        JOptionPane.showMessageDialog(TagSelector.this.ourFrame, "Tag Selector: A tag with the new name already exists");
                        return;
                    }
                    EventData ed = TagSelector.this.ourGUI.getInput().getEventData();
                    ConnectionData cd = TagSelector.this.ourGUI.getInput().getConnections();
                    SavedFilterData fd = TagSelector.this.ourGUI.getSavedFilterData();
                    int i = 0;
                    while (i < ed.getTotalNumberOfEvents()) {
                        if (ed.getEventByIndex(i).getTags() != null && (index = ed.getEventByIndex(i).getTags().getTagByName(oldTag)) != -1) {
                            Event ourEv = ed.getEventByIndex(i);
                            ourEv.getTags().replaceTag(index, result);
                            if (ourEv.getEditor() != null) {
                                ourTS = ourEv.getEditor().getTagsPanel();
                                ourTS.replaceNewTag(oldTag, result);
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < cd.getNumberOfConnections()) {
                        if (cd.getConnection(i).getTags() != null && (index = cd.getConnection(i).getTags().getTagByName(oldTag)) != -1) {
                            Connection ourCn = cd.getConnection(i);
                            ourCn.getTags().replaceTag(index, result);
                            if (ourCn.getEditor() != null) {
                                ourTS = ourCn.getEditor().getTagsPanel();
                                ourTS.replaceNewTag(oldTag, result);
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < fd.getNumFilters()) {
                        int j = 0;
                        while (j < fd.getSavedFilterByIndex(i).getNumFilterStages()) {
                            int index2;
                            if (fd.getSavedFilterByIndex(i).getFilterStageSaved(j).getTags() != null && (index2 = fd.getSavedFilterByIndex(i).getFilterStageSaved(j).getTags().getTagByName(oldTag)) != -1) {
                                fd.getSavedFilterByIndex(i).getFilterStageSaved(j).getTags().replaceTag(index2, result);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    TagSelector.this.replaceNewTag(oldTag, result);
                    TagSelector.this.masterList.removeTagByName(oldTag);
                    TagSelector.this.masterList.addTag(result);
                    TagSelector.this.masterList.sortTags();
                    TagSelector.this.updateAvailableTags();
                    FilterEditor ourFilterEditor = TagSelector.this.ourGUI.getFilterEditor();
                    Filter activeFilter = ourFilterEditor.getActiveFilter();
                    int i2 = 0;
                    while (i2 < activeFilter.getNumFilterStages()) {
                        ActiveFilterStage stage = activeFilter.getFilterStageActive(i2);
                        TagList stageTags = stage.getTags();
                        if (stageTags.tagExists(oldTag)) {
                            int index3 = stageTags.getTagByName(oldTag);
                            stageTags.replaceTag(index3, result);
                        }
                        stage.getFilterStageEditor().getTagSelector().updateNewTags(stageTags);
                        ++i2;
                    }
                    ourFilterEditor.revalidate();
                    ourFilterEditor.repaint();
                }
            });
        }
        JPanel tagsPanel = new JPanel(this.flowLayoutLeft);
        tagsPanel.add(newPanel);
        tagsPanel.add(tagButtonsBox);
        tagsPanel.add(availablePanel);
        JPanel mainButtonsPanel = new JPanel(this.flowLayoutRight);
        Box tagsMainPanel = Box.createVerticalBox();
        tagsMainPanel.add(tagsPanel);
        if (allowDefine.equals((Object)AllowDefine.DEFINE)) {
            tagsMainPanel.add(definePanel);
        }
        tagsMainPanel.add(mainButtonsPanel);
        this.add(tagsMainPanel);
    }

    private void replaceNewTag(String oldTag, String newTag) {
        if (this.newTagsList.tagExists(oldTag)) {
            this.newTagsList.removeTagByName(oldTag);
            this.newTagsList.addTag(newTag);
            this.newTagsList.sortTags();
            this.newTagsField.setListData((String[])this.newTagsList.getTagsAsArray());
        }
    }

    private void updateNewTags(TagList currentTags) {
        this.newTagsList = currentTags.getCopyOfTags();
        String[] tagArray = currentTags.getTagsAsArray();
        this.newTagsField.setListData((String[])tagArray);
        this.isScroll.setViewportView(this.newTagsField);
        this.ourFrame.revalidate();
        this.ourFrame.repaint();
    }

    private void updateAddRemButtons() {
        if (this.newTagsList.isEmpty()) {
            this.remTagButton.setEnabled(false);
        } else {
            this.remTagButton.setEnabled(true);
        }
        if (this.availableList.isEmpty()) {
            this.addTagButton.setEnabled(false);
        } else {
            this.addTagButton.setEnabled(true);
        }
    }

    public void updateAvailableTags() {
        this.availableList = new TagList();
        this.availableList = this.ourGUI.getMasterTags().getCopyOfTags();
        int i = 0;
        while (i < this.newTagsList.getList().size()) {
            this.availableList.removeTagByName(this.newTagsList.getTagByIndex(i));
            ++i;
        }
        this.availableList.sortTags();
        String[] availableArray = this.availableList.getTagsAsArray();
        this.availableTagsField.setListData((String[])availableArray);
        this.availableScroll.setViewportView(this.availableTagsField);
        this.ourFrame.revalidate();
        this.ourFrame.repaint();
    }

    public TagList getNewTagList() {
        return this.newTagsList;
    }

    public static enum AllowDefine {
        DEFINE,
        NO_DEFINE;

    }
}

