/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class TagList {
    private ArrayList<String> tags = new ArrayList();

    public TagList() {
        this.tags.clear();
    }

    public boolean isEmpty() {
        return this.tags.isEmpty() || this.tags.size() == 1 && this.tags.get(0).equals("");
    }

    public ArrayList<String> getList() {
        return this.tags;
    }

    public String getTagByIndex(int i) {
        return this.tags.get(i);
    }

    public int getTagByName(String t) {
        return this.tags.indexOf(t);
    }

    public boolean tagExists(String t) {
        return this.tags.contains(t);
    }

    public void replaceTag(int i, String t) {
        this.tags.set(i, t);
    }

    public void addTag(String t) {
        if (!this.tagExists(t)) {
            this.tags.add(t.trim());
        }
    }

    public void removeTagByName(String t) {
        this.tags.remove(t);
    }

    public void removeMultipleTags(List<String> targets) {
        this.tags.removeAll(targets);
    }

    public int getSize() {
        return this.tags.size();
    }

    public void initialiseList() {
        this.tags.clear();
    }

    public void sortTags() {
        this.tags.sort(null);
    }

    public String getTagsAsString() {
        Object tmp = "";
        int i = 0;
        while (i < this.tags.size()) {
            tmp = (String)tmp + this.tags.get(i) + " ";
            ++i;
        }
        tmp = this.removeLastSpace((String)tmp);
        return tmp;
    }

    private String removeLastSpace(String str) {
        String result = "";
        if (str != null && str.length() > 0 && str.charAt(str.length() - 1) == ' ') {
            result = str.substring(0, str.length() - 1);
        }
        return result;
    }

    public String[] getTagsAsArray() {
        String[] tmp = new String[this.tags.size()];
        int i = 0;
        while (i < this.tags.size()) {
            tmp[i] = this.tags.get(i);
            ++i;
        }
        return tmp;
    }

    public void setTagListFromString(String s) {
        this.tags = !s.equals("") ? new ArrayList<String>(Arrays.asList(s.split(" "))) : new ArrayList();
    }

    public TagList getCopyOfTags() {
        TagList dest = new TagList();
        if (this.tags != null) {
            int i = 0;
            while (i < this.tags.size()) {
                dest.addTag(this.tags.get(i));
                ++i;
            }
        }
        return dest;
    }
}

