/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.Event;
import culturalDynamics.Segment;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class SegmentList {
    private Event timeline;
    private List<Segment> segments;

    public SegmentList(Event tl) {
        this.timeline = tl;
        this.segments = new ArrayList<Segment>();
    }

    public void addSegment(Segment seg) {
        this.segments.add(seg);
    }

    public Event getTimeline() {
        return this.timeline;
    }

    public void setTimeline(Event timeline) {
        this.timeline = timeline;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public int getNumberOfSegments() {
        return this.segments.size();
    }

    public Segment getASegment(int idx) {
        return this.segments.get(idx);
    }

    public Boolean deleteSegment(Segment seg) {
        return this.segments.remove(seg);
    }

    public LocalDate getEarliestStartDate() {
        LocalDate minimumStartDate = null;
        for (Segment segment : this.segments) {
            if (minimumStartDate != null && !segment.getDates().getEarlyStartDate().isBefore(minimumStartDate)) continue;
            minimumStartDate = segment.getDates().getEarlyStartDate();
        }
        return minimumStartDate;
    }

    public LocalDate getLatestEndDate() {
        LocalDate maximumEndDate = null;
        for (Segment segment : this.segments) {
            LocalDate tmp = segment.getDates().getEarlyEndDate();
            if (segment.getDates().getLateEndDate() != null) {
                tmp = segment.getDates().getLateEndDate();
            }
            if (maximumEndDate != null && !tmp.isAfter(maximumEndDate)) continue;
            maximumEndDate = tmp;
        }
        return maximumEndDate;
    }

    public Segment getLatestSegment() {
        if (this.segments.size() == 0) {
            return null;
        }
        LocalDate maximumEndDate = null;
        Segment lastSegment = null;
        for (Segment segment : this.segments) {
            LocalDate tmp = segment.getDates().getEarlyEndDate();
            if (segment.getDates().getLateEndDate() != null) {
                tmp = segment.getDates().getLateEndDate();
            }
            if (maximumEndDate != null && !tmp.isAfter(maximumEndDate)) continue;
            maximumEndDate = tmp;
            lastSegment = segment;
        }
        return lastSegment;
    }

    public void sortSegmentsByStart() {
        if (this.segments != null && this.segments.size() != 0) {
            Collections.sort(this.segments, new StartSorter());
        }
    }

    private static class StartSorter
    implements Comparator<Segment> {
        private StartSorter() {
        }

        @Override
        public int compare(Segment o1, Segment o2) {
            int tmp = o1.getDates().getEarlyStartDate().compareTo(o2.getDates().getEarlyStartDate());
            return tmp;
        }
    }
}

