/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.CommonEditor;
import culturalDynamics.Dates;
import culturalDynamics.Event;
import culturalDynamics.PaletteColorPanel;
import culturalDynamics.Segment;
import culturalDynamics.SegmentList;
import culturalDynamics.TimePanel;
import culturalDynamics.Utils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LinearGradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeParseException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

class SegmentEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JFrame segEditorFrame;
    private SegmentEditor segEditor;
    private CDgui ourGUI;
    private TimePanel segDisplay;
    private Event segTimeline;
    private CommonEditor.NewObject newSeg;
    private int segErrors = 0;
    private SpinnerModel segLineModel = new SpinnerNumberModel(1, 1, 10, 1);
    private JSpinner segLineSpinner = new JSpinner(this.segLineModel);
    private JTextField segTextField = new JTextField(30);
    private JTextField segEStartField = new JTextField(10);
    private JTextField segLStartField = new JTextField(10);
    private JTextField segEEndField = new JTextField(10);
    private JTextField segLEndField = new JTextField(10);
    private String segCorrectDate = "Use yyyy-mm-dd, yyyy-mm-dd AD, yyyy-mm-dd BC.";
    private int segOldLine;
    private String segOldName;
    private LocalDate segOldEStartDate;
    private LocalDate segOldLStartDate;
    private LocalDate segOldEEndDate;
    private LocalDate segOldLEndDate;
    private String segOldColorFG;
    private String segOldColorBGOuterStart;
    private String segOldColorBGOuterEnd;
    private String segOldColorBGInner;
    private int segNewLine;
    private String segNewName;
    private LocalDate segNewEStartDate;
    private LocalDate segNewLStartDate;
    private LocalDate segNewEEndDate;
    private LocalDate segNewLEndDate;
    private String segNewColorFG;
    private String segNewColorBGOuterStart;
    private String segNewColorBGOuterEnd;
    private String segNewColorBGInner;
    private String fgTip = "Edit the foreground (text) colour of the segment";
    private String bgOsTip = "Edit the background colour at the outer ends to start the gradient for vague dates";
    private String bgOeTip = "Edit the background colour at the outer ends to end the gradient for vague dates";
    private String bgInnerTip = "Edit the main background colour for the segment";
    private PaletteColorPanel fgPanel;
    private PaletteColorPanel bgOuterStartPanel;
    private PaletteColorPanel bgOuterEndPanel;
    private PaletteColorPanel bgInnerPanel;
    private JTabbedPane colourTabsPane;
    private String sampleTip = "This shows how the segment will look with the current colours and on a monochrome grey scale printer";
    private SamplePanel segSamplePanel;
    private JButton buttonOK = new JButton("OK");
    private JButton buttonApply = new JButton("Apply");
    private JButton buttonCancel = new JButton("Cancel");
    private JButton buttonDelete = new JButton("Delete");
    private LineBorder contentBorder = new LineBorder(Color.lightGray, 3);
    private FocusListener nameListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent f) {
            if (SegmentEditor.this.newSeg.equals((Object)CommonEditor.NewObject.NEW)) {
                SegmentEditor.this.segTextField.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent f) {
        }
    };

    SegmentEditor(CDgui mainGUI, final Segment ourSeg, Event timeline, TimePanel timePanel, CommonEditor.NewObject isNewSeg) {
        this.segEditorFrame = this;
        this.segEditor = this;
        ourSeg.setEditor(this);
        this.ourGUI = mainGUI;
        this.segTimeline = timeline;
        this.segDisplay = timePanel;
        this.newSeg = isNewSeg;
        this.setPreferredSize(new Dimension(570, 500));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ourSeg.setEditor(null);
                SegmentEditor.this.ourGUI.getWindowManager().closeWindow();
            }

            @Override
            public void windowActivated(WindowEvent wa) {
                SegmentEditor.this.fgPanel.updatePaletteTable(SegmentEditor.this.ourGUI.getPreferences().getPalette(), true, SegmentEditor.this.fgPanel.getSelectedColorName());
                SegmentEditor.this.bgOuterStartPanel.updatePaletteTable(SegmentEditor.this.ourGUI.getPreferences().getPalette(), true, SegmentEditor.this.bgOuterStartPanel.getSelectedColorName());
                SegmentEditor.this.bgOuterEndPanel.updatePaletteTable(SegmentEditor.this.ourGUI.getPreferences().getPalette(), true, SegmentEditor.this.bgOuterEndPanel.getSelectedColorName());
                SegmentEditor.this.bgInnerPanel.updatePaletteTable(SegmentEditor.this.ourGUI.getPreferences().getPalette(), true, SegmentEditor.this.bgInnerPanel.getSelectedColorName());
                SegmentEditor.this.segSamplePanel.revalidate();
                SegmentEditor.this.segSamplePanel.repaint();
            }
        });
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.segErrors = 0;
        LineBorder segPanelsBorder = new LineBorder(Color.lightGray, 3);
        FlowLayout flowLayoutRight = new FlowLayout(2);
        FlowLayout flowLayoutLeft = new FlowLayout(0);
        JLabel segLineLabel = new JLabel("Line Number: ", 4);
        JComponent editor = this.segLineSpinner.getEditor();
        JFormattedTextField tf = ((JSpinner.DefaultEditor)editor).getTextField();
        tf.setColumns(2);
        this.segOldLine = ourSeg.getLine();
        this.segLineSpinner.setValue(this.segOldLine);
        this.segOldName = ourSeg.getText();
        this.segTextField.setText(this.segOldName);
        this.segTextField.selectAll();
        this.segTextField.addFocusListener(this.nameListener);
        this.segTextField.setEditable(true);
        JPanel segTextPanel = new JPanel(flowLayoutLeft);
        TitledBorder segPanelTitle = new TitledBorder(segPanelsBorder, "Text", 1, 2);
        segTextPanel.setBorder(segPanelTitle);
        segTextPanel.add(segLineLabel);
        segTextPanel.add(this.segLineSpinner);
        segTextPanel.add(this.segTextField);
        JLabel segEStartLabel = new JLabel("Earliest Start: ", 4);
        JLabel segLStartLabel = new JLabel("Latest Start: ", 4);
        JLabel segEEndLabel = new JLabel("Earliest End: ", 4);
        JLabel segLEndLabel = new JLabel("Latest End: ", 4);
        this.segOldEStartDate = ourSeg.getDates().getEarlyStartDate();
        this.segOldLStartDate = ourSeg.getDates().getLateStartDate();
        this.segOldEEndDate = ourSeg.getDates().getEarlyEndDate();
        this.segOldLEndDate = ourSeg.getDates().getLateEndDate();
        String segOldEStart = "";
        if (this.segOldEStartDate != null) {
            segOldEStart = Utils.dayFormatter.format(this.segOldEStartDate);
        }
        String segOldLStart = "";
        if (this.segOldLStartDate != null) {
            segOldLStart = Utils.dayFormatter.format(this.segOldLStartDate);
        }
        String segOldEEnd = "";
        if (this.segOldEEndDate != null) {
            segOldEEnd = Utils.dayFormatter.format(this.segOldEEndDate);
        }
        String segOldLEnd = "";
        if (this.segOldLEndDate != null) {
            segOldLEnd = Utils.dayFormatter.format(this.segOldLEndDate);
        }
        if (this.segEStartField.getText().isEmpty() && this.newSeg.equals((Object)CommonEditor.NewObject.NEW)) {
            Segment latestSeg = null;
            if (this.segTimeline.getTlSegmentList() != null) {
                latestSeg = this.segTimeline.getTlSegmentList().getLatestSegment();
            }
            segOldEStart = latestSeg == null ? this.ourGUI.getLaterDate(this.segTimeline.getDates().getEarlyStartDate(), this.segTimeline.getDates().getLateStartDate()).toString() : this.ourGUI.getLaterDate(latestSeg.getDates().getEarlyEndDate(), latestSeg.getDates().getLateEndDate()).toString();
        }
        this.segEStartField.setText(segOldEStart);
        this.segLStartField.setText(segOldLStart);
        this.segEEndField.setText(segOldEEnd);
        this.segLEndField.setText(segOldLEnd);
        this.segEStartField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent f) {
            }

            @Override
            public void focusLost(FocusEvent f) {
                String eStart = SegmentEditor.this.segEStartField.getText();
                String eStartYear = SegmentEditor.this.segEStartField.getText();
                if (!eStart.isEmpty() && eStart.length() == 4 && SegmentEditor.this.segLStartField.getText().isEmpty()) {
                    SegmentEditor.this.segEStartField.setText(eStartYear + "-01-01");
                    SegmentEditor.this.segLStartField.setText(eStartYear + "-12-31");
                } else if (!eStart.isEmpty() && eStart.length() == 7 && SegmentEditor.this.segLStartField.getText().isEmpty()) {
                    String mString = SegmentEditor.this.segEStartField.getText().substring(5, 7);
                    eStartYear = SegmentEditor.this.segEStartField.getText().substring(0, 4);
                    int ultimo = 0;
                    try {
                        int y = Integer.parseInt(eStartYear);
                        int m = Integer.parseInt(mString);
                        YearMonth yearMonthObject = YearMonth.of(y, m);
                        ultimo = yearMonthObject.lengthOfMonth();
                    }
                    catch (NumberFormatException | DateTimeException n) {
                        JOptionPane.showMessageDialog(SegmentEditor.this.ourGUI, "Segment Editor: invalid month or year in early start field");
                    }
                    SegmentEditor.this.segEStartField.setText(eStart + "-01");
                    SegmentEditor.this.segLStartField.setText(eStart + "-" + String.valueOf(ultimo));
                }
            }
        });
        this.segEEndField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent f) {
            }

            @Override
            public void focusLost(FocusEvent f) {
                String eEnd = SegmentEditor.this.segEEndField.getText();
                String eEndYear = SegmentEditor.this.segEEndField.getText();
                if (!eEnd.isEmpty() && eEnd.length() == 4 && SegmentEditor.this.segLEndField.getText().isEmpty()) {
                    SegmentEditor.this.segEEndField.setText(eEndYear + "-01-01");
                    SegmentEditor.this.segLEndField.setText(eEndYear + "-12-31");
                } else if (!eEnd.isEmpty() && eEnd.length() == 7 && SegmentEditor.this.segLEndField.getText().isEmpty()) {
                    String mString = SegmentEditor.this.segEEndField.getText().substring(5, 7);
                    eEndYear = SegmentEditor.this.segEEndField.getText().substring(0, 4);
                    int ultimo = 0;
                    try {
                        int y = Integer.parseInt(eEndYear);
                        int m = Integer.parseInt(mString);
                        YearMonth yearMonthObject = YearMonth.of(y, m);
                        ultimo = yearMonthObject.lengthOfMonth();
                    }
                    catch (NumberFormatException | DateTimeException n) {
                        JOptionPane.showMessageDialog(SegmentEditor.this.ourGUI, "Segment Editor: invalid month or year in early end field");
                    }
                    SegmentEditor.this.segEEndField.setText(eEnd + "-01");
                    SegmentEditor.this.segLEndField.setText(eEnd + "-" + String.valueOf(ultimo));
                }
            }
        });
        JPanel segEStartPanel = new JPanel(flowLayoutRight);
        segEStartPanel.add(segEStartLabel);
        segEStartPanel.add(this.segEStartField);
        JPanel segLStartPanel = new JPanel(flowLayoutRight);
        segLStartPanel.add(segLStartLabel);
        segLStartPanel.add(this.segLStartField);
        JPanel segEEndPanel = new JPanel(flowLayoutRight);
        segEEndPanel.add(segEEndLabel);
        segEEndPanel.add(this.segEEndField);
        JPanel segLEndPanel = new JPanel(flowLayoutRight);
        segLEndPanel.add(segLEndLabel);
        segLEndPanel.add(this.segLEndField);
        JPanel segDatesPanel = new JPanel();
        segDatesPanel.setLayout(new GridLayout(0, 2));
        TitledBorder segDatesTitle = new TitledBorder(segPanelsBorder, "Dates", 1, 2);
        segDatesPanel.setBorder(segDatesTitle);
        segDatesPanel.add(segEStartPanel);
        segDatesPanel.add(segLStartPanel);
        segDatesPanel.add(segEEndPanel);
        segDatesPanel.add(segLEndPanel);
        this.colourTabsPane = new JTabbedPane();
        this.segOldColorFG = ourSeg.getColorFG();
        this.segOldColorBGOuterStart = ourSeg.getColorOuterStart();
        this.segOldColorBGOuterEnd = ourSeg.getColorOuterEnd();
        this.segOldColorBGInner = ourSeg.getColorInner();
        this.segNewColorFG = this.segOldColorFG;
        this.segNewColorBGOuterStart = this.segOldColorBGOuterStart;
        this.segNewColorBGOuterEnd = this.segOldColorBGOuterEnd;
        this.segNewColorBGInner = this.segOldColorBGInner;
        this.fgPanel = new PaletteColorPanel(this.ourGUI.getPreferences().getPalette(), this.segOldColorFG);
        TitledBorder fgTitle = new TitledBorder(this.contentBorder, "Foreground Colour", 1, 2);
        this.fgPanel.setBorder(fgTitle);
        this.bgOuterStartPanel = new PaletteColorPanel(this.ourGUI.getPreferences().getPalette(), this.segOldColorBGOuterStart);
        TitledBorder bgosTitle = new TitledBorder(this.contentBorder, "Background Outer Start Colour", 1, 2);
        this.fgPanel.setBorder(bgosTitle);
        this.bgOuterEndPanel = new PaletteColorPanel(this.ourGUI.getPreferences().getPalette(), this.segOldColorBGOuterEnd);
        TitledBorder bgoeTitle = new TitledBorder(this.contentBorder, "Background Outer End Colour", 1, 2);
        this.fgPanel.setBorder(bgoeTitle);
        this.bgInnerPanel = new PaletteColorPanel(this.ourGUI.getPreferences().getPalette(), this.segOldColorBGInner);
        TitledBorder bgiTitle = new TitledBorder(this.contentBorder, "Inner Background Colour", 1, 2);
        this.fgPanel.setBorder(bgiTitle);
        this.colourTabsPane.addTab("Foreground", null, this.fgPanel, this.fgTip);
        this.colourTabsPane.addTab("Outer Background Start", null, this.bgOuterStartPanel, this.bgOsTip);
        this.colourTabsPane.addTab("Outer Background End", null, this.bgOuterEndPanel, this.bgOeTip);
        this.colourTabsPane.addTab("Inner Background", null, this.bgInnerPanel, this.bgInnerTip);
        this.segSamplePanel = new SamplePanel();
        TitledBorder sampleTitle = new TitledBorder(this.contentBorder, "Colour Samples", 1, 2);
        this.segSamplePanel.setBorder(sampleTitle);
        this.segSamplePanel.setPreferredSize(new Dimension(this.segEditorFrame.getWidth(), 80));
        this.segSamplePanel.setToolTipText(this.sampleTip);
        this.buttonOK.setToolTipText("Apply the edits and close the window");
        this.buttonOK.setPreferredSize(new Dimension(100, 20));
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegmentEditor.this.OkApply(ourSeg);
                if (SegmentEditor.this.segErrors == 0) {
                    if (SegmentEditor.this.newSeg.equals((Object)CommonEditor.NewObject.NEW)) {
                        if (SegmentEditor.this.segTimeline.getTlSegmentList() == null) {
                            SegmentList newSegmentList = new SegmentList(SegmentEditor.this.segTimeline);
                            SegmentEditor.this.segTimeline.setTlSegmentList(newSegmentList);
                        }
                        SegmentEditor.this.segTimeline.getTlSegmentList().addSegment(ourSeg);
                        ourSeg.setEditor(SegmentEditor.this.segEditor);
                        SegmentEditor.this.newSeg = CommonEditor.NewObject.EXISTING;
                    }
                    SegmentEditor.this.ourGUI.setRange();
                    SegmentEditor.this.ourGUI.panLimits();
                    SegmentEditor.this.segDisplay.repaint();
                    SegmentEditor.this.segEditorFrame.dispose();
                    ourSeg.setEditor(null);
                    SegmentEditor.this.ourGUI.getWindowManager().closeWindow();
                    SegmentEditor.this.ourGUI.setFileSaved(false);
                }
            }
        });
        this.buttonApply.setToolTipText("Apply edits and keep window open");
        this.buttonApply.setPreferredSize(new Dimension(100, 20));
        this.buttonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegmentEditor.this.OkApply(ourSeg);
                if (SegmentEditor.this.segErrors == 0) {
                    if (SegmentEditor.this.newSeg.equals((Object)CommonEditor.NewObject.NEW)) {
                        if (SegmentEditor.this.segTimeline.getTlSegmentList() == null) {
                            SegmentList newSegmentList = new SegmentList(SegmentEditor.this.segTimeline);
                            SegmentEditor.this.segTimeline.setTlSegmentList(newSegmentList);
                        }
                        SegmentEditor.this.segTimeline.getTlSegmentList().addSegment(ourSeg);
                        ourSeg.setEditor(SegmentEditor.this.segEditor);
                        SegmentEditor.this.newSeg = CommonEditor.NewObject.EXISTING;
                        SegmentEditor.this.buttonDelete.setEnabled(true);
                    }
                    SegmentEditor.this.segEditor.setTitle("Segment Editor: " + SegmentEditor.this.segNewName + " on " + SegmentEditor.this.segTimeline.getName());
                    SegmentEditor.this.ourGUI.setRange();
                    SegmentEditor.this.ourGUI.panLimits();
                    SegmentEditor.this.segDisplay.repaint();
                    SegmentEditor.this.ourGUI.setFileSaved(false);
                }
            }
        });
        this.buttonCancel.setToolTipText("Cancel the edits");
        this.buttonCancel.setPreferredSize(new Dimension(100, 20));
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegmentEditor.this.segEditorFrame.dispose();
                ourSeg.setEditor(null);
                SegmentEditor.this.ourGUI.getWindowManager().closeWindow();
                SegmentEditor.this.segSamplePanel.repaint();
            }
        });
        this.buttonDelete.setToolTipText("Delete this Segment");
        this.buttonDelete.setPreferredSize(new Dimension(100, 20));
        if (this.newSeg.equals((Object)CommonEditor.NewObject.NEW)) {
            this.buttonDelete.setEnabled(false);
        }
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent del) {
                SegmentEditor.this.segTimeline.getTlSegmentList().deleteSegment(ourSeg);
                SegmentEditor.this.segEditorFrame.dispose();
                ourSeg.setEditor(null);
                SegmentEditor.this.ourGUI.getWindowManager().closeWindow();
                SegmentEditor.this.segDisplay.repaint();
            }
        });
        JPanel okPanel = new JPanel();
        okPanel.add(this.buttonOK);
        okPanel.add(this.buttonCancel);
        okPanel.add(this.buttonDelete);
        okPanel.add(this.buttonApply);
        Box partsPanel = Box.createVerticalBox();
        partsPanel.add(segTextPanel);
        partsPanel.add(segDatesPanel);
        partsPanel.add(this.colourTabsPane);
        partsPanel.add(this.segSamplePanel);
        JPanel allPane = new JPanel();
        allPane.setLayout(new BorderLayout());
        JScrollPane allScroll = new JScrollPane(allPane);
        allPane.add((Component)partsPanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)allScroll, "Center");
        this.add((Component)okPanel, "Last");
        this.setTitle("Segment Editor: " + this.segOldName + " on " + this.segTimeline.getName());
        this.pack();
        this.setVisible(true);
    }

    private void OkApply(Segment ourSeg) {
        this.segErrors = 0;
        this.segSamplePanel.repaint();
        this.segNewLine = (Integer)this.segLineSpinner.getValue();
        if (this.segTextField.getText().equals("")) {
            JOptionPane.showMessageDialog(this.segEditorFrame, " Segment Editor: Segment name cannot be blank");
            ++this.segErrors;
        } else if (this.segTextField.getText().contains(";")) {
            JOptionPane.showMessageDialog(this.segEditorFrame, " Segment Editor: Segment name cannot contain semicolon");
            ++this.segErrors;
        } else {
            this.segNewName = this.segTextField.getText();
        }
        this.segNewEStartDate = this.segOldEStartDate;
        if (this.segEStartField.getText().equals("")) {
            JOptionPane.showMessageDialog(this.segEditorFrame, "Segment Editor: imeline earliest start date cannot be blank");
            ++this.segErrors;
        } else {
            try {
                this.segNewEStartDate = LocalDate.parse(this.segEStartField.getText(), Utils.dayFormatter);
            }
            catch (DateTimeParseException f) {
                this.segNewEStartDate = null;
            }
            if (this.segNewEStartDate == null) {
                JOptionPane.showMessageDialog(this.segEditorFrame, "Segment Editor: Invalid segment earliest start date\n" + this.segCorrectDate);
                ++this.segErrors;
                this.segNewEStartDate = this.segOldEStartDate;
            }
        }
        this.segNewLStartDate = null;
        if (!this.segLStartField.getText().equals("")) {
            try {
                this.segNewLStartDate = LocalDate.parse(this.segLStartField.getText(), Utils.dayFormatter);
            }
            catch (DateTimeParseException f) {
                this.segNewLStartDate = null;
            }
            if (this.segNewLStartDate == null) {
                JOptionPane.showMessageDialog(this.segEditorFrame, "Segment Editor: Invalid segment latest start date\n" + this.segCorrectDate);
                ++this.segErrors;
            }
        }
        this.segNewEEndDate = this.segOldEEndDate;
        if (this.segEEndField.getText().equals("")) {
            JOptionPane.showMessageDialog(this.segEditorFrame, "Segment Editor: Segment earliest end date cannot be blank");
            ++this.segErrors;
        } else {
            try {
                this.segNewEEndDate = LocalDate.parse(this.segEEndField.getText(), Utils.dayFormatter);
            }
            catch (DateTimeParseException f) {
                this.segNewEEndDate = null;
            }
            if (this.segNewEEndDate == null) {
                JOptionPane.showMessageDialog(this.segEditorFrame, "Segment Editor: Invalid segment earliest end date\n" + this.segCorrectDate);
                ++this.segErrors;
                this.segNewEEndDate = this.segOldEEndDate;
            }
        }
        this.segNewLEndDate = null;
        if (!this.segLEndField.getText().equals("")) {
            try {
                this.segNewLEndDate = LocalDate.parse(this.segLEndField.getText(), Utils.dayFormatter);
            }
            catch (DateTimeParseException f) {
                this.segNewLEndDate = null;
            }
            if (this.segNewLEndDate == null) {
                JOptionPane.showMessageDialog(this.segEditorFrame, "Segment Editor: Invalid segment latest end date");
                ++this.segErrors;
            }
        }
        if (this.segNewLStartDate != null && this.segNewEStartDate != null && this.segNewLStartDate.isBefore(this.segNewEStartDate)) {
            JOptionPane.showMessageDialog(this.segEditorFrame, "Segment Editor: Latest start date cannot be before earliest start date");
            ++this.segErrors;
            this.segNewEStartDate = this.segOldEStartDate;
            this.segNewLStartDate = this.segOldLStartDate;
        }
        if (this.segNewLEndDate != null && this.segNewEEndDate != null && this.segNewLEndDate.isBefore(this.segNewEEndDate)) {
            JOptionPane.showMessageDialog(this.segEditorFrame, "Segment Editor: Latest end date cannot be before earliest end date\n" + this.segCorrectDate);
            ++this.segErrors;
            this.segNewEEndDate = this.segOldEEndDate;
        }
        LocalDate tmpStart = this.segNewEStartDate;
        if (this.segNewLStartDate != null) {
            tmpStart = this.segNewLStartDate;
        }
        LocalDate tmpEnd = this.segNewEEndDate;
        if (this.segNewLEndDate != null) {
            tmpEnd = this.segNewLEndDate;
        }
        if (tmpStart != null && tmpEnd != null && tmpEnd.isBefore(tmpStart)) {
            JOptionPane.showMessageDialog(this.segEditorFrame, "Segment Editor: End dates cannot be before start dates");
            ++this.segErrors;
            this.segNewEEndDate = this.segOldEEndDate;
        }
        this.segNewColorFG = this.fgPanel.getSelectedPaletteColor().getName();
        this.segNewColorBGOuterStart = this.bgOuterStartPanel.getSelectedPaletteColor().getName();
        this.segNewColorBGOuterEnd = this.bgOuterEndPanel.getSelectedPaletteColor().getName();
        this.segNewColorBGInner = this.bgInnerPanel.getSelectedPaletteColor().getName();
        try {
            if (this.segErrors == 0) {
                ourSeg.setLine(this.segNewLine);
                ourSeg.setText(this.segNewName);
                ourSeg.setDates(new Dates(this.segNewEStartDate, this.segNewLStartDate, this.segNewEEndDate, this.segNewLEndDate));
                ourSeg.setColorFG(this.segNewColorFG);
                ourSeg.setColorOuterStart(this.segNewColorBGOuterStart);
                ourSeg.setColorOuterEnd(this.segNewColorBGOuterEnd);
                ourSeg.setColorInner(this.segNewColorBGInner);
            }
        }
        catch (Throwable unforeseen) {
            JOptionPane.showMessageDialog(this.ourGUI, "Segment Editor: Unhandled Error!\n" + this.ourGUI.displayError(unforeseen));
        }
    }

    private void drawSample(Graphics2D g2d, int startX, int startY, Color fg, Color bgos, Color bgoe, Color bgin) {
        int width = 150;
        int height = 20;
        int innerEnd = startX + width + width;
        Point2D.Float gradStart = new Point2D.Float(startX, startY);
        Point2D.Float gradEnd = new Point2D.Float(startX + width, startY + height);
        float[] gradDistance = new float[]{0.0f, 1.0f};
        Color[] gradStartColors = new Color[]{bgos, bgoe};
        LinearGradientPaint greydient = new LinearGradientPaint(gradStart, gradEnd, gradDistance, gradStartColors);
        g2d.setPaint(greydient);
        g2d.fill(new Rectangle2D.Double(startX, startY, width, height));
        g2d.setColor(bgin);
        g2d.fill(new Rectangle2D.Double(startX + width, startY, width, height));
        gradStart = new Point2D.Float(innerEnd, startY);
        gradEnd = new Point2D.Float(innerEnd + width, startY + height);
        float[] gradLateDistance = new float[]{0.0f, 1.0f};
        Color[] gradEndColors = new Color[]{bgoe, bgos};
        LinearGradientPaint greydientNeg = new LinearGradientPaint(gradStart, gradEnd, gradLateDistance, gradEndColors);
        g2d.setPaint(greydientNeg);
        g2d.fill(new Rectangle2D.Double(innerEnd, startY, width, height));
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(fg);
        Utils.setGraphicsFont(g2d, this.ourGUI.getPreferences().getTlSegmentFont());
        int SegHeight = (int)this.ourGUI.getPreferences().getTlSegmentFont().getMaxCharBounds(this.ourGUI.getTimePanel().getGraphicsContext().getFontRenderContext()).getHeight();
        int segNameX = startX + width;
        int segNameY = startY + SegHeight;
        g2d.drawString("Sample Name", segNameX, segNameY);
    }

    private class SamplePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private SamplePanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Color fg = SegmentEditor.this.ourGUI.getPreferences().getPalette().getColorByName(SegmentEditor.this.segNewColorFG);
            Color bgOS = SegmentEditor.this.ourGUI.getPreferences().getPalette().getColorByName(SegmentEditor.this.segNewColorBGOuterStart);
            Color bgOE = SegmentEditor.this.ourGUI.getPreferences().getPalette().getColorByName(SegmentEditor.this.segNewColorBGOuterEnd);
            Color bgIn = SegmentEditor.this.ourGUI.getPreferences().getPalette().getColorByName(SegmentEditor.this.segNewColorBGInner);
            SegmentEditor.this.drawSample(g2d, 10, 20, fg, bgOS, bgOE, bgIn);
            SegmentEditor.this.drawSample(g2d, 10, 45, Utils.colorToGrey(fg), Utils.colorToGrey(bgOS), Utils.colorToGrey(bgOE), Utils.colorToGrey(bgIn));
        }
    }
}

