/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.Dates;
import culturalDynamics.Event;
import culturalDynamics.Preferences;
import culturalDynamics.SegmentEditor;
import culturalDynamics.Utils;
import java.awt.geom.Rectangle2D;
import org.json.JSONWriter;

class Segment {
    private Event timeline;
    private String text;
    private String colorFG;
    private String colorOuterStart;
    private String colorOuterEnd;
    private String colorInner;
    private Dates dates;
    private int line;
    private Rectangle2D nameBounds;
    private SegmentEditor editor;

    Segment(Preferences prefs, Event tl, String tx, String cfg, String cbgos, String cbgoe, String cbgi, Dates datesIn, int line) {
        this.timeline = tl;
        this.text = tx;
        this.colorFG = cfg == null || cfg.equals("") ? prefs.defaultSegFG : cfg;
        this.colorOuterStart = cbgos == null || cbgos.equals("") ? prefs.defaultSegBGouterStart : cbgos;
        this.colorOuterEnd = cbgoe == null || cbgoe.equals("") ? prefs.defaultSegBGouterEnd : cbgoe;
        this.colorInner = cbgi == null || cbgi.equals("") ? prefs.defaultBGinner : cbgi;
        this.dates = datesIn;
        this.line = line;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getColorFG() {
        return this.colorFG;
    }

    public void setColorFG(String color) {
        this.colorFG = color;
    }

    public String getColorOuterStart() {
        return this.colorOuterStart;
    }

    public void setColorOuterStart(String colorOuterStart) {
        this.colorOuterStart = colorOuterStart;
    }

    public String getColorOuterEnd() {
        return this.colorOuterEnd;
    }

    public void setColorOuterEnd(String colorOuterEnd) {
        this.colorOuterEnd = colorOuterEnd;
    }

    public String getColorInner() {
        return this.colorInner;
    }

    public void setColorInner(String colorInner) {
        this.colorInner = colorInner;
    }

    public void setDates(Dates newDates) {
        this.dates = newDates;
    }

    public Dates getDates() {
        return this.dates;
    }

    public void setLine(int l) {
        this.line = l;
    }

    public int getLine() {
        return this.line;
    }

    public Rectangle2D getNameBounds() {
        return this.nameBounds;
    }

    public void setNameBounds(Rectangle2D nameBounds) {
        this.nameBounds = nameBounds;
    }

    public boolean isClickedSegment(double mouseX, double mouseY) {
        return this.nameBounds != null && this.nameBounds.contains(mouseX, mouseY);
    }

    public Event getTimeline() {
        return this.timeline;
    }

    public SegmentEditor getEditor() {
        return this.editor;
    }

    public void setEditor(SegmentEditor editor) {
        this.editor = editor;
    }

    public void toJSON(JSONWriter writer, CDgui mainGUI) {
        writer.object().key("timeline").value(this.getTimeline().getName()).key("text").value(this.getText()).key("colour").value(this.getColorFG()).key("colourBGouterStart").value(this.getColorOuterStart()).key("colourBGouterEnd").value(this.getColorOuterEnd()).key("colourBGinner").value(this.getColorInner());
        writer.key("earliestStartDate").value(Utils.dayFormatterOut.format(this.getDates().getEarlyStartDate()));
        if (this.getDates().getLateStartDate() != null) {
            writer.key("latestStartDate").value(Utils.dayFormatterOut.format(this.getDates().getLateStartDate()));
        }
        if (this.getDates().getEarlyEndDate() != null) {
            writer.key("earliestEndDate").value(Utils.dayFormatterOut.format(this.getDates().getEarlyEndDate()));
        }
        if (this.getDates().getLateEndDate() != null) {
            writer.key("latestEndDate").value(Utils.dayFormatterOut.format(this.getDates().getLateEndDate()));
        }
        writer.key("line").value(this.getLine()).endObject();
    }
}

