/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.PaletteColor;
import culturalDynamics.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

class Palette {
    private List<PaletteColor> paletteColors = new ArrayList<PaletteColor>();

    public boolean paletteColorExists(String name) {
        int i = 0;
        while (i < this.paletteColors.size()) {
            if (this.paletteColors.get(i).getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public PaletteColor getPaletteColorByName(String n) {
        int i = 0;
        while (i < this.paletteColors.size()) {
            if (this.paletteColors.get(i).getName().equals(n)) {
                return this.paletteColors.get(i);
            }
            ++i;
        }
        return this.paletteColors.get(0);
    }

    public Color getColorByName(String n) {
        for (PaletteColor color : this.paletteColors) {
            if (!color.getName().equals(n)) continue;
            return color.getColor();
        }
        return this.paletteColors.get(0).getColor();
    }

    public void addColorToPalette(PaletteColor c) {
        this.paletteColors.add(c);
    }

    public void deleteColorByIndex(int i) {
        this.paletteColors.remove(i);
    }

    public void replaceColorInPalette(PaletteColor c, int i) {
        this.paletteColors.set(i, c);
    }

    public Palette copyPalette() {
        Palette newPalette = new Palette();
        int i = 0;
        while (i < this.paletteColors.size()) {
            newPalette.addColorToPalette(this.paletteColors.get(i));
            ++i;
        }
        return newPalette;
    }

    public int getSize() {
        return this.paletteColors.size();
    }

    public Color getColor(int i) {
        return this.paletteColors.get(i).getColor();
    }

    public String getColorName(int i) {
        return this.paletteColors.get(i).getName();
    }

    public String getColorHex(int i) {
        return Utils.stringFromColor(this.paletteColors.get(i).getColor());
    }

    public void sortPalette() {
        if (this.paletteColors != null && this.paletteColors.size() != 0) {
            this.paletteColors.sort(new NameSorter());
        }
    }

    private class NameSorter
    implements Comparator<PaletteColor> {
        private NameSorter() {
        }

        @Override
        public int compare(PaletteColor o1, PaletteColor o2) {
            int tmp = o1.getName().compareToIgnoreCase(o2.getName());
            return tmp;
        }
    }
}

