/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.ConnectionData;
import culturalDynamics.EventData;
import culturalDynamics.Filter;
import culturalDynamics.SavedFilterData;
import culturalDynamics.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import org.json.JSONWriter;

class OutputFile {
    private static BufferedWriter jsonBuffer = null;

    public boolean OpenFileForWrite(File jsonFile, CDgui mainGUI) {
        try {
            FileWriter jsonWriter = new FileWriter(jsonFile);
            jsonBuffer = new BufferedWriter(jsonWriter);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(mainGUI, "Output File: IO Exception opening file for write");
            return false;
        }
        return true;
    }

    public static boolean CreateOutFile(File outFile, CDgui mainGUI) {
        try {
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            FileWriter jsonWriter = new FileWriter(outFile);
            jsonBuffer = new BufferedWriter(jsonWriter);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(mainGUI, "Output File: IO Exception creating output file");
            return false;
        }
        return true;
    }

    public boolean writeJSONdata(EventData eventDataIn, ConnectionData connectionDataIn, CDgui mainGUI) {
        JSONWriter cdJSONWriter = new JSONWriter(jsonBuffer);
        cdJSONWriter.object().key("CDdata");
        cdJSONWriter.object();
        cdJSONWriter.key("programVersion").object().key("version").value(mainGUI.getProgramMajorVersion()).key("timestamp").value(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + " with " + mainGUI.getProgramName() + " version " + mainGUI.getProgramVersion());
        cdJSONWriter.endObject();
        if (mainGUI.getPreferences().getSavePrefsChoice()) {
            mainGUI.getPreferences().toJSON(cdJSONWriter);
        }
        cdJSONWriter.key("intro").object().key("introduction").value(Utils.encodeEscapes(mainGUI.getIntroText())).key("techDetails").value(Utils.encodeEscapes(mainGUI.getTechText()));
        cdJSONWriter.endObject();
        eventDataIn.writeEventsToJSON(cdJSONWriter, mainGUI);
        connectionDataIn.toJSON(cdJSONWriter, mainGUI);
        mainGUI.getRowData().toJSON(cdJSONWriter);
        SavedFilterData ourFilters = mainGUI.getSavedFilterData();
        if (ourFilters != null && ourFilters.getNumFilters() > 0) {
            cdJSONWriter.key("filters").array();
            int i = 0;
            while (i < ourFilters.getNumFilters()) {
                Filter tmpFilter = ourFilters.getSavedFilterByIndex(i);
                tmpFilter.toJSON(cdJSONWriter);
                ++i;
            }
            cdJSONWriter.endArray();
        }
        mainGUI.getHTMLDialog().toJSON(cdJSONWriter);
        cdJSONWriter.endObject();
        cdJSONWriter.endObject();
        try {
            jsonBuffer.flush();
            jsonBuffer.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(mainGUI, "Output File: IO Exception closing JSON file");
            return false;
        }
        JOptionPane.showMessageDialog(mainGUI, "Output File: Data written to file");
        mainGUI.setFileSaved(true);
        return true;
    }
}

