/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

class IntroEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String oldIntro = "";
    private String oldTech = "";
    private JFrame introEditorFrame;
    private CDgui ourGUI;
    private JTextArea introField = new JTextArea(10, 50);
    private JTextArea techField = new JTextArea(10, 50);

    IntroEditor(CDgui mainGUI) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                IntroEditor.this.introEditorFrame.dispose();
                IntroEditor.this.ourGUI.getWindowManager().closeWindow();
                IntroEditor.this.ourGUI.closeIntroEditor();
            }

            @Override
            public void windowActivated(WindowEvent wa) {
            }
        });
        this.introEditorFrame = this;
        this.ourGUI = mainGUI;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        LineBorder introPanelsBorder = new LineBorder(Color.lightGray, 3);
        JPanel introPanel = new JPanel();
        introPanel.setLayout(new BorderLayout());
        TitledBorder introTitle = new TitledBorder(introPanelsBorder, "Introduction", 1, 2);
        introPanel.setBorder(introTitle);
        JScrollPane introScroll = new JScrollPane();
        introScroll.setViewportView(this.introField);
        this.introField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    IntroEditor.this.introField.setRows(IntroEditor.this.introField.getRows() + 1);
                }
            }
        });
        this.introField.setToolTipText("Introductory text for this file - optionally included in Summary Report");
        this.introField.setLineWrap(false);
        this.introField.setWrapStyleWord(true);
        this.oldIntro = Utils.decodeEscapes(this.ourGUI.getIntroText());
        if (this.oldIntro.isEmpty() || this.oldIntro == "") {
            this.introField.setText("");
        } else {
            String[] lines = this.oldIntro.split(System.lineSeparator());
            int i = 0;
            while (i < lines.length) {
                if (i < lines.length - 1) {
                    this.introField.append(lines[i] + "\n");
                } else {
                    this.introField.append(lines[i]);
                }
                ++i;
            }
            if (lines.length > 10) {
                this.introField.setRows(lines.length);
            }
        }
        introPanel.add((Component)introScroll, "Center");
        this.introField.setCaretPosition(0);
        JPanel techPanel = new JPanel();
        techPanel.setLayout(new BorderLayout());
        TitledBorder techTitle = new TitledBorder(introPanelsBorder, "Technical Details", 1, 2);
        techPanel.setBorder(techTitle);
        JScrollPane techScroll = new JScrollPane();
        techScroll.setViewportView(this.techField);
        this.techField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    IntroEditor.this.techField.setRows(IntroEditor.this.techField.getRows() + 1);
                }
            }
        });
        this.techField.setToolTipText("Technical details for this file");
        this.techField.setLineWrap(false);
        this.techField.setWrapStyleWord(true);
        this.oldTech = Utils.decodeEscapes(this.ourGUI.getTechText());
        if (this.oldTech.isEmpty() || this.oldTech == "") {
            this.techField.setText("");
        } else {
            String[] lines = this.oldTech.split(System.lineSeparator());
            int i = 0;
            while (i < lines.length) {
                if (i < lines.length - 1) {
                    this.techField.append(lines[i] + "\n");
                } else {
                    this.techField.append(lines[i]);
                }
                ++i;
            }
            if (lines.length > 10) {
                this.techField.setRows(lines.length);
            }
        }
        techPanel.add((Component)techScroll, "Center");
        this.techField.setCaretPosition(0);
        JButton buttonOK = new JButton("OK");
        JButton buttonCancel = new JButton("Cancel");
        JButton buttonApply = new JButton("Apply");
        JButton buttonWrap = new JButton("Wrap text");
        buttonOK.setToolTipText("Apply the edits and close the window");
        buttonOK.setPreferredSize(new Dimension(100, 20));
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntroEditor.this.ourGUI.setIntroText(Utils.encodeEscapes(IntroEditor.this.introField.getText()));
                IntroEditor.this.ourGUI.setTechText(Utils.encodeEscapes(IntroEditor.this.techField.getText()));
                IntroEditor.this.ourGUI.setFileSaved(false);
                IntroEditor.this.introEditorFrame.dispose();
                IntroEditor.this.ourGUI.closeIntroEditor();
            }
        });
        buttonApply.setToolTipText("Apply the edits and keep the window open");
        buttonApply.setPreferredSize(new Dimension(100, 20));
        buttonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntroEditor.this.ourGUI.setIntroText(Utils.encodeEscapes(IntroEditor.this.introField.getText()));
                IntroEditor.this.ourGUI.setTechText(Utils.encodeEscapes(IntroEditor.this.techField.getText()));
                IntroEditor.this.ourGUI.setFileSaved(false);
            }
        });
        buttonCancel.setToolTipText("Cancel the edits");
        buttonCancel.setPreferredSize(new Dimension(100, 20));
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntroEditor.this.introEditorFrame.dispose();
                IntroEditor.this.ourGUI.getWindowManager().closeWindow();
                IntroEditor.this.ourGUI.closeIntroEditor();
            }
        });
        buttonWrap.setToolTipText("Toggle wrapping of the lines");
        buttonWrap.setPreferredSize(new Dimension(100, 20));
        buttonWrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntroEditor.this.introField.setLineWrap(!IntroEditor.this.introField.getLineWrap());
                IntroEditor.this.techField.setLineWrap(!IntroEditor.this.techField.getLineWrap());
            }
        });
        JPanel okPanel = new JPanel();
        okPanel.add(buttonOK);
        okPanel.add(buttonCancel);
        okPanel.add(buttonApply);
        okPanel.add(buttonWrap);
        this.add(introPanel);
        this.add(techPanel);
        this.add((Component)okPanel, "South");
        this.setTitle("Introduction Editor");
        this.toFront();
        this.pack();
    }
}

