/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.CommonData;
import culturalDynamics.Connection;
import culturalDynamics.ConnectionData;
import culturalDynamics.Event;
import culturalDynamics.EventData;
import culturalDynamics.Segment;
import culturalDynamics.SegmentList;
import culturalDynamics.TimePanel;
import culturalDynamics.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

class Find
extends JFrame {
    private static final long serialVersionUID = 1L;
    private CDgui ourGUI;
    private JFrame findFrame;
    private LineBorder contentBorder = new LineBorder(Color.lightGray, 3);
    private FlowLayout flowLayoutLeft = new FlowLayout(0);
    private FlowLayout flowLayoutCenter = new FlowLayout(1);
    private JLabel findLabel = new JLabel("Find:");
    private JTextField findField = new JTextField(20);
    private JButton searchButton = new JButton("Search");
    private JRadioButton findSimple = new JRadioButton("Simple");
    private JRadioButton findRegEx = new JRadioButton("Regular Expression");
    private ButtonGroup findButtonGroup = new ButtonGroup();
    private JCheckBox caseBox = new JCheckBox("Case sensitive");
    private JCheckBox umlautBox = new JCheckBox("Umlauts");
    private JLabel whereLabel = new JLabel("Search in:");
    private JCheckBox whereNameBox = new JCheckBox("Name");
    private JCheckBox whereTagsBox = new JCheckBox("Tags");
    private JCheckBox whereDescBox = new JCheckBox("Description");
    private JCheckBox whereColorBox = new JCheckBox("Color");
    private JCheckBox whereCnSrcBox = new JCheckBox("Source");
    private JCheckBox whereCnDstBox = new JCheckBox("Destination");
    private JCheckBox openEditorBox = new JCheckBox("Open Editor");
    private JLabel connectionsLabel = new JLabel("Connections:");
    private JRadioButton cnSrcButton = new JRadioButton("Source");
    private JRadioButton cnDstButton = new JRadioButton("Destination");
    private JLabel cnOpenAtLabel = new JLabel("Open at:");
    private ButtonGroup cnButtonGroup = new ButtonGroup();
    private JLabel resultLabel = new JLabel("Results");
    private JLabel noResultLabel = new JLabel("None found");
    private ArrayList<Found> foundList = new ArrayList();
    private int sortColumn = 0;
    private DefaultTableModel foundTableModel = null;
    private JTable foundTable = null;
    private JScrollPane foundScroll;
    private boolean found;
    private String foundIn;
    private String tableTip = "<html>The columns show the type of the item, its name and in which attributes the search string was found.<br>The codes for the Found in column are: <ul>N = Name, <li>D = Description, <li>T = Tags, <li>C = Colour, <li>Cs = Connection Source, <li>Cd = Connection Destination, <li>I = Introduction, <li>Te = Technical Introduction</ul>Entries which are filtered out are in italics. Double-click or the Go there button will only open the editor if that checkbox is checked.</html>";
    private JButton goButton = new JButton("Go there");
    private JButton closeButton = new JButton("Close");

    public Find(final CDgui mainGUI) {
        this.ourGUI = mainGUI;
        this.findFrame = this;
        this.setPreferredSize(new Dimension(530, 400));
        this.setTitle("Find");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                Find.this.findFrame.setVisible(false);
            }

            @Override
            public void windowActivated(WindowEvent wa) {
                Find.this.searchAction(Find.this.sortColumn);
                Find.this.findField.requestFocusInWindow();
                Find.this.findField.selectAll();
            }
        });
        this.findLabel.setToolTipText("Enter string or regular expression to search for");
        this.findField.setToolTipText(this.findLabel.getToolTipText());
        this.findSimple.setToolTipText("Simple search");
        this.findRegEx.setToolTipText("Search using Regular Expression");
        this.caseBox.setToolTipText("Differentiate between upper and lower case letters");
        this.umlautBox.setToolTipText("Also find transliterations of German umlauts \u00e4 as ae etc.");
        this.whereNameBox.setToolTipText("Search in names of items");
        this.whereTagsBox.setToolTipText("Search in tags of items");
        this.whereDescBox.setToolTipText("Search in descriptions of items");
        this.whereColorBox.setToolTipText("Search in colors");
        this.whereCnSrcBox.setToolTipText("Search in connection source event name");
        this.whereCnDstBox.setToolTipText("Search in connection destination event name");
        this.searchButton.setToolTipText("Start the search");
        this.openEditorBox.setToolTipText("Open the item's editor when going to the item");
        this.cnSrcButton.setToolTipText("Go to the connection's source");
        this.cnDstButton.setToolTipText("Go to the connection's destination");
        this.goButton.setToolTipText("Go to the selected item and open its editor if desired (checkbox).");
        this.closeButton.setToolTipText("Close the find window");
        this.searchButton.setPreferredSize(new Dimension(100, 20));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent search) {
                Find.this.searchAction(Find.this.sortColumn);
            }
        });
        this.findField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Find.this.searchAction(Find.this.sortColumn);
            }
        });
        JPanel findPanel = new JPanel(this.flowLayoutLeft);
        findPanel.add(this.findLabel);
        findPanel.add(this.findField);
        findPanel.add(this.searchButton);
        this.findButtonGroup.add(this.findSimple);
        this.findButtonGroup.add(this.findRegEx);
        this.findSimple.setSelected(true);
        this.umlautBox.setSelected(true);
        JPanel regExPanel = new JPanel(this.flowLayoutLeft);
        regExPanel.add(this.findSimple);
        regExPanel.add(this.findRegEx);
        regExPanel.add(this.caseBox);
        regExPanel.add(this.umlautBox);
        JPanel wherePanel = new JPanel(this.flowLayoutLeft);
        this.whereNameBox.setSelected(true);
        wherePanel.add(this.whereLabel);
        wherePanel.add(this.whereNameBox);
        wherePanel.add(this.whereTagsBox);
        wherePanel.add(this.whereDescBox);
        wherePanel.add(this.whereColorBox);
        Box paramsPanel = Box.createVerticalBox();
        paramsPanel.add(wherePanel);
        this.cnButtonGroup.add(this.cnSrcButton);
        this.cnButtonGroup.add(this.cnDstButton);
        this.cnSrcButton.setSelected(true);
        JPanel connectionPanel = new JPanel(this.flowLayoutLeft);
        connectionPanel.add(this.connectionsLabel);
        connectionPanel.add(this.whereCnSrcBox);
        connectionPanel.add(this.whereCnDstBox);
        connectionPanel.add(this.cnOpenAtLabel);
        connectionPanel.add(this.cnSrcButton);
        connectionPanel.add(new JLabel());
        connectionPanel.add(this.cnDstButton);
        JPanel nothingPanel = new JPanel();
        this.noResultLabel.setForeground(Color.RED);
        this.noResultLabel.setFont(new Font(this.resultLabel.getFont().getName(), 1, this.resultLabel.getFont().getSize()));
        nothingPanel.add(this.noResultLabel);
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new BorderLayout());
        TitledBorder resultsTitle = new TitledBorder(this.contentBorder, "Results", 1, 2);
        resultsPanel.setBorder(resultsTitle);
        Object[] foundHeader = new String[]{"Type", "Name", "Found in"};
        this.foundTableModel = new DefaultTableModel(0, 3){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.foundTableModel.setColumnIdentifiers(foundHeader);
        this.foundTable = new JTable(this.foundTableModel){
            private static final long serialVersionUID = 1L;
        };
        this.foundTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.foundTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.foundTable.getColumnModel().getColumn(2).setPreferredWidth(40);
        this.foundTable.setAutoResizeMode(1);
        this.foundTable.setAutoCreateRowSorter(false);
        this.foundTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 1) {
                    Find.this.goButton.setEnabled(true);
                }
                if (me.getClickCount() == 2) {
                    Find.this.goButton.setEnabled(true);
                    Find.this.go();
                }
            }
        });
        this.foundTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Find.this.sortColumn = Find.this.foundTable.columnAtPoint(e.getPoint());
                Find.this.searchAction(Find.this.sortColumn);
            }
        });
        this.foundTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int idx = Find.this.foundTable.getSelectedRow();
                if (idx < 0) {
                    Find.this.goButton.setEnabled(false);
                }
            }
        });
        this.foundTable.getTableHeader().setToolTipText(this.tableTip);
        this.foundTable.setSelectionMode(0);
        this.foundScroll = new JScrollPane(this.foundTable);
        this.foundScroll.setPreferredSize(new Dimension(450, 150));
        resultsPanel.add((Component)this.foundScroll, "Center");
        this.goButton.setPreferredSize(new Dimension(100, 20));
        this.goButton.setEnabled(false);
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent go) {
                Find.this.go();
            }
        });
        this.closeButton.setPreferredSize(new Dimension(100, 20));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent close) {
                Find.this.findFrame.setVisible(false);
                mainGUI.getTimePanel().setFound(null, TimePanel.HighlightEnd.SRC);
                mainGUI.getTimePanel().repaint();
            }
        });
        JPanel buttonsPanel = new JPanel(this.flowLayoutCenter);
        buttonsPanel.add(this.openEditorBox);
        buttonsPanel.add(this.goButton);
        buttonsPanel.add(this.closeButton);
        Box overallPanel = Box.createVerticalBox();
        overallPanel.add(findPanel);
        overallPanel.add(regExPanel);
        overallPanel.add(paramsPanel);
        overallPanel.add(connectionPanel);
        overallPanel.add(nothingPanel);
        overallPanel.add(resultsPanel);
        overallPanel.add(buttonsPanel);
        this.add(overallPanel);
        this.pack();
    }

    private void go() {
        int idx = this.foundTable.getSelectedRow();
        if (idx < 0) {
            this.goButton.setEnabled(false);
            return;
        }
        Found foundItem = this.foundList.get(idx);
        switch (foundItem.getType()) {
            case "timeline": 
            case "general_event": 
            case "untimed": 
            case "timeline_event": {
                Event tmpTl = (Event)foundItem.getItem();
                if (!tmpTl.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
                    int y = (int)Math.round(tmpTl.getNameBounds().getY());
                    LocalDate tlEarly = tmpTl.getDates().getEarlyStartDate();
                    this.ourGUI.showPosition(tlEarly, y);
                } else {
                    this.ourGUI.setViewportTopLeft();
                }
                if (!this.openEditorBox.isSelected()) break;
                this.ourGUI.showEventEditor(tmpTl);
                break;
            }
            case "segment": {
                Segment tmpSeg = (Segment)foundItem.getItem();
                int y = (int)Math.round(tmpSeg.getNameBounds().getY());
                LocalDate tlEarly = tmpSeg.getDates().getEarlyStartDate();
                this.ourGUI.showPosition(tlEarly, y);
                if (!this.openEditorBox.isSelected()) break;
                this.ourGUI.showSegmentEditor(tmpSeg);
                break;
            }
            case "connection": {
                int y = 0;
                Connection tmpCn = (Connection)foundItem.getItem();
                Event source = tmpCn.getSourceEvent();
                if (this.cnSrcButton.isSelected() && foundItem.isShown()) {
                    if (source.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                        y = (int)Math.round(source.getNameBounds().getY());
                        LocalDate srcDate = source.getDates().getEarlyStartDate();
                        if (tmpCn.getSourceTimelinePoint() == 1) {
                            srcDate = tmpCn.getDates().getSrcEarlyDate();
                        }
                        this.ourGUI.showPosition(srcDate, y);
                    } else {
                        y = (int)tmpCn.getSourceEvent().getPositionY();
                        LocalDate useDate = source.getDates().getEarlyStartDate();
                        if (source.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
                            useDate = this.ourGUI.getRangeStart();
                        }
                        this.ourGUI.showPosition(useDate, y);
                    }
                }
                if (this.cnDstButton.isSelected() && foundItem.isShown()) {
                    Event destination = tmpCn.getDestEvent();
                    if (destination.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                        y = (int)Math.round(destination.getNameBounds().getY());
                        LocalDate dstDate = destination.getDates().getEarlyStartDate();
                        if (tmpCn.getDestTimelinePoint() == 1) {
                            dstDate = tmpCn.getDates().getDstEarlyDate();
                        }
                        this.ourGUI.showPosition(dstDate, y);
                    } else {
                        y = (int)destination.getPositionY();
                        LocalDate useDate = destination.getDates().getEarlyStartDate();
                        if (destination.getEventType().equals((Object)CommonData.EventType.UNTIMED)) {
                            useDate = this.ourGUI.getRangeStart();
                        }
                        this.ourGUI.showPosition(useDate, y);
                    }
                }
                if (!this.openEditorBox.isSelected()) break;
                this.ourGUI.showConnectionEditor(tmpCn);
                break;
            }
            case "introduction": {
                this.ourGUI.showIntroEditor();
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.findFrame, "Find: Invalid found item type " + foundItem.getType() + " Name: " + foundItem.getName());
                return;
            }
        }
        if (foundItem.isShown()) {
            TimePanel.HighlightEnd srcDst = TimePanel.HighlightEnd.DST;
            if (this.cnSrcButton.isSelected()) {
                srcDst = TimePanel.HighlightEnd.SRC;
            }
            this.ourGUI.getTimePanel().setFound(foundItem, srcDst);
        } else {
            this.ourGUI.getTimePanel().setFound(null, TimePanel.HighlightEnd.SRC);
        }
    }

    public void clearLists() {
        this.foundTableModel.setRowCount(0);
    }

    private void searchAction(int sortColumn) {
        this.foundTableModel.setRowCount(0);
        this.goButton.setEnabled(false);
        this.foundList = new ArrayList();
        this.noResultLabel.setVisible(true);
        if (!this.findField.getText().isEmpty() && this.findField.getText() != "") {
            EventData ourEventData = this.ourGUI.getInput().getEventData();
            int i = 0;
            while (i < ourEventData.getTotalNumberOfEvents()) {
                boolean match;
                Event tmpEv = ourEventData.getEventByIndex(i);
                this.found = false;
                this.foundIn = "";
                if (this.whereNameBox.isSelected() && (match = Utils.patternMatch(this.findField.getText(), tmpEv.getName(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected()))) {
                    this.found = true;
                    this.foundIn = String.valueOf(this.foundIn) + "N ";
                    this.noResultLabel.setVisible(false);
                }
                if (this.whereTagsBox.isSelected() && (match = Utils.patternMatch(this.findField.getText(), tmpEv.getTags().getTagsAsString(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected()))) {
                    this.found = true;
                    this.foundIn = String.valueOf(this.foundIn) + "T ";
                    this.noResultLabel.setVisible(false);
                }
                if (this.whereDescBox.isSelected() && (match = Utils.patternMatch(this.findField.getText(), tmpEv.getDescription(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected()))) {
                    this.found = true;
                    this.foundIn = String.valueOf(this.foundIn) + "D ";
                    this.noResultLabel.setVisible(false);
                }
                if (this.whereColorBox.isSelected() && (match = Utils.patternMatch(this.findField.getText(), tmpEv.getColor(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected()))) {
                    this.found = true;
                    this.foundIn = String.valueOf(this.foundIn) + "C ";
                    this.noResultLabel.setVisible(false);
                }
                if (this.found) {
                    this.foundList.add(new Found(tmpEv.getEventType().toString(), tmpEv.getName(), this.foundIn, tmpEv, tmpEv.isShown()));
                }
                if (tmpEv.getEventType().equals((Object)CommonData.EventType.TIMELINE) && (this.whereNameBox.isSelected() || this.whereColorBox.isSelected()) && tmpEv.getTlSegmentList() != null) {
                    SegmentList tmpSegs = tmpEv.getTlSegmentList();
                    int j = 0;
                    while (j < tmpSegs.getNumberOfSegments()) {
                        boolean match2;
                        boolean foundSeg = false;
                        Object foundInSeg = "";
                        Segment tmpSeg = null;
                        tmpSeg = tmpSegs.getASegment(j);
                        if (this.whereNameBox.isSelected() && (match2 = Utils.patternMatch(this.findField.getText(), tmpSeg.getText(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected()))) {
                            foundSeg = true;
                            foundInSeg = (String)foundInSeg + "N ";
                            this.noResultLabel.setVisible(false);
                        }
                        if (this.whereColorBox.isSelected()) {
                            boolean matchFG = Utils.patternMatch(this.findField.getText(), tmpSeg.getColorFG(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected());
                            boolean matchBGOS = Utils.patternMatch(this.findField.getText(), tmpSeg.getColorOuterStart(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected());
                            boolean matchBGOE = Utils.patternMatch(this.findField.getText(), tmpSeg.getColorOuterEnd(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected());
                            boolean matchBGin = Utils.patternMatch(this.findField.getText(), tmpSeg.getColorInner(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected());
                            if (matchFG || matchBGOS || matchBGOE || matchBGin) {
                                foundSeg = true;
                                foundInSeg = (String)foundInSeg + "C ";
                                this.noResultLabel.setVisible(false);
                            }
                        }
                        if (foundSeg) {
                            this.foundList.add(new Found("SEGMENT", tmpSeg.getText() + " (in " + tmpEv.getName() + ")", (String)foundInSeg, tmpSeg, tmpEv.isShown()));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ConnectionData tmpCnData = this.ourGUI.getInput().getConnections();
            Connection tmpCn = null;
            int i2 = 0;
            while (i2 < tmpCnData.getNumberOfConnections()) {
                boolean match;
                boolean match3;
                boolean match4;
                boolean match5;
                boolean match6;
                boolean match7;
                tmpCn = tmpCnData.getConnection(i2);
                this.found = false;
                this.foundIn = "";
                if (this.whereNameBox.isSelected() && (match7 = Utils.patternMatch(this.findField.getText(), tmpCn.getName(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected()))) {
                    this.found = true;
                    this.foundIn = String.valueOf(this.foundIn) + "N ";
                    this.noResultLabel.setVisible(false);
                }
                if (this.whereCnSrcBox.isSelected() && (match6 = Utils.patternMatch(this.findField.getText(), tmpCn.getSrcEvTlName(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected()))) {
                    this.found = true;
                    this.foundIn = String.valueOf(this.foundIn) + "Cs ";
                    this.noResultLabel.setVisible(false);
                }
                if (this.whereCnDstBox.isSelected() && (match5 = Utils.patternMatch(this.findField.getText(), tmpCn.getDstEvTlName(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected()))) {
                    this.found = true;
                    this.foundIn = String.valueOf(this.foundIn) + "Cd ";
                    this.noResultLabel.setVisible(false);
                }
                if (this.whereTagsBox.isSelected() && (match4 = Utils.patternMatch(this.findField.getText(), tmpCn.getTags().getTagsAsString(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected()))) {
                    this.found = true;
                    this.foundIn = String.valueOf(this.foundIn) + "T ";
                    this.noResultLabel.setVisible(false);
                }
                if (this.whereDescBox.isSelected() && (match3 = Utils.patternMatch(this.findField.getText(), tmpCn.getDescription(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected()))) {
                    this.found = true;
                    this.foundIn = String.valueOf(this.foundIn) + "D ";
                    this.noResultLabel.setVisible(false);
                }
                if (this.whereColorBox.isSelected() && (match = Utils.patternMatch(this.findField.getText(), tmpCn.getColor(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected()))) {
                    this.found = true;
                    this.foundIn = String.valueOf(this.foundIn) + "C ";
                    this.noResultLabel.setVisible(false);
                }
                if (this.found) {
                    Object tmpName = "";
                    if (!tmpCn.getName().equals("")) {
                        tmpName = tmpCn.getName() + ": ";
                    }
                    this.foundList.add(new Found("CONNECTION", (String)tmpName + tmpCn.getNiceID(), this.foundIn, tmpCn, tmpCn.isShown()));
                }
                ++i2;
            }
            if (this.whereDescBox.isSelected()) {
                this.found = false;
                this.foundIn = "";
                boolean match = Utils.patternMatch(this.findField.getText(), this.ourGUI.getIntroText(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected());
                if (match) {
                    this.found = true;
                    this.foundIn = String.valueOf(this.foundIn) + "I ";
                    this.noResultLabel.setVisible(false);
                }
                if (match = Utils.patternMatch(this.findField.getText(), this.ourGUI.getTechText(), this.findSimple.isSelected(), this.caseBox.isSelected(), this.umlautBox.isSelected())) {
                    this.found = true;
                    this.foundIn = String.valueOf(this.foundIn) + "Te ";
                    this.noResultLabel.setVisible(false);
                }
                if (this.found) {
                    this.foundList.add(new Found("INTRODUCTION", "", this.foundIn, null, true));
                }
            }
            switch (sortColumn) {
                case 0: {
                    this.sortFoundListByType();
                    break;
                }
                case 1: {
                    this.sortFoundListByName();
                    break;
                }
                case 2: {
                    this.sortFoundListByFoundIn();
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this.ourGUI, "Find: illegal column number for sorting.");
                }
            }
            for (Found item : this.foundList) {
                Object type = item.type;
                Object name = item.name;
                Object foundIn = item.foundIn;
                if (!item.isShown()) {
                    type = "<html><i>" + item.type + "</i></html>";
                    name = "<html><i>" + item.name + "</i></html>";
                    foundIn = "<html><i>" + item.foundIn + "</i></html>";
                }
                this.foundTableModel.addRow(new Object[]{type, Utils.flatline((String)name), foundIn});
            }
        }
        if (this.foundTableModel.getRowCount() > 0 && this.foundTable.getSelectedRow() > 0) {
            this.goButton.setEnabled(true);
        }
        this.foundTable.revalidate();
        this.findFrame.revalidate();
        this.findFrame.repaint();
    }

    private void sortFoundListByName() {
        if (this.foundList != null && this.foundList.size() != 0) {
            this.foundList.sort(new NameSorter());
        }
    }

    private void sortFoundListByType() {
        if (this.foundList != null && this.foundList.size() != 0) {
            this.foundList.sort(new TypeSorter());
        }
    }

    private void sortFoundListByFoundIn() {
        if (this.foundList != null && this.foundList.size() != 0) {
            this.foundList.sort(new FoundInSorter());
        }
    }

    class Found {
        private String type;
        private String name;
        private String foundIn;
        private Object item;
        private boolean shown;

        private Found(String t, String n, String f, Object i, boolean s) {
            this.type = t;
            this.name = n;
            this.foundIn = f;
            this.item = i;
            this.shown = s;
        }

        public String getType() {
            return this.type.toLowerCase();
        }

        public String getName() {
            return this.name.toLowerCase();
        }

        public String getFoundIn() {
            return this.foundIn;
        }

        public Object getItem() {
            return this.item;
        }

        public boolean isShown() {
            return this.shown;
        }
    }

    private class FoundInSorter
    implements Comparator<Found> {
        private FoundInSorter() {
        }

        @Override
        public int compare(Found o1, Found o2) {
            int tmp = o1.getFoundIn().compareToIgnoreCase(o2.getFoundIn());
            return tmp;
        }
    }

    private class NameSorter
    implements Comparator<Found> {
        private NameSorter() {
        }

        @Override
        public int compare(Found o1, Found o2) {
            int tmp = o1.getName().compareToIgnoreCase(o2.getName());
            return tmp;
        }
    }

    private class TypeSorter
    implements Comparator<Found> {
        private TypeSorter() {
        }

        @Override
        public int compare(Found o1, Found o2) {
            int tmp = o1.getType().compareToIgnoreCase(o2.getType());
            return tmp;
        }
    }
}

