/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.ActiveFilterStage;
import culturalDynamics.CDgui;
import culturalDynamics.FilterEditor;
import culturalDynamics.FilterStage;
import culturalDynamics.FilterStageEditor;
import culturalDynamics.SavedFilterStage;
import culturalDynamics.TagList;
import culturalDynamics.Utils;
import java.time.LocalDate;
import java.util.ArrayList;
import org.json.JSONWriter;

class Filter {
    private String name;
    private String description;
    private boolean hideConnections;
    private boolean hideCnNames;
    private boolean hideEmptyRows;
    private boolean showNoTags;
    private boolean showTimelines;
    private int exploreIterations;
    private ExploreDirection exploreDirection;
    private LocalDate notBeforeDate;
    private LocalDate notAfterDate;
    private ArrayList<FilterStage> stages = new ArrayList();

    Filter() {
    }

    public void addStageActive(CDgui mainGUI, FilterEditor.Logic logicIn, FilterEditor.Operation opIn, TagList tagsIn, FilterStageEditor.StageEditorListener sel) {
        this.stages.add(new ActiveFilterStage(mainGUI, logicIn, opIn, tagsIn, sel));
    }

    public void addStageActive(int index, CDgui mainGUI, FilterEditor.Logic logicIn, FilterEditor.Operation opIn, TagList tagsIn, FilterStageEditor.StageEditorListener sel) {
        this.stages.add(index, new ActiveFilterStage(mainGUI, logicIn, opIn, tagsIn, sel));
    }

    public void addStageSaved(FilterEditor.Logic logicIn, FilterEditor.Operation opIn, TagList tagsIn) {
        this.stages.add(new SavedFilterStage(logicIn, opIn, tagsIn));
    }

    public void addStage(FilterStage stageIn) {
        this.stages.add(stageIn);
    }

    public void removeStage(int i) {
        this.stages.remove(i);
    }

    public int getNumFilterStages() {
        return this.stages.size();
    }

    public void clearStages() {
        this.stages.clear();
    }

    public ActiveFilterStage getFilterStageActive(int idx) {
        return (ActiveFilterStage)this.stages.get(idx);
    }

    public SavedFilterStage getFilterStageSaved(int idx) {
        return (SavedFilterStage)this.stages.get(idx);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FilterEditor.Operation getOperation(int idx) {
        return this.stages.get(idx).getOperation();
    }

    public FilterEditor.Logic getLogic(int idx) {
        return this.stages.get(idx).getLogic();
    }

    public boolean isShowNoTags() {
        return this.showNoTags;
    }

    public void setShowNoTags(boolean showNoTags) {
        this.showNoTags = showNoTags;
    }

    public boolean isShowTimelines() {
        return this.showTimelines;
    }

    public void setShowTimelines(boolean showTimelines) {
        this.showTimelines = showTimelines;
    }

    public boolean isHideConnections() {
        return this.hideConnections;
    }

    public void setHideConnections(boolean hideConnections) {
        this.hideConnections = hideConnections;
    }

    public boolean isHideCnNames() {
        return this.hideCnNames;
    }

    public void setHideCnNames(boolean hideCnNames) {
        this.hideCnNames = hideCnNames;
    }

    public boolean isHideEmptyRows() {
        return this.hideEmptyRows;
    }

    public void setHideEmptyRows(boolean hideEmptyRows) {
        this.hideEmptyRows = hideEmptyRows;
    }

    public int getExploreIterations() {
        return this.exploreIterations;
    }

    public void setExploreIterations(int iter) {
        this.exploreIterations = iter;
    }

    public ExploreDirection getExploreDirection() {
        return this.exploreDirection;
    }

    public void setExploreDirection(ExploreDirection dir) {
        this.exploreDirection = dir;
    }

    public LocalDate getNotBeforeDate() {
        return this.notBeforeDate;
    }

    public void setNotBeforeDate(LocalDate d) {
        this.notBeforeDate = d;
    }

    public LocalDate getNotAfterDate() {
        return this.notAfterDate;
    }

    public void setNotAfterDate(LocalDate d) {
        this.notAfterDate = d;
    }

    public void toJSON(JSONWriter writer) {
        writer.object().key("name").value(this.name).key("showNoTags").value(this.isShowNoTags()).key("showTimelinsOfEvents").value(this.isShowTimelines()).key("hideConnections").value(this.isHideConnections()).key("hideConnectionNames").value(this.isHideCnNames()).key("hideEmptyRows").value(this.isHideEmptyRows()).key("exploreIterations").value(this.exploreIterations).key("exploreDirection").value((Object)this.exploreDirection);
        if (this.notBeforeDate != null) {
            writer.key("notBefore").value(Utils.dayFormatterOut.format(this.notBeforeDate));
        }
        if (this.notAfterDate != null) {
            writer.key("notAfter").value(Utils.dayFormatterOut.format(this.notAfterDate));
        }
        writer.key("description").value(this.description).key("stages").array();
        int j = 0;
        while (j < this.getNumFilterStages()) {
            writer.object().key("index").value(j).key("logic").value((Object)this.getLogic(j)).key("operation").value((Object)this.getOperation(j)).key("tags").value(this.getFilterStageSaved(j).getTags().getTagsAsString()).endObject();
            ++j;
        }
        writer.endArray().endObject();
    }

    public static enum ExploreDirection {
        BACK,
        FORWARD,
        BOTH;

    }
}

