/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.TimePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

class ExportDialog
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private CDgui ourGUI;
    private JFrame exportFrame;
    private TimePanel ourTimePanel;
    private MediaSizeName[] paperTypes = new MediaSizeName[]{MediaSizeName.NA_LETTER, MediaSizeName.ISO_A0, MediaSizeName.ISO_A1, MediaSizeName.ISO_A2, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_A6, MediaSizeName.ISO_A7, MediaSizeName.ISO_A8, MediaSizeName.ISO_A9, MediaSizeName.ISO_A10, MediaSizeName.ISO_B0, MediaSizeName.ISO_B1, MediaSizeName.ISO_B2, MediaSizeName.ISO_B3, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ISO_B7, MediaSizeName.ISO_B8, MediaSizeName.ISO_B9, MediaSizeName.ISO_B10, MediaSizeName.JIS_B0, MediaSizeName.JIS_B1, MediaSizeName.JIS_B2, MediaSizeName.JIS_B3, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.JIS_B6, MediaSizeName.JIS_B7, MediaSizeName.JIS_B8, MediaSizeName.JIS_B9, MediaSizeName.JIS_B10, MediaSizeName.ISO_C0, MediaSizeName.ISO_C1, MediaSizeName.ISO_C2, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C5, MediaSizeName.ISO_C6, MediaSizeName.NA_LEGAL, MediaSizeName.EXECUTIVE, MediaSizeName.LEDGER, MediaSizeName.TABLOID, MediaSizeName.INVOICE, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.JAPANESE_DOUBLE_POSTCARD};
    private String[] fileTypes = new String[]{"PNG", "JPG", "GIF", "BMP"};
    private JRadioButton res72Button = new JRadioButton("72");
    private JRadioButton res100Button = new JRadioButton("100");
    private JRadioButton res300Button = new JRadioButton("300");
    private JRadioButton res600Button = new JRadioButton("600");
    private JRadioButton res1200Button = new JRadioButton("1200");
    private JRadioButton resCustomButton = new JRadioButton("Custom");
    private ButtonGroup resolutionGroup = new ButtonGroup();
    private JTextField resolutionField = new JTextField(5);
    private JComboBox<String> paperTypeField = new JComboBox();
    private JRadioButton standardButton = new JRadioButton("Standard");
    private JRadioButton sizeCustomButton = new JRadioButton("Custom");
    private ButtonGroup stdCustGroup = new ButtonGroup();
    private JRadioButton inchesButton = new JRadioButton("Inch");
    private JRadioButton mmButton = new JRadioButton("mm");
    private ButtonGroup unitsGroup = new ButtonGroup();
    private JLabel widthLabel = new JLabel("Width");
    private JTextField widthField = new JTextField(10);
    private JLabel heightLabel = new JLabel("Height");
    private JTextField heightField = new JTextField(10);
    private JRadioButton portraitButton = new JRadioButton("Portrait");
    private JRadioButton landscapeButton = new JRadioButton("Landscape");
    private ButtonGroup orientationGroup = new ButtonGroup();
    private JRadioButton pngButton = new JRadioButton(this.fileTypes[0]);
    private JRadioButton jpgButton = new JRadioButton(this.fileTypes[1]);
    private JRadioButton gifButton = new JRadioButton(this.fileTypes[2]);
    private JRadioButton bmpButton = new JRadioButton(this.fileTypes[3]);
    private ButtonGroup fileTypeGroup = new ButtonGroup();
    private JRadioButton singleImageButton = new JRadioButton("Single image");
    private JRadioButton multipleImagesButton = new JRadioButton("Multiple images high");
    private JRadioButton fullDiagramButton = new JRadioButton("Full diagram");
    private ButtonGroup layoutGroup = new ButtonGroup();
    private JCheckBox xAxisPagesField = new JCheckBox("X-Axis on each page");
    private JCheckBox splitRowsField = new JCheckBox("Split rows across pages");
    private JLabel resultLabel = new JLabel("Image size not yet defined.");
    private JLabel exportAsLabel = new JLabel("Export as:");
    private JTextField exportFileField = new JTextField(30);
    private JButton browseButton = new JButton("Browse");
    private JButton exportButton = new JButton("Export");
    private JButton closeButton = new JButton("Close");
    private JLabel workingLabel = new JLabel(" ");
    private FileNameExtensionFilter pngFilter = new FileNameExtensionFilter("PNG files (*.png)", "png");
    private FileNameExtensionFilter jpgFilter = new FileNameExtensionFilter("JPG files (*.jpg)", "jpg");
    private FileNameExtensionFilter gifFilter = new FileNameExtensionFilter("GIF files (*.gif)", "gif");
    private FileNameExtensionFilter bmpFilter = new FileNameExtensionFilter("BMP files (*.bmp)", "bmp");
    private FileNameExtensionFilter currentExtFilter;
    private File saveFile = null;
    private String outfolderPath;
    private String currentExportDir = "";
    private double newPaperX;
    private double newPaperY;
    private int resolution;
    private int imageWidth;
    private int imageHeight;
    private int imageSize;
    private TimePanel.Layout imageLayout = TimePanel.Layout.SINGLE_IMAGE;
    private TimePanel.XaxisPaging xAxisPerPage;
    private TimePanel.SplitRows splitRows;
    private NumberFormat numberFormat;
    private NumberFormat decimalFormat;
    private String fileExtension;
    private FocusListener resolutionListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent g) {
            ExportDialog.this.resCustomButton.setSelected(true);
        }

        @Override
        public void focusLost(FocusEvent g) {
            ExportDialog.this.resCustomButton.setSelected(true);
            try {
                ExportDialog.this.resolution = Integer.valueOf(ExportDialog.this.resolutionField.getText());
            }
            catch (NumberFormatException n) {
                JOptionPane.showMessageDialog(ExportDialog.this.exportFrame, "Invalid number in resolution field.");
            }
            ExportDialog.this.calculateResult();
        }
    };
    private FocusListener customWidthListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent f) {
            ExportDialog.this.sizeCustomButton.setSelected(true);
            ExportDialog.this.widthField.selectAll();
        }

        @Override
        public void focusLost(FocusEvent f) {
            ExportDialog.this.sizeCustomButton.setSelected(true);
            try {
                ExportDialog.this.newPaperX = Double.valueOf(ExportDialog.this.widthField.getText());
            }
            catch (NumberFormatException n) {
                JOptionPane.showMessageDialog(ExportDialog.this.exportFrame, "Invalid number in paper width field.");
            }
            ExportDialog.this.calculateResult();
        }
    };
    private FocusListener customHeightListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent f) {
            ExportDialog.this.sizeCustomButton.setSelected(true);
            ExportDialog.this.heightField.selectAll();
        }

        @Override
        public void focusLost(FocusEvent f) {
            ExportDialog.this.sizeCustomButton.setSelected(true);
            try {
                ExportDialog.this.newPaperY = Double.valueOf(ExportDialog.this.heightField.getText());
            }
            catch (NumberFormatException n) {
                JOptionPane.showMessageDialog(ExportDialog.this.exportFrame, "Invalid number in paper height field.");
            }
            ExportDialog.this.calculateResult();
        }
    };
    private Thread.UncaughtExceptionHandler unforeseenHandler = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread th, Throwable ex) {
            JOptionPane.showMessageDialog(ExportDialog.this.getMainWindow(), "Unhandled Error in Thread!\n" + ExportDialog.this.displayError(ex));
        }
    };

    ExportDialog(CDgui mainUI) {
        this.ourGUI = mainUI;
        this.exportFrame = this;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ExportDialog.this.setWorking(" ");
                ExportDialog.this.ourGUI.getWindowManager().closeWindow();
            }
        });
        LineBorder panelsBorder = new LineBorder(Color.lightGray, 3);
        FlowLayout flowLayoutRight = new FlowLayout(2);
        FlowLayout flowLayoutLeft = new FlowLayout(0);
        this.numberFormat = NumberFormat.getInstance();
        this.decimalFormat = new DecimalFormat("#.###");
        this.res72Button.setToolTipText("Set image resolution to 72 dpi");
        this.res72Button.addActionListener(this);
        this.res72Button.setActionCommand("resolution");
        this.res100Button.setToolTipText("Set image resolution to 100 dpi");
        this.res100Button.addActionListener(this);
        this.res100Button.setActionCommand("resolution");
        this.res300Button.setToolTipText("Set image resolution to 300 dpi");
        this.res300Button.addActionListener(this);
        this.res300Button.setActionCommand("resolution");
        this.res600Button.setToolTipText("Set image resolution to 600 dpi");
        this.res600Button.addActionListener(this);
        this.res600Button.setActionCommand("resolution");
        this.res1200Button.setToolTipText("Set image resolution to 1200 dpi");
        this.res1200Button.addActionListener(this);
        this.res1200Button.setActionCommand("resolution");
        this.resCustomButton.setToolTipText("Set your own image resolution");
        this.resolutionField.setToolTipText("Enter your own image resolution");
        this.resolutionGroup.add(this.res72Button);
        this.resolutionGroup.add(this.res100Button);
        this.resolutionGroup.add(this.res300Button);
        this.resolutionGroup.add(this.res600Button);
        this.resolutionGroup.add(this.res1200Button);
        this.resolutionGroup.add(this.resCustomButton);
        this.res300Button.setSelected(true);
        this.resolutionField.setText(String.valueOf(300));
        this.resolutionField.addFocusListener(this.resolutionListener);
        this.resolution = 300;
        this.standardButton.setToolTipText("Select a standard size from the drop-down list");
        this.standardButton.addActionListener(this);
        this.standardButton.setActionCommand("sizing");
        this.sizeCustomButton.setToolTipText("Use a custom size entered in the width and height fields");
        this.sizeCustomButton.addActionListener(this);
        this.sizeCustomButton.setActionCommand("sizing");
        this.stdCustGroup.add(this.standardButton);
        this.stdCustGroup.add(this.sizeCustomButton);
        this.standardButton.setSelected(true);
        this.inchesButton.setToolTipText("Set image size units to inches");
        this.inchesButton.addActionListener(this);
        this.inchesButton.setActionCommand("sizing");
        this.mmButton.setToolTipText("Set image size units to millimeters");
        this.mmButton.addActionListener(this);
        this.mmButton.setActionCommand("sizing");
        this.unitsGroup.add(this.inchesButton);
        this.unitsGroup.add(this.mmButton);
        this.mmButton.setSelected(true);
        String[] paperNames = new String[this.paperTypes.length];
        int i = 0;
        while (i < this.paperTypes.length) {
            paperNames[i] = this.paperTypes[i].toString();
            ++i;
        }
        this.paperTypeField.setModel(new DefaultComboBoxModel<String>(paperNames));
        this.paperTypeField.addActionListener(this);
        this.paperTypeField.setActionCommand("sizing");
        this.paperTypeField.setSelectedIndex(5);
        MediaSize newSize = MediaSize.getMediaSizeForName(this.paperTypes[5]);
        this.newPaperX = newSize.getX(1000);
        this.widthField.setText(this.decimalFormat.format(this.newPaperX));
        this.newPaperY = newSize.getY(1000);
        this.heightField.setText(this.decimalFormat.format(this.newPaperY));
        this.widthField.setToolTipText("Width of image in the selected units");
        this.widthField.addFocusListener(this.customWidthListener);
        this.heightField.setToolTipText("Heigth of image in the selected units");
        this.heightField.addFocusListener(this.customHeightListener);
        this.portraitButton.setToolTipText("Image orientation high");
        this.portraitButton.addActionListener(this);
        this.portraitButton.setActionCommand("sizing");
        this.landscapeButton.setToolTipText("Image orientation wide");
        this.landscapeButton.addActionListener(this);
        this.landscapeButton.setActionCommand("sizing");
        this.orientationGroup.add(this.portraitButton);
        this.orientationGroup.add(this.landscapeButton);
        this.portraitButton.setSelected(true);
        this.pngButton.setToolTipText("Export to PNG graphics file");
        this.pngButton.addActionListener(this);
        this.pngButton.setActionCommand("pngButton");
        this.jpgButton.setToolTipText("Export to JPG graphics file");
        this.jpgButton.addActionListener(this);
        this.jpgButton.setActionCommand("jpgButton");
        this.gifButton.setToolTipText("Export to GIF graphics file");
        this.gifButton.addActionListener(this);
        this.gifButton.setActionCommand("gifButton");
        this.bmpButton.setToolTipText("Export to BMP graphics file");
        this.bmpButton.addActionListener(this);
        this.bmpButton.setActionCommand("bmpButton");
        this.fileTypeGroup.add(this.pngButton);
        this.fileTypeGroup.add(this.jpgButton);
        this.fileTypeGroup.add(this.gifButton);
        this.fileTypeGroup.add(this.bmpButton);
        this.pngButton.setSelected(true);
        this.fileExtension = "PNG";
        this.currentExtFilter = this.pngFilter;
        this.exportFileField.setEditable(false);
        this.singleImageButton.setToolTipText("Export the currently viewed time range to a single image file.");
        this.singleImageButton.addActionListener(this);
        this.singleImageButton.setActionCommand("singleImage");
        this.multipleImagesButton.setToolTipText("Export the currently viewed time range to a single page across and multiple pages down");
        this.multipleImagesButton.addActionListener(this);
        this.multipleImagesButton.setActionCommand("multipleImages");
        this.fullDiagramButton.setToolTipText("Export the full diagram to multiple pages across and down");
        this.fullDiagramButton.addActionListener(this);
        this.fullDiagramButton.setActionCommand("fullDiagram");
        this.layoutGroup.add(this.singleImageButton);
        this.layoutGroup.add(this.multipleImagesButton);
        this.layoutGroup.add(this.fullDiagramButton);
        this.singleImageButton.setSelected(true);
        this.xAxisPagesField.setToolTipText("Add the X-axis on every page.");
        this.xAxisPagesField.setSelected(false);
        this.splitRowsField.setToolTipText("Allow rows to split across pages");
        this.splitRowsField.setSelected(false);
        this.calculateResult();
        this.browseButton.setToolTipText("Select where to save the exported files");
        this.browseButton.setPreferredSize(new Dimension(100, 20));
        this.browseButton.setActionCommand("BrowseButton");
        this.browseButton.addActionListener(this);
        this.exportButton.setToolTipText("Start the export to one or more files");
        this.exportButton.setPreferredSize(new Dimension(100, 20));
        this.exportButton.setActionCommand("ExportButton");
        this.exportButton.addActionListener(this);
        this.exportButton.setEnabled(false);
        this.closeButton.setToolTipText("Close this window");
        this.closeButton.setActionCommand("CloseButton");
        this.closeButton.setPreferredSize(new Dimension(100, 20));
        this.closeButton.addActionListener(this);
        JPanel resolutionPanel = new JPanel(flowLayoutLeft);
        TitledBorder resolutionTitle = new TitledBorder(panelsBorder, "Image Resolution dpi", 1, 2);
        resolutionPanel.setBorder(resolutionTitle);
        resolutionPanel.add(this.res72Button);
        resolutionPanel.add(this.res100Button);
        resolutionPanel.add(this.res300Button);
        resolutionPanel.add(this.res600Button);
        resolutionPanel.add(this.res1200Button);
        resolutionPanel.add(this.resCustomButton);
        resolutionPanel.add(this.resolutionField);
        Box stdCustPanel = Box.createVerticalBox();
        stdCustPanel.add(this.standardButton);
        stdCustPanel.add(this.sizeCustomButton);
        JPanel whPanel = new JPanel(flowLayoutLeft);
        whPanel.add(this.widthLabel);
        whPanel.add(this.widthField);
        whPanel.add(this.heightLabel);
        whPanel.add(this.heightField);
        Box paperPanel = Box.createVerticalBox();
        paperPanel.add(this.paperTypeField);
        paperPanel.add(whPanel);
        JPanel orientationPanel = new JPanel(flowLayoutLeft);
        orientationPanel.add(this.portraitButton);
        orientationPanel.add(this.landscapeButton);
        JPanel unitsPanel = new JPanel(flowLayoutLeft);
        unitsPanel.add(this.inchesButton);
        unitsPanel.add(this.mmButton);
        Box orientUnitsPanel = Box.createVerticalBox();
        orientUnitsPanel.add(orientationPanel);
        orientUnitsPanel.add(unitsPanel);
        JPanel sizePanel = new JPanel(flowLayoutLeft);
        TitledBorder sizeTitle = new TitledBorder(panelsBorder, "Image Size", 1, 2);
        sizePanel.setBorder(sizeTitle);
        sizePanel.add(stdCustPanel);
        sizePanel.add(paperPanel);
        sizePanel.add(orientUnitsPanel);
        JPanel resultPanel = new JPanel(flowLayoutLeft);
        TitledBorder resultTitle = new TitledBorder(panelsBorder, "Result", 1, 2);
        resultPanel.setBorder(resultTitle);
        this.calculateResult();
        resultPanel.add(this.resultLabel);
        JPanel fileTypePanel = new JPanel(flowLayoutLeft);
        TitledBorder fileTypeTitle = new TitledBorder(panelsBorder, "Export File Type", 1, 2);
        fileTypePanel.setBorder(fileTypeTitle);
        fileTypePanel.add(this.pngButton);
        fileTypePanel.add(this.jpgButton);
        fileTypePanel.add(this.gifButton);
        fileTypePanel.add(this.bmpButton);
        JPanel layout1Panel = new JPanel(flowLayoutLeft);
        layout1Panel.add(this.singleImageButton);
        layout1Panel.add(this.multipleImagesButton);
        layout1Panel.add(this.fullDiagramButton);
        JPanel layout2Panel = new JPanel(flowLayoutLeft);
        layout2Panel.add(this.xAxisPagesField);
        layout2Panel.add(this.splitRowsField);
        Box layoutPanel = Box.createVerticalBox();
        TitledBorder layoutTitle = new TitledBorder(panelsBorder, "Export Layout", 1, 2);
        layoutPanel.setBorder(layoutTitle);
        layoutPanel.add(layout1Panel);
        layoutPanel.add(layout2Panel);
        JPanel filePanel = new JPanel(flowLayoutLeft);
        TitledBorder fileTitle = new TitledBorder(panelsBorder, "Export File", 1, 2);
        filePanel.setBorder(fileTitle);
        filePanel.add(this.exportAsLabel);
        filePanel.add(this.exportFileField);
        filePanel.add(this.browseButton);
        JPanel buttonsPanel = new JPanel(flowLayoutRight);
        buttonsPanel.add(this.closeButton);
        buttonsPanel.add(this.exportButton);
        JPanel statusPanel = new JPanel(flowLayoutRight);
        statusPanel.add(this.workingLabel);
        Box exportPanel = Box.createVerticalBox();
        exportPanel.add(resolutionPanel);
        exportPanel.add(sizePanel);
        exportPanel.add(resultPanel);
        exportPanel.add(fileTypePanel);
        exportPanel.add(layoutPanel);
        exportPanel.add(filePanel);
        exportPanel.add(buttonsPanel);
        exportPanel.add(statusPanel);
        this.add(exportPanel);
        this.setTitle("Export to Image Files");
        this.pack();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        var3_3 = cmd = e.getActionCommand();
        tmp = -1;
        switch (var3_3.hashCode()) {
            case -1765637517: {
                if (var3_3.equals("jpgButton")) {
                    tmp = 1;
                }
                break;
            }
            case -1752260109: {
                if (var3_3.equals("singleImage")) {
                    tmp = 2;
                }
                break;
            }
            case -1726768873: {
                if (var3_3.equals("bmpButton")) {
                    tmp = 3;
                }
                break;
            }
            case -1600030548: {
                if (var3_3.equals("resolution")) {
                    tmp = 4;
                }
                break;
            }
            case -1178409946: {
                if (var3_3.equals("ExportButton")) {
                    tmp = 5;
                }
                break;
            }
            case -901906306: {
                if (var3_3.equals("sizing")) {
                    tmp = 6;
                }
                break;
            }
            case -840515562: {
                if (var3_3.equals("gifButton")) {
                    tmp = 7;
                }
                break;
            }
            case 473344377: {
                if (var3_3.equals("sizeField")) {
                    tmp = 8;
                }
                break;
            }
            case 510244676: {
                if (var3_3.equals("fullDiagram")) {
                    tmp = 9;
                }
                break;
            }
            case 563052156: {
                if (var3_3.equals("BrowseButton")) {
                    tmp = 10;
                }
                break;
            }
            case 679954600: {
                if (var3_3.equals("multipleImages")) {
                    tmp = 11;
                }
                break;
            }
            case 1083884219: {
                if (var3_3.equals("pngButton")) {
                    tmp = 12;
                }
                break;
            }
            case 1355169578: {
                if (var3_3.equals("CloseButton")) {
                    tmp = 13;
                }
                break;
            }
        }
        switch (tmp) {
            case 4: {
                if (this.resCustomButton.isSelected()) ** GOTO lbl139
                buttons = this.resolutionGroup.getElements();
                block50: while (buttons.hasMoreElements()) {
                    button = buttons.nextElement();
                    if (!button.isSelected()) continue;
                    var6_13 = button.getText();
                    tmp = -1;
                    switch (var6_13.hashCode()) {
                        case 1755: {
                            if (var6_13.equals("72")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 48625: {
                            if (var6_13.equals("100")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 50547: {
                            if (var6_13.equals("300")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case 53430: {
                            if (var6_13.equals("600")) {
                                tmp = 4;
                            }
                            break;
                        }
                        case 1509345: {
                            if (var6_13.equals("1200")) {
                                tmp = 5;
                            }
                            break;
                        }
                        case 2029746065: {
                            if (var6_13.equals("Custom")) {
                                tmp = 6;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            this.resolution = 72;
                            break;
                        }
                        case 2: {
                            this.resolution = 100;
                            break;
                        }
                        case 3: {
                            this.resolution = 300;
                            break;
                        }
                        case 4: {
                            this.resolution = 600;
                            break;
                        }
                        case 5: {
                            this.resolution = 1200;
                            break;
                        }
                        case 6: {
                            try {
                                this.resolution = Integer.parseInt(this.resolutionField.getText());
                            }
                            catch (NumberFormatException n) {
                                this.resolution = 300;
                                JOptionPane.showMessageDialog(this.exportFrame, "Export: Invalid number in custom resolution field");
                            }
                            continue block50;
                        }
                        default: {
                            JOptionPane.showMessageDialog(this.exportFrame, "Export: unknown resolution button");
                        }
                    }
                }
lbl139:
                // 2 sources

                this.resolutionField.setText(String.valueOf(this.resolution));
                this.calculateResult();
                break;
            }
            case 6: {
                if (!this.sizeCustomButton.isSelected()) {
                    paperIndex = this.paperTypeField.getSelectedIndex();
                    newPaper = this.paperTypes[paperIndex];
                    newSize = MediaSize.getMediaSizeForName(newPaper);
                    if (this.inchesButton.isSelected()) {
                        this.newPaperX = newSize.getX(25400);
                        this.newPaperY = newSize.getY(25400);
                    } else {
                        this.newPaperX = newSize.getX(1000);
                        this.newPaperY = newSize.getY(1000);
                    }
                    if (this.landscapeButton.isSelected()) {
                        tmp = this.newPaperX;
                        this.newPaperX = this.newPaperY;
                        this.newPaperY = tmp;
                    }
                }
                this.widthField.setText(this.decimalFormat.format(this.newPaperX));
                this.heightField.setText(this.decimalFormat.format(this.newPaperY));
                this.calculateResult();
                break;
            }
            case 8: {
                this.sizeCustomButton.setSelected(true);
                this.calculateResult();
                break;
            }
            case 2: {
                this.imageLayout = TimePanel.Layout.SINGLE_IMAGE;
                break;
            }
            case 11: {
                this.imageLayout = TimePanel.Layout.MULTIPLE_HIGH;
                break;
            }
            case 9: {
                this.imageLayout = TimePanel.Layout.FULL_DIAGRAM;
                break;
            }
            case 12: {
                this.fileExtension = "PNG";
                this.currentExtFilter = this.pngFilter;
                break;
            }
            case 1: {
                this.fileExtension = "JPG";
                this.currentExtFilter = this.jpgFilter;
                break;
            }
            case 7: {
                this.fileExtension = "GIF";
                this.currentExtFilter = this.gifFilter;
                break;
            }
            case 3: {
                this.fileExtension = "BMP";
                this.currentExtFilter = this.bmpFilter;
                break;
            }
            case 10: {
                try {
                    if (this.currentExportDir == "") {
                        this.outfolderPath = System.getProperty("user.home");
                    }
                    outFileChooser = new JFileChooser(this.outfolderPath);
                    outFileChooser.setFileSelectionMode(2);
                    outFileChooser.setFileFilter(this.currentExtFilter);
                    outFileChooser.setDialogTitle("Export to File");
                    outFileChooser.setApproveButtonText("Choose");
                    outfolderChoice = outFileChooser.showOpenDialog(this);
                    if (outfolderChoice != 0) {
                        this.exportButton.setEnabled(false);
                        return;
                    }
                    this.exportButton.setEnabled(true);
                    chosenFolder = outFileChooser.getSelectedFile();
                    this.outfolderPath = chosenFolder.getAbsolutePath();
                    this.saveFile = outFileChooser.getSelectedFile();
                    this.currentExportDir = this.saveFile.getParent();
                    this.exportFileField.setText(this.outfolderPath);
                }
                catch (Throwable unforeseen) {
                    JOptionPane.showMessageDialog(this, "Unhandled Error!\n" + this.ourGUI.displayError(unforeseen));
                    this.exportButton.setEnabled(false);
                }
                break;
            }
            case 5: {
                if (this.saveFile.exists() && (newOverwriteSelection = JOptionPane.showConfirmDialog(this.getMainWindow(), "New output file already exists. Do you want to overwrite it?", "That File Already Exists - overwrite it?", 0, 3)) == 1) break;
                this.setWorking("Exporting");
                this.splitRows = TimePanel.SplitRows.NO_SPLIT;
                if (this.splitRowsField.isSelected()) {
                    this.splitRows = TimePanel.SplitRows.SPLIT;
                }
                this.xAxisPerPage = TimePanel.XaxisPaging.ONLY_FIRST_PAGE;
                if (this.xAxisPagesField.isSelected()) {
                    this.xAxisPerPage = TimePanel.XaxisPaging.EVERY_PAGE;
                }
                exportThread = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$0(), ()V)((ExportDialog)this));
                exportThread.setUncaughtExceptionHandler(this.unforeseenHandler);
                exportThread.start();
                break;
            }
            case 13: {
                this.ourGUI.getWindowManager().closeWindow();
                this.setWorking(" ");
                this.setVisible(false);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.exportFrame, "Export listener called with unexpected action command " + cmd);
            }
        }
        this.calculateResult();
    }

    private void calculateResult() {
        double conversion = 1.0;
        if (this.mmButton.isSelected()) {
            conversion = 25.4;
        }
        this.imageWidth = (int)Math.round(this.newPaperX / conversion * (double)this.resolution);
        this.imageHeight = (int)Math.round(this.newPaperY / conversion * (double)this.resolution);
        this.imageSize = this.imageWidth * this.imageHeight;
        this.resultLabel.setText("Resulting image size: " + this.numberFormat.format(this.imageWidth) + " x " + this.numberFormat.format(this.imageHeight) + " = " + this.numberFormat.format(this.imageSize) + " pixels.");
        this.repaint();
    }

    private JFrame getMainWindow() {
        return this;
    }

    private String displayError(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String stackTrace = sw.toString();
        return stackTrace.replace(System.getProperty("line.separator"), "\n");
    }

    public void setTimePanel(TimePanel tp) {
        this.ourTimePanel = tp;
    }

    public void setWorking(String status) {
        this.workingLabel.setText(status);
        this.workingLabel.revalidate();
        this.workingLabel.repaint();
        this.revalidate();
        this.repaint();
    }

    private /* synthetic */ void lambda$0() {
        this.ourTimePanel.setScreenEnabled(false);
        this.ourTimePanel.export(this.imageLayout, this.xAxisPerPage, this.splitRows, this.resolution, 1.0, this.imageWidth, this.imageHeight, this.ourGUI.getViewStartDate(), this.ourGUI.getViewRangeDays(), this.saveFile, this.fileExtension, TimePanel.Scaling.PRINTER);
        this.ourTimePanel.setScreenEnabled(true);
    }
}

