/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.Connection;
import culturalDynamics.ConnectionData;
import culturalDynamics.Event;
import culturalDynamics.EventEditor;
import culturalDynamics.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class ConnectionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private CDgui ourGUI;
    private DefaultTableModel connectionTableModel = null;
    private JTable connectionTable = null;
    private ConnectionData ourConnectionList;
    private Event ourEv;
    private ConnectionData.Direction direction;
    private EventEditor ourEventEditor;
    private JScrollPane connectionScroll;

    ConnectionsPanel(CDgui mainGUI, EventEditor evEdIn, ConnectionData allConnectionList, Event currentEvent, ConnectionData.Direction dir) {
        this.ourGUI = mainGUI;
        this.ourEventEditor = evEdIn;
        this.ourEv = currentEvent;
        this.direction = dir;
        this.setLayout(new BorderLayout());
        Object[] connectionHeader = new String[]{"Source", "Name"};
        this.connectionTableModel = new DefaultTableModel(0, 2){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.connectionTableModel.setColumnIdentifiers(connectionHeader);
        this.connectionTable = new JTable(this.connectionTableModel){
            private static final long serialVersionUID = 1L;
            private Border outside;
            private Border inside;
            private Border highlight;
            private Border noHighlight;
            {
                this.outside = new MatteBorder(1, 0, 1, 0, Color.RED);
                this.inside = new EmptyBorder(0, 1, 0, 1);
                this.highlight = new CompoundBorder(this.outside, this.inside);
                this.noHighlight = new EmptyBorder(0, 1, 0, 1);
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                JComponent jc = (JComponent)c;
                if (this.isRowSelected(row)) {
                    jc.setBorder(this.highlight);
                } else {
                    jc.setBorder(this.noHighlight);
                }
                return c;
            }
        };
        this.connectionTable.setSelectionMode(2);
        this.connectionScroll = new JScrollPane(this.connectionTable);
        this.connectionScroll.setPreferredSize(new Dimension(450, 150));
        this.updateConnectionTable(allConnectionList, false, this.direction, null);
        this.add((Component)this.connectionScroll, "Center");
        this.connectionTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.connectionTable.setToolTipText("Double-click a row to open the connection editor.");
        this.connectionTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JTable table = (JTable)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                int row = table.rowAtPoint(point);
                if (mouseEvent.getClickCount() == 2 && table.getSelectedRow() != -1) {
                    Connection clickedCn = ConnectionsPanel.this.ourConnectionList.getConnection(row);
                    ConnectionsPanel.this.ourGUI.showOrOpenCn(clickedCn);
                }
            }
        });
    }

    public void updateConnectionTable(ConnectionData allConnections, boolean clear, ConnectionData.Direction src, String selected) {
        if (clear) {
            this.connectionTableModel.setRowCount(0);
        }
        if (src.equals((Object)ConnectionData.Direction.INCOMING)) {
            this.ourConnectionList = allConnections.getConnectedEvents(this.ourEv, ConnectionData.Direction.INCOMING);
            if (this.ourConnectionList.getNumberOfConnections() == 0) {
                this.ourEventEditor.enDisableDeleteIncoming(false);
            } else {
                this.ourEventEditor.enDisableDeleteIncoming(true);
            }
        } else {
            this.ourConnectionList = allConnections.getConnectedEvents(this.ourEv, ConnectionData.Direction.OUTGOING);
            if (this.ourConnectionList.getNumberOfConnections() == 0) {
                this.ourEventEditor.enDisableDeleteOutgoing(false);
            } else {
                this.ourEventEditor.enDisableDeleteOutgoing(true);
            }
        }
        this.ourConnectionList.sortConnectionsByName();
        int i = 0;
        while (i < this.ourConnectionList.getNumberOfConnections()) {
            if (src.equals((Object)ConnectionData.Direction.INCOMING)) {
                this.connectionTableModel.addRow(new Object[]{Utils.flatline(this.ourConnectionList.getConnection(i).getSourceEvent().getName()), Utils.flatline(this.ourConnectionList.getConnection(i).getName())});
            } else {
                this.connectionTableModel.addRow(new Object[]{Utils.flatline(this.ourConnectionList.getConnection(i).getDestEvent().getName()), Utils.flatline(this.ourConnectionList.getConnection(i).getName())});
            }
            ++i;
        }
        this.revalidate();
        this.repaint();
    }

    public int getSelectedConnectionIndex() {
        return this.connectionTable.getSelectedRow();
    }

    public Connection[] getSelectedConnections() {
        int[] rows = this.connectionTable.getSelectedRows();
        Connection[] result = new Connection[this.ourConnectionList.getNumberOfConnections()];
        int i = 0;
        while (i < rows.length) {
            result[i] = this.ourConnectionList.getConnection(rows[i]);
            ++i;
        }
        return result;
    }
}

