/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.DefaultImageIcon;
import culturalDynamics.Event;
import culturalDynamics.Link;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;

class Utils {
    public static final Color rowColor = new Color(0.6f, 0.6f, 0.6f, 1.0f);
    public static final Color defaultColor = new Color(0, 0, 0, 0);
    public static final Color dateAxisColor = new Color(0.6f, 0.6f, 0.6f, 0.6f);
    public static final LocalDate MAX_DATE = LocalDate.of(50000, 1, 1);
    public static final LocalDate MIN_DATE = LocalDate.of(-50000, 1, 1);
    public static DateTimeFormatter dayFormatter = new DateTimeFormatterBuilder().parseLenient().append(DateTimeFormatter.ofPattern("yyyy-M-d[ G]", Locale.of("US", "US"))).toFormatter(Locale.US);
    public static DateTimeFormatter dayFormatterOut = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("yyyy-MM-dd[ G]", Locale.of("US", "US"))).toFormatter(Locale.US);
    public static DateTimeFormatter dayFormatterAxis = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("dd MM\ny G")).toFormatter(Locale.US);
    private static DefaultImageIcon defaultIcon = new DefaultImageIcon();
    private static String styles = "<style type=\"text/css\">\n\tp{margin: 0px 0px 0px 0px; padding: 0px 0px 0px 0px;}\n\t.indent{margin: 0px 0px 0px 30px;}\nblockquote{margin: 0px 0px 0px 30px;}\nh1{margin: 12pt 0px 0px 0px; padding: 0px 0px 0px 0px; font-size:24pt;}\nh2{margin:  9pt 0px 0px 0px; padding: 0px 0px 0px 0px; font-size:18pt;}\nh3{margin:  7pt 0px 0px 0px; padding: 0px 0px 0px 0px; font-size:14pt;}\na{color: Blue;}\na:hover {color: Orange;}\n</style>\n";
    private static String[][] URLconversion = new String[][]{{"\u00c0", "%c3%80"}, {"\u00c1", "%c3%81"}, {"\u00c2", "%c3%82"}, {"\u00c3", "%c3%83"}, {"\u00c4", "%c3%84"}, {"\u00c5", "%c3%85"}, {"\u00c6", "%c3%86"}, {"\u00c7", "%c3%87"}, {"\u00c8", "%c3%88"}, {"\u00c9", "%c3%89"}, {"\u00ca", "%c3%8a"}, {"\u00cb", "%c3%8b"}, {"\u00cc", "%c3%8c"}, {"\u00cd", "%c3%8d"}, {"\u00ce", "%c3%8e"}, {"\u00cf", "%c3%8f"}, {"\u00d0", "%c3%90"}, {"\u00d1", "%c3%91"}, {"\u00d2", "%c3%92"}, {"\u00d3", "%c3%93"}, {"\u00d4", "%c3%94"}, {"\u00d5", "%c3%95"}, {"\u00d6", "%c3%96"}, {"\u00d7", "%c3%97"}, {"\u00d8", "%c3%98"}, {"\u00d9", "%c3%99"}, {"\u00da", "%c3%9a"}, {"\u00db", "%c3%9b"}, {"\u00dc", "%c3%9c"}, {"\u00dd", "%c3%9d"}, {"\u00de", "%c3%9e"}, {"\u00df", "%c3%9f"}, {"\u00e0", "%c3%a0"}, {"\u00e1", "%c3%a1"}, {"\u00e2", "%c3%a2"}, {"\u00e3", "%c3%a3"}, {"\u00e4", "%c3%a4"}, {"\u00e5", "%c3%a5"}, {"\u00e6", "%c3%a6"}, {"\u00e7", "%c3%a7"}, {"\u00e8", "%c3%a8"}, {"\u00e9", "%c3%a9"}, {"\u00ea", "%c3%aa"}, {"\u00eb", "%c3%ab"}, {"\u00ec", "%c3%ac"}, {"\u00ed", "%c3%ad"}, {"\u00ee", "%c3%ae"}, {"\u00ef", "%c3%af"}, {"\u00f0", "%c3%b0"}, {"\u00f1", "%c3%b1"}, {"\u00f2", "%c3%b2"}, {"\u00f3", "%c3%b3"}, {"\u00f4", "%c3%b4"}, {"\u00f5", "%c3%b5"}, {"\u00f6", "%c3%b6"}, {"\u00f7", "%c3%b7"}, {"\u00f8", "%c3%b8"}, {"\u00f9", "%c3%b9"}, {"\u00fa", "%c3%ba"}, {"\u00fb", "%c3%bb"}, {"\u00fc", "%c3%bc"}, {"\u00fd", "%c3%bd"}, {"\u00fe", "%c3%be"}, {"\u00ff", "%c3%bf"}};

    public static ArrayList<Link> getCopyOf(ArrayList<Link> source) {
        ArrayList<Link> dest = new ArrayList<Link>();
        if (source != null) {
            int i = 0;
            while (i < source.size()) {
                dest.add(source.get(i));
                ++i;
            }
        }
        return dest;
    }

    public static ImageIcon getDefaultIcon() {
        return defaultIcon.getImageIcon();
    }

    public static void updateCombos(List<Event> allEvents, Event selectEv, JComboBox<String> field) {
        if (allEvents != null && allEvents.size() != 0) {
            String[] cnEventNames = new String[allEvents.size()];
            int tmpIdx = 0;
            int i = 0;
            while (i < allEvents.size()) {
                Event event = allEvents.get(i);
                cnEventNames[i] = Utils.flatline(event.getName());
                if (event.equals(selectEv)) {
                    tmpIdx = i;
                }
                ++i;
            }
            field.setModel(new DefaultComboBoxModel<String>(cnEventNames));
            field.setSelectedIndex(tmpIdx);
        }
    }

    public static boolean patternMatch(String patternIn, String targetIn, boolean simple, boolean casesensitive, boolean umlauts) {
        boolean match = false;
        String pattern = patternIn;
        String target = targetIn;
        if (umlauts) {
            if (simple) {
                pattern = Utils.replaceUmlauts(patternIn);
            }
            target = Utils.replaceUmlauts(targetIn);
        }
        if (!casesensitive) {
            if (simple) {
                pattern = pattern.toLowerCase();
            }
            target = target.toLowerCase();
        }
        if (simple) {
            if (target.contains(pattern)) {
                match = true;
            }
        } else {
            Pattern compiledPattern = null;
            try {
                compiledPattern = Pattern.compile(pattern, 32);
            }
            catch (PatternSyntaxException exc) {
                System.out.println("Syntax error in find pattern regular expression" + pattern);
            }
            Matcher m = compiledPattern.matcher(target);
            if (m.matches()) {
                match = true;
            }
        }
        return match;
    }

    private static String replaceUmlauts(String in) {
        String result = in;
        result = result.replace("\u00c4", "AE");
        result = result.replace("\u00d6", "OE");
        result = result.replace("\u00dc", "UE");
        result = result.replace("\u00df", "ss");
        result = result.replace("\u00e4", "ae");
        result = result.replace("\u00f6", "oe");
        result = result.replace("\u00fc", "ue");
        return result;
    }

    public static String getFileWoExt(String fileName) {
        Path filePath = Paths.get(fileName, new String[0]);
        String fileWithoutFolder = filePath.getFileName().toString();
        String[] fileNameOnly = fileWithoutFolder.split("\\.");
        return fileNameOnly[0];
    }

    public static String encodeEscapes(String in) {
        String result = in;
        result = result.replace("\\", "\\\\");
        result = result.replace(System.lineSeparator(), "\\n");
        result = result.replace("\"", "\\\"");
        return result;
    }

    public static String decodeEscapes(String in) {
        String result = in;
        result = result.replace("\\n", System.lineSeparator());
        result = result.replace("\\\"", "\"");
        result = result.replace("\\" + System.lineSeparator(), "\\n");
        result = result.replace("\\\\", "\\");
        return result;
    }

    public static String flatline(String s) {
        String result = s;
        result = result.replace("\\n", " ");
        return result;
    }

    public static String correctFilename(String nameIn) {
        String result = nameIn.replace("/", "-");
        result = result.replace(".", "_");
        result = result.replace("'", "_");
        result = result.replace("\\n", " ");
        return result;
    }

    public static String escapeQuotes(String in) {
        String result = in.replace("'", "\\\u2019");
        return result;
    }

    public static Color colorFromString(String in) {
        Long colorIn;
        try {
            colorIn = Long.decode(in);
        }
        catch (Exception NumerFormatException) {
            return null;
        }
        Long blue = colorIn & 0xFFL;
        int blue2 = blue.intValue();
        Long green = colorIn & 0xFF00L;
        green = green >> 8;
        int green2 = green.intValue();
        Long red = colorIn & 0xFF0000L;
        red = red >> 16;
        int red2 = red.intValue();
        Long alpha = colorIn;
        alpha = alpha >> 24;
        alpha = alpha & 0xFFL;
        int alpha2 = alpha.intValue();
        Color newColor = new Color(red2, green2, blue2, alpha2);
        return newColor;
    }

    public static String stringFromColor(Color c) {
        String hex = Integer.toHexString(c.getRGB());
        return "0x" + hex;
    }

    public static Color colorToGrey(Color c) {
        int grey = (int)Math.round((double)c.getRed() * 0.3 + (double)c.getGreen() * 0.59 + (double)c.getBlue() * 0.11);
        return new Color(grey, grey, grey, c.getAlpha());
    }

    public static void setGraphicsFont(Graphics2D g, Font font) {
        g.setFont(font);
    }

    public static String getHTMLstyles() {
        return styles;
    }

    public static String makeH1(String s) {
        return "<h1>" + s + "</h1>\n";
    }

    public static String makeH2(String s) {
        return "<h2>" + Utils.makeAnchor("toc_", s) + "</h2>\n";
    }

    public static String makeH3(String s) {
        return "<h3>" + s + "</h3>\n";
    }

    public static String makeH4(String s) {
        return "<br><b>" + s + "</b>\n";
    }

    public static String makeP(String s) {
        return "<p>" + s + "</p>";
    }

    public static String makePindent(String s) {
        return "<p class=\"indent\">" + s + "</p>";
    }

    public static String noSpace(String s) {
        return s.replaceAll("\\s+", "");
    }

    public static String makeExtLink(String url, String text) {
        return "<a href=\"" + url + "\" target=\"_blank\">" + text + "</a>";
    }

    public static String makeIntLink(String url, String text) {
        return "<a href=\"#" + url + "\">" + Utils.flatline(text) + "</a>";
    }

    public static String makeAnchor(String prefix, String tlName) {
        return "<A name=\"" + prefix + Utils.noSpace(tlName) + "\">" + Utils.flatline(tlName) + "</A>";
    }

    public static String makeCnAnchor(String cnAnchor, String cnName) {
        return "<A name=\"" + Utils.noSpace(cnAnchor) + "\">" + Utils.flatline(cnName) + "</A>";
    }

    public static String buildLinksHTML(ArrayList<Link> links) {
        Object output = "<html>";
        if (links != null) {
            int i = 0;
            while (i < links.size()) {
                output = (String)output + "<a href=\"" + links.get(i).getURL() + "\">" + links.get(i).getText() + "</a><br>";
                ++i;
            }
        }
        output = (String)output + "</html>";
        return output;
    }

    public static String makeHTMLCheckbox(boolean x) {
        String result = "&#9744";
        if (x) {
            result = "&#9745";
        }
        return result;
    }

    public static String URLpercents(String in) {
        Object out = "";
        int i = 0;
        while (i < in.length()) {
            String c = in.substring(i, i + 1);
            int j = 0;
            while (j < URLconversion.length) {
                if (c.equals(URLconversion[j][0])) {
                    c = URLconversion[j][1];
                    break;
                }
                ++j;
            }
            out = (String)out + c;
            ++i;
        }
        return out;
    }
}

