/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.Filter;
import java.util.ArrayList;
import java.util.Comparator;

class SavedFilterData {
    private ArrayList<Filter> filters = new ArrayList();

    public SavedFilterData() {
        this.filters.clear();
    }

    public int getNumFilters() {
        return this.filters.size();
    }

    public void addSavedFilter(Filter f) {
        this.filters.add(f);
    }

    public void replaceSavedFilter(Filter repFilter) {
        String name = repFilter.getName();
        this.removeSavedFilterByName(name);
        this.filters.add(repFilter);
    }

    public Filter getSavedFilterByIndex(int idx) {
        return this.filters.get(idx);
    }

    public Filter getSavedFilterByName(String name) {
        for (Filter filter : this.filters) {
            if (!filter.getName().equals(name)) continue;
            return filter;
        }
        return null;
    }

    public void sortFilters() {
        if (this.filters != null && this.filters.size() != 0) {
            this.filters.sort(new NameSorter());
        }
    }

    public String[] getFilterNamesAsArray() {
        String[] tmp = new String[this.filters.size()];
        int i = 0;
        while (i < this.filters.size()) {
            tmp[i] = this.filters.get(i).getName();
            ++i;
        }
        return tmp;
    }

    public void removeSavedFilterByName(String name) {
        Filter which = this.getSavedFilterByName(name);
        this.filters.remove(which);
    }

    public void clearFilterData() {
        this.filters.clear();
    }

    private class NameSorter
    implements Comparator<Filter> {
        private NameSorter() {
        }

        @Override
        public int compare(Filter o1, Filter o2) {
            int tmp = o1.getName().compareToIgnoreCase(o2.getName());
            return tmp;
        }
    }
}

