/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CDgui;
import culturalDynamics.Row;
import culturalDynamics.RowData;
import culturalDynamics.TimePanel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class RowEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private CDgui ourGUI;
    private JFrame rowEditorFrame;
    private TimePanel ourTimepanel;
    private int ourRowIdx;
    private RowData ourRowData;
    private JCheckBox keepEmptyField = new JCheckBox("Keep row empty", false);
    private JRadioButton insertAbove = new JRadioButton("above", true);
    private JRadioButton insertBelow = new JRadioButton("below", false);
    private ButtonGroup insertGroup = new ButtonGroup();
    private JButton insertButton = new JButton("Insert");
    private JButton moveUpButton = new JButton("Move Up");
    private JButton moveDownButton = new JButton("Move Down");
    private JButton deleteButton = new JButton("Delete");
    private JButton sortByStartButton = new JButton("Sort All by Start Date");
    private JButton closeButton = new JButton("Close");

    RowEditor(CDgui mainGUI, int inRowIdx, RowData inRowData) {
        this.ourGUI = mainGUI;
        this.rowEditorFrame = this;
        this.ourRowIdx = inRowIdx;
        this.ourRowData = inRowData;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                RowEditor.this.rowEditorFrame.setVisible(false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent v) {
                RowEditor.this.keepEmptyField.setSelected(RowEditor.this.ourRowData.getRowByIndex(RowEditor.this.ourRowIdx).getKeepRowEmpty());
                RowEditor.this.ourTimepanel = RowEditor.this.ourGUI.getTimePanel();
                RowEditor.this.buttonLogic();
                RowEditor.this.rowEditorFrame.setTitle("Row Editor: row " + String.valueOf(RowEditor.this.ourRowIdx + 1));
                RowEditor.this.rowEditorFrame.revalidate();
                RowEditor.this.rowEditorFrame.repaint();
            }
        });
        this.rowEditorFrame = this;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        FlowLayout flowLayoutLeft = new FlowLayout(0);
        JPanel emptyPanel = new JPanel(flowLayoutLeft);
        this.keepEmptyField.setToolTipText("Keep this row empty when optimising rows");
        this.keepEmptyField.setSelected(this.ourRowData.getRowByIndex(this.ourRowIdx).getKeepRowEmpty());
        this.keepEmptyField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ke) {
                RowEditor.this.ourRowData.getRowByIndex(RowEditor.this.ourRowIdx).setKeepRowEmpty(RowEditor.this.keepEmptyField.isSelected());
                if (RowEditor.this.ourRowData.getRowByIndex(RowEditor.this.ourRowIdx).getKeepRowEmpty() && !RowEditor.this.ourRowData.getRowByIndex(RowEditor.this.ourRowIdx).isRowEmpty()) {
                    JOptionPane.showMessageDialog(RowEditor.this.rowEditorFrame, "Row Editor: You must delete all timelines and events from the row or move them to another row before you can keep it empty.");
                    RowEditor.this.ourRowData.getRowByIndex(RowEditor.this.ourRowIdx).setKeepRowEmpty(false);
                    RowEditor.this.keepEmptyField.setSelected(false);
                }
                RowEditor.this.ourGUI.setFileSaved(false);
                RowEditor.this.ourTimepanel.repaint();
            }
        });
        emptyPanel.add(this.keepEmptyField);
        JPanel insertPanel = new JPanel(flowLayoutLeft);
        this.insertGroup.add(this.insertAbove);
        this.insertGroup.add(this.insertBelow);
        insertPanel.add(this.insertAbove);
        insertPanel.add(this.insertBelow);
        insertPanel.add(this.insertButton);
        this.insertAbove.setToolTipText("Insert button will insert a row above this one");
        this.insertBelow.setToolTipText("Insert button will insert a row below this one");
        this.insertButton.setToolTipText("Insert a new row above or below the current row");
        this.insertButton.setPreferredSize(new Dimension(100, 20));
        this.insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent insert) {
                Row insertedRow = new Row();
                if (RowEditor.this.insertAbove.isSelected()) {
                    RowEditor.this.ourRowData.insertRow(insertedRow, RowEditor.this.ourRowIdx);
                } else {
                    RowEditor.this.ourRowData.insertRow(insertedRow, RowEditor.this.ourRowIdx + 1);
                }
                RowEditor.this.buttonLogic();
                RowEditor.this.ourGUI.setFileSaved(false);
                RowEditor.this.ourTimepanel.repaint();
            }
        });
        JPanel movePanel = new JPanel(flowLayoutLeft);
        this.moveUpButton.setToolTipText("Move this row up");
        this.moveDownButton.setToolTipText("Move this row down");
        movePanel.add(this.moveUpButton);
        movePanel.add(this.moveDownButton);
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent up) {
                int newRowIdx = RowEditor.this.ourRowData.moveUp(RowEditor.this.ourRowIdx);
                RowEditor.this.setRow(newRowIdx);
                RowEditor.this.ourGUI.setFileSaved(false);
                RowEditor.this.ourTimepanel.repaint();
            }
        });
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent down) {
                int newRowIdx = RowEditor.this.ourRowData.moveDown(RowEditor.this.ourRowIdx);
                RowEditor.this.setRow(newRowIdx);
                RowEditor.this.ourGUI.setFileSaved(false);
                RowEditor.this.ourTimepanel.repaint();
            }
        });
        JPanel deletePanel = new JPanel(flowLayoutLeft);
        this.deleteButton.setToolTipText("Delete this row (must be empty)");
        deletePanel.add(this.deleteButton);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent del) {
                if (RowEditor.this.ourRowData.getRowByIndex(RowEditor.this.ourRowIdx).isRowEmpty()) {
                    RowEditor.this.ourRowData.removeRow(RowEditor.this.ourRowIdx);
                    int newRowIdx = RowEditor.this.ourRowIdx - 1;
                    if (newRowIdx < 0) {
                        newRowIdx = 0;
                    }
                    RowEditor.this.setRow(newRowIdx);
                    RowEditor.this.buttonLogic();
                    RowEditor.this.ourGUI.setFileSaved(false);
                    RowEditor.this.ourTimepanel.repaint();
                } else {
                    JOptionPane.showMessageDialog(RowEditor.this.rowEditorFrame, "Row Editor: You must delete all timelines and events from the row or move them to another row before you can delete it.");
                }
            }
        });
        JPanel sortPanel = new JPanel(flowLayoutLeft);
        this.sortByStartButton.setToolTipText("Sort the rows by start date");
        sortPanel.add(this.sortByStartButton);
        this.sortByStartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent sort) {
                RowEditor.this.ourRowData.sortRows();
                RowEditor.this.ourGUI.setFileSaved(false);
                RowEditor.this.ourTimepanel.repaint();
            }
        });
        JPanel closePanel = new JPanel(flowLayoutLeft);
        this.closeButton.setToolTipText("Close the row editor window");
        closePanel.add(this.closeButton);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent sort) {
                RowEditor.this.rowEditorFrame.setVisible(false);
            }
        });
        this.add(emptyPanel);
        this.add(insertPanel);
        this.add(movePanel);
        this.add(deletePanel);
        this.add(sortPanel);
        this.add(closePanel);
        this.setTitle("Row Editor: row " + String.valueOf(this.ourRowIdx + 1));
        this.pack();
    }

    private void buttonLogic() {
        if (this.ourRowData.isRowDataEmpty()) {
            this.insertAbove.setEnabled(true);
            this.insertBelow.setEnabled(true);
            this.insertButton.setEnabled(true);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.sortByStartButton.setEnabled(false);
        } else {
            this.insertAbove.setEnabled(true);
            this.insertBelow.setEnabled(true);
            this.insertButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            if (this.ourRowData.getSize() >= 2) {
                this.moveUpButton.setEnabled(true);
                this.moveDownButton.setEnabled(true);
                if (!this.ourRowData.isRowDataPlusEmpty()) {
                    this.sortByStartButton.setEnabled(true);
                }
            } else {
                this.moveUpButton.setEnabled(false);
                this.moveDownButton.setEnabled(false);
                this.sortByStartButton.setEnabled(false);
            }
        }
    }

    public void setRow(int r) {
        this.ourRowIdx = r;
        this.setTitle("Row Editor: row " + String.valueOf(this.ourRowIdx + 1));
        this.keepEmptyField.setSelected(this.ourRowData.getRowByIndex(this.ourRowIdx).getKeepRowEmpty());
    }
}

