/*
 * Decompiled with CFR 0.152.
 */
package culturalDynamics;

import culturalDynamics.CommonData;
import culturalDynamics.Event;
import culturalDynamics.Preferences;
import culturalDynamics.Utils;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

class Row {
    private List<Event> events = new ArrayList<Event>();
    private boolean keepEmpty = false;
    private Rectangle2D nameBounds = null;
    private int rowY;
    private int rowMaxHeight;
    private boolean isShown = true;

    public int getRowY() {
        return this.rowY;
    }

    public void setRowY(int rowY) {
        this.rowY = rowY;
    }

    public int getRowTopY() {
        return this.rowMaxHeight;
    }

    public void setRowTopY(int rowTopY) {
        this.rowMaxHeight = rowTopY;
    }

    public boolean isShown() {
        return this.isShown;
    }

    public void setShown(boolean s) {
        this.isShown = s;
    }

    public boolean getKeepRowEmpty() {
        return this.keepEmpty;
    }

    public void setKeepRowEmpty(boolean newKeep) {
        this.keepEmpty = newKeep;
    }

    public boolean isRowEmpty() {
        return this.events.size() == 0;
    }

    public boolean isRowFilteredEmpty() {
        boolean result = true;
        int i = 0;
        while (i < this.getNumberOfEvents()) {
            if (this.events.get(i).isShown()) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public int getNumberOfEvents() {
        return this.events.size();
    }

    public Event getEventByIndex(int idx) {
        return this.events.get(idx);
    }

    public void removeEvent(Event ev) {
        int i = 0;
        while (i < this.getNumberOfEvents()) {
            if (this.events.get(i).equals(ev)) {
                this.events.remove(i);
            }
            ++i;
        }
    }

    public Rectangle2D getNameBounds() {
        return this.nameBounds;
    }

    public void setNameBounds(Rectangle2D nameBounds) {
        this.nameBounds = nameBounds;
    }

    public LocalDate getEarliestDate() {
        LocalDate result = LocalDate.MAX;
        int i = 0;
        while (i < this.getNumberOfEvents()) {
            Event tmpEv = this.getEventByIndex(i);
            if (result == null || tmpEv.getDates().getEarlyStartDate().isBefore(result)) {
                result = tmpEv.getDates().getEarlyStartDate();
            }
            ++i;
        }
        return result;
    }

    public int rowMaxHeightAbove(Preferences prefs, Graphics2D g2d) {
        int maxHeight = prefs.getRowMinYGap();
        int tlNameHeight = g2d.getFontMetrics(prefs.getTlNameFont()).getHeight();
        int tlAgeHeight = 0;
        int maxTlIconHeight = 0;
        if (prefs.getTimelineShowAgesChoice()) {
            tlAgeHeight = g2d.getFontMetrics(prefs.getTlAgeFont()).getHeight() + tlNameHeight;
        }
        if (this.events != null && this.events.size() != 0) {
            int j = 0;
            while (j < this.events.size()) {
                Event tmpEv = this.events.get(j);
                if (tmpEv.isShown()) {
                    if (tmpEv.getEventType().equals((Object)CommonData.EventType.TIMELINE)) {
                        if (tmpEv.getIcon() != null) {
                            maxTlIconHeight = Math.max(maxTlIconHeight, tmpEv.getIcon().getIconHeight() / 2);
                        }
                        if (tmpEv.getEndIcon() != null) {
                            maxTlIconHeight = Math.max(maxTlIconHeight, tmpEv.getEndIcon().getIconHeight() / 2);
                        }
                        maxHeight = Math.max(Math.max(Math.max(maxHeight, tlNameHeight), tlAgeHeight), maxTlIconHeight);
                    } else {
                        int ih = 0;
                        ih = tmpEv.getIcon() != null ? tmpEv.getIcon().getIconHeight() : Utils.getDefaultIcon().getIconHeight();
                        if (ih / 2 > maxHeight) {
                            maxHeight = ih / 2;
                        }
                    }
                }
                ++j;
            }
        }
        this.rowMaxHeight = maxHeight;
        return maxHeight;
    }

    public boolean isClickedRow(double mouseX, double mouseY) {
        return this.nameBounds != null && this.nameBounds.contains(mouseX, mouseY);
    }
}

